/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a>\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0006\u001a\u00020\u0001\u001aN\u0010\f\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001aY\u0010\f\u001a\u00020\u00162\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00172\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0018\u001aT\u0010\f\u001a\u00020\u00162\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00192\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\\\u0010\f\u001a\u00020\u00162\u0016\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001a2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"delimiter", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "first", "newLines", "level", "", "guessType", "value", "", "toJson", "", "dbms", "Lcom/intellij/database/Dbms;", "formatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "mode", "Lcom/intellij/database/extractors/ObjectFormatterMode;", "helper", "Lcom/intellij/database/remote/jdbc/helpers/JdbcHelper;", "", "", "([Ljava/lang/Object;Ljava/lang/StringBuilder;Lcom/intellij/database/Dbms;Lcom/intellij/database/extractors/ObjectFormatter;Lcom/intellij/database/extractors/ObjectFormatterMode;Lcom/intellij/database/remote/jdbc/helpers/JdbcHelper;ZI)V", "", "", "intellij.database.core.impl"})
public final class JsonUtilKt {
    @NotNull
    public static final String toJson(@Nullable Object value2, @NotNull Dbms dbms, @NotNull ObjectFormatter formatter, @NotNull ObjectFormatterMode mode, @Nullable JdbcHelper helper, boolean newLines) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        StringBuilder sb = new StringBuilder();
        JdbcHelper jdbcHelper = helper;
        if (jdbcHelper == null) {
            JdbcHelper jdbcHelper2 = DbImplUtilCore.getJdbcHelper(dbms);
            jdbcHelper = jdbcHelper2;
            Intrinsics.checkNotNullExpressionValue((Object)jdbcHelper2, (String)"DbImplUtilCore.getJdbcHelper(dbms)");
        }
        JdbcHelper h = jdbcHelper;
        JsonUtilKt.toJson(value2, sb, dbms, formatter, mode, h, newLines, 0);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String toJson$default(Object object, Dbms dbms, ObjectFormatter objectFormatter, ObjectFormatterMode objectFormatterMode, JdbcHelper jdbcHelper, boolean bl, int n, Object object2) {
        if ((n & 0x10) != 0) {
            jdbcHelper = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return JsonUtilKt.toJson(object, dbms, objectFormatter, objectFormatterMode, jdbcHelper, bl);
    }

    private static final void toJson(Object value2, StringBuilder sb, Dbms dbms, ObjectFormatter formatter, ObjectFormatterMode mode, JdbcHelper helper, boolean newLines, int level) {
        block9: {
            String string;
            block14: {
                block13: {
                    String string2;
                    block12: {
                        Object object;
                        block11: {
                            block10: {
                                block8: {
                                    object = value2;
                                    if (!(object instanceof Object[])) break block8;
                                    Object object2 = value2;
                                    if (object2 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                                    }
                                    JsonUtilKt.toJson((Object[])object2, sb, dbms, formatter, mode, helper, newLines, level);
                                    break block9;
                                }
                                if (!(object instanceof List)) break block10;
                                Object object3 = value2;
                                if (object3 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
                                }
                                JsonUtilKt.toJson((List)object3, sb, dbms, formatter, mode, helper, newLines, level);
                                break block9;
                            }
                            if (!(object instanceof Map)) break block11;
                            Object object4 = value2;
                            if (object4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.Any?, kotlin.Any?>");
                            }
                            JsonUtilKt.toJson((Map)object4, sb, dbms, formatter, mode, helper, newLines, level);
                            break block9;
                        }
                        if (object != null) break block12;
                        sb.append("null");
                        break block9;
                    }
                    int jdbcType = JsonUtilKt.guessType(value2);
                    DataConsumer.Column column2 = new DataConsumer.Column(0, "", jdbcType, "", value2.getClass().getName());
                    string = formatter.getValueLiteral(value2, column2, dbms, mode);
                    if (string == null) break block13;
                    String string3 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String literal = string3;
                    boolean bl3 = false;
                    if (ObjectFormatter.isStringLiteral(dbms, column2, value2, helper, mode)) {
                        string2 = "\"" + StringUtil.escapeStringCharacters((String)literal) + "\"";
                    } else {
                        String string4 = literal;
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"literal");
                    }
                    string = string2;
                    if (string2 != null) break block14;
                }
                string = "null";
            }
            String v = string;
            sb.append(v);
        }
    }

    public static final int guessType(@Nullable Object value2) {
        Object object = value2;
        return object instanceof Map ? 2000 : (object instanceof List ? 2003 : (object instanceof String ? 12 : (object instanceof Integer ? 4 : (object instanceof Long ? -5 : (object instanceof Double ? 8 : (object instanceof Boolean ? 16 : (object instanceof Timestamp ? 93 : (object instanceof Date ? 91 : (object instanceof Time ? 92 : (object instanceof java.util.Date ? 91 : 1111))))))))));
    }

    private static final void toJson(List<? extends Object> value2, StringBuilder sb, Dbms dbms, ObjectFormatter formatter, ObjectFormatterMode mode, JdbcHelper helper, boolean newLines, int level) {
        sb.append("[");
        boolean first2 = true;
        for (Object object : value2) {
            if (object == ReservedCellValue.UNSET) continue;
            first2 = JsonUtilKt.delimiter(sb, first2, newLines, level);
            JsonUtilKt.toJson(object, sb, dbms, formatter, mode, helper, newLines, level + 1);
        }
        if (newLines) {
            sb.append("\n").append(StringUtil.repeat((String)" ", (int)(level * 2)));
        }
        sb.append("]");
    }

    private static final boolean delimiter(StringBuilder sb, boolean first2, boolean newLines, int level) {
        if (!first2) {
            sb.append(",").append(newLines ? "" : " ");
        }
        if (newLines) {
            sb.append("\n").append(StringUtil.repeat((String)" ", (int)((level + 1) * 2)));
        }
        return false;
    }

    private static final void toJson(Object[] value2, StringBuilder sb, Dbms dbms, ObjectFormatter formatter, ObjectFormatterMode mode, JdbcHelper helper, boolean newLines, int level) {
        sb.append("[");
        boolean first2 = true;
        for (Object v : value2) {
            if (v == ReservedCellValue.UNSET) continue;
            first2 = JsonUtilKt.delimiter(sb, first2, newLines, level);
            JsonUtilKt.toJson(v, sb, dbms, formatter, mode, helper, newLines, level + 1);
        }
        if (newLines) {
            sb.append("\n").append(StringUtil.repeat((String)" ", (int)(level * 2)));
        }
        sb.append("]");
    }

    /*
     * WARNING - void declaration
     */
    private static final void toJson(Map<Object, ? extends Object> value2, StringBuilder sb, Dbms dbms, ObjectFormatter formatter, ObjectFormatterMode mode, JdbcHelper helper, boolean newLines, int level) {
        sb.append("{");
        boolean first2 = true;
        Object object = value2;
        boolean bl = false;
        Iterator<Map.Entry<Object, ? extends Object>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<Object, ? extends Object> entry;
            Map.Entry<Object, ? extends Object> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Object v = entry2.getValue();
            if (v == ReservedCellValue.UNSET) continue;
            first2 = JsonUtilKt.delimiter(sb, first2, newLines, level);
            JsonUtilKt.toJson(key, sb, dbms, formatter, mode, helper, newLines, level + 1);
            sb.append(": ");
            JsonUtilKt.toJson(v, sb, dbms, formatter, mode, helper, newLines, level + 1);
        }
        if (newLines) {
            sb.append("\n").append(StringUtil.repeat((String)" ", (int)(level * 2)));
        }
        sb.append("}");
    }
}

