/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlValuesExtractor
extends TranspositionAwareExtractor {
    public HtmlValuesExtractor(ObjectFormatter converter) {
        super(converter);
    }

    @NotNull
    public String getDataPrefix() {
        return "<table border=\"1\" style=\"border-collapse:collapse\">";
    }

    @NotNull
    public String getDataSuffix() {
        return "</table>";
    }

    @NotNull
    public String getLinePrefix() {
        return "<tr>";
    }

    @NotNull
    public String getLineSuffix() {
        return "</tr>";
    }

    @NotNull
    public String getValuePrefix() {
        return "<td>";
    }

    @NotNull
    public String getValueSuffix() {
        return "</td>";
    }

    @Override
    public String getColumnName(DataConsumer.Column column2) {
        return "<th>" + column2.name + "</th>";
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, @NotNull ObjectFormatterMode mode) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(0);
        }
        if (column2 == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(3);
        }
        return this.getValueAsString(row, column2, dbms, mode, true);
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, @NotNull ObjectFormatterMode mode, boolean escape) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(7);
        }
        String repr = super.getValueAsString(row, column2, dbms, mode);
        return escape ? HtmlValuesExtractor.escapeChars(repr) : repr;
    }

    @Nullable
    public static String escapeChars(@Nullable String s2) {
        return s2 != null ? StringUtil.escapeXmlEntities((String)s2.replaceAll("[\t\b\\f]", "")).replaceAll("\\r|\\n|\\r\\n", "<br/>") : null;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "html";
    }

    @Override
    protected TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, @NotNull ExtractionConfig config, boolean isTransposedMode, int ... selectedColumns) {
        if (config == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(8);
        }
        return new HtmlExtraction(out, dbms, config, allColumns, isTransposedMode, selectedColumns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/HtmlValuesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "startExtraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class HtmlExtraction
    extends TranspositionAwareExtractor.TranspositionAwareExtraction {
        private final boolean myIsTransposedMode;

        public HtmlExtraction(CharOut output, @NotNull Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, boolean isTransposedMode, int[] selectedColumnIndices) {
            if (config == null) {
                HtmlExtraction.$$$reportNull$$$0(0);
            }
            super(HtmlValuesExtractor.this, output, dbms, config, allColumns, selectedColumnIndices);
            this.myIsTransposedMode = isTransposedMode;
        }

        protected String getHeader() {
            return "<!DOCTYPE html>\n<html>\n<head>\n  <title></title>\n</head>\n<body>\n" + HtmlValuesExtractor.this.getDataPrefix() + "\n";
        }

        protected String getFooter() {
            return "\n</body>\n</html>";
        }

        @Override
        protected void doAppendData(List<DataConsumer.Row> rows) {
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            boolean first2 = true;
            for (DataConsumer.Row row : rows) {
                if (!first2) {
                    this.myOutput.append(HtmlValuesExtractor.this.getLineSeparator());
                } else {
                    first2 = false;
                }
                this.myOutput.append(HtmlValuesExtractor.this.getLinePrefix());
                if (this.myIsTransposedMode) {
                    this.myOutput.append(HtmlValuesExtractor.this.getValuePrefix()).append(HtmlValuesExtractor.this.getValueLiteral(this.myDbms, this.getRowNumber(row), null, null)).append(HtmlValuesExtractor.this.getValueSuffix());
                }
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column2 == null) continue;
                    String value2 = HtmlValuesExtractor.this.getValueLiteral(row, column2, this.myDbms, ObjectFormatterMode.DEFAULT);
                    this.myOutput.append(HtmlValuesExtractor.this.getValuePrefix()).append(value2).append(HtmlValuesExtractor.this.getValueSuffix());
                }
                this.myOutput.append(HtmlValuesExtractor.this.getLineSuffix());
            }
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            this.myOutput.append(this.getHeader());
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            if (selectedColumns.length == 0) {
                return;
            }
            String columnName = this.myIsTransposedMode ? HtmlValuesExtractor.this.getColumnName(this.getRowNumbersColumn()) : "";
            this.myOutput.append(HtmlValuesExtractor.this.getLinePrefix()).append(columnName);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
            for (int selectedColumn : selectedColumns) {
                DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                if (column2 == null) continue;
                this.myOutput.append(HtmlValuesExtractor.this.getColumnName(column2));
            }
            this.myOutput.append(HtmlValuesExtractor.this.getLineSuffix());
            if (appendNewLine) {
                this.myOutput.append(HtmlValuesExtractor.this.getLineSeparator());
            }
        }

        @Override
        protected void doAppendFooter() {
            this.myOutput.append(HtmlValuesExtractor.this.getDataSuffix()).append(this.getFooter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/extractors/HtmlValuesExtractor$HtmlExtraction", "<init>"));
        }
    }
}

