/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.util.BinaryOut;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.Out;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExtractionHelper {
    public static final Pattern UNDERSCORES_PATTERN = Pattern.compile("_+");

    public boolean accepts(@NotNull DataExtractor var1);

    @NotNull
    public Out createOut(@NotNull String var1, @NotNull DataExtractor var2) throws IOException;

    public boolean isSingleFileMode();

    public void sourceDumped(@NotNull DataExtractor var1, @NotNull Out var2);

    public void after(@NotNull Project var1, @NotNull DumpHandler.DumpInfo var2) throws IOException;

    @NlsContexts.ProgressTitle
    @NotNull
    public String getTitle(@NotNull String var1);

    public static String prepareFileName(@NotNull String name) {
        if (name == null) {
            ExtractionHelper.$$$reportNull$$$0(0);
        }
        return UNDERSCORES_PATTERN.matcher(FileUtil.sanitizeFileName((String)name)).replaceAll("_");
    }

    public static void errorNotification(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) {
        String summary;
        if (project == null) {
            ExtractionHelper.$$$reportNull$$$0(1);
        }
        if (info == null) {
            ExtractionHelper.$$$reportNull$$$0(2);
        }
        if ((summary = info.getErrorSummary()).isEmpty()) {
            return;
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(summary, NotificationType.ERROR).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dump/ExtractionHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareFileName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "errorNotification";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ClipboardExtractionHelper
    implements ExtractionHelper {
        @Override
        public boolean accepts(@NotNull DataExtractor extractor) {
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(0);
            }
            return extractor instanceof DataExtractor.Text;
        }

        @Override
        @NotNull
        public CharOut createOut(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(1);
            }
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(2);
            }
            CharOut charOut = CharOut.Util.newSink();
            if (charOut == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(3);
            }
            return charOut;
        }

        @Override
        public boolean isSingleFileMode() {
            return false;
        }

        @Override
        public void sourceDumped(@NotNull DataExtractor extractor, @NotNull Out out) {
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(4);
            }
            if (out == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(5);
            }
            if (!(out instanceof CharOut)) {
                return;
            }
            String data = out.toString();
            boolean htmlNeeded = extractor.getFileExtension().contains("htm");
            Object content = htmlNeeded ? new TextTransferable(data) : new StringSelection(data);
            UIUtil.invokeLaterIfNeeded(() -> ClipboardExtractionHelper.lambda$sourceDumped$0((Transferable)content));
        }

        @Override
        public void after(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) {
            if (project == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(6);
            }
            if (info == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(7);
            }
            ExtractionHelper.errorNotification(project, info);
        }

        @Override
        @NotNull
        public String getTitle(@NotNull String displayName) {
            if (displayName == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(8);
            }
            String string = DatabaseBundle.message("export.copy.to.clipboard", displayName);
            if (string == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void lambda$sourceDumped$0(Transferable content) {
            CopyPasteManager.getInstance().setContents(content);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOut";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createOut";
                    break;
                }
                case 3: 
                case 9: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "sourceDumped";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "after";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FileExtractionHelper
    implements ExtractionHelper {
        private final File myFile;

        public FileExtractionHelper(@NotNull File file) {
            if (file == null) {
                FileExtractionHelper.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @Override
        public boolean accepts(@NotNull DataExtractor extractor) {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        @NotNull
        public Out createOut(@NotNull String name, @NotNull DataExtractor extractor) throws IOException {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(2);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(3);
            }
            File fileToWrite = this.createFileToWrite(name, extractor);
            FileOutputStream outputStream = new FileOutputStream(fileToWrite);
            Out out = extractor instanceof DataExtractor.Binary ? BinaryOut.Util.newSink(new BufferedOutputStream(outputStream)) : CharOut.Util.newSink(new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8)));
            if (out == null) {
                FileExtractionHelper.$$$reportNull$$$0(4);
            }
            return out;
        }

        private File createFileToWrite(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(5);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(6);
            }
            if (this.myFile.isFile()) {
                return this.myFile;
            }
            return this.findFile(name, extractor);
        }

        private File findFile(@NotNull String name, @NotNull DataExtractor extractor) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(7);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(8);
            }
            File result2 = this.createFile(name, extractor, null);
            int index2 = 1;
            while (result2.exists()) {
                result2 = this.createFile(name, extractor, index2++);
            }
            return result2;
        }

        private File createFile(@NotNull String name, @NotNull DataExtractor extractor, @Nullable Integer index2) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(9);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(10);
            }
            return new File(this.myFile, ExtractionHelper.prepareFileName(name) + (String)(index2 == null ? "" : "_" + index2) + "." + extractor.getFileExtension());
        }

        @Override
        public boolean isSingleFileMode() {
            return this.myFile.isFile();
        }

        @Override
        public void sourceDumped(@NotNull DataExtractor extractor, @NotNull Out output) {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(11);
            }
            if (output == null) {
                FileExtractionHelper.$$$reportNull$$$0(12);
            }
        }

        @Override
        public void after(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) throws IOException {
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(13);
            }
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(14);
            }
            this.notification(project, info);
            ExtractionHelper.errorNotification(project, info);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }

        private void notification(@NotNull Project project, @NotNull DumpHandler.DumpInfo info) {
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(15);
            }
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(16);
            }
            String title = info.getTitle();
            long rowCount = info.getRowCount();
            String producerName = info.getProducerName();
            String sourceName = info.getSourceName();
            int sourcesCount = info.getSourcesCount();
            boolean needSources = sourceName != null && sourcesCount > 1;
            String content = DatabaseBundle.message("export.rows.saved.to.file.message", needSources ? 1 : 0, sourcesCount, sourceName, rowCount, producerName != null ? 1 : 0, producerName, this.myFile.isFile() ? 1 : 0);
            DbUIUtil.createFileLinkNotification(project, title, content, !info.getErrorSummary().isEmpty() ? NotificationType.ERROR : NotificationType.INFORMATION, this.myFile.getPath()).notify(project);
        }

        @Override
        @NotNull
        public String getTitle(@NotNull String displayName) {
            if (displayName == null) {
                FileExtractionHelper.$$$reportNull$$$0(17);
            }
            String string = DatabaseBundle.message("export.save.to.file", displayName);
            if (string == null) {
                FileExtractionHelper.$$$reportNull$$$0(18);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOut";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createOut";
                    break;
                }
                case 4: 
                case 18: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileToWrite";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findFile";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createFile";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "sourceDumped";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "after";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "notification";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitle";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

