/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportHead {
    private static final String OPEN_TABLE_DESC = "open_table";
    private static final Logger LOG = Logger.getInstance(ImportHead.class);
    private final ImportInfo myInfo;
    private final Project myProject;
    private final ReaderTask.Input myInput;
    private final ImportErrorHandler myHandler;

    public ImportHead(@NotNull Project project, @NotNull ImportInfo info, @NotNull ReaderTask.Input input) {
        if (project == null) {
            ImportHead.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ImportHead.$$$reportNull$$$0(1);
        }
        if (input == null) {
            ImportHead.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myInput = input;
        this.myHandler = new ImportErrorHandler(project, info);
        this.myInfo = info;
    }

    /*
     * Exception decompiling
     */
    public boolean start(@NotNull ProgressIndicator indicator, @NotNull ImportTarget target, @NotNull ErrorHandler errorHandler) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Notification createNotification(@NotNull Project project, @Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater, @Nullable Long importedCount, long errorsCount, boolean bl) {
        void error2;
        if (project == null) {
            ImportHead.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(7);
        }
        DbDataSource system = this.myInfo.getContext().getDataSource();
        String path = this.myInfo.getErrorTaskInfo().getErrorRecordsPath();
        String content = ImportHead.getContent(this.myInfo, timeSpent, path, updater, importedCount, errorsCount);
        NotificationType type = errorsCount > 0L || error2 != false ? NotificationType.ERROR : NotificationType.INFORMATION;
        DbUIUtil.FileNotificationListener fileNotificationListener = path == null ? null : new DbUIUtil.FileNotificationListener(project, path);
        OpenTableNotificationListener openTableNotificationListener = new OpenTableNotificationListener(system, this.myInfo.getTable());
        NotificationListener notificationListener = (notification, event) -> {
            if (fileNotificationListener != null) {
                fileNotificationListener.hyperlinkUpdate(notification, event);
            }
            openTableNotificationListener.hyperlinkUpdate(notification, event);
        };
        Notification notification2 = DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(Objects.requireNonNull(system).getName(), content, type).setListener(notificationListener);
        if (notification2 == null) {
            ImportHead.$$$reportNull$$$0(8);
        }
        return notification2;
    }

    private static void notifyAboutInputError(@NlsContexts.NotificationContent @Nullable String error2, @NotNull Project project) {
        if (project == null) {
            ImportHead.$$$reportNull$$$0(9);
        }
        if (error2 != null) {
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(error2, NotificationType.ERROR).notify(project);
        }
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getContent(@NotNull ImportInfo info, @Nullable Long timeSpent, @Nullable String path, @NotNull ImportIndicatorUpdater updater, @Nullable Long importedCount, long errorsCount) {
        if (info == null) {
            ImportHead.$$$reportNull$$$0(10);
        }
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(11);
        }
        String string = ImportHead.getTitle(info) + ImportHead.getInsertedCount(importedCount) + ImportHead.getStatistics(timeSpent, updater) + ImportHead.getErrorsCountAndPath(path, errorsCount);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getTitle(@NotNull ImportInfo info) {
        if (info == null) {
            ImportHead.$$$reportNull$$$0(13);
        }
        String string = DatabaseBundle.message("database.data.import.imported.to", info.getProducerName(), info.getTableName());
        if (string == null) {
            ImportHead.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String getStatistics(@Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater) {
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(15);
        }
        String time = ImportHead.getTimeSpent(timeSpent);
        String speed = ImportHead.getSpeed(timeSpent, updater);
        boolean isTimeEmpty = StringUtil.isEmpty((String)time);
        boolean isSpeedEmpty = StringUtil.isEmpty((String)speed);
        String string = isTimeEmpty && isSpeedEmpty ? "" : (isTimeEmpty || isSpeedEmpty ? String.format(" (%s)", isTimeEmpty ? speed : time) : String.format(" (%s, %s)", time, speed));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getInsertedCount(@Nullable Long importedCount) {
        String string = importedCount == null ? "" : DatabaseBundle.message("notification.content.choice.row.rows", importedCount, importedCount == 1L ? 0 : 1);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String getErrorsCountAndPath(@Nullable String path, long errorsCount) {
        return errorsCount > 0L ? DatabaseBundle.message("notification.content.choice.error.errors.choice.occurred.saved.to", errorsCount, errorsCount == 1L ? 0 : 1, path == null ? 0 : 1) + (String)(path == null ? "" : " " + DbUIUtil.wrapInOpenFileLink(path)) : "";
    }

    @NotNull
    private static String getTimeSpent(@Nullable Long timeSpent) {
        String string = timeSpent == null ? "" : NlsMessages.formatDuration((long)timeSpent);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getSpeed(@Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater) {
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(19);
        }
        if (timeSpent == null || timeSpent / 1000L == 0L) {
            return "";
        }
        String string = StringUtil.notNullize((String)updater.calculateSpeed(timeSpent / 1000L));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportHead";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportHead";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedCount";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeSpent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpeed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutInputError";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getStatistics";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSpeed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OpenTableNotificationListener
    implements NotificationListener {
        private final DbDataSource mySystem;
        private final DeTable myTable;

        OpenTableNotificationListener(@Nullable DbDataSource system, @NotNull DeTable table) {
            if (table == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(0);
            }
            this.mySystem = system;
            this.myTable = table;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                OpenTableNotificationListener.$$$reportNull$$$0(2);
            }
            if (!ImportHead.OPEN_TABLE_DESC.equals(event.getDescription())) {
                return;
            }
            DbElement dbTable = DbImplUtilCore.findElement(this.mySystem, this.myTable.unwrap());
            if (dbTable == null && this.mySystem != null) {
                dbTable = DbSqlUtilCore.findElement(this.mySystem, this.myTable.getPath());
            }
            if (dbTable != null) {
                DbNavigationUtils.navigateToData(dbTable, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportHead$OpenTableNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

