/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtilCore;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcUrlParserUtil
extends JdbcUrlParserUtilCore {
    @Nullable
    public static JdbcUrlParser parsed(@Nullable RawConnectionConfig config, @Nullable String url) {
        if (config == null) {
            return null;
        }
        StatelessJdbcUrlParser parser2 = JdbcUrlParserUtil.select(config, url);
        return JdbcUrlParserUtil.parsed(parser2, url);
    }

    @Nullable
    public static JdbcUrlParser parsed(@Nullable RawConnectionConfig config) {
        String url = config == null ? null : config.getUrl();
        return JdbcUrlParserUtil.parsed(config, url);
    }

    @Nullable
    public static Pair.NonNull<String, String> extractHostPort(@NotNull Collection<StatelessJdbcUrlParser> parsers, @NotNull String url, @Nullable Ref<JdbcUrlParser> p2) {
        JdbcUrlParser parser2;
        if (parsers == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(0);
        }
        if (url == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(1);
        }
        if ((parser2 = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(parsers, url, StatelessJdbcUrlParser.LocationType.REMOTE))) != null) {
            parser2.setUrlText(url);
        }
        if (parser2 == null || !parser2.isValid()) {
            return null;
        }
        String host = parser2.getParameter("host");
        String port = parser2.getParameter("port");
        if (StringUtil.isEmpty((String)port)) {
            port = parser2.getParameterDefValue("port");
        }
        if (p2 != null) {
            p2.set((Object)parser2);
        }
        return StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port) ? null : Pair.createNonNull((Object)host, (Object)port);
    }

    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriverCore.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(2);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(3);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return connectionPoint;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        LazyStatefulParser parser2 = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser2, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
            return connectionPoint;
        }
        return JdbcUrlParserUtil.rebound(parser2, connectionPoint, bounds, neededParam);
    }

    public static DatabaseConnectionPoint connectedTo(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriverCore.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(4);
        }
        if (current == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(5);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(6);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return connectionPoint;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return connectionPoint;
        }
        String parameter = JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo);
        if (!JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam)) {
            return connectionPoint;
        }
        return JdbcUrlParserUtil.rebound(new LazyStatefulParser(connectionPoint), connectionPoint, bounds, neededParam);
    }

    public static boolean isBounded(@NotNull DatabaseConnectionPoint connectionPoint) {
        DatabaseDriverCore.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(7);
        }
        return (bounds = JdbcUrlParserUtil.getBounds(connectionPoint)) != null && (!bounds.inReadOnlyMode || connectionPoint.isReadOnly());
    }

    public static boolean isDatabaseBounded(@NotNull DatabaseConnectionPoint connectionPoint) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(8);
        }
        if (!JdbcUrlParserUtil.isBounded(connectionPoint)) {
            return false;
        }
        DatabaseDriverCore.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds != null && bounds.boundTo == ObjectKind.DATABASE;
    }

    @Nullable
    public static DatabaseDriverCore.Bounds getBounds(@Nullable DatabaseConnectionPoint connectionPoint) {
        return JdbcUrlParserUtil.getBounds(connectionPoint == null ? null : connectionPoint.getDatabaseDriver());
    }

    @Nullable
    private static DatabaseDriverCore.Bounds getBounds(@Nullable DatabaseDriverCore driver) {
        return driver == null ? null : driver.getConnectionBounds();
    }

    public static boolean isReboundable(@NotNull DatabaseConnectionPoint connectionPoint) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(9);
        }
        if (!connectionPoint.getDataSource().isRewriteBounds()) {
            return false;
        }
        DatabaseDriverCore.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds != null && !bounds.rewriteParameters.isEmpty();
    }

    @NotNull
    private static DatabaseConnectionPoint rebound(@NotNull LazyStatefulParser parser2, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull DatabaseDriverCore.Bounds bounds, final @NotNull String neededParam) {
        if (parser2 == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(10);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(11);
        }
        if (bounds == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(12);
        }
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(13);
        }
        if (bounds.rewriteParameters.isEmpty() || !connectionPoint.getDataSource().isRewriteBounds()) {
            DatabaseConnectionPoint databaseConnectionPoint = connectionPoint;
            if (databaseConnectionPoint == null) {
                JdbcUrlParserUtil.$$$reportNull$$$0(14);
            }
            return databaseConnectionPoint;
        }
        final Pair<String, Boolean> param = bounds.rewriteParameters.get(0);
        if (((Boolean)param.second).booleanValue()) {
            JdbcUrlParser urlParser = parser2.getParser();
            if (urlParser == null) {
                DatabaseConnectionPoint databaseConnectionPoint = connectionPoint;
                if (databaseConnectionPoint == null) {
                    JdbcUrlParserUtil.$$$reportNull$$$0(15);
                }
                return databaseConnectionPoint;
            }
            urlParser.setParameter((String)param.first, neededParam);
            final String rewritten = urlParser.getUrlText();
            return new DatabaseConnectionPoint.Adapter(connectionPoint){

                @Override
                public String getUrl() {
                    return rewritten;
                }
            };
        }
        return new DatabaseConnectionPoint.Adapter(connectionPoint){

            @Override
            @NotNull
            public Properties getConnectionProperties() {
                Properties properties = super.getConnectionProperties();
                properties.setProperty((String)param.first, neededParam);
                Properties properties2 = properties;
                if (properties2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return properties2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/JdbcUrlParserUtil$2", "getConnectionProperties"));
            }
        };
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ObjectPath needed) {
        DatabaseDriverCore.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(16);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(17);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        LazyStatefulParser parser2 = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser2, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull TreePattern needed) {
        DatabaseDriverCore.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(18);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(19);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return false;
        }
        TreePatternNode.Group neededParam = needed.root.getGroup(bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        LazyStatefulParser parser2 = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser2, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(parameter, neededParam);
    }

    public static String getBoundParameter(@NotNull DatabaseConnectionPoint connectionPoint) {
        DatabaseDriverCore.Bounds bounds;
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(20);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(connectionPoint), connectionPoint.isReadOnly()) || bounds.rewriteParameters.isEmpty()) {
            return null;
        }
        LazyStatefulParser parser2 = new LazyStatefulParser(connectionPoint);
        String parameter = JdbcUrlParserUtil.findParameter(parser2, connectionPoint, bounds.rewriteParameters);
        if (StringUtil.isEmpty((String)parameter)) {
            parameter = bounds.defaultValue;
        }
        return StringUtil.nullize((String)parameter);
    }

    public static boolean outOfBounds(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath current, @NotNull ObjectPath needed) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(21);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(22);
        }
        if (current == null) {
            return JdbcUrlParserUtil.outOfBounds(connectionPoint, needed);
        }
        return JdbcUrlParserUtil.outOfBounds(connectionPoint.getDatabaseDriver(), connectionPoint.isReadOnly(), current, needed);
    }

    public static boolean outOfBounds(@Nullable DatabaseDriverCore driver, boolean isReadOnly, @NotNull ObjectPath current, @NotNull ObjectPath needed) {
        DatabaseDriverCore.Bounds bounds;
        if (current == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(23);
        }
        if (needed == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(24);
        }
        if (JdbcUrlParserUtil.inBoundsFast(bounds = JdbcUrlParserUtil.getBounds(driver), isReadOnly)) {
            return false;
        }
        String neededParam = JdbcUrlParserUtil.getObjectItem(needed, bounds.boundTo);
        if (neededParam == null) {
            return false;
        }
        return JdbcUrlParserUtil.paramOutOfBounds(JdbcUrlParserUtil.getObjectItem(current, bounds.boundTo), neededParam);
    }

    private static boolean paramOutOfBounds(@Nullable String currentParameter, @NotNull String neededParam) {
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(25);
        }
        if (currentParameter == null) {
            return true;
        }
        return !neededParam.equalsIgnoreCase(currentParameter);
    }

    private static boolean paramOutOfBounds(@Nullable String currentParameter, @NotNull TreePatternNode.Group neededParam) {
        if (neededParam == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(26);
        }
        if (currentParameter == null) {
            return true;
        }
        return !neededParam.matchedChildren(ObjectName.plain(currentParameter), CasingProvider.MIXED_CASING, null);
    }

    private static boolean inBoundsFast(@Nullable DatabaseDriverCore.Bounds bounds, boolean isReadOnly) {
        return bounds == null || !isReadOnly && bounds.inReadOnlyMode;
    }

    @Nullable
    public static ObjectPath toBound(@NotNull DatabaseConnectionPoint connectionPoint, @Nullable ObjectPath path) {
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(27);
        }
        if (path == null || !JdbcUrlParserUtil.outOfBounds(connectionPoint, path)) {
            return null;
        }
        DatabaseDriverCore.Bounds bounds = JdbcUrlParserUtil.getBounds(connectionPoint);
        return bounds == null ? null : JdbcUrlParserUtil.getObjectPathTo(path, bounds.boundTo);
    }

    @Nullable
    public static String getObjectItem(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        ObjectPath p2;
        if (kind == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(28);
        }
        return (p2 = JdbcUrlParserUtil.getObjectPathTo(path, kind)) == null ? null : p2.getName();
    }

    @Nullable
    public static ObjectPath getObjectPathTo(@Nullable ObjectPath path, @NotNull ObjectKind kind) {
        if (kind == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(29);
        }
        return path == null ? null : path.findParent(kind, false);
    }

    @Nullable
    private static String findParameter(@NotNull LazyStatefulParser parser2, @NotNull DatabaseConnectionPoint connectionPoint, @NotNull List<Pair<String, Boolean>> params) {
        if (parser2 == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(30);
        }
        if (connectionPoint == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(31);
        }
        if (params == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(32);
        }
        HashMap<Object, Object> properties = null;
        for (Pair<String, Boolean> param : params) {
            String value2;
            if (((Boolean)param.second).booleanValue()) {
                JdbcUrlParser urlParser = parser2.getParser();
                value2 = urlParser != null ? urlParser.getParameter((String)param.first) : null;
            } else {
                if (properties == null) {
                    properties = new HashMap<Object, Object>(connectionPoint.getConnectionProperties());
                }
                value2 = (String)ObjectUtils.tryCast(properties.get(param.first), String.class);
            }
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public static boolean isAuthSupported(@NotNull StatelessParametersHolder parametersHolder) {
        Collection<String> parameters;
        if (parametersHolder == null) {
            JdbcUrlParserUtil.$$$reportNull$$$0(33);
        }
        return (parameters = parametersHolder.getParameters()).contains("password") || parameters.contains("user");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 3: 
            case 6: 
            case 17: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 10: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 13: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "neededParam";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/JdbcUrlParserUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "rebound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHostPort";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connectedTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBounded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseBounded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReboundable";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rebound";
                break;
            }
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "outOfBounds";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBoundParameter";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "paramOutOfBounds";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toBound";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getObjectItem";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPathTo";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findParameter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isAuthSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LazyStatefulParser {
        private final RawConnectionConfig myConfig;
        private Ref<JdbcUrlParser> myParser;

        private LazyStatefulParser(RawConnectionConfig config) {
            this.myConfig = config;
        }

        @Nullable
        JdbcUrlParser getParser() {
            if (this.myParser == null) {
                this.myParser = Ref.create((Object)JdbcUrlParserUtil.parsed(this.myConfig));
            }
            return (JdbcUrlParser)this.myParser.get();
        }
    }
}

