/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorageUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcUtilsCore {
    private static final Logger LOG = Logger.getInstance(DbSrcUtilsCore.class);
    protected static final String EMPTY = "&empty;";
    protected static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("/", "\\", "&", "@"), Arrays.asList("&eslash;", "&slash;", "&amp;", "&at;"));

    protected DbSrcUtilsCore() {
    }

    public static boolean isDbSrcFile(@Nullable VirtualFile file) {
        return file != null && file.getFileSystem() instanceof DbSrcFileSystemCore;
    }

    @Nullable
    public static String getDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(0);
        }
        return DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<String>(){

            @Override
            public String processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataSourceId;
            }

            @Override
            public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dataSourceId;
            }

            @Override
            public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                return dataSourceId;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static ObjectPath getFullPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(1);
        }
        return DbSrcFileSystemCore.processPath(path, new DbSrcFileSystemCore.ItemProcessor<ObjectPath>(){

            @Override
            public ObjectPath processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, ObjectKind group) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                return group == null ? path : null;
            }

            @Override
            public ObjectPath processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    2.$$$reportNull$$$0(3);
                }
                return path;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(2);
        }
        return StringUtil.tokenize((String)path, (String)"/");
    }

    public static String unescapeChars(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s2, ESCAPES.get(1), ESCAPES.get(0));
    }

    @Nullable
    public static ObjectKind findKind(@Nullable String code) {
        return code == null ? null : ObjectKind.ourKinds.get(code);
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(3);
        }
        List<? extends LocalDataSource> sources = DbSrcUtilsCore.getDataSources(project);
        for (LocalDataSource localDataSource : sources) {
            if (localDataSource.isGlobal() != (project == null) || !id.equals(localDataSource.getUniqueId())) continue;
            return localDataSource;
        }
        return null;
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<LocalDataSource>(){

            @Override
            public LocalDataSource processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(1);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (type == null) {
                    3.$$$reportNull$$$0(4);
                }
                return DbSrcUtilsCore.findDataSource(project, dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static List<? extends LocalDataSource> getDataSources(@Nullable Project project) {
        List<? extends LocalDataSource> list = project == null ? DataSourceStorageUtil.getStorage().getDataSources() : DataSourceStorageUtil.getProjectStorage(project).getDataSources();
        if (list == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static int hashCode(CharSequence cs) {
        int res2 = 0;
        if (cs != null) {
            for (int i2 = 0; i2 < cs.length(); ++i2) {
                res2 = StringHashBuilder.hashStep(res2, cs.charAt(i2));
            }
        }
        return res2;
    }

    public static String escapeChars(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s2, ESCAPES.get(0), ESCAPES.get(1));
    }

    @Nullable
    public static <T extends DbElement> T findDbElement(final @NotNull Project project, @NotNull String file, final @NotNull Class<T> clazz) {
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(7);
        }
        return (T)((DbElement)DbSrcFileSystemCore.processPath(file, new DbSrcFileSystemCore.ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project p2, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    4.$$$reportNull$$$0(2);
                }
                return this.findElement(p2, dataSourceId, path);
            }

            @Override
            public T processFolder(@Nullable Project p2, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (group != null) {
                    return null;
                }
                return this.findElement(p2, dataSourceId, path);
            }

            @Nullable
            private T findElement(@Nullable Project p2, @NotNull String dataSourceId, @Nullable ObjectPath path) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (p2 != null && p2 != project) {
                    return null;
                }
                DbDataSource dataSource2 = DbPsiFacade.getInstance(project).findDataSource(dataSourceId);
                if (dataSource2 == null) {
                    return null;
                }
                DbDataSource result2 = path == null ? dataSource2 : DbSqlUtilCore.findElement(dataSource2, path);
                return (DbElement)ObjectUtils.tryCast((Object)result2, (Class)clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @NotNull
    public static PersistentMarkup formatCompositeText(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable String target, @NotNull CompositeText text2, @Nullable CodeStyleSettings settings) {
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(8);
        }
        if (dialect == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(10);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        ArrayList<Pair> ranges = new ArrayList<Pair>();
        CompositeText.Kind prev = CompositeText.Kind.FIXED_TEXT;
        for (CompositeText.Fragment fragment : text2.getFragments()) {
            int start2 = document.getTextLength();
            document.insertString(start2, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
            int end2 = document.getTextLength();
            CompositeText.Kind kind = fragment.getKind();
            if (kind == CompositeText.Kind.COMPACT_DEFINITION) {
                kind = prev.getContent() ? prev : CompositeText.Kind.ORIGINAL_TEXT;
            }
            boolean doNotFormat = kind == CompositeText.Kind.FIXED_TEXT || kind == CompositeText.Kind.ORIGINAL_TEXT || kind == CompositeText.Kind.SPECIFICATION_TEXT;
            RangeMarker marker = doNotFormat ? document.createGuardedBlock(start2, end2) : document.createRangeMarker(start2, end2);
            ranges.add(Pair.create((Object)marker, (Object)fragment));
        }
        SqlPsiFacade.getInstance((Project)project).format(project, dialect, (Document)document, settings);
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (Pair range : ranges) {
            if (!((RangeMarker)range.first).isValid()) {
                LOG.warn("Range marker died during formatting" + (String)(target == null ? "" : " of " + target));
                continue;
            }
            builder.add(((CompositeText.Fragment)range.second).getKind(), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset(), ((CompositeText.Fragment)range.second).getError());
        }
        PersistentMarkup persistentMarkup = builder.build(document.getText());
        if (persistentMarkup == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(11);
        }
        return persistentMarkup;
    }

    @NlsContexts.TabTitle
    @Nullable
    public static String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file, boolean appendDataSource, boolean shorten) {
        ObjectPath path;
        if (project == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(12);
        }
        if (file == null) {
            DbSrcUtilsCore.$$$reportNull$$$0(13);
        }
        if ((path = DbSrcUtilsCore.getFullPath(file.getPath())) == null) {
            return null;
        }
        String dataSourceId = DbSrcUtilsCore.getDataSource(file);
        DbDataSource dataSource2 = DbPsiFacade.getInstance(project).findDataSource(dataSourceId);
        return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file, path, dataSource2, appendDataSource, shorten);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtilsCore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFullPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 4: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDbElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringHashBuilder {
        private int h = 0;

        public void consume(int c2) {
            this.h = StringHashBuilder.hashStep(this.h, c2);
        }

        public void consume(byte[] a2, int s2, int f) {
            while (s2 < f) {
                this.consume(a2[s2]);
                ++s2;
            }
        }

        public void consume(byte[] a2) {
            this.consume(a2, 0, a2.length);
        }

        public static int hashStep(int h, int c2) {
            return 31 * h + c2;
        }

        public static int hashStep(int h, byte[] a2, int s2, int f) {
            if (a2 == null) {
                return h;
            }
            while (s2 < f) {
                h = StringHashBuilder.hashStep(h, a2[s2]);
                ++s2;
            }
            return h;
        }

        public static int hashStep(int h, byte[] a2) {
            return a2 == null ? h : StringHashBuilder.hashStep(h, a2, 0, a2.length);
        }

        public int get() {
            return this.h;
        }
    }
}

