/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.DbSrcMigrationUtils;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DbSrcModificationSession {
    private static final Logger LOG = Logger.getInstance(DbSrcModificationSession.class);
    private static final CountedThreadExecutor ourStorageWriter = new CountedThreadExecutor(10);
    @Nullable
    private final Project myContextProject;
    private final List<ObjectPath> myRemoveQueue;
    private final List<Couple<ObjectPath>> myRenameQueue;
    private final Set<ObjectPath> myInvalidatedSchemas;
    private final Set<ObjectPath> myDirtySrc;
    private volatile Pair<BasicSourceAware, CompositeText> myCurrentSource;
    private final boolean myGlobal;
    private final boolean myFormatOnSync;
    private final DbSrcStorage myStorage;
    private final ModalityState myModality;

    DbSrcModificationSession(@Nullable Project contextProject, boolean global, @NotNull DbSrcStorage storage, @NotNull ModalityState modality) {
        if (storage == null) {
            DbSrcModificationSession.$$$reportNull$$$0(0);
        }
        if (modality == null) {
            DbSrcModificationSession.$$$reportNull$$$0(1);
        }
        this.myRemoveQueue = new ArrayList<ObjectPath>();
        this.myRenameQueue = new ArrayList<Couple<ObjectPath>>();
        this.myInvalidatedSchemas = new LinkedHashSet<ObjectPath>();
        this.myDirtySrc = new LinkedHashSet<ObjectPath>();
        this.myCurrentSource = null;
        assert (contextProject != null || global);
        this.myContextProject = contextProject;
        this.myGlobal = global;
        this.myStorage = storage;
        this.myModality = modality;
        LocalDataSource dataSource2 = DbSrcUtils.findDataSource(contextProject, this.myStorage.getDataSourceId());
        DatabaseDriver driver = dataSource2 != null ? dataSource2.getDatabaseDriver() : null;
        this.myFormatOnSync = driver != null && DatabaseDriver.OPTION_FORMAT_SOURCES_ON_SYNC.get(driver) != false;
    }

    public synchronized void save(@NotNull BasicSourceAware object, @Nullable CompositeText text2) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(2);
        }
        this.flushDeleteQueue();
        this.flushRenameQueue();
        ObjectPath srcPath = ObjectPaths.of(object, object.getModel());
        if (text2 == null) {
            ourStorageWriter.execute(() -> this.processDelete(srcPath));
        } else {
            CompositeText generated = this.generate(object, text2);
            Dbms dbms = DbSrcModificationSession.getDbms(object);
            int genVersion = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(object).getCreateVersion();
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(dbms, object.getKind());
            ourStorageWriter.execute(() -> this.processSave(srcPath, dbms, generated, introVersion, genVersion));
        }
    }

    @NotNull
    private static Dbms getDbms(@NotNull BasicSourceAware object) {
        BasicModel model;
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(3);
        }
        Dbms dbms = (model = object.getModel()) == null ? object.getMetaObject().getModel().dbms : model.getDbms();
        if (dbms == null) {
            DbSrcModificationSession.$$$reportNull$$$0(4);
        }
        return dbms;
    }

    public synchronized void queueRename(@NotNull BasicElement object, @NotNull String oldName) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(5);
        }
        if (oldName == null) {
            DbSrcModificationSession.$$$reportNull$$$0(6);
        }
        this.flushDeleteQueue();
        ObjectPath srcPath = ObjectPaths.of(object, object.getModel());
        ObjectPath oldPath = ObjectPath.create(oldName, srcPath.kind, true, srcPath.getIdentity(), srcPath.parent);
        if (!oldPath.equals(srcPath)) {
            this.myRenameQueue.add((Couple<ObjectPath>)Couple.of((Object)oldPath, (Object)srcPath));
        }
    }

    public synchronized void queueDelete(@NotNull BasicElement object) {
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(7);
        }
        ObjectPath srcPath = ObjectPaths.of(object, object.getModel());
        this.flushRenameQueue();
        this.myRemoveQueue.add(srcPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompositeText generate(@NotNull BasicSourceAware object, @NotNull CompositeText text2) {
        CompositeText compositeText;
        BasicModel model;
        block11: {
            if (object == null) {
                DbSrcModificationSession.$$$reportNull$$$0(8);
            }
            if (text2 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(9);
            }
            this.myCurrentSource = Pair.create((Object)object, (Object)text2);
            model = object.getModel();
            if (model != null && this.myContextProject != null && !this.myContextProject.isDisposed()) break block11;
            CompositeText compositeText2 = text2;
            this.myCurrentSource = null;
            CompositeText compositeText3 = compositeText2;
            if (compositeText3 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(10);
            }
            return compositeText3;
        }
        try {
            ScriptingSingleModelTaskBuilder task2 = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
            task2.getElements().add(object);
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(model.getDbms()), object), BasicNamespace.class);
            task2.setCurrentNamespace(namespace);
            ScriptingResult result2 = ScriptGenerators.INSTANCE.makeScript(this.myContextProject, task2.build());
            CompositeText compositeText4 = result2.getScript();
            this.myCurrentSource = null;
            compositeText = compositeText4;
        }
        catch (Throwable e) {
            CompositeText compositeText5;
            try {
                LOG.warn("Code generation failed", e);
                CompositeText compositeText6 = text2;
                compositeText5 = compositeText6;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.myCurrentSource = null;
            }
            if (compositeText5 == null) {
                DbSrcModificationSession.$$$reportNull$$$0(12);
            }
            return compositeText5;
        }
        if (compositeText == null) {
            DbSrcModificationSession.$$$reportNull$$$0(11);
        }
        return compositeText;
    }

    private void flushDeleteQueue() {
        if (this.myRemoveQueue.isEmpty()) {
            return;
        }
        List<ObjectPath> toRemove = DbSrcModificationSession.collectRoots(this.myRemoveQueue);
        this.myRemoveQueue.clear();
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            for (ObjectPath path : toRemove) {
                try {
                    this.processDrop(path);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        }));
    }

    synchronized void regenSources(@NotNull BasicModModel model) {
        if (model == null) {
            DbSrcModificationSession.$$$reportNull$$$0(13);
        }
        this.waitExecutionFinished();
        if (this.myDirtySrc.isEmpty()) {
            return;
        }
        List<ObjectPath> regenRoots = DbSrcModificationSession.collectRoots(new ArrayList<ObjectPath>(this.myDirtySrc));
        this.myDirtySrc.clear();
        for (BasicModSourceAware obj : ((JBTreeTraverser)model.basicTraverser().withRoots((Iterable)JBIterable.from(regenRoots).flatten(p2 -> QNameUtil.findByPath(model, p2)).filter(BasicElement.class))).filter(BasicModSourceAware.class)) {
            this.regenSource(obj);
        }
    }

    @NotNull
    private static List<ObjectPath> collectRoots(List<ObjectPath> paths) {
        ObjectIntHashMap lens = new ObjectIntHashMap(paths.size());
        for (ObjectPath path : paths) {
            lens.put((Object)path, ObjectPaths.getLength(path));
        }
        paths.sort((arg_0, arg_1) -> DbSrcModificationSession.lambda$collectRoots$5((ObjectIntMap)lens, arg_0, arg_1));
        LinkedHashSet<ObjectPath> processed = new LinkedHashSet<ObjectPath>();
        ArrayList<ObjectPath> regenRoots = new ArrayList<ObjectPath>();
        block1: for (ObjectPath cur2 : paths) {
            if (!processed.add(cur2)) continue;
            ObjectPath p2 = cur2.parent;
            while (p2 != null) {
                if (processed.contains(p2)) continue block1;
                p2 = p2.parent;
            }
            regenRoots.add(cur2);
        }
        ArrayList<ObjectPath> arrayList = regenRoots;
        if (arrayList == null) {
            DbSrcModificationSession.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private void regenSource(@NotNull BasicModSourceAware element2) {
        if (element2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(15);
        }
        ObjectPath path = BasicPaths.of(element2, element2.getModel());
        byte[] content = new byte[]{};
        try {
            content = this.myStorage.getContent(path, DbSrcFileSystemCore.ItemType.ORIG);
        }
        catch (IOException e) {
            LOG.warn("Failed to get sources of " + path.getDisplayName(), (Throwable)e);
        }
        if (content == null) {
            return;
        }
        DbSrcStorageDsMetadata.MetaData metaData = this.myStorage.getMetaData(path);
        String text2 = new String(content, StandardCharsets.UTF_8);
        CompositeText markup = metaData == null ? new SimpleCompositeText((CharSequence)text2, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text2, metaData.offsets, metaData.kinds, null);
        this.save(element2, markup);
    }

    private void flushRenameQueue() {
        if (this.myRenameQueue.isEmpty()) {
            return;
        }
        LinkedHashMap<ObjectPath, ObjectPath> toHandle = new LinkedHashMap<ObjectPath, ObjectPath>();
        for (Couple<ObjectPath> couple : this.myRenameQueue) {
            toHandle.put((ObjectPath)couple.first, (ObjectPath)couple.second);
        }
        this.myRenameQueue.clear();
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            try {
                this.processGroupRename(toHandle);
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }));
    }

    private void processGroupRename(Map<ObjectPath, ObjectPath> renames) {
        HashSet<ObjectPath> targets2 = new HashSet<ObjectPath>(renames.values());
        this.processSimpleRenames(renames, targets2);
        while (!renames.isEmpty()) {
            Iterator<Map.Entry<ObjectPath, ObjectPath>> it2 = renames.entrySet().iterator();
            Map.Entry<ObjectPath, ObjectPath> breaker = it2.next();
            it2.remove();
            ObjectPath tmp2 = ObjectPath.create(breaker.getKey().name, breaker.getKey().kind, breaker.getKey().isQuoted(), "cycle-rename-temporary", breaker.getKey().parent);
            this.processRename(breaker.getKey(), tmp2);
            this.processSimpleRenames(renames, targets2);
            this.processRename(tmp2, breaker.getValue());
        }
    }

    private void processSimpleRenames(Map<ObjectPath, ObjectPath> renames, Set<ObjectPath> targets2) {
        while (!renames.isEmpty()) {
            int before2 = renames.size();
            Iterator<Map.Entry<ObjectPath, ObjectPath>> it2 = renames.entrySet().iterator();
            block1: while (it2.hasNext()) {
                Map.Entry<ObjectPath, ObjectPath> entry = it2.next();
                if (renames.containsKey(entry.getValue())) continue;
                ObjectPath tmp2 = entry.getKey().parent;
                while (tmp2 != null) {
                    if (targets2.contains(tmp2)) continue block1;
                    tmp2 = tmp2.parent;
                }
                it2.remove();
                this.processRename(entry.getKey(), entry.getValue());
            }
            if (before2 != renames.size()) continue;
            break;
        }
    }

    private void processRename(@NotNull ObjectPath from, @NotNull ObjectPath to) {
        if (from == null) {
            DbSrcModificationSession.$$$reportNull$$$0(16);
        }
        if (to == null) {
            DbSrcModificationSession.$$$reportNull$$$0(17);
        }
        try {
            this.myStorage.moveAll(from, to);
            this.myDirtySrc.add(to);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    public synchronized void beginWrite() {
    }

    public synchronized void endWrite() {
        this.flushDeleteQueue();
        this.flushRenameQueue();
    }

    @Nullable
    public CompositeText getTmpSource(@NotNull BasicSourceAware object) {
        Pair<BasicSourceAware, CompositeText> src;
        if (object == null) {
            DbSrcModificationSession.$$$reportNull$$$0(18);
        }
        return (src = this.myCurrentSource) == null || src.first != object ? null : (CompositeText)src.second;
    }

    private void processDelete(@NotNull ObjectPath srcPath) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(19);
        }
        try {
            this.myStorage.putOriginalContent(srcPath, null, DbSrcStorageDsMetadata.MetaData.EMPTY);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this.invalidateSchema(srcPath);
    }

    private void processDrop(@NotNull ObjectPath srcPath) {
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(20);
        }
        try {
            this.myStorage.dropObject(srcPath, true);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this.invalidateSchema(srcPath);
    }

    @NotNull
    private PersistentMarkup format(@NotNull ObjectPath srcPath, @NotNull Dbms dbms, @NotNull CompositeText text2) {
        PersistentMarkup persistentMarkup;
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(21);
        }
        if (dbms == null) {
            DbSrcModificationSession.$$$reportNull$$$0(22);
        }
        if (text2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(23);
        }
        if (this.myContextProject == null || this.myContextProject.isDisposed()) {
            return DbSrcModificationSession.asPersistent(text2);
        }
        try {
            SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(dbms);
            persistentMarkup = DbSrcUtilsCore.formatCompositeText(this.myContextProject, dialect, srcPath.getDisplayName(), text2, null);
        }
        catch (Throwable e) {
            LOG.warn("Formatting for " + srcPath + " failed, passing unformatted", e);
            return DbSrcModificationSession.asPersistent(text2);
        }
        if (persistentMarkup == null) {
            DbSrcModificationSession.$$$reportNull$$$0(24);
        }
        return persistentMarkup;
    }

    @NotNull
    private static PersistentMarkup asPersistent(@NotNull CompositeText text2) {
        if (text2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(25);
        }
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (CompositeText.Fragment f : text2.getFragments()) {
            builder.add(f.getKind(), f.getBegin(), f.getEnd(), f.getError());
        }
        PersistentMarkup persistentMarkup = builder.build(text2.getText());
        if (persistentMarkup == null) {
            DbSrcModificationSession.$$$reportNull$$$0(26);
        }
        return persistentMarkup;
    }

    private void synchronizeFs(boolean async) {
        this.submitTransaction(() -> this.myStorage.flushToFs(async));
    }

    private void processSave(@NotNull ObjectPath srcPath, @NotNull Dbms dbms, @NotNull CompositeText text2, int introVersion, int genVersion) {
        FileDocumentManager manager;
        Document document;
        VirtualFile dbFile;
        if (srcPath == null) {
            DbSrcModificationSession.$$$reportNull$$$0(27);
        }
        if (dbms == null) {
            DbSrcModificationSession.$$$reportNull$$$0(28);
        }
        if (text2 == null) {
            DbSrcModificationSession.$$$reportNull$$$0(29);
        }
        PersistentMarkup sql = this.myFormatOnSync ? this.format(srcPath, dbms, text2) : DbSrcModificationSession.asPersistent(text2);
        if (this.myContextProject != null) {
            sql = DbSrcModificationSession.markCompactDefinition(this.myContextProject, dbms, srcPath, sql);
        }
        DbSrcStorageDsMetadata.MetaData data = this.myStorage.getMetaData(srcPath);
        DbSrcStorageDsMetadata.MetaData expected = sql.getExpectedMetaData(data, introVersion, genVersion);
        Project objProject = this.getObjectProject();
        VirtualFile virtualFile = dbFile = objProject != null && objProject.isDisposed() ? null : DbSrcFileSystem.getInstance().findFileByPathIfCached(DbSrcFileSystem.getPathFromNormalized(objProject, this.myStorage.getDataSourceId(), srcPath, (DbSrcFileSystemCore.ItemTypeOrFolder)DbSrcFileSystemCore.ItemType.SRC));
        if (dbFile != null && (document = (manager = FileDocumentManager.getInstance()).getCachedDocument(dbFile)) != null && manager.isDocumentUnsaved(document)) {
            manager.saveDocument(document);
        }
        try {
            this.myStorage.putOriginalContent(srcPath, sql.getText().toString().getBytes(StandardCharsets.UTF_8), expected);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        if (data == null || data.introContentVersion != expected.introContentVersion || data.genContentVersion != expected.genContentVersion) {
            this.invalidateSchema(srcPath);
        }
    }

    public static PersistentMarkup markCompactDefinition(@NotNull Project project, Dbms dbms, ObjectPath path, PersistentMarkup sql) {
        TextRange rg;
        if (project == null) {
            DbSrcModificationSession.$$$reportNull$$$0(30);
        }
        if ((rg = DbSrcMigrationUtils.findCompactDefinitionRange(project, dbms, path, sql, (Function<CompositeText, CompositeText>)Functions.id())) == null) {
            return sql;
        }
        List<CompositeText.Fragment> fragments = sql.getFragments();
        int sz = fragments.size() + 2;
        int[] offsets = new int[sz];
        char[] kinds = new char[sz];
        TIntObjectHashMap errors = new TIntObjectHashMap();
        int i2 = 0;
        int rgs = rg.getStartOffset();
        int rge = rg.getEndOffset();
        for (CompositeText.Fragment fragment : fragments) {
            int end2 = fragment.getEnd();
            char kind = fragment.getKind().getCode();
            String error2 = fragment.getError();
            if (fragment.getBegin() <= rgs && end2 >= rge) {
                offsets[i2] = rgs;
                kinds[i2] = kind;
                if (error2 != null) {
                    errors.put(i2, (Object)error2);
                }
                offsets[++i2] = rge;
                kinds[i2] = CompositeText.Kind.COMPACT_DEFINITION.getCode();
                if (error2 != null) {
                    errors.put(i2, (Object)error2);
                }
                ++i2;
            }
            offsets[i2] = end2;
            kinds[i2] = kind;
            if (error2 != null) {
                errors.put(i2, (Object)error2);
            }
            ++i2;
        }
        return new PersistentMarkup(sql.getText(), offsets, kinds, (TIntObjectHashMap<String>)errors);
    }

    @Nullable
    private Project getObjectProject() {
        return this.myGlobal ? null : this.myContextProject;
    }

    private void runWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbSrcModificationSession.$$$reportNull$$$0(31);
        }
        this.submitTransaction(() -> {
            Application app = ApplicationManager.getApplication();
            if (!((ComponentManager)Objects.requireNonNull(this.myGlobal ? app : this.myContextProject)).isDisposed()) {
                app.runWriteAction(runnable);
            }
        });
    }

    private void submitTransaction(@NotNull Runnable runnable) {
        Application app;
        if (runnable == null) {
            DbSrcModificationSession.$$$reportNull$$$0(32);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeAndWait(() -> {
                if (!((ComponentManager)Objects.requireNonNull(this.myGlobal ? app : this.myContextProject)).isDisposed()) {
                    runnable.run();
                }
            }, this.myModality);
        }
    }

    public void waitForWriteFinished(boolean asyncRefresh) {
        this.waitExecutionFinished();
        this.synchronizeFs(asyncRefresh);
    }

    public void waitExecutionFinished() {
        CountDownLatch latch = new CountDownLatch(1);
        ourStorageWriter.execute(latch::countDown);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void invalidateSchema(@NotNull ObjectPath path) {
        ObjectPath schema;
        if (path == null) {
            DbSrcModificationSession.$$$reportNull$$$0(33);
        }
        if ((schema = path.findParent(ObjectKind.SCHEMA, false)) != null && !this.myInvalidatedSchemas.contains(schema)) {
            this.myInvalidatedSchemas.add(schema);
            DbSrcValidator.invalidate(this.myStorage, schema);
        }
    }

    private static /* synthetic */ int lambda$collectRoots$5(ObjectIntMap lens, ObjectPath p1, ObjectPath p2) {
        return Comparing.compare((int)lens.get((Object)p1), (int)lens.get((Object)p2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 9: 
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcPath";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "asPersistent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queueRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "queueDelete";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "regenSources";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "regenSource";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processRename";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTmpSource";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processDelete";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processDrop";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "asPersistent";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processSave";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "markCompactDefinition";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runWriteAction";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "invalidateSchema";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CountedThreadExecutor
    implements Executor {
        private final Logger LOG = Logger.getInstance(CountedThreadExecutor.class);
        private final BlockingQueue<Runnable> myQueue = new LinkedBlockingQueue<Runnable>(100);
        private final int myTimeoutSec;
        private volatile int myRefCount = 0;
        private volatile boolean myRunning = false;

        private CountedThreadExecutor(int timeoutSec) {
            this.myTimeoutSec = timeoutSec;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                ++this.myRefCount;
                if (!this.myRunning) {
                    this.myRunning = true;
                    ApplicationManager.getApplication().executeOnPooledThread(this::processQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                assert (this.myRefCount > 0);
                assert (this.myRunning);
                --this.myRefCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Runnable command) {
            boolean acquire;
            if (command == null) {
                CountedThreadExecutor.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Operation not allowed from EDT");
            }
            boolean bl = acquire = this.myRefCount == 0;
            if (acquire) {
                this.acquire();
            }
            assert (this.myRunning);
            try {
                this.myQueue.put(command);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (acquire) {
                    this.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            block25: {
                boolean running = true;
                block19: while (true) {
                    try {
                        while (true) {
                            Runnable task2;
                            if ((task2 = this.myQueue.poll(this.myTimeoutSec, TimeUnit.SECONDS)) == null) {
                                BlockingQueue<Runnable> blockingQueue = this.myQueue;
                                synchronized (blockingQueue) {
                                    if (this.myQueue.isEmpty() && this.myRefCount == 0) {
                                        running = false;
                                        this.myRunning = false;
                                        break block25;
                                    }
                                    continue block19;
                                }
                            }
                            try {
                                task2.run();
                                continue block19;
                            }
                            catch (Throwable e2) {
                                this.LOG.warn(e2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        BlockingQueue<Runnable> e2 = this.myQueue;
                        synchronized (e2) {
                            running = false;
                            this.myRunning = false;
                        }
                        Thread.currentThread().interrupt();
                        break block25;
                    }
                }
                finally {
                    if (running) {
                        BlockingQueue<Runnable> blockingQueue = this.myQueue;
                        synchronized (blockingQueue) {
                            Application app = ApplicationManager.getApplication();
                            if (this.myRunning) {
                                this.LOG.warn("DbSrcWriter accidentally stopped, rescheduling...");
                                app.invokeLater(() -> app.executeOnPooledThread(this::processQueue), app.getDisposed());
                            }
                        }
                    }
                    this.LOG.info("DbSrcWriter stopped");
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dataSource/srcStorage/DbSrcModificationSession$CountedThreadExecutor", "execute"));
        }
    }
}

