/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionResult;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.UniversalResultsProducerKt;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.util.ThrowableRunnable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000534567B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020 H\u0002J!\u0010#\u001a\u0002H$\"\u0004\b\u0001\u0010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H$0\u0016H\u0016\u00a2\u0006\u0002\u0010&J\u0012\u0010#\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\u001bH\u0002J\b\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020\u001bH\u0002J!\u0010,\u001a\u0002H-\"\u0004\b\u0001\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/H\u0016\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\u00020 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0/H\u0016J\b\u00102\u001a\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer;", "T", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "statement", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "result", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "(Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lcom/intellij/database/dataSource/connection/statements/Configuration;Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)V", "currentResultSetIndex", "", "currentResults", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "currentResultsIndex", "parameters", "", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "source", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "updateCount", "advance", "", "advanceContentAndSource", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "advanceCurrentSourceContent", "clearCurrentResults", "", "close", "closeResultSet", "getParameterValue", "V", "parameter", "(Lcom/intellij/database/dataSource/connection/statements/OutParameter;)Ljava/lang/Object;", "", "index", "hasParameterResults", "hasResults", "hasUpdateCount", "processCurrent", "R", "processor", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;", "(Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;)Ljava/lang/Object;", "processRemaining", "requestedResultsReached", "ParametersSource", "ResultSource", "Source", "StatementSource", "Verdict", "intellij.database.core.impl"})
public final class UniversalResultsProducer<T extends RemoteStatement>
implements ClosableResultsProducer {
    private RemoteResultSet currentResults;
    private int updateCount;
    private List<? extends OutParameter<?>> parameters;
    private int currentResultSetIndex;
    private int currentResultsIndex;
    private Source source;
    private final StatementHolder.CloseableRef<T> statement;
    private final SmartStatementMark mark;
    private final Configuration configuration;
    private final DatabaseConnectionCore connection;

    @Override
    public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.hasParameterResults()) {
            processor2.parameterResults(this.parameters, (Function1)new Function1<OutParameter<?>, Object>(this){
                final /* synthetic */ UniversalResultsProducer this$0;

                @Nullable
                public final Object invoke(@NotNull OutParameter<?> it2) {
                    Intrinsics.checkNotNullParameter(it2, (String)"it");
                    return this.this$0.getParameterValue(it2);
                }
                {
                    this.this$0 = universalResultsProducer;
                    super(1);
                }
            }, this.currentResultSetIndex);
        }
        while (this.advance()) {
            this.processCurrent((ResultsProducer.Processor)new ResultsProducer.Processor<Unit>(processor2){
                final /* synthetic */ ResultsProducer.Processor $processor;

                public void results(@NotNull RemoteResultSet resultSet, int index2) {
                    Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                    this.$processor.results(resultSet, index2);
                }

                public void parameterResults(@NotNull List<? extends OutParameter<?>> parameters, @NotNull Function1<? super OutParameter<?>, ? extends Object> retriever, int index2) {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                    this.$processor.parameterResults(parameters, retriever, index2);
                }

                public void updateCount(int count, int index2) {
                    this.$processor.updateCount(count, index2);
                }
                {
                    this.$processor = $captured_local_variable$0;
                }
            });
        }
    }

    public <R> R processCurrent(@NotNull ResultsProducer.Processor<R> processor2) {
        R r;
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.hasResults()) {
            RemoteResultSet remoteResultSet = this.currentResults;
            Intrinsics.checkNotNull((Object)remoteResultSet);
            r = processor2.results(remoteResultSet, this.currentResultSetIndex);
        } else if (this.hasUpdateCount()) {
            r = processor2.updateCount(this.updateCount, this.currentResultSetIndex);
        } else {
            throw (Throwable)new IllegalStateException("Please, call advance before processCurrent() and make sure that results exits");
        }
        return r;
    }

    public <V> V getParameterValue(@NotNull OutParameter<V> parameter) {
        Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
        T stmt = this.statement.getValue();
        if (stmt instanceof RemoteCallableStatement) {
            return parameter.retrieve((RemoteCallableStatement)stmt);
        }
        throw (Throwable)((Object)new AssertionError((Object)("The statement class is " + stmt.getClass().getSimpleName() + " when expected CallableStatement")));
    }

    @Override
    @Nullable
    public Object getParameterValue(int index2) {
        Object v0;
        block2: {
            Iterable iterable = this.parameters;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                OutParameter it2 = (OutParameter)t;
                boolean bl3 = false;
                if (!(it2 instanceof IndexedOutParameter && ((IndexedOutParameter)it2).getIndex() == index2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        OutParameter outParameter = v0;
        if (outParameter == null) {
            return null;
        }
        OutParameter parameter = outParameter;
        return this.getParameterValue((OutParameter<V>)parameter);
    }

    @Override
    public boolean advance() throws StagedException {
        Verdict state = this.advanceContentAndSource();
        while (state == Verdict.CONTINUE) {
            state = this.advanceContentAndSource();
        }
        return state == Verdict.STOP_ON_RESULT;
    }

    @Override
    public void close() {
        this.connection.getAuditService().getWarningsListener().printStatementWarnings((RemoteStatement)this.statement.getValue(), this.mark);
        this.closeResultSet();
        this.connection.getAuditService().resultsProcessed(this.mark);
        DbImplUtilCore.closeSafe(this.statement);
    }

    private final Verdict advanceContentAndSource() {
        Verdict state = this.advanceCurrentSourceContent();
        this.source = this.source.advance(this.hasResults() || this.hasUpdateCount());
        return state;
    }

    private final Verdict advanceCurrentSourceContent() {
        this.clearCurrentResults();
        this.updateCount = -1;
        if (this.source.hasMoreResultSets()) {
            this.currentResults = (RemoteResultSet)SmartStatementsUtil.runReportingAndGet(this.connection, StagedException.Stage.GET_RESULT_SET, this.mark, (Function0)new Function0<RemoteResultSet>(this){
                final /* synthetic */ UniversalResultsProducer this$0;

                @Nullable
                public final RemoteResultSet invoke() {
                    return UniversalResultsProducer.access$getSource$p(this.this$0).getResultSet();
                }
                {
                    this.this$0 = universalResultsProducer;
                    super(0);
                }
            });
            AdvancedAuditService advancedAuditService = this.connection.getAuditService();
            RemoteResultSet remoteResultSet = this.currentResults;
            Intrinsics.checkNotNull((Object)remoteResultSet);
            advancedAuditService.resultsOpened(remoteResultSet, this.mark);
            int n = this.currentResultSetIndex;
            this.currentResultSetIndex = n + 1;
            n = this.currentResultsIndex;
            this.currentResultsIndex = n + 1;
            n = SmartStatementFactory.Companion.getMaxResults();
            if (1 <= n && this.currentResultSetIndex > n) {
                AdvancedAuditService advancedAuditService2 = this.connection.getAuditService();
                String string = DatabaseBundle.message("notification.content.maximum.number.result.sets.per.query.reached", SmartStatementFactory.Companion.getMaxResults());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026tementFactory.maxResults)");
                advancedAuditService2.message(string, this.mark);
                return Verdict.CONTINUE;
            }
            if (!this.requestedResultsReached()) {
                AdvancedAuditService advancedAuditService3 = this.connection.getAuditService();
                String string = DatabaseBundle.message("notification.content.skipping.result.set", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DatabaseBundle.message(\"\u2026ent.skipping.result.set\")");
                advancedAuditService3.message(string, this.mark);
                return Verdict.CONTINUE;
            }
        } else {
            this.updateCount = ((Number)SmartStatementsUtil.runReportingAndGet(this.connection, StagedException.Stage.GET_UPDATE_COUNT, this.mark, (Function0)new Function0<Integer>(this){
                final /* synthetic */ UniversalResultsProducer this$0;

                public final int invoke() {
                    return UniversalResultsProducer.access$getSource$p(this.this$0).getUpdateCount();
                }
                {
                    this.this$0 = universalResultsProducer;
                    super(0);
                }
            })).intValue();
            if (!this.hasUpdateCount()) {
                return this.source.noResultsVerdict();
            }
            this.connection.getAuditService().updateCount(this.updateCount, this.mark);
            int n = this.currentResultsIndex;
            this.currentResultsIndex = n + 1;
        }
        return Verdict.STOP_ON_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void closeResultSet() {
        RemoteResultSet results2 = this.currentResults;
        try {
            this.clearCurrentResults();
            if (results2 == null) return;
        }
        catch (Throwable throwable) {
            if (results2 == null) throw throwable;
            Function0 function0 = (Function0)new Function0<Unit>(results2){

                public final void invoke() {
                    ((RemoteResultSet)this.receiver).close();
                }
            };
            JdbcNativeUtil.performSafe((ThrowableRunnable)new ThrowableRunnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            });
            throw throwable;
        }
        Function0 function0 = (Function0)new /* invalid duplicate definition of identical inner class */;
        JdbcNativeUtil.performSafe((ThrowableRunnable)new /* invalid duplicate definition of identical inner class */);
    }

    private final void clearCurrentResults() {
        if (this.currentResults != null) {
            AdvancedAuditService advancedAuditService = this.connection.getAuditService();
            RemoteResultSet remoteResultSet = this.currentResults;
            Intrinsics.checkNotNull((Object)remoteResultSet);
            advancedAuditService.beforeResultsClosing(remoteResultSet, this.mark);
        }
        this.currentResults = null;
    }

    private final boolean hasUpdateCount() {
        return this.updateCount != -1;
    }

    private final boolean hasResults() {
        return this.currentResults != null;
    }

    private final boolean hasParameterResults() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.parameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OutParameter it2 = (OutParameter)element$iv;
                    boolean bl2 = false;
                    if (!(!UniversalResultsProducerKt.access$isResultSet$p(it2))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean requestedResultsReached() {
        if (this.configuration.getResultsIndex() == null) return true;
        Integer n = this.configuration.getResultsIndex();
        Intrinsics.checkNotNull((Object)n);
        if (n <= 0) return true;
        Integer n2 = this.configuration.getResultsIndex();
        int n3 = this.currentResultSetIndex;
        if (n2 == null) return false;
        if (n2 != n3) return false;
        return true;
    }

    public UniversalResultsProducer(@NotNull StatementHolder.CloseableRef<T> statement, @NotNull SmartStatementMark mark2, @NotNull Configuration configuration, @NotNull DatabaseConnectionCore connection2, @NotNull ExecutionResult result2) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.statement = statement;
        this.mark = mark2;
        this.configuration = configuration;
        this.connection = connection2;
        this.updateCount = -1;
        this.parameters = result2.getOutParameters();
        this.source = new ResultSource(result2, (RemoteStatement)this.statement.getValue());
    }

    @Override
    public boolean advanceSafe() {
        return ClosableResultsProducer.DefaultImpls.advanceSafe(this);
    }

    public static final /* synthetic */ Source access$getSource$p(UniversalResultsProducer $this) {
        return $this.source;
    }

    public static final /* synthetic */ void access$setSource$p(UniversalResultsProducer $this, Source source) {
        $this.source = source;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "", "(Ljava/lang/String;I)V", "CONTINUE", "STOP_ON_RESULT", "FINISH", "intellij.database.core.impl"})
    private static final class Verdict
    extends Enum<Verdict> {
        public static final /* enum */ Verdict CONTINUE;
        public static final /* enum */ Verdict STOP_ON_RESULT;
        public static final /* enum */ Verdict FINISH;
        private static final /* synthetic */ Verdict[] $VALUES;

        static {
            Verdict[] verdictArray = new Verdict[3];
            Verdict[] verdictArray2 = verdictArray;
            verdictArray[0] = CONTINUE = new Verdict();
            verdictArray[1] = STOP_ON_RESULT = new Verdict();
            verdictArray[2] = FINISH = new Verdict();
            $VALUES = verdictArray;
        }

        public static Verdict[] values() {
            return (Verdict[])$VALUES.clone();
        }

        public static Verdict valueOf(String string) {
            return Enum.valueOf(Verdict.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H&J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\u0007\u001a\u00020\bH&J\b\u0010\t\u001a\u00020\u0004H&J\b\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "", "advance", "hasSomething", "", "getResultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getUpdateCount", "", "hasMoreResultSets", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "intellij.database.core.impl"})
    private static interface Source {
        @Nullable
        public RemoteResultSet getResultSet();

        public int getUpdateCount();

        public boolean hasMoreResultSets();

        @NotNull
        public Source advance(boolean var1);

        @NotNull
        public Verdict noResultsVerdict();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ResultSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "executionResult", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "(Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "advance", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$StatementSource;", "hasSomething", "", "getResultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getUpdateCount", "", "hasMoreResultSets", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "intellij.database.core.impl"})
    private static final class ResultSource
    implements Source {
        private final ExecutionResult executionResult;
        private final RemoteStatement statement;

        @Override
        public boolean hasMoreResultSets() {
            return this.executionResult.hasResultSet();
        }

        @Override
        @Nullable
        public RemoteResultSet getResultSet() {
            return this.executionResult.getResultSet();
        }

        @Override
        public int getUpdateCount() {
            return this.executionResult.getUpdateCount();
        }

        @Override
        @NotNull
        public StatementSource advance(boolean hasSomething) {
            return new StatementSource(this.statement, this.executionResult);
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return Verdict.CONTINUE;
        }

        public ResultSource(@NotNull ExecutionResult executionResult, @NotNull RemoteStatement statement) {
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            this.executionResult = executionResult;
            this.statement = statement;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$StatementSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "executionResult", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)V", "advance", "hasSomething", "", "getResultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getUpdateCount", "", "hasMoreResultSets", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "shouldCheckOutParameters", "intellij.database.core.impl"})
    private static final class StatementSource
    implements Source {
        private final RemoteStatement statement;
        private final ExecutionResult executionResult;

        @Override
        public boolean hasMoreResultSets() {
            return this.statement.getMoreResults();
        }

        @Override
        @Nullable
        public RemoteResultSet getResultSet() {
            return this.statement.getResultSet();
        }

        @Override
        public int getUpdateCount() {
            return this.statement.getUpdateCount();
        }

        @Override
        @NotNull
        public Source advance(boolean hasSomething) {
            Source source;
            if (hasSomething || !this.shouldCheckOutParameters()) {
                source = this;
            } else {
                RemoteStatement remoteStatement = this.statement;
                if (remoteStatement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.remote.jdbc.RemoteCallableStatement");
                }
                source = new ParametersSource((RemoteCallableStatement)remoteStatement, this.executionResult.getOutParameters());
            }
            return source;
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return this.shouldCheckOutParameters() ? Verdict.CONTINUE : Verdict.FINISH;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldCheckOutParameters() {
            if (!(this.statement instanceof RemoteCallableStatement)) return false;
            Collection collection = this.executionResult.getOutParameters();
            boolean bl = false;
            if (collection.isEmpty()) return false;
            return true;
        }

        public StatementSource(@NotNull RemoteStatement statement, @NotNull ExecutionResult executionResult) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            this.statement = statement;
            this.executionResult = executionResult;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ParametersSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "params", "", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "(Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;Ljava/util/List;)V", "currentIdx", "", "currentResults", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "advance", "hasSomething", "", "getResultSet", "getUpdateCount", "hasMoreResultSets", "nextResultSet", "nextResultsIndex", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "remaining", "intellij.database.core.impl"})
    private static final class ParametersSource
    implements Source {
        private int currentIdx;
        private RemoteResultSet currentResults;
        private final RemoteCallableStatement statement;
        private final List<OutParameter<?>> params;

        @Override
        @Nullable
        public RemoteResultSet getResultSet() {
            this.currentResults = this.nextResultSet();
            return this.currentResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasMoreResultSets() {
            boolean bl;
            RemoteResultSet results2 = this.currentResults;
            try {
                boolean bl2 = bl = this.nextResultsIndex() != -1;
                if (results2 == null) return bl;
            }
            catch (Throwable throwable) {
                if (results2 == null) throw throwable;
                Function0 function0 = (Function0)new Function0<Unit>(results2){

                    public final void invoke() {
                        ((RemoteResultSet)this.receiver).close();
                    }
                };
                JdbcNativeUtil.performSafe((ThrowableRunnable)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            Function0 function0 = (Function0)new /* invalid duplicate definition of identical inner class */;
            JdbcNativeUtil.performSafe((ThrowableRunnable)new /* invalid duplicate definition of identical inner class */);
            return bl;
        }

        @Override
        public int getUpdateCount() {
            return -1;
        }

        @Override
        @NotNull
        public Source advance(boolean hasSomething) {
            return this;
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return Verdict.FINISH;
        }

        private final RemoteResultSet nextResultSet() {
            RemoteResultSet remoteResultSet;
            int index2 = this.nextResultsIndex();
            List<OutParameter<?>> remaining = this.remaining();
            int n = this.currentIdx = index2 == -1 ? this.params.size() : index2 + this.currentIdx + 1;
            if (index2 == -1) {
                remoteResultSet = null;
            } else {
                OutParameter<?> outParameter = remaining.get(index2);
                if (!(outParameter instanceof CallableStatementData.SimpleOutParameter)) {
                    outParameter = null;
                }
                CallableStatementData.SimpleOutParameter simpleOutParameter = (CallableStatementData.SimpleOutParameter)outParameter;
                Object object = simpleOutParameter != null ? UniversalResultsProducerKt.access$retrieveResultSet(simpleOutParameter, (RemoteStatement)this.statement) : null;
                if (!(object instanceof RemoteResultSet)) {
                    object = null;
                }
                remoteResultSet = (RemoteResultSet)object;
            }
            return remoteResultSet;
        }

        private final int nextResultsIndex() {
            int n;
            block2: {
                List<OutParameter<?>> $this$indexOfFirst$iv = this.remaining();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<OutParameter<?>> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    OutParameter<?> item$iv;
                    OutParameter<?> it2 = item$iv = iterator.next();
                    boolean bl = false;
                    if (UniversalResultsProducerKt.access$isResultSet$p(it2)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        private final List<OutParameter<?>> remaining() {
            return this.currentIdx < this.params.size() ? this.params.subList(this.currentIdx, this.params.size()) : CollectionsKt.emptyList();
        }

        public ParametersSource(@NotNull RemoteCallableStatement statement, @NotNull List<? extends OutParameter<?>> params) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            this.statement = statement;
            this.params = params;
        }
    }
}

