/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00070\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u001a2\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u001a:\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00060\n\"\u0004\b\u0000\u0010\u0006*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00060!\u001a3\u0010\"\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00060!\u00a2\u0006\u0002\u0010#\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006$"}, d2={"logPath", "Ljava/io/File;", "getLogPath", "()Ljava/io/File;", "consumer", "Lkotlin/Function1;", "T", "", "Lcom/intellij/util/Consumer;", "executeBatch", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "trimSql", "", "sql", "maxChars", "", "message", "t", "", "runReporting", "stage", "Lcom/intellij/database/dataSource/connection/statements/StagedException$Stage;", "runnable", "Lkotlin/Function0;", "runReportingAndGet", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/statements/StagedException$Stage;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.core.impl"})
@JvmName(name="SmartStatementsUtil")
public final class SmartStatementsUtil {
    @NotNull
    public static final Either<StagedException, ClosableResultsProducer> executeBatch(@NotNull RemoteStatement statement, @NotNull DatabaseConnectionCore connection2, @NotNull SmartStatementMark mark2, @NotNull BatchesContainer batches) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter((Object)batches, (String)"batches");
        return SmartStatementsUtil.runReporting(connection2, StagedException.Stage.EXECUTE, mark2, (Function0)new Function0<ClosableResultsProducer>(connection2, batches, mark2, statement){
            final /* synthetic */ DatabaseConnectionCore $connection;
            final /* synthetic */ BatchesContainer $batches;
            final /* synthetic */ SmartStatementMark $mark;
            final /* synthetic */ RemoteStatement $statement;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ClosableResultsProducer invoke() {
                ClosableResultsProducer closableResultsProducer;
                AdvancedAuditService advancedAuditService = this.$connection.getAuditService();
                Intrinsics.checkNotNullExpressionValue((Object)advancedAuditService, (String)"connection.auditService");
                AdvancedAuditService auditService = advancedAuditService;
                try {
                    int[] nArray;
                    try {
                        auditService.beforeSimpleStatement(this.$batches.getSql(), this.$mark);
                        nArray = this.$statement.executeBatch();
                    }
                    finally {
                        auditService.afterStatement(this.$mark);
                    }
                    int[] updates = nArray;
                    Intrinsics.checkNotNullExpressionValue((Object)updates, (String)"updates");
                    int sum2 = SequencesKt.sumOfInt((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((int[])updates), (Function1)executeBatch.sum.1.INSTANCE));
                    if (sum2 > 0) {
                        auditService.updateCount(sum2, this.$mark);
                    }
                    closableResultsProducer = new ClosableResultsProducer(updates){
                        private int currentIdx;
                        final /* synthetic */ int[] $updates;

                        public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor2) {
                            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                            while (this.advance()) {
                                this.processCurrent(processor2);
                            }
                        }

                        public boolean advance() {
                            executeBatch.1 v0 = this;
                            ++v0.currentIdx;
                            return v0.currentIdx < this.$updates.length;
                        }

                        public <T> T processCurrent(@NotNull ResultsProducer.Processor<T> processor2) {
                            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                            return processor2.updateCount(this.$updates[this.currentIdx], this.currentIdx);
                        }

                        @NotNull
                        public <T> Void getParameterValue(@NotNull OutParameter<T> parameter) {
                            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
                            throw (Throwable)new IllegalStateException("This statement has no out parameters");
                        }

                        @Nullable
                        public Object getParameterValue(int index2) {
                            return null;
                        }

                        public void close() {
                        }
                        {
                            this.$updates = $captured_local_variable$0;
                            this.currentIdx = -1;
                        }

                        public boolean advanceSafe() {
                            return ClosableResultsProducer.DefaultImpls.advanceSafe(this);
                        }
                    };
                }
                catch (Throwable throwable) {
                    try {
                        auditService.resultsProcessed(this.$mark);
                        this.$batches.clear();
                    }
                    catch (Throwable throwable2) {
                        this.$batches.clear();
                        SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ executeBatch.1 this$0;

                            public final void invoke() {
                                this.this$0.$statement.clearBatch();
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                        throw throwable2;
                    }
                    SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                try {
                    auditService.resultsProcessed(this.$mark);
                    this.$batches.clear();
                }
                catch (Throwable throwable) {
                    this.$batches.clear();
                    SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                SmartStatementsUtil.runReporting(this.$connection, StagedException.Stage.BATCH_CLEARING, this.$mark, (Function0)new /* invalid duplicate definition of identical inner class */);
                return closableResultsProducer;
            }
            {
                this.$connection = databaseConnectionCore;
                this.$batches = batchesContainer;
                this.$mark = smartStatementMark;
                this.$statement = remoteStatement;
                super(0);
            }
        });
    }

    @NlsSafe
    @Nullable
    public static final String message(@NotNull DatabaseConnectionCore $this$message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        DatabaseConnectionPoint databaseConnectionPoint = $this$message.getConnectionPoint();
        Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"connectionPoint");
        LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"connectionPoint.dataSource");
        LocalDataSource dataSource2 = localDataSource;
        return JdbcEngineUtils.getErrorMessage(t, dataSource2);
    }

    @NotNull
    public static final <T> Either<StagedException, T> runReporting(@NotNull DatabaseConnectionCore $this$runReporting, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Either<Object, Object> either;
        Intrinsics.checkNotNullParameter((Object)$this$runReporting, (String)"$this$runReporting");
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        try {
            either = Either.Companion.right(runnable.invoke());
        }
        catch (SQLException e) {
            AdvancedAuditService advancedAuditService = $this$runReporting.getAuditService();
            String string = SmartStatementsUtil.message($this$runReporting, e);
            if (string == null) {
                StringBuilder stringBuilder = new StringBuilder().append('(').append(stage.getErrorText()).append(": ");
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "";
                }
                string = stringBuilder.append(string2).toString();
            }
            advancedAuditService.error(string, mark2);
            either = Either.Companion.left(new StagedException(e, stage));
        }
        return either;
    }

    public static final <T> T runReportingAndGet(@NotNull DatabaseConnectionCore $this$runReportingAndGet, @NotNull StagedException.Stage stage, @NotNull SmartStatementMark mark2, @NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter((Object)$this$runReportingAndGet, (String)"$this$runReportingAndGet");
        Intrinsics.checkNotNullParameter((Object)((Object)stage), (String)"stage");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        Either<StagedException, T> result2 = SmartStatementsUtil.runReporting($this$runReportingAndGet, stage, mark2, runnable);
        if (result2.isLeft()) {
            StagedException stagedException = result2.getLeft();
            Intrinsics.checkNotNull((Object)stagedException);
            throw (Throwable)stagedException;
        }
        T t = result2.getRight();
        Intrinsics.checkNotNull(t);
        return t;
    }

    @NotNull
    public static final String trimSql(@NotNull String sql, int maxChars) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (sql.length() <= maxChars) {
            return sql;
        }
        String string = sql;
        int n = 0;
        boolean bl = false;
        String string2 = string.substring(n, maxChars);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String substring = string2;
        int difference = sql.length() - maxChars;
        String moreString = "-- and " + difference + ' ' + StringUtil.pluralize((String)"character", (int)difference) + " more...";
        return moreString.length() >= difference ? sql : substring + ' ' + moreString;
    }

    @NotNull
    public static final <T> Function1<T, Unit> consumer(@NotNull Consumer<T> consumer2) {
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        return new Function1<T, Unit>(consumer2){
            final /* synthetic */ Consumer $consumer;

            public final void invoke(T it2) {
                this.$consumer.consume(it2);
            }
            {
                this.$consumer = consumer2;
                super(1);
            }
        };
    }

    @NotNull
    public static final File getLogPath() {
        return new File(new File(PathManager.getSystemPath(), "database-log"), "database.0.log");
    }
}

