/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.connection.audit.JdbcObjectsListener;
import com.intellij.database.dataSource.connection.audit.JdbcWarningsListener;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.util.JdbcUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0003\u001d\u001e\u001fB\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0006\u0010\u0018\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002 !\u00a8\u0006\""}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "Lcom/intellij/database/dataSource/connection/audit/JdbcObjectsListener;", "Ljava/lang/AutoCloseable;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;)V", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "beforeResultsClosing", "", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeStatementClosing", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "close", "isClosed", "", "printConnectionWarnings", "printResultSetWarnings", "printStatementWarnings", "resultsOpened", "statementOpened", "Async", "Companion", "Sync", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async;", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Sync;", "intellij.database.core.impl"})
public abstract class JdbcWarningsListener
implements JdbcObjectsListener,
AutoCloseable {
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final ListenerAuditService auditService;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void statementOpened(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printStatementWarnings(statement, mark2);
    }

    @Override
    public void beforeStatementClosing(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printStatementWarnings(statement, mark2);
        this.printConnectionWarnings();
    }

    @Override
    public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printResultSetWarnings(resultSet, mark2);
    }

    @Override
    public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printResultSetWarnings(resultSet, mark2);
    }

    public void printStatementWarnings(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        if (this.isClosed(statement)) {
            return;
        }
        Companion.printAllWarnings((List)JdbcWarningsListener.Companion.runSafe((Function0)new Function0<List<SQLWarning>>(statement){
            final /* synthetic */ RemoteStatement $statement;

            public final List<SQLWarning> invoke() {
                return this.$statement.getAllWarnings();
            }
            {
                this.$statement = remoteStatement;
                super(0);
            }
        }), this.auditService, mark2);
    }

    public final void printResultSetWarnings(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        if (this.isClosed(resultSet)) {
            return;
        }
        Companion.printAllWarnings((List)JdbcWarningsListener.Companion.runSafe((Function0)new Function0<List<SQLWarning>>(resultSet){
            final /* synthetic */ RemoteResultSet $resultSet;

            public final List<SQLWarning> invoke() {
                return this.$resultSet.getAllWarnings();
            }
            {
                this.$resultSet = remoteResultSet;
                super(0);
            }
        }), this.auditService, mark2);
    }

    public final void printConnectionWarnings() {
        Companion.printAllWarnings((List)JdbcWarningsListener.Companion.runSafe((Function0)new Function0<List<SQLWarning>>(this){
            final /* synthetic */ JdbcWarningsListener this$0;

            public final List<SQLWarning> invoke() {
                RemoteConnection remoteConnection = this.this$0.getConnection().getRemoteConnection();
                Intrinsics.checkNotNullExpressionValue((Object)remoteConnection, (String)"connection.remoteConnection");
                return remoteConnection.getAllWarnings();
            }
            {
                this.this$0 = jdbcWarningsListener;
                super(0);
            }
        }), this.auditService, null);
    }

    protected final boolean isClosed(@NotNull RemoteStatement statement) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        try {
            bl = statement.isClosed();
        }
        catch (Throwable t) {
            bl = true;
        }
        return bl;
    }

    protected final boolean isClosed(@NotNull RemoteResultSet resultSet) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        try {
            bl = resultSet.isClosed();
        }
        catch (Throwable t) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void close() {
    }

    @NotNull
    protected final DatabaseConnectionCore getConnection() {
        return this.connection;
    }

    @NotNull
    protected final ListenerAuditService getAuditService() {
        return this.auditService;
    }

    private JdbcWarningsListener(DatabaseConnectionCore connection2, ListenerAuditService auditService) {
        this.connection = connection2;
        this.auditService = auditService;
    }

    public /* synthetic */ JdbcWarningsListener(DatabaseConnectionCore connection2, ListenerAuditService auditService, DefaultConstructorMarker $constructor_marker) {
        this(connection2, auditService);
    }

    @JvmStatic
    @NotNull
    public static final JdbcWarningsListener listenFor(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
        return Companion.listenFor(connection2, auditService);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async;", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;)V", "results", "", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "resultsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "statements", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "statementsLock", "beforeResultsClosing", "", "resultSet", "mark", "beforeStatementClosing", "statement", "close", "locked", "lock", "runnable", "Lkotlin/Function0;", "printStatementWarnings", "resultsOpened", "statementOpened", "withResultsLocked", "withStatementsLocked", "Companion", "intellij.database.core.impl"})
    public static final class Async
    extends JdbcWarningsListener {
        private final ReentrantLock statementsLock;
        private final ReentrantLock resultsLock;
        private final Map<RemoteStatement, SmartStatementMark> statements;
        private final Map<RemoteResultSet, SmartStatementMark> results;
        private static final Set<Async> ourWatchers;
        private static ScheduledFuture<?> ourWarningsScheduledFuture;
        @NotNull
        public static final Companion Companion;

        @Override
        public void statementOpened(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.withStatementsLocked((Function0<Unit>)((Function0)new Function0<Unit>(this, statement, mark2){
                final /* synthetic */ Async this$0;
                final /* synthetic */ RemoteStatement $statement;
                final /* synthetic */ SmartStatementMark $mark;

                public final void invoke() {
                    Async.access$statementOpened$s63574620(this.this$0, this.$statement, this.$mark);
                    Async.access$getStatements$p(this.this$0).put(this.$statement, this.$mark);
                }
                {
                    this.this$0 = async;
                    this.$statement = remoteStatement;
                    this.$mark = smartStatementMark;
                    super(0);
                }
            }));
        }

        @Override
        public void printStatementWarnings(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.withStatementsLocked((Function0<Unit>)((Function0)new Function0<Unit>(this, statement, mark2){
                final /* synthetic */ Async this$0;
                final /* synthetic */ RemoteStatement $statement;
                final /* synthetic */ SmartStatementMark $mark;

                public final void invoke() {
                    Async.access$printStatementWarnings$s63574620(this.this$0, this.$statement, this.$mark);
                }
                {
                    this.this$0 = async;
                    this.$statement = remoteStatement;
                    this.$mark = smartStatementMark;
                    super(0);
                }
            }));
        }

        @Override
        public void beforeStatementClosing(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            if (this.isClosed(statement)) {
                return;
            }
            this.withStatementsLocked((Function0<Unit>)((Function0)new Function0<Unit>(this, statement, mark2){
                final /* synthetic */ Async this$0;
                final /* synthetic */ RemoteStatement $statement;
                final /* synthetic */ SmartStatementMark $mark;

                public final void invoke() {
                    Map map2 = Async.access$getStatements$p(this.this$0);
                    RemoteStatement remoteStatement = this.$statement;
                    boolean bl = false;
                    map2.remove(remoteStatement);
                    Async.access$beforeStatementClosing$s63574620(this.this$0, this.$statement, this.$mark);
                }
                {
                    this.this$0 = async;
                    this.$statement = remoteStatement;
                    this.$mark = smartStatementMark;
                    super(0);
                }
            }));
        }

        @Override
        public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.withResultsLocked((Function0<Unit>)((Function0)new Function0<Unit>(this, resultSet, mark2){
                final /* synthetic */ Async this$0;
                final /* synthetic */ RemoteResultSet $resultSet;
                final /* synthetic */ SmartStatementMark $mark;

                public final void invoke() {
                    Async.access$resultsOpened$s63574620(this.this$0, this.$resultSet, this.$mark);
                    Async.access$getResults$p(this.this$0).put(this.$resultSet, this.$mark);
                }
                {
                    this.this$0 = async;
                    this.$resultSet = remoteResultSet;
                    this.$mark = smartStatementMark;
                    super(0);
                }
            }));
        }

        @Override
        public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            if (this.isClosed(resultSet)) {
                return;
            }
            this.withResultsLocked((Function0<Unit>)((Function0)new Function0<Unit>(this, resultSet, mark2){
                final /* synthetic */ Async this$0;
                final /* synthetic */ RemoteResultSet $resultSet;
                final /* synthetic */ SmartStatementMark $mark;

                public final void invoke() {
                    Map map2 = Async.access$getResults$p(this.this$0);
                    RemoteResultSet remoteResultSet = this.$resultSet;
                    boolean bl = false;
                    map2.remove(remoteResultSet);
                    Async.access$beforeResultsClosing$s63574620(this.this$0, this.$resultSet, this.$mark);
                }
                {
                    this.this$0 = async;
                    this.$resultSet = remoteResultSet;
                    this.$mark = smartStatementMark;
                    super(0);
                }
            }));
        }

        @Override
        public void close() {
            this.statements.clear();
            this.results.clear();
            Collection collection = ourWatchers;
            Async async = this;
            boolean bl = false;
            collection.remove(async);
            super.close();
        }

        private final void withStatementsLocked(Function0<Unit> runnable) {
            this.locked(this.statementsLock, runnable);
        }

        private final void withResultsLocked(Function0<Unit> runnable) {
            this.locked(this.resultsLock, runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void locked(ReentrantLock lock, Function0<Unit> runnable) {
            lock.lock();
            try {
                runnable.invoke();
            }
            finally {
                lock.unlock();
            }
        }

        public Async(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            super(connection2, auditService, null);
            Collection collection = ourWatchers;
            Async async = this;
            boolean bl = false;
            collection.add(async);
            Async.Companion.schedulePrintAllWarnings();
            this.statementsLock = new ReentrantLock();
            this.resultsLock = new ReentrantLock();
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConcurrentWeakMap()");
            this.statements = concurrentMap;
            ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"ContainerUtil.createConcurrentWeakMap()");
            this.results = concurrentMap2;
        }

        static {
            Companion = new Companion(null);
            Set set = ConcurrentCollectionFactory.createConcurrentIdentitySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ConcurrentCollectionFact\u2026rrentIdentitySet<Async>()");
            ourWatchers = set;
        }

        public static final /* synthetic */ void access$statementOpened$s63574620(Async $this, RemoteStatement statement, SmartStatementMark mark2) {
            super.statementOpened(statement, mark2);
        }

        public static final /* synthetic */ void access$printStatementWarnings$s63574620(Async $this, RemoteStatement statement, SmartStatementMark mark2) {
            super.printStatementWarnings(statement, mark2);
        }

        public static final /* synthetic */ void access$beforeStatementClosing$s63574620(Async $this, RemoteStatement statement, SmartStatementMark mark2) {
            super.beforeStatementClosing(statement, mark2);
        }

        public static final /* synthetic */ void access$resultsOpened$s63574620(Async $this, RemoteResultSet resultSet, SmartStatementMark mark2) {
            super.resultsOpened(resultSet, mark2);
        }

        public static final /* synthetic */ void access$beforeResultsClosing$s63574620(Async $this, RemoteResultSet resultSet, SmartStatementMark mark2) {
            super.beforeResultsClosing(resultSet, mark2);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010\u0005\u001a.\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\n\u00a2\u0006\u0002\b\t0\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async$Companion;", "", "()V", "ourWarningsScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "ourWatchers", "", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "printAllWarnings", "", "schedulePrintAllWarnings", "intellij.database.core.impl"})
        public static final class Companion {
            private final void schedulePrintAllWarnings() {
                ScheduledFuture scheduledFuture = ourWarningsScheduledFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                ourWarningsScheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(schedulePrintAllWarnings.1.INSTANCE, 300L, TimeUnit.MILLISECONDS);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void printAllWarnings() {
                for (Async watcher : ourWatchers) {
                    boolean bl;
                    Map map2;
                    if (watcher.statementsLock.tryLock()) {
                        try {
                            map2 = watcher.statements;
                            bl = false;
                            for (Map.Entry statement : map2.entrySet()) {
                                if (!((SmartStatementMark)statement.getValue()).getRunning()) continue;
                                watcher.printStatementWarnings((RemoteStatement)statement.getKey(), (SmartStatementMark)statement.getValue());
                            }
                        }
                        finally {
                            watcher.statementsLock.unlock();
                        }
                    }
                    if (!watcher.resultsLock.tryLock()) continue;
                    try {
                        map2 = watcher.results;
                        bl = false;
                        for (Map.Entry result2 : map2.entrySet()) {
                            watcher.printResultSetWarnings((RemoteResultSet)result2.getKey(), (SmartStatementMark)result2.getValue());
                        }
                    }
                    finally {
                        watcher.resultsLock.unlock();
                    }
                }
                Collection collection = ourWatchers;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    this.schedulePrintAllWarnings();
                }
            }

            private Companion() {
            }

            public static final /* synthetic */ void access$printAllWarnings(Companion $this) {
                $this.printAllWarnings();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Sync;", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;)V", "intellij.database.core.impl"})
    public static final class Sync
    extends JdbcWarningsListener {
        public Sync(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            super(connection2, auditService, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J*\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0004J#\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Companion;", "", "()V", "listenFor", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "printAllWarnings", "", "warnings", "", "Ljava/sql/SQLWarning;", "service", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "runSafe", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.core.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JdbcWarningsListener listenFor(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Dbms dbms = connection2.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"connection.dbms");
            Dbms family = dbms;
            return Intrinsics.areEqual((Object)family, (Object)Dbms.POSTGRES) || Intrinsics.areEqual((Object)family, (Object)Dbms.GREENPLUM) || family.isMicrosoft() ? (JdbcWarningsListener)new Async(connection2, auditService) : (JdbcWarningsListener)new Sync(connection2, auditService);
        }

        protected final void printAllWarnings(@Nullable List<? extends SQLWarning> warnings, @NotNull AuditService service, @Nullable SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            if (warnings == null) {
                return;
            }
            for (SQLWarning sQLWarning : warnings) {
                String message2;
                Intrinsics.checkNotNullExpressionValue((Object)JdbcUtil.getLongMessage(sQLWarning), (String)"JdbcUtil.getLongMessage(warning)");
                if (mark2 != null) {
                    service.warning(message2, mark2);
                    continue;
                }
                service.warning(message2);
            }
        }

        private final <T> T runSafe(Function0<? extends T> runnable) {
            try {
                return (T)runnable.invoke();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

