/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u0000 \u00052\u00020\u00012\u00020\u0002:\u000b\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "Ljava/lang/AutoCloseable;", "Block", "BlockType", "Companion", "Counter", "DataSourceBlock", "DatabaseLogBlockRecord", "DatabaseLogRecord", "LogInfo", "Printer", "Service", "TextBlock", "intellij.database.core.impl"})
public interface DatabaseGlobalAuditService
extends ListenerAuditService,
AutoCloseable {
    @NotNull
    public static final Companion Companion = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.$$INSTANCE;

    @JvmStatic
    @NotNull
    public static java.util.logging.Logger logger(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
        return Companion.logger(project, connection2);
    }

    @JvmStatic
    @NotNull
    public static java.util.logging.Logger logger(@Nullable Project project, @NotNull DasDataSource dataSource2, @Nullable String sessionId) {
        return Companion.logger(project, dataSource2, sessionId);
    }

    @JvmStatic
    @NotNull
    public static java.util.logging.Logger logger(@Nullable Project project, @NotNull String dataSourceId, @Nullable String sessionId) {
        return Companion.logger(project, dataSourceId, sessionId);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static Set<SmartStatementMark> getPendingStatements() {
        return Companion.getPendingStatements();
    }

    @JvmStatic
    public static void attach(@NotNull Handler handler, @NotNull Disposable disposable2) {
        Companion.attach(handler, disposable2);
    }

    @JvmStatic
    public static void setRootLevel(@NotNull Level level, @NotNull Disposable disposable2) {
        Companion.setRootLevel(level, disposable2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Printer;", "", "print", "", "record", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord;", "intellij.database.core.impl"})
    public static interface Printer {
        public void print(@NotNull DatabaseLogBlockRecord var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016Ja\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)H\u0002\u00a2\u0006\u0002\u0010*J;\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010/\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u00100\u001a\u00020\b2\u0006\u00101\u001a\u0002022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u00103\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u00103\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Service;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)V", "afterStatement", "", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeCallableStatement", "data", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "beforeParameterizedStatement", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementData;", "beforeResultsClosing", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "beforeSimpleStatement", "sql", "", "beforeStatementClosing", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "close", "connected", "disconnected", "error", "message", "logStatement", "print", "type", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "level", "Ljava/util/logging/Level;", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Ljava/util/logging/Level;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "(Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Ljava/util/logging/Level;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "processed", "resultsOpened", "resultsProcessed", "statementOpened", "updateCount", "count", "", "warning", "intellij.database.core.impl"})
    private static final class Service
    implements DatabaseGlobalAuditService {
        private final Project project;
        private final DatabaseConnectionCore connection;

        @Override
        public void connected() {
            String sessionId = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessionsCounter$p(Companion).incrementAndGet();
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).put(this.connection, sessionId);
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            Service.print$default(this, this.connection, "connected", null, null, null, level, new Block[0], 24, null);
        }

        @Override
        public void disconnected() {
            String string = (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(this.connection);
            if (string == null) {
                return;
            }
            String id = string;
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            Service.print$default(this, this.connection, "disconnected", null, null, null, level, new Block[0], 24, null);
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).remove(this.connection);
        }

        @Override
        public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.logStatement(data.getBasis().getSql(), mark2);
        }

        @Override
        public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.logStatement(sql, mark2);
        }

        @Override
        public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.logStatement(data.getBasis().getSql(), mark2);
        }

        private final void logStatement(String sql, SmartStatementMark mark2) {
            String id = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getStatementsCounter$p(Companion).incrementAndGet();
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).put(mark2, new LogInfo(id, System.currentTimeMillis(), (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(this.connection), 0L, 0L, 0, 56, null));
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            this.print(null, mark2, level, new TextBlock(BlockType.STATEMENT, SmartStatementsUtil.trimSql(sql, 10000), false, 4, null));
        }

        @Override
        public void warning(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.WARNING");
            this.print(this.connection, "warning", null, null, null, level, new TextBlock(BlockType.WARNING, message2, false, 4, null));
        }

        @Override
        public void warning(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.WARNING");
            this.print("warning", mark2, level, new TextBlock(BlockType.WARNING, message2, false, 4, null));
        }

        @Override
        public void message(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.WARNING");
            this.print("message", mark2, level, new TextBlock(BlockType.MESSAGE, message2, false, 4, null));
        }

        @Override
        public void message(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            this.print(this.connection, "message", null, null, null, level, new TextBlock(BlockType.MESSAGE, message2, false, 4, null));
        }

        @Override
        public void error(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.SEVERE");
            this.print(this.connection, "error", null, null, null, level, new TextBlock(BlockType.ERROR, message2, false, 4, null));
        }

        @Override
        public void error(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.SEVERE");
            this.print("error", mark2, level, new TextBlock(BlockType.ERROR, message2, false));
        }

        @Override
        public void updateCount(int count, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            if (count < 1) {
                return;
            }
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            if (info != null) {
                LogInfo logInfo = info;
                logInfo.setUpdateCount(logInfo.getUpdateCount() + (long)count);
            } else {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).warn("Logging update count without pending statement");
            }
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            this.print("update count received", mark2, level, new TextBlock(BlockType.UPDATE_COUNT, String.valueOf(count), false, 4, null));
        }

        @Override
        public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            if (info != null) {
                LogInfo logInfo = info;
                int n = logInfo.getResults();
                logInfo.setResults(n + 1);
            } else {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).warn("Logging result set without pending statement");
            }
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            this.print("results received", mark2, level, new Block[0]);
        }

        @Override
        public void resultsProcessed(@NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.processed(mark2);
        }

        @Override
        public void beforeStatementClosing(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.processed(mark2);
        }

        @Override
        public void afterStatement(@NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            if (info == null) {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).warn("Execution finished without pending statement");
                return;
            }
            info.setEndTime(System.currentTimeMillis());
        }

        private final void processed(SmartStatementMark mark2) {
            boolean bl;
            TextBlock textBlock;
            Collection collection;
            LogInfo logInfo = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).remove(mark2);
            if (logInfo == null) {
                return;
            }
            LogInfo info = logInfo;
            long endTime = info.getEndTime() == -1L ? System.currentTimeMillis() : info.getEndTime();
            long executionDurationMs = info.getEndTime() != -1L ? Math.max(endTime - info.getStartTime(), 1L) : -1L;
            long processingDurationMs = System.currentTimeMillis() - info.getStartTime();
            long fetchingDurationMs = info.getEndTime() == -1L ? -1L : processingDurationMs - executionDurationMs;
            ArrayList messages = new ArrayList();
            if (executionDurationMs > 0L) {
                collection = messages;
                textBlock = new TextBlock(BlockType.EXECUTION_DURATION, "execution time: " + StringUtil.formatDuration((long)executionDurationMs), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            if (fetchingDurationMs > 0L && (info.getUpdateCount() > 0L || info.getResults() > 0)) {
                collection = messages;
                textBlock = new TextBlock(BlockType.FETCHING_DURATION, "fetching time: " + StringUtil.formatDuration((long)fetchingDurationMs), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            if (info.getUpdateCount() > 0L) {
                collection = messages;
                textBlock = new TextBlock(BlockType.TOTAL_UPDATE_COUNT, "total update count: " + info.getUpdateCount(), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            if (info.getResults() > 0) {
                collection = messages;
                textBlock = new TextBlock(BlockType.TOTAL_RESULT_SET_COUNT, "total result sets count: " + info.getResults(), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            String string = info.getStatementId();
            String string2 = info.getSessionId();
            DatabaseDepartment databaseDepartment = mark2.getDepartment();
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"Level.INFO");
            Collection $this$toTypedArray$iv = messages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
            if (blockArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            this.print(this.connection, "finished", string, string2, databaseDepartment, level, Arrays.copyOf(blockArray, blockArray.length));
        }

        private final void print(String type, SmartStatementMark mark2, Level level, Block ... blocks) {
            LogInfo logInfo = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            LogInfo logInfo2 = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            this.print(this.connection, type, logInfo != null ? logInfo.getStatementId() : null, logInfo2 != null ? logInfo2.getSessionId() : null, mark2.getDepartment(), level, Arrays.copyOf(blocks, blocks.length));
        }

        private final void print(DatabaseConnectionCore connection2, String type, String statementId, String sessionId, DatabaseDepartment department, Level level, Block ... blocks) {
            Project project = this.project;
            String string = project != null ? project.getName() : null;
            DatabaseConnectionPoint databaseConnectionPoint = connection2.getConnectionPoint();
            Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"connection.connectionPoint");
            LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"connection.connectionPoint.dataSource");
            DasDataSource dasDataSource = localDataSource;
            String string2 = sessionId;
            if (string2 == null) {
                string2 = (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(connection2);
            }
            Companion.print(new DatabaseLogBlockRecord(string, dasDataSource, type, statementId, string2, department, level, Arrays.copyOf(blocks, blocks.length)));
        }

        static /* synthetic */ void print$default(Service service, DatabaseConnectionCore databaseConnectionCore, String string, String string2, String string3, DatabaseDepartment databaseDepartment, Level level, Block[] blockArray, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                databaseDepartment = null;
            }
            service.print(databaseConnectionCore, string, string2, string3, databaseDepartment, level, blockArray);
        }

        @Override
        public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        }

        @Override
        public void statementOpened(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        }

        @Override
        public void close() {
        }

        public Service(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            this.project = project;
            this.connection = connection2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "", "type", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "(Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;Z)V", "content", "", "getContent", "()Ljava/lang/String;", "getFormat", "()Z", "text", "getText", "text$delegate", "Lkotlin/Lazy;", "getType", "()Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "intellij.database.core.impl"})
    public static abstract class Block {
        @NotNull
        private final Lazy text$delegate;
        @NotNull
        private final BlockType type;
        private final boolean format;

        @NotNull
        protected abstract String getContent();

        @NotNull
        public final String getText() {
            Lazy lazy = this.text$delegate;
            Block block = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final BlockType getType() {
            return this.type;
        }

        public final boolean getFormat() {
            return this.format;
        }

        public Block(@NotNull BlockType type, boolean format) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.format = format;
            this.text$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Block this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getFormat() ? this.this$0.getType().format(this.this$0.getContent()) : this.this$0.getContent();
                }
                {
                    this.this$0 = block;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Block(BlockType blockType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(blockType, bl);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$TextBlock;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "type", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "content", "", "format", "", "(Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;Ljava/lang/String;Z)V", "getContent", "()Ljava/lang/String;", "intellij.database.core.impl"})
    public static final class TextBlock
    extends Block {
        @NotNull
        private final String content;

        @Override
        @NotNull
        protected String getContent() {
            return this.content;
        }

        public TextBlock(@NotNull BlockType type, @NotNull String content, boolean format) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(type, format);
            this.content = content;
        }

        public /* synthetic */ TextBlock(BlockType blockType, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(blockType, string, bl);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DataSourceBlock;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "(Lcom/intellij/database/model/DasDataSource;)V", "content", "", "getContent", "()Ljava/lang/String;", "getDataSource", "()Lcom/intellij/database/model/DasDataSource;", "intellij.database.core.impl"})
    public static final class DataSourceBlock
    extends Block {
        @NotNull
        private final DasDataSource dataSource;

        @Override
        @NotNull
        protected String getContent() {
            String string = this.dataSource.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSource.name");
            return string;
        }

        @NotNull
        public final DasDataSource getDataSource() {
            return this.dataSource;
        }

        public DataSourceBlock(@NotNull DasDataSource dataSource2) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            super(BlockType.DATA_SOURCE, false, 2, null);
            this.dataSource = dataSource2;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "", "separator", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSeparator", "()Ljava/lang/String;", "bound", "s", "format", "inline", "STATEMENT_PREFIX", "LINE_PREFIX", "TIMESTAMP", "DATA_SOURCE", "SUBSYSTEM", "SESSION_ID", "STATEMENT_ID", "EVENT_TYPE", "STATEMENT", "MESSAGE", "WARNING", "ERROR", "PROJECT", "EXECUTION_DURATION", "FETCHING_DURATION", "UPDATE_COUNT", "TOTAL_UPDATE_COUNT", "TOTAL_RESULT_SET_COUNT", "STATEMENT_SUFFIX", "intellij.database.core.impl"})
    public static final class BlockType
    extends Enum<BlockType> {
        public static final /* enum */ BlockType STATEMENT_PREFIX;
        public static final /* enum */ BlockType LINE_PREFIX;
        public static final /* enum */ BlockType TIMESTAMP;
        public static final /* enum */ BlockType DATA_SOURCE;
        public static final /* enum */ BlockType SUBSYSTEM;
        public static final /* enum */ BlockType SESSION_ID;
        public static final /* enum */ BlockType STATEMENT_ID;
        public static final /* enum */ BlockType EVENT_TYPE;
        public static final /* enum */ BlockType STATEMENT;
        public static final /* enum */ BlockType MESSAGE;
        public static final /* enum */ BlockType WARNING;
        public static final /* enum */ BlockType ERROR;
        public static final /* enum */ BlockType PROJECT;
        public static final /* enum */ BlockType EXECUTION_DURATION;
        public static final /* enum */ BlockType FETCHING_DURATION;
        public static final /* enum */ BlockType UPDATE_COUNT;
        public static final /* enum */ BlockType TOTAL_UPDATE_COUNT;
        public static final /* enum */ BlockType TOTAL_RESULT_SET_COUNT;
        public static final /* enum */ BlockType STATEMENT_SUFFIX;
        private static final /* synthetic */ BlockType[] $VALUES;
        @NotNull
        private final String separator;

        static {
            BlockType[] blockTypeArray = new BlockType[19];
            BlockType[] blockTypeArray2 = blockTypeArray;
            blockTypeArray[0] = STATEMENT_PREFIX = new BlockType("\n");
            blockTypeArray[1] = LINE_PREFIX = new BlockType("LINE_PREFIX", 1, null, 1, null);
            blockTypeArray[2] = TIMESTAMP = new BlockType("TIMESTAMP", 2, null, 1, null);
            blockTypeArray[3] = DATA_SOURCE = new DATA_SOURCE("DATA_SOURCE", 3);
            blockTypeArray[4] = SUBSYSTEM = new SUBSYSTEM("SUBSYSTEM", 4);
            blockTypeArray[5] = SESSION_ID = new SESSION_ID("SESSION_ID", 5);
            blockTypeArray[6] = STATEMENT_ID = new STATEMENT_ID("STATEMENT_ID", 6);
            blockTypeArray[7] = EVENT_TYPE = new BlockType(" - ");
            blockTypeArray[8] = STATEMENT = new STATEMENT("STATEMENT", 8);
            blockTypeArray[9] = MESSAGE = new MESSAGE("MESSAGE", 9);
            blockTypeArray[10] = WARNING = new WARNING("WARNING", 10);
            blockTypeArray[11] = ERROR = new ERROR("ERROR", 11);
            blockTypeArray[12] = PROJECT = new PROJECT("PROJECT", 12);
            blockTypeArray[13] = EXECUTION_DURATION = new BlockType(", ");
            blockTypeArray[14] = FETCHING_DURATION = new BlockType(", ");
            blockTypeArray[15] = UPDATE_COUNT = new BlockType("UPDATE_COUNT", 15, null, 1, null);
            blockTypeArray[16] = TOTAL_UPDATE_COUNT = new BlockType(", ");
            blockTypeArray[17] = TOTAL_RESULT_SET_COUNT = new BlockType(", ");
            blockTypeArray[18] = STATEMENT_SUFFIX = new BlockType("");
            $VALUES = blockTypeArray;
        }

        @NotNull
        public String format(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            return s2;
        }

        @NotNull
        public final String bound(@NotNull String s2) {
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            return '[' + s2 + ']';
        }

        @NotNull
        public final String inline(@NotNull String s2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
            if (StringUtil.containsLineBreak((CharSequence)s2)) {
                String string2 = StringUtil.escapeStringCharacters((String)s2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.escapeStringCharacters(s)");
            } else {
                string = s2;
            }
            return string;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        private BlockType(String separator) {
            this.separator = separator;
        }

        /* synthetic */ BlockType(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string2 = " ";
            }
            this(string2);
        }

        public /* synthetic */ BlockType(String $enum$name, int $enum$ordinal, String separator, DefaultConstructorMarker $constructor_marker) {
            this(separator);
        }

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String string) {
            return Enum.valueOf(BlockType.class, string);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$DATA_SOURCE;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class DATA_SOURCE
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.bound(s2);
            }

            /*
             * WARNING - void declaration
             */
            DATA_SOURCE() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$SUBSYSTEM;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class SUBSYSTEM
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.bound(s2);
            }

            /*
             * WARNING - void declaration
             */
            SUBSYSTEM() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$SESSION_ID;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class SESSION_ID
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.bound(s2);
            }

            /*
             * WARNING - void declaration
             */
            SESSION_ID() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$STATEMENT_ID;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class STATEMENT_ID
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.bound(s2);
            }

            /*
             * WARNING - void declaration
             */
            STATEMENT_ID() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$STATEMENT;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class STATEMENT
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return (!StringUtil.startsWith((CharSequence)s2, (CharSequence)"\n") ? "\n" : "") + super.format(s2);
            }

            /*
             * WARNING - void declaration
             */
            STATEMENT() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$MESSAGE;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class MESSAGE
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.inline(s2);
            }

            /*
             * WARNING - void declaration
             */
            MESSAGE() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$WARNING;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class WARNING
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.inline(s2);
            }

            /*
             * WARNING - void declaration
             */
            WARNING() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$ERROR;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class ERROR
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.inline(s2);
            }

            /*
             * WARNING - void declaration
             */
            ERROR() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$PROJECT;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class PROJECT
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s2) {
                Intrinsics.checkNotNullParameter((Object)s2, (String)"s");
                return this.bound(s2);
            }

            /*
             * WARNING - void declaration
             */
            PROJECT() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003JG\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\nH\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$LogInfo;", "", "statementId", "", "startTime", "", "sessionId", "endTime", "updateCount", "results", "", "(Ljava/lang/String;JLjava/lang/String;JJI)V", "getEndTime", "()J", "setEndTime", "(J)V", "getResults", "()I", "setResults", "(I)V", "getSessionId", "()Ljava/lang/String;", "getStartTime", "getStatementId", "getUpdateCount", "setUpdateCount", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.core.impl"})
    public static final class LogInfo {
        @NotNull
        private final String statementId;
        private final long startTime;
        @Nullable
        private final String sessionId;
        private long endTime;
        private long updateCount;
        private int results;

        @NotNull
        public final String getStatementId() {
            return this.statementId;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final String getSessionId() {
            return this.sessionId;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(long l) {
            this.endTime = l;
        }

        public final long getUpdateCount() {
            return this.updateCount;
        }

        public final void setUpdateCount(long l) {
            this.updateCount = l;
        }

        public final int getResults() {
            return this.results;
        }

        public final void setResults(int n) {
            this.results = n;
        }

        public LogInfo(@NotNull String statementId, long startTime, @Nullable String sessionId, long endTime, long updateCount2, int results2) {
            Intrinsics.checkNotNullParameter((Object)statementId, (String)"statementId");
            this.statementId = statementId;
            this.startTime = startTime;
            this.sessionId = sessionId;
            this.endTime = endTime;
            this.updateCount = updateCount2;
            this.results = results2;
        }

        public /* synthetic */ LogInfo(String string, long l, String string2, long l2, long l3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                l = -1L;
            }
            if ((n2 & 8) != 0) {
                l2 = -1L;
            }
            if ((n2 & 0x10) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            this(string, l, string2, l2, l3, n);
        }

        @NotNull
        public final String component1() {
            return this.statementId;
        }

        public final long component2() {
            return this.startTime;
        }

        @Nullable
        public final String component3() {
            return this.sessionId;
        }

        public final long component4() {
            return this.endTime;
        }

        public final long component5() {
            return this.updateCount;
        }

        public final int component6() {
            return this.results;
        }

        @NotNull
        public final LogInfo copy(@NotNull String statementId, long startTime, @Nullable String sessionId, long endTime, long updateCount2, int results2) {
            Intrinsics.checkNotNullParameter((Object)statementId, (String)"statementId");
            return new LogInfo(statementId, startTime, sessionId, endTime, updateCount2, results2);
        }

        public static /* synthetic */ LogInfo copy$default(LogInfo logInfo, String string, long l, String string2, long l2, long l3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = logInfo.statementId;
            }
            if ((n2 & 2) != 0) {
                l = logInfo.startTime;
            }
            if ((n2 & 4) != 0) {
                string2 = logInfo.sessionId;
            }
            if ((n2 & 8) != 0) {
                l2 = logInfo.endTime;
            }
            if ((n2 & 0x10) != 0) {
                l3 = logInfo.updateCount;
            }
            if ((n2 & 0x20) != 0) {
                n = logInfo.results;
            }
            return logInfo.copy(string, l, string2, l2, l3, n);
        }

        @NotNull
        public String toString() {
            return "LogInfo(statementId=" + this.statementId + ", startTime=" + this.startTime + ", sessionId=" + this.sessionId + ", endTime=" + this.endTime + ", updateCount=" + this.updateCount + ", results=" + this.results + ")";
        }

        public int hashCode() {
            String string = this.statementId;
            String string2 = this.sessionId;
            return (((((string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.startTime)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Long.hashCode(this.endTime)) * 31 + Long.hashCode(this.updateCount)) * 31 + Integer.hashCode(this.results);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LogInfo)) break block3;
                    LogInfo logInfo = (LogInfo)object;
                    if (!Intrinsics.areEqual((Object)this.statementId, (Object)logInfo.statementId) || this.startTime != logInfo.startTime || !Intrinsics.areEqual((Object)this.sessionId, (Object)logInfo.sessionId) || this.endTime != logInfo.endTime || this.updateCount != logInfo.updateCount || this.results != logInfo.results) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogRecord;", "Ljava/util/logging/LogRecord;", "projectName", "", "dataSourceId", "sessionId", "level", "Ljava/util/logging/Level;", "msg", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/logging/Level;Ljava/lang/String;)V", "getDataSourceId", "()Ljava/lang/String;", "getProjectName", "getSessionId", "intellij.database.core.impl"})
    public static class DatabaseLogRecord
    extends LogRecord {
        @Nullable
        private final String projectName;
        @NotNull
        private final String dataSourceId;
        @Nullable
        private final String sessionId;

        @Nullable
        public final String getProjectName() {
            return this.projectName;
        }

        @NotNull
        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Nullable
        public final String getSessionId() {
            return this.sessionId;
        }

        public DatabaseLogRecord(@Nullable String projectName, @NotNull String dataSourceId, @Nullable String sessionId, @Nullable Level level, @Nullable String msg) {
            Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
            super(level, msg);
            this.projectName = projectName;
            this.dataSourceId = dataSourceId;
            this.sessionId = sessionId;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBc\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogRecord;", "projectName", "", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "type", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "level", "Ljava/util/logging/Level;", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "(Ljava/lang/String;Lcom/intellij/database/model/DasDataSource;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Ljava/util/logging/Level;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "getBlocks", "()[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getStatementId", "()Ljava/lang/String;", "getType", "getMessage", "prepare", "", "Companion", "intellij.database.core.impl"})
    public static final class DatabaseLogBlockRecord
    extends DatabaseLogRecord {
        @NotNull
        private final Block[] blocks;
        @Nullable
        private final String type;
        @Nullable
        private final String statementId;
        @Nullable
        private final DatabaseDepartment department;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Block[] getBlocks() {
            return this.blocks;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = super.getMessage();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it2 = string2;
                boolean bl3 = false;
                return it2;
            }
            String newMessage = Companion.format(this.prepare());
            this.setMessage(newMessage);
            return newMessage;
        }

        @NotNull
        public final List<Block> prepare() {
            return DatabaseLogBlockRecord.Companion.prepare(this.getProjectName(), this.type, this.statementId, this.getSessionId(), this.department, this.getMillis(), Arrays.copyOf(this.blocks, this.blocks.length));
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getStatementId() {
            return this.statementId;
        }

        @Nullable
        public final DatabaseDepartment getDepartment() {
            return this.department;
        }

        public DatabaseLogBlockRecord(@Nullable String projectName, @NotNull DasDataSource dataSource2, @Nullable String type, @Nullable String statementId, @Nullable String sessionId, @Nullable DatabaseDepartment department, @NotNull Level level, Block ... blocks) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            String string = dataSource2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSource.uniqueId");
            super(projectName, string, sessionId, level, null);
            this.type = type;
            this.statementId = statementId;
            this.department = department;
            this.blocks = (Block[])ArraysKt.plus((Object[])new Block[]{new DataSourceBlock(dataSource2)}, (Object[])blocks);
        }

        public /* synthetic */ DatabaseLogBlockRecord(String string, DasDataSource dasDataSource, String string2, String string3, String string4, DatabaseDepartment databaseDepartment, Level level, Block[] blockArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            if ((n & 0x20) != 0) {
                databaseDepartment = null;
            }
            this(string, dasDataSource, string2, string3, string4, databaseDepartment, level, blockArray);
        }

        @JvmStatic
        @NotNull
        public static final String format(@NotNull List<? extends Block> prepared) {
            return Companion.format(prepared);
        }

        @JvmStatic
        private static final List<Block> prepare(String projectName, String type, String statementId, String sessionId, DatabaseDepartment department, long millis, Block ... blocks) {
            return DatabaseLogBlockRecord.Companion.prepare(projectName, type, statementId, sessionId, department, millis, blocks);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007Ji\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0012\"\u00020\u0007H\u0003\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord$Companion;", "", "()V", "format", "", "prepared", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "prepare", "projectName", "type", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "millis", "", "blocks", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;J[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)Ljava/util/List;", "intellij.database.core.impl"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public final String format(@NotNull List<? extends Block> prepared) {
                void $this$mapIndexedTo$iv$iv;
                Intrinsics.checkNotNullParameter(prepared, (String)"prepared");
                Iterable $this$mapIndexed$iv = prepared;
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void value2;
                    void idx;
                    int n = index$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Block block = (Block)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string = idx == prepared.size() - 1 ? value2.getText() : value2.getText() + value2.getType().getSeparator();
                    collection.add(string);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }

            @JvmStatic
            private final List<Block> prepare(String projectName, String type, String statementId, String sessionId, DatabaseDepartment department, long millis, Block ... blocks) {
                boolean statement;
                Object $this$any$iv;
                ArrayList otherBlocks;
                block7: {
                    boolean bl;
                    int n;
                    Block[] blockArray;
                    otherBlocks = new ArrayList();
                    Collection collection = otherBlocks;
                    String string = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getFormatter$p(DatabaseGlobalAuditService.Companion).format(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(Instant\u2026ult()).toLocalDateTime())");
                    Object object = new TextBlock(BlockType.TIMESTAMP, string, false, 4, null);
                    boolean bl2 = false;
                    collection.add(object);
                    if (department != null) {
                        collection = otherBlocks;
                        object = new TextBlock(BlockType.SUBSYSTEM, department.getDepartmentName(), false, 4, null);
                        bl2 = false;
                        collection.add(object);
                    }
                    if (sessionId != null) {
                        collection = otherBlocks;
                        object = new TextBlock(BlockType.SESSION_ID, "session id: " + sessionId, false, 4, null);
                        bl2 = false;
                        collection.add(object);
                    }
                    if (statementId != null) {
                        collection = otherBlocks;
                        object = new TextBlock(BlockType.STATEMENT_ID, "statement id: " + statementId, false, 4, null);
                        bl2 = false;
                        collection.add(object);
                    }
                    if (type != null) {
                        collection = otherBlocks;
                        object = blocks;
                        bl2 = false;
                        blockArray = object;
                        n = 0;
                        object = new TextBlock(BlockType.EVENT_TYPE, type, !(blockArray.length == 0));
                        bl2 = false;
                        collection.add(object);
                    }
                    $this$any$iv = blocks;
                    boolean $i$f$any = false;
                    blockArray = $this$any$iv;
                    n = blockArray.length;
                    for (int j = 0; j < n; ++j) {
                        Block element$iv;
                        Block it2 = element$iv = blockArray[j];
                        boolean bl3 = false;
                        if (!(it2.getType() == BlockType.STATEMENT)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = statement = false;
                }
                if (statement) {
                    $this$any$iv = otherBlocks;
                    TextBlock $i$f$any = new TextBlock(BlockType.STATEMENT_PREFIX, "-- [ --------------------------------------------------", false, 4, null);
                    boolean bl = false;
                    $this$any$iv.add($i$f$any);
                    $this$any$iv = otherBlocks;
                    $i$f$any = new TextBlock(BlockType.STATEMENT_SUFFIX, "-- ] --------------------------------------------------", false, 4, null);
                    bl = false;
                    $this$any$iv.add($i$f$any);
                }
                if (projectName != null) {
                    $this$any$iv = otherBlocks;
                    TextBlock $i$f$any = new TextBlock(BlockType.PROJECT, projectName, false, 4, null);
                    boolean bl = false;
                    $this$any$iv.add($i$f$any);
                }
                $this$any$iv = otherBlocks;
                TextBlock $i$f$any = new TextBlock(BlockType.LINE_PREFIX, "--", false, 4, null);
                boolean bl = false;
                $this$any$iv.add($i$f$any);
                Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)otherBlocks, (Object[])blocks);
                boolean $i$f$sortedBy = false;
                bl = false;
                return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a2, T b2) {
                        boolean bl = false;
                        Block f = (Block)a2;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getORDER$p(DatabaseGlobalAuditService.Companion), (Object)((Object)f.getType())));
                        f = (Block)b2;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = ArraysKt.indexOf((Object[])com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getORDER$p(DatabaseGlobalAuditService.Companion), (Object)((Object)f.getType()));
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
            }

            static /* synthetic */ List prepare$default(Companion companion, String string, String string2, String string3, String string4, DatabaseDepartment databaseDepartment, long l, Block[] blockArray, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                if ((n & 8) != 0) {
                    string4 = null;
                }
                if ((n & 0x10) != 0) {
                    databaseDepartment = null;
                }
                return companion.prepare(string, string2, string3, string4, databaseDepartment, l, blockArray);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Counter;", "", "()V", "reference", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "getReference", "()Ljava/util/concurrent/atomic/AtomicReference;", "asIdString", "", "pair", "increment", "longs", "incrementAndGet", "nextValue", "long", "intellij.database.core.impl"})
    private static final class Counter {
        @NotNull
        private final AtomicReference<Pair<Long, Long>> reference;

        @NotNull
        public final AtomicReference<Pair<Long, Long>> getReference() {
            return this.reference;
        }

        @NotNull
        public final String incrementAndGet() {
            Pair<Long, Long> pair = this.reference.updateAndGet(new UnaryOperator(this){
                final /* synthetic */ Counter this$0;

                public final Pair<Long, Long> apply(Pair<Long, Long> it2) {
                    Pair<Long, Long> pair = it2;
                    Intrinsics.checkNotNullExpressionValue(pair, (String)"it");
                    return Counter.access$increment(this.this$0, pair);
                }
                {
                    this.this$0 = counter;
                }
            });
            Intrinsics.checkNotNullExpressionValue(pair, (String)"reference.updateAndGet { increment(it) }");
            return this.asIdString(pair);
        }

        private final String asIdString(Pair<Long, Long> pair) {
            return (((Number)pair.getFirst()).longValue() == 0L ? "" : String.valueOf(((Number)pair.getFirst()).longValue())) + String.valueOf(((Number)pair.getSecond()).longValue());
        }

        private final Pair<Long, Long> increment(Pair<Long, Long> longs) {
            long second = ((Number)longs.getSecond()).longValue();
            long nextSecond = this.nextValue(second);
            long first2 = nextSecond == 0L ? this.nextValue(((Number)longs.getFirst()).longValue()) : ((Number)longs.getFirst()).longValue();
            return new Pair((Object)first2, (Object)nextSecond);
        }

        private final long nextValue(long l) {
            return l == Long.MAX_VALUE ? 0L : l + 1L;
        }

        public Counter() {
            long l = new Random().nextInt();
            boolean bl = false;
            this.reference = new AtomicReference<Pair>(TuplesKt.to((Object)0L, (Object)Math.abs(l)));
        }

        public static final /* synthetic */ Pair access$increment(Counter $this, Pair longs) {
            return $this.increment((Pair<Long, Long>)longs);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u001b\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0016H\u0086\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130&H\u0007J\u001a\u0010'\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0016H\u0007J$\u0010'\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0007J$\u0010'\u001a\u00020\f2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010+\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J,\u00102\u001a\u0002032\u0006\u0010-\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u00042\u0006\u0010+\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Companion;", "", "()V", "DB_LOGGER", "", "MAX_CHARACTERS", "", "ORDER", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "databaseCategoryLog", "Ljava/util/logging/Logger;", "formatter", "Ljava/time/format/DateTimeFormatter;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "pending", "", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$LogInfo;", "sessions", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "sessionsCounter", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Counter;", "statementsCounter", "attach", "", "handler", "Ljava/util/logging/Handler;", "disposable", "Lcom/intellij/openapi/Disposable;", "get", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "getPendingStatements", "", "logger", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "sessionId", "dataSourceId", "print", "record", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord;", "setRootLevel", "level", "Ljava/util/logging/Level;", "wrap", "Ljava/util/logging/LogRecord;", "projectName", "intellij.database.core.impl"})
    public static final class Companion {
        private static final int MAX_CHARACTERS = 10000;
        private static final BlockType[] ORDER;
        private static final String DB_LOGGER = "database-global-audit-service";
        private static final Logger log;
        private static final Map<SmartStatementMark, LogInfo> pending;
        private static final Map<DatabaseConnectionCore, String> sessions;
        private static final DateTimeFormatter formatter;
        private static final Counter statementsCounter;
        private static final Counter sessionsCounter;
        private static final java.util.logging.Logger databaseCategoryLog;
        static final /* synthetic */ Companion $$INSTANCE;

        private final LogRecord wrap(LogRecord record, String projectName, String dataSourceId, String sessionId) {
            LogRecord logRecord;
            LogRecord logRecord2 = record;
            if (logRecord2 instanceof DatabaseLogRecord) {
                logRecord = record;
            } else {
                DatabaseLogRecord databaseLogRecord = new DatabaseLogRecord(projectName, dataSourceId, sessionId, record.getLevel(), record.getMessage());
                boolean bl = false;
                boolean bl2 = false;
                DatabaseLogRecord $this$apply = databaseLogRecord;
                boolean bl3 = false;
                $this$apply.setInstant(record.getInstant());
                $this$apply.setSequenceNumber(record.getSequenceNumber());
                $this$apply.setSourceClassName(record.getSourceClassName());
                $this$apply.setSourceMethodName(record.getSourceMethodName());
                $this$apply.setThreadID(record.getThreadID());
                $this$apply.setThrown(record.getThrown());
                $this$apply.setLoggerName(record.getLoggerName());
                $this$apply.setResourceBundleName(record.getResourceBundleName());
                logRecord = databaseLogRecord;
            }
            return logRecord;
        }

        @JvmStatic
        @NotNull
        public final java.util.logging.Logger logger(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            String sessionId = sessions.get(connection2);
            DatabaseConnectionPoint databaseConnectionPoint = connection2.getConnectionPoint();
            Intrinsics.checkNotNullExpressionValue((Object)databaseConnectionPoint, (String)"connection.connectionPoint");
            LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"connection.connectionPoint.dataSource");
            LocalDataSource dataSource2 = localDataSource;
            return this.logger(project, dataSource2, sessionId);
        }

        @JvmStatic
        @NotNull
        public final java.util.logging.Logger logger(@Nullable Project project, @NotNull DasDataSource dataSource2, @Nullable String sessionId) {
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            String string = dataSource2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dataSource.uniqueId");
            String dataSourceId = string;
            return this.logger(project, dataSourceId, sessionId);
        }

        @JvmStatic
        @NotNull
        public final java.util.logging.Logger logger(@Nullable Project project, @NotNull String dataSourceId, @Nullable String sessionId) {
            Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
            StringBuilder stringBuilder = new StringBuilder().append("database-global-audit-service.");
            String string = sessionId;
            if (string == null) {
                string = dataSourceId;
            }
            String loggerName = stringBuilder.append(string).toString();
            LogManager manager = LogManager.getLogManager();
            java.util.logging.Logger logger2 = manager.getLogger(loggerName);
            if (logger2 != null) {
                java.util.logging.Logger logger3 = logger2;
                boolean bl = false;
                boolean bl2 = false;
                java.util.logging.Logger it2 = logger3;
                boolean bl3 = false;
                return it2;
            }
            Project project2 = project;
            String projectName = project2 != null ? project2.getName() : null;
            java.util.logging.Logger newLogger2 = new java.util.logging.Logger(this, projectName, dataSourceId, sessionId, loggerName, loggerName, null){
                final /* synthetic */ Companion this$0;
                final /* synthetic */ String $projectName;
                final /* synthetic */ String $dataSourceId;
                final /* synthetic */ String $sessionId;
                final /* synthetic */ String $loggerName;

                public void log(@NotNull LogRecord record) {
                    Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                    LogRecord wrappedRecord = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$wrap(this.this$0, record, this.$projectName, this.$dataSourceId, this.$sessionId);
                    super.log(wrappedRecord);
                }
                {
                    this.this$0 = this$0;
                    this.$projectName = $captured_local_variable$1;
                    this.$dataSourceId = $captured_local_variable$2;
                    this.$sessionId = $captured_local_variable$3;
                    this.$loggerName = $captured_local_variable$4;
                    super($super_call_param$5, $super_call_param$6);
                }
            };
            manager.addLogger(newLogger2);
            return newLogger2;
        }

        @NotNull
        public final DatabaseGlobalAuditService get(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            return new Service(project, connection2);
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final Set<SmartStatementMark> getPendingStatements() {
            return pending.keySet();
        }

        @JvmStatic
        public final void attach(@NotNull Handler handler, @NotNull Disposable disposable2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
                java.util.logging.Logger logger2 = databaseCategoryLog;
                if (logger2 == null) break block0;
                java.util.logging.Logger logger3 = logger2;
                boolean bl = false;
                boolean bl2 = false;
                java.util.logging.Logger $this$apply = logger3;
                boolean bl3 = false;
                $this$apply.addHandler(handler);
                Disposer.register((Disposable)disposable2, (Disposable)new Disposable($this$apply, handler, disposable2){
                    final /* synthetic */ java.util.logging.Logger $this_apply;
                    final /* synthetic */ Handler $handler$inlined;
                    final /* synthetic */ Disposable $disposable$inlined;
                    {
                        this.$this_apply = logger2;
                        this.$handler$inlined = handler;
                        this.$disposable$inlined = disposable2;
                    }

                    public final void dispose() {
                        this.$this_apply.removeHandler(this.$handler$inlined);
                    }
                });
            }
        }

        @JvmStatic
        public final void setRootLevel(@NotNull Level level, @NotNull Disposable disposable2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
                java.util.logging.Logger logger2 = databaseCategoryLog;
                if (logger2 == null) break block0;
                java.util.logging.Logger logger3 = logger2;
                boolean bl = false;
                boolean bl2 = false;
                java.util.logging.Logger $this$apply = logger3;
                boolean bl3 = false;
                Level prev = $this$apply.getLevel();
                $this$apply.setLevel(level);
                Disposer.register((Disposable)disposable2, (Disposable)new Disposable($this$apply, prev){
                    final /* synthetic */ java.util.logging.Logger $this_apply;
                    final /* synthetic */ Level $prev;

                    public final void dispose() {
                        this.$this_apply.setLevel(this.$prev);
                    }
                    {
                        this.$this_apply = logger2;
                        this.$prev = level;
                    }
                });
            }
        }

        private final void print(DatabaseLogBlockRecord record) {
            block0: {
                java.util.logging.Logger logger2 = databaseCategoryLog;
                if (logger2 == null) break block0;
                logger2.log(record);
            }
        }

        private Companion() {
        }

        static {
            java.util.logging.Logger logger2;
            Companion companion;
            $$INSTANCE = companion = new Companion();
            ORDER = new BlockType[]{BlockType.STATEMENT_PREFIX, BlockType.LINE_PREFIX, BlockType.TIMESTAMP, BlockType.PROJECT, BlockType.DATA_SOURCE, BlockType.SUBSYSTEM, BlockType.SESSION_ID, BlockType.STATEMENT_ID, BlockType.EVENT_TYPE, BlockType.STATEMENT, BlockType.MESSAGE, BlockType.WARNING, BlockType.ERROR, BlockType.UPDATE_COUNT, BlockType.EXECUTION_DURATION, BlockType.FETCHING_DURATION, BlockType.TOTAL_UPDATE_COUNT, BlockType.TOTAL_RESULT_SET_COUNT, BlockType.STATEMENT_SUFFIX};
            Logger logger3 = Logger.getInstance(DatabaseGlobalAuditService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"com.intellij.openapi.dia\u2026Service::class.java\n    )");
            log = logger3;
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConcurrentWeakMap()");
            pending = concurrentMap;
            sessions = new ConcurrentHashMap();
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"DateTimeFormatterBuilder\u2026, 2)\n      .toFormatter()");
            formatter = dateTimeFormatter;
            statementsCounter = new Counter();
            sessionsCounter = new Counter();
            try {
                File dir = SmartStatementsUtil.getLogPath().getParentFile();
                FileUtil.ensureExists((File)dir);
                String string = StringUtil.trimEnd((String)SmartStatementsUtil.getLogPath().getName(), (String)".0.log");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimEnd(logPath.name, \".0.log\")");
                String trimmed = string;
                File oldFile = new File(dir, trimmed + ".log");
                if (oldFile.exists()) {
                    try {
                        FileUtil.rename((File)oldFile, (String)SmartStatementsUtil.getLogPath().getName());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                FileHandler handler = new FileHandler(new File(dir, trimmed + ".%g.log").getPath(), 0x100000, 12, true);
                handler.setLevel(Level.INFO);
                handler.setEncoding("UTF-8");
                handler.setFormatter(new Formatter(){

                    @Override
                    @NotNull
                    public String format(@NotNull LogRecord record) {
                        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                        return record.getMessage() + "\n";
                    }
                });
                java.util.logging.Logger logger4 = java.util.logging.Logger.getLogger(DB_LOGGER);
                Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"Logger.getLogger(DB_LOGGER)");
                java.util.logging.Logger result2 = logger4;
                result2.setUseParentHandlers(false);
                result2.addHandler(handler);
                result2.setLevel(Level.INFO);
                logger2 = result2;
            }
            catch (IOException e) {
                log.error("Failed to initialize database logging", (Throwable)e);
                logger2 = null;
            }
            databaseCategoryLog = logger2;
        }

        public static final /* synthetic */ Counter access$getSessionsCounter$p(Companion $this) {
            Companion companion = $this;
            return sessionsCounter;
        }

        public static final /* synthetic */ Map access$getSessions$p(Companion $this) {
            Companion companion = $this;
            return sessions;
        }

        public static final /* synthetic */ Counter access$getStatementsCounter$p(Companion $this) {
            Companion companion = $this;
            return statementsCounter;
        }

        public static final /* synthetic */ Map access$getPending$p(Companion $this) {
            Companion companion = $this;
            return pending;
        }

        public static final /* synthetic */ Logger access$getLog$p(Companion $this) {
            Companion companion = $this;
            return log;
        }

        public static final /* synthetic */ DateTimeFormatter access$getFormatter$p(Companion $this) {
            Companion companion = $this;
            return formatter;
        }

        public static final /* synthetic */ BlockType[] access$getORDER$p(Companion $this) {
            Companion companion = $this;
            return ORDER;
        }

        public static final /* synthetic */ LogRecord access$wrap(Companion $this, LogRecord record, String projectName, String dataSourceId, String sessionId) {
            return $this.wrap(record, projectName, dataSourceId, sessionId);
        }
    }
}

