/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SslConnectionInterceptor
implements DatabaseConnectionInterceptor,
ConsoleRunConfiguration.ParamProvider {
    @Override
    public @Nullable CompletionStage<@NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        LocalDataSource dataSource2;
        DataSourceSslConfiguration ssl;
        if (proto == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(0);
        }
        if ((ssl = (dataSource2 = proto.getConnectionPoint().getDataSource()).getSslCfg()) == null || !ssl.myEnabled) {
            return null;
        }
        return DatabaseCredentials.getInitialCredentialsImpl(ssl.myPasswordStorage, !silent, () -> AsyncTask.currentFrame().compute(AsyncUtil.getPoolExecutor(), () -> proto.getCredentials().getSslPassphrase(dataSource2)), th -> th == null ? SslConnectionInterceptor.askNoCredentials(proto) : SslConnectionInterceptor.askCredentialsWhenFailed(proto, th.getMessage(), true), Objects::isNull).apply(null, p2 -> {
            JdbcSettings.SSL_MODE.put(proto.getExtraProperties(), (Object)ssl.myMode);
            JdbcSettings.SSL_CLIENT_CERT_PATH.put(proto.getExtraProperties(), (Object)StringUtil.nullize((String)ssl.myClientCertPath));
            JdbcSettings.SSL_CLIENT_KEY_PATH.put(proto.getExtraProperties(), (Object)StringUtil.nullize((String)ssl.myClientKeyPath));
            JdbcSettings.SSL_CLIENT_KEY_PWD.put(proto.getExtraProperties(), (Object)(p2 == null ? null : p2.toCharArray()));
            return proto;
        }).unwrap();
    }

    @Override
    public void populate(@NotNull ParametersList params, @NotNull LocalDataSource dataSource2) {
        DataSourceSslConfiguration ssl;
        if (params == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(1);
        }
        if (dataSource2 == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(2);
        }
        if ((ssl = dataSource2.getSslCfg()) != null && ssl.myEnabled) {
            SslConnectionInterceptor.addNotEmpty(params, ssl.myCaCertPath, "sslCaCertPath");
            if (Registry.is((String)"database.ssl.use.socket.factory", (boolean)false)) {
                SslConnectionInterceptor.addNotEmpty(params, ssl.myClientCertPath, "sslClientCertPath");
                SslConnectionInterceptor.addNotEmpty(params, ssl.myClientKeyPath, "sslClientKeyPath");
                SslConnectionInterceptor.addNotEmpty(params, "true", "sslUseFactory");
            } else {
                SslConnectionInterceptor.addNotEmpty(params, "true", "sslDeferredKeyLoading");
            }
        }
    }

    private static void addNotEmpty(@NotNull ParametersList props, @Nullable String value2, @NotNull String key) {
        if (props == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(3);
        }
        if (key == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(4);
        }
        if (!StringUtil.isEmptyOrSpaces((String)value2)) {
            props.addProperty(key, value2);
        }
    }

    @Override
    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> handleConnectionFailure(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NotNull SQLException e, boolean silent, int attempt) {
        String msg;
        if (proto == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(5);
        }
        if (e == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(6);
        }
        if ((msg = StringUtil.notNullize((String)e.getMessage())).contains("JCE error: Password is not ASCII") || msg.contains("JCE error: Cannot retrieve the PKCS8EncodedKeySpec")) {
            String message2 = DatabaseBundle.message("dialog.message.wrong.ssl.key.password", msg);
            return silent ? null : SslConnectionInterceptor.askCredentialsWhenFailed(proto, message2, true).apply(null, p2 -> {
                JdbcSettings.SSL_CLIENT_KEY_PWD.put(proto.getExtraProperties(), (Object)(p2 == null ? null : p2.toCharArray()));
                return proto;
            }).unwrap();
        }
        return null;
    }

    private static AsyncTask<OneTimeString> askNoCredentials(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto) {
        if (proto == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(7);
        }
        return SslConnectionInterceptor.askCredentialsWhenFailed(proto, DatabaseBundle.message("dialog.message.html.please.provide.ssl.private.key.passphrase.html", new Object[0]), false);
    }

    @NotNull
    public static AsyncTask<OneTimeString> askCredentialsWhenFailed(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, @NlsContexts.DialogMessage @Nullable String message2, boolean error2) {
        if (proto == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(8);
        }
        LocalDataSource dataSource2 = proto.getConnectionPoint().getDataSource();
        Project project = proto.getRunConfiguration().getProject();
        DatabaseCredentials dc = proto.getCredentials();
        if (project.isDefault()) {
            AsyncTask<OneTimeString> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                SslConnectionInterceptor.$$$reportNull$$$0(9);
            }
            return asyncTask;
        }
        OneTimeString c1 = dc.getSslPassphrase(dataSource2);
        AsyncTask<OneTimeString> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.re.ask.credentials", new Object[0])).computeAsync(DatabaseCredentialsUi.EXECUTOR, () -> {
            OneTimeString c2 = dc.getSslPassphrase(dataSource2);
            if (Comparing.equal((CharSequence)c1, (CharSequence)c2)) {
                boolean ok;
                DataSourceSshSslPanel.SslPassphraseComponent component = new DataSourceSshSslPanel.SslPassphraseComponent(dc, dataSource2);
                component.reset(dataSource2.getSslCfg(), c2 == null);
                DialogBuilder builder = DatabaseCredentialsUi.prepareDialog(project, (error2 ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), component, DatabaseBundle.message("dialog.title.connecting.to", dataSource2.getName()), StringUtil.notNullize((String)message2));
                builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
                boolean bl = ok = builder.show() == 0;
                if (!ok) {
                    throw new ProcessCanceledException();
                }
                DataSourceSslConfiguration cfg = dataSource2.getSslCfg();
                if (cfg != null) {
                    component.save(dataSource2, cfg, true);
                }
            }
            return AsyncTask.currentFrame().compute(AsyncUtil.getPoolExecutor(), () -> dc.getSslPassphrase(dataSource2));
        });
        if (asyncTask == null) {
            SslConnectionInterceptor.$$$reportNull$$$0(10);
        }
        return asyncTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/SslConnectionInterceptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/SslConnectionInterceptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "askCredentialsWhenFailed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNotEmpty";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionFailure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "askNoCredentials";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "askCredentialsWhenFailed";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

