/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.download.impl.DownloadableFileSetDescriptionImpl;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.ZipUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.xmlpull.v1.XmlPullParser;

@ApiStatus.Internal
public final class DatabaseArtifactList {
    public static final String STABLE_CHANNEL = "stable";
    private static final Logger LOG = Logger.getInstance(DatabaseArtifactList.class);
    public static final DatabaseArtifactList EMPTY = new DatabaseArtifactList(false, new URL[0]);
    private static final Version IDE_VERSION = Version.of(ApplicationInfo.getInstance().getBuild().getComponents());
    private final Map<String, Artifact> myArtifacts;
    private final Map<String, Channel> myChannels;
    private List<RemoteRepository> myDefaultRepositories;
    private final List<RemoteRepository> myRepositories;
    private final Channel myStableChannel;
    private static final File NATIVE_LIBS_ROOT = new File(PathManager.getSystemPath(), "jdbc-native-deps");
    public static final ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.artifactsConfig");

    public DatabaseArtifactList(boolean checkDuplicates, URL ... urls) {
        if (urls == null) {
            DatabaseArtifactList.$$$reportNull$$$0(0);
        }
        this.myArtifacts = new TreeMap<String, Artifact>();
        this.myChannels = new TreeMap<String, Channel>();
        this.myRepositories = new ArrayList<RemoteRepository>();
        this.myStableChannel = new Channel(STABLE_CHANNEL, "Latest stable", false);
        this.myChannels.put(this.myStableChannel.id, this.myStableChannel);
        for (URL url : urls) {
            this.loadList(url, checkDuplicates);
        }
    }

    @Nullable
    public Artifact getArtifact(@Nullable String id) {
        return id == null ? null : this.myArtifacts.get(id);
    }

    @Nullable
    public ArtifactVersion resolve(@NotNull String artifactId, @Nullable Version version) {
        Artifact artifact;
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(1);
        }
        if ((artifact = this.getArtifact(artifactId)) == null) {
            return null;
        }
        return version == null ? null : artifact.get(version);
    }

    @Nullable
    public ArtifactVersion resolve(@NotNull String artifactId, @Nullable Version version, @Nullable String channelId, @Nullable Condition<? super ArtifactVersion> filter2) {
        if (artifactId == null) {
            DatabaseArtifactList.$$$reportNull$$$0(2);
        }
        if (channelId != null) {
            Channel channel = this.getChannel(channelId);
            Artifact artifact = this.getArtifact(artifactId);
            return artifact == null || channel == null ? null : channel.getLatest(artifact, filter2);
        }
        return this.resolve(artifactId, version);
    }

    @Nullable
    public Channel getChannel(@Nullable String id) {
        return id == null ? null : this.myChannels.get(id);
    }

    @NotNull
    public Set<Artifact> getArtifacts() {
        return new LinkedHashSet<Artifact>(this.myArtifacts.values());
    }

    @NotNull
    public List<Channel> getChannels() {
        return new ArrayList<Channel>(this.myChannels.values());
    }

    public boolean isValid(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(3);
        }
        return DatabaseArtifactList.isValidFileList(version);
    }

    public boolean isValid(@NotNull String name, @Nullable Version version) {
        Artifact artifact;
        ArtifactVersion desc;
        if (name == null) {
            DatabaseArtifactList.$$$reportNull$$$0(4);
        }
        ArtifactVersion artifactVersion = desc = (artifact = this.getArtifact(name)) == null || version == null ? null : artifact.get(version);
        if (desc != null) {
            return this.isValid(desc);
        }
        return version != null && DatabaseArtifactList.getArtifactDir(name, version).exists();
    }

    public boolean isFreshFiles(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(5);
        }
        return DatabaseArtifactList.isAllDownloaded(version);
    }

    public static boolean isValidFileList(@NotNull ArtifactVersion desc) {
        if (desc == null) {
            DatabaseArtifactList.$$$reportNull$$$0(6);
        }
        return DatabaseArtifactList.isAllDownloaded(desc);
    }

    private static boolean isAllDownloaded(@NotNull ArtifactVersion artifact) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(7);
        }
        File dir = DatabaseArtifactList.getArtifactDir(artifact);
        for (Item item : artifact.items) {
            if (!item.os.applicable || item.type == Item.Type.LICENSE || DatabaseArtifactList.exists(dir, artifact, item)) continue;
            return false;
        }
        return true;
    }

    private static boolean exists(File dir, ArtifactVersion ver, Item item) {
        if (item.type != Item.Type.MAVEN) {
            return new File(dir, item.name).exists();
        }
        Pair<List<File>, Boolean> state = item.getClassPathState(ver, dir);
        if (!((Boolean)state.second).booleanValue()) {
            return false;
        }
        for (File file : (List)state.first) {
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadArtifact(@NotNull ArtifactVersion download) throws IOException {
        if (download == null) {
            DatabaseArtifactList.$$$reportNull$$$0(8);
        }
        File dir = DatabaseArtifactList.getArtifactDir(download);
        try {
            DownloadableFileSetDescription description = DatabaseArtifactList.asDownloadable(download);
            if (!description.getFiles().isEmpty()) {
                FileDownloader downloader = DownloadableFileService.getInstance().createDownloader(description);
                downloader.download(dir);
            }
            try {
                this.downloadMavenItems(download, dir);
            }
            catch (Exception e) {
                throw new IOException("Download from maven failed", e);
            }
            DatabaseArtifactList.unpackZippedItems(download);
        }
        finally {
            for (Item item : download.items) {
                DatabaseArtifactList.refillCache(download, dir, item);
            }
        }
    }

    private void downloadMavenItems(@NotNull ArtifactVersion download, File dir) throws Exception {
        if (download == null) {
            DatabaseArtifactList.$$$reportNull$$$0(9);
        }
        for (Item item : download.items) {
            if (item.type != Item.Type.MAVEN) continue;
            this.resolveMavenItem(dir, item, true);
        }
    }

    private static void refillCache(@NotNull ArtifactVersion download, File dir, Item item) {
        if (download == null) {
            DatabaseArtifactList.$$$reportNull$$$0(10);
        }
        item.classpath = null;
        item.getClassPathState(download, dir);
    }

    public static void unpackZippedItems(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(11);
        }
        File dir = DatabaseArtifactList.getArtifactDir(version);
        for (Item item : version.items) {
            if (!item.os.applicable || item.type != Item.Type.NATIVE && item.type != Item.Type.PACK) continue;
            DatabaseArtifactList.unpackZipIfNeeded(dir, version, item);
        }
    }

    @Nullable
    private static File unpackZipIfNeeded(File dir, @NotNull ArtifactVersion version, Item item) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(12);
        }
        File archive = new File(dir, item.name);
        return DatabaseArtifactList.unpackZipIfNeeded(archive, version);
    }

    public static List<File> getNativeLibraries(@NotNull ArtifactVersion version, @NotNull Bitness bitness) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(13);
        }
        if (bitness == null) {
            DatabaseArtifactList.$$$reportNull$$$0(14);
        }
        File dir = DatabaseArtifactList.getArtifactDir(version);
        ArrayList<File> paths = new ArrayList<File>();
        for (Item item : version.items) {
            File archive;
            File archPath;
            if (!item.os.applicable || item.type != Item.Type.NATIVE || (archPath = DatabaseArtifactList.getNativeLibrary(archive = new File(dir, item.name), version, bitness)) == null) continue;
            paths.add(archPath);
        }
        return paths;
    }

    public static File getNativeLibrary(@NotNull File archive, @Nullable ArtifactVersion version, @NotNull Bitness bitness) {
        File path;
        if (archive == null) {
            DatabaseArtifactList.$$$reportNull$$$0(15);
        }
        if (bitness == null) {
            DatabaseArtifactList.$$$reportNull$$$0(16);
        }
        if ((path = DatabaseArtifactList.unpackZipIfNeeded(archive, version)) == null) {
            return null;
        }
        return DatabaseArtifactList.chooseArchPath(path, bitness);
    }

    private static File chooseArchPath(File path, Bitness bitness) {
        File archFolder = new File(path, bitness.toString());
        if (!archFolder.exists()) {
            return path;
        }
        File sso = new File(archFolder, "SSO");
        if (sso.exists()) {
            return sso;
        }
        return archFolder;
    }

    private static void extractLibrary(File archive, File out, String name) {
        if (DatabaseArtifactList.isExtracted(out)) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2(DatabaseBundle.message("progress.details.extracting", name));
        }
        try {
            ZipUtil.extract((File)archive, (File)out, null, (boolean)true);
        }
        catch (IOException e) {
            LOG.warn("Failed to extract " + name, (Throwable)e);
            FileUtil.delete((File)out);
        }
    }

    private static File unpackZipIfNeeded(@NotNull File archive, @Nullable ArtifactVersion version) {
        if (archive == null) {
            DatabaseArtifactList.$$$reportNull$$$0(17);
        }
        if (!archive.exists()) {
            return null;
        }
        File out = DatabaseArtifactList.getUnpackPath(archive, version);
        DatabaseArtifactList.extractLibrary(archive, out, archive.getName());
        return out;
    }

    private static boolean isExtracted(File out) {
        return out.exists() && !ArrayUtil.isEmpty((Object[])out.list());
    }

    @NotNull
    private static File getUnpackPath(File archive, @Nullable ArtifactVersion version) {
        String name = FileUtil.getNameWithoutExtension((File)archive);
        if (version != null) {
            return new File(new File(new File(NATIVE_LIBS_ROOT, version.artifact.id), version.version.toString()), name);
        }
        MessageDigest digest = DigestUtil.sha256();
        DigestUtil.updateContentHash((MessageDigest)digest, (Path)archive.toPath());
        String fileHash = StringUtil.toHexString((byte[])digest.digest());
        return new File(new File(NATIVE_LIBS_ROOT, "user-provided"), name + "-" + fileHash);
    }

    void loadList(@NotNull URL url, boolean checkDuplicates) {
        if (url == null) {
            DatabaseArtifactList.$$$reportNull$$$0(18);
        }
        try (InputStream stream = url.openStream();){
            String file = PathUtil.getFileName((String)url.getPath());
            if (!file.startsWith("test-") && !file.startsWith("builtin-")) {
                file = null;
            }
            this.loadList((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (XmlPullParser)new MXParser()), checkDuplicates, file);
        }
        catch (IOException e) {
            LOG.warnInProduction((Throwable)e);
        }
    }

    void loadList(@NotNull HierarchicalStreamReader reader, boolean checkDuplicates, @Nullable String source) throws IOException {
        if (reader == null) {
            DatabaseArtifactList.$$$reportNull$$$0(19);
        }
        if (!"artifacts".equals(reader.getNodeName())) {
            throw new IOException("Unexpected root: " + reader.getNodeName());
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "repository": {
                    this.readRepository(reader);
                    break;
                }
                case "artifact": {
                    this.readArtifact(reader, checkDuplicates, source);
                    break;
                }
                case "channel": {
                    this.readChannel(reader, null, null);
                    break;
                }
                case "constraint": {
                    String id = reader.getAttribute("artifact-id");
                    if (id == null) {
                        throw new IOException("No artifact id for constraint");
                    }
                    Artifact artifact = this.getArtifact(id);
                    if (artifact == null) {
                        throw new IOException("Unable to find artifact " + id);
                    }
                    DatabaseArtifactList.readConstraint(reader, artifact);
                }
            }
            reader.moveUp();
        }
    }

    private static void readConstraint(HierarchicalStreamReader reader, @NotNull Artifact artifact) {
        Dbms dbms;
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(20);
        }
        Version from = Version.of(reader.getAttribute("from"));
        Version to = Version.of(reader.getAttribute("to"));
        String dbmsName = reader.getAttribute("dbms");
        Version dbForm = Version.of(reader.getAttribute("db-from"));
        Version dbTo = Version.of(reader.getAttribute("db-to"));
        Version ideForm = Version.of(reader.getAttribute("ide-from"));
        Version ideTo = Version.of(reader.getAttribute("ide-to"));
        Dbms dbms2 = dbms = dbmsName == null ? null : Dbms.byName(dbmsName);
        if (dbms == null && dbmsName != null) {
            return;
        }
        artifact.constraints.add(new Constraint(from, to, dbms, dbForm, dbTo, ideForm, ideTo));
    }

    private void readChannel(HierarchicalStreamReader reader, @Nullable String artifactId, @Nullable Version version) {
        String id = reader.getAttribute("id");
        Channel channel = this.myChannels.get(id);
        if (channel == null) {
            String name = reader.getAttribute("name");
            String implicit = reader.getAttribute("implicit");
            channel = new Channel(id, name, "true".equals(implicit));
            this.myChannels.put(channel.id, channel);
        }
        if (artifactId == null) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("artifact".equals(reader.getNodeName())) {
                    artifactId = reader.getAttribute("id");
                    version = Version.parse(reader.getAttribute("version"));
                    if (artifactId != null && version != null) {
                        channel.addHead(artifactId, version);
                    }
                }
                reader.moveUp();
            }
        } else {
            String versionStr = reader.getAttribute("version");
            if (versionStr != null) {
                version = Version.parse(versionStr);
            }
            if (version != null) {
                channel.addHead(artifactId, version);
            }
        }
    }

    private void readRepository(HierarchicalStreamReader reader) throws IOException {
        String id = reader.getAttribute("id");
        if (id == null) {
            throw new IOException("No id for repository");
        }
        String url = reader.getAttribute("url");
        if (url == null) {
            throw new IOException("No url for repository");
        }
        RemoteRepository repo = ArtifactRepositoryManager.createRemoteRepository((String)id, (String)url);
        this.myRepositories.add(repo);
    }

    private void readArtifact(HierarchicalStreamReader reader, boolean checkDuplicates, @Nullable String source) throws IOException {
        Artifact artifact;
        String id = reader.getAttribute("id");
        String name = reader.getAttribute("name");
        if (id == null) {
            id = StringUtil.trimEnd((String)name.replaceAll("[^a-zA-Z0-9. _-]", ""), (String)" 8");
        }
        if ("Redshift 2".equals(id)) {
            id = "Redshift";
            name = "Redshift";
        }
        if ("PostgreSQL 2".equals(id)) {
            id = "PostgreSQL";
            name = "PostgreSQL";
        }
        if ((artifact = this.myArtifacts.get(id)) == null) {
            artifact = new Artifact(id, name);
            this.checkIndexConsistency(artifact);
            this.myArtifacts.put(artifact.id, artifact);
        }
        this.myArtifacts.put(name, artifact);
        artifact.names.add(name);
        ArtifactVersion prevVersion = null;
        if (reader.getAttribute("version") == null) {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                switch (reader.getNodeName()) {
                    case "version": {
                        prevVersion = this.readArtifactVersion(reader, artifact, checkDuplicates, source);
                        break;
                    }
                    case "constraint": {
                        DatabaseArtifactList.readConstraint(reader, artifact);
                        break;
                    }
                    case "channel": {
                        this.readChannel(reader, artifact.id, prevVersion == null ? null : prevVersion.version);
                    }
                }
                reader.moveUp();
            }
        } else {
            this.readArtifactVersion(reader, artifact, checkDuplicates, source);
        }
    }

    private void checkIndexConsistency(Artifact artifact) throws IOException {
        Artifact byName;
        Artifact byId = this.myArtifacts.get(artifact.id);
        if (byId != (byName = this.myArtifacts.get(artifact.name))) {
            throw new IOException("id/name inconsistency: " + (byId == null ? null : byId.id + ":" + byId.name) + "/" + (byName == null ? null : byName.id + ":" + byName.name));
        }
    }

    private ArtifactVersion readArtifactVersion(HierarchicalStreamReader reader, @NotNull Artifact artifact, boolean checkDuplicates, @Nullable String source) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(21);
        }
        Version version = Version.of(reader.getAttribute("version"));
        ArrayList<Item> items2 = new ArrayList<Item>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "item": {
                    items2.add(this.readItem(reader));
                    break;
                }
                case "channel": {
                    this.readChannel(reader, artifact.id, version);
                }
            }
            reader.moveUp();
        }
        ArtifactVersion av = new ArtifactVersion(artifact, version, items2, source);
        if (!artifact.versions.add(av) && checkDuplicates) {
            LOG.error("Duplicate artifact version " + av);
        }
        return av;
    }

    private Item readItem(HierarchicalStreamReader reader) {
        String osName;
        Item.OS os;
        String url = reader.getAttribute("url");
        String name = reader.getAttribute("name");
        if (name == null) {
            name = PathUtil.getFileName((String)url);
        }
        Item.OS oS = os = (osName = reader.getAttribute("os")) == null ? null : (Item.OS)((Object)ContainerUtil.find((Object[])Item.OS.values(), o -> o.name().equalsIgnoreCase(osName)));
        if (os == null) {
            os = name.contains("win") ? Item.OS.WIN : Item.OS.ANY;
        }
        String typeName = reader.getAttribute("type");
        Item.Type type = (Item.Type)((Object)ContainerUtil.find((Object[])Item.Type.values(), o -> o.name().equalsIgnoreCase(typeName)));
        if (type == null) {
            type = name.endsWith(".txt") ? Item.Type.LICENSE : ((name.startsWith("sqlserver") || name.startsWith("jtds")) && name.endsWith("win-auth.jar") ? Item.Type.NATIVE : Item.Type.JAR);
        }
        return new Item(this, name, url, os, type);
    }

    @NotNull
    private static File getArtifactDir(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(22);
        }
        return DatabaseArtifactList.getArtifactDir(version.artifact, version.version);
    }

    @NotNull
    static File getArtifactDir(@NotNull Artifact artifact, @NotNull Version version) {
        File expected;
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(23);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(24);
        }
        if ((expected = DatabaseArtifactList.getArtifactDirImpl(artifact.id, version)).exists()) {
            File file = expected;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(25);
            }
            return file;
        }
        File old = DatabaseArtifactList.getArtifactDirImpl(artifact.name, version);
        if (old.exists()) {
            File file = old;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(26);
            }
            return file;
        }
        if (artifact.id.equals("MySQL ConnectorJ") && (old = DatabaseArtifactList.getArtifactDirImpl("MySQL Connector/J 8", version)).exists()) {
            File file = old;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(27);
            }
            return file;
        }
        File file = expected;
        if (file == null) {
            DatabaseArtifactList.$$$reportNull$$$0(28);
        }
        return file;
    }

    @NotNull
    public static File getArtifactDir(@NotNull String name, @NotNull Version version) {
        File asIs;
        if (name == null) {
            DatabaseArtifactList.$$$reportNull$$$0(29);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(30);
        }
        if ((asIs = DatabaseArtifactList.getArtifactDirImpl(name, version)).exists()) {
            File file = asIs;
            if (file == null) {
                DatabaseArtifactList.$$$reportNull$$$0(31);
            }
            return file;
        }
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        Artifact artifact = artifacts.getArtifact(name);
        return artifact == null ? asIs : DatabaseArtifactList.getArtifactDir(artifact, version);
    }

    @NotNull
    private static File getArtifactDirImpl(@NotNull String artifact, @NotNull Version version) {
        if (artifact == null) {
            DatabaseArtifactList.$$$reportNull$$$0(32);
        }
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(33);
        }
        return new File(new File(DatabaseDriverImpl.getDownloadPath(), artifact), version.toString());
    }

    @NotNull
    private static DownloadableFileDescription asDownloadable(@NotNull Item item) {
        if (item == null) {
            DatabaseArtifactList.$$$reportNull$$$0(34);
        }
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(item.url, item.name);
        if (downloadableFileDescription == null) {
            DatabaseArtifactList.$$$reportNull$$$0(35);
        }
        return downloadableFileDescription;
    }

    @NotNull
    public static DownloadableFileSetDescription asDownloadable(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(36);
        }
        return new DownloadableFileSetDescriptionImpl(version.artifact.name, version.version.toString(), ContainerUtil.mapNotNull(version.items, item -> item.os.applicable && item.type != Item.Type.MAVEN ? DatabaseArtifactList.asDownloadable(item) : null));
    }

    @NotNull
    public static List<File> getClasspathElements(@NotNull ArtifactVersion version) {
        if (version == null) {
            DatabaseArtifactList.$$$reportNull$$$0(37);
        }
        File dir = DatabaseArtifactList.getArtifactDir(version);
        ArrayList<File> elements = new ArrayList<File>();
        for (Item item : version.items) {
            List<File> cp = item.getClassPath(version, dir);
            if (cp == null) continue;
            elements.addAll(cp);
        }
        ArrayList<File> arrayList = elements;
        if (arrayList == null) {
            DatabaseArtifactList.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    private Collection<File> resolveMavenItem(File dir, Item item, boolean download) throws Exception {
        final ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText(DatabaseBundle.message("progress.text.choice.downloading.resolving", download ? 0 : 1, item.url));
        }
        ArtifactRepositoryManager manager = new ArtifactRepositoryManager(dir, this.getRepositories(), indicator != null ? new ProgressConsumer(){

            public void consume(String message2) {
                indicator.setText2(message2);
            }

            public boolean isCanceled() {
                return indicator.isCanceled();
            }
        } : ProgressConsumer.DEAF, !download);
        List coords = StringUtil.split((String)item.url, (String)":");
        if (coords.size() != 3) {
            throw new IOException("Illegal maven coordinates " + item.url + " should be group:artifact:version");
        }
        Collection collection = manager.resolveDependency((String)coords.get(0), (String)coords.get(1), (String)coords.get(2), true, Collections.emptyList());
        if (collection == null) {
            DatabaseArtifactList.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @NotNull
    private List<RemoteRepository> getRepositories() {
        if (this.myDefaultRepositories == null) {
            this.myDefaultRepositories = ArtifactRepositoryManager.createDefaultRemoteRepositories();
        }
        List list = ContainerUtil.concat(this.myDefaultRepositories, this.myRepositories);
        if (list == null) {
            DatabaseArtifactList.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 22: 
            case 24: 
            case 30: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 7: 
            case 20: 
            case 21: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "download";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bitness";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactList";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactDir";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "asDownloadable";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMavenItem";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFreshFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAllDownloaded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifact";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadMavenItems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refillCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unpackZippedItems";
                break;
            }
            case 12: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unpackZipIfNeeded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibraries";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibrary";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readConstraint";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readArtifactVersion";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDir";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactDirImpl";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "asDownloadable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getClasspathElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Constraint {
        @Nullable
        public final Version from;
        @Nullable
        public final Version to;
        @Nullable
        public final Dbms dbms;
        @Nullable
        public final Version dbFrom;
        @Nullable
        public final Version dbTo;
        @Nullable
        public final Version ideFrom;
        @Nullable
        public final Version ideTo;

        public Constraint(@Nullable Version from, @Nullable Version to, @Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo, @Nullable Version ideFrom, @Nullable Version ideTo) {
            this.from = from;
            this.to = to;
            this.dbms = dbms;
            this.dbFrom = dbFrom;
            this.dbTo = dbTo;
            this.ideFrom = ideFrom;
            this.ideTo = ideTo;
        }

        public boolean matches(@Nullable Version ver, @Nullable Dbms dbms, @Nullable Version dbVer) {
            return this.matches(ver, dbms, dbVer, dbVer);
        }

        public boolean matches(@Nullable Version ver, @Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo) {
            if (this.ideFrom != null && IDE_VERSION.less(this.ideFrom)) {
                return false;
            }
            if (this.ideTo != null && IDE_VERSION.isOrGreater(this.ideTo)) {
                return false;
            }
            if (ver != null && this.from != null && ver.less(this.from)) {
                return false;
            }
            if (ver != null && this.to != null && ver.isOrGreater(this.to)) {
                return false;
            }
            if (dbms != null && this.dbms != null && this.dbms != dbms) {
                return false;
            }
            if (dbFrom != null && this.dbFrom != null && dbFrom.less(this.dbFrom)) {
                return false;
            }
            return dbTo == null || this.dbTo == null || !dbTo.isOrGreater(this.dbTo);
        }
    }

    public static final class Channel
    implements VersionRef {
        public final String id;
        @NlsSafe
        public final String name;
        public final boolean implicit;
        public final Map<String, Version> heads;

        public Channel(@NotNull String id, @NotNull String name, boolean implicit) {
            if (id == null) {
                Channel.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Channel.$$$reportNull$$$0(1);
            }
            this.id = id;
            this.name = name;
            this.implicit = implicit;
            this.heads = new LinkedHashMap<String, Version>();
        }

        private void addHead(@NotNull String artifactId, @NotNull Version version) {
            Version prev;
            if (artifactId == null) {
                Channel.$$$reportNull$$$0(2);
            }
            if (version == null) {
                Channel.$$$reportNull$$$0(3);
            }
            if ((prev = this.heads.get(artifactId)) == null || prev.less(version)) {
                this.heads.put(artifactId, version);
            }
        }

        public boolean contains(@NotNull ArtifactVersion version) {
            if (version == null) {
                Channel.$$$reportNull$$$0(4);
            }
            Version head = this.getHead(version.artifact.id);
            return head.isOrGreater(version.version);
        }

        public boolean isEnabledFor(@NotNull Artifact artifact) {
            if (artifact == null) {
                Channel.$$$reportNull$$$0(5);
            }
            return !this.implicit || this.heads.containsKey(artifact.id);
        }

        private Version getHead(String artifactId) {
            return this.heads.getOrDefault(artifactId, this.implicit ? null : Version.INFINITY);
        }

        @Nullable
        public ArtifactVersion getLatest(@NotNull Artifact artifact, @Nullable Condition<? super ArtifactVersion> filter2) {
            Version head;
            if (artifact == null) {
                Channel.$$$reportNull$$$0(6);
            }
            return (head = this.getHead(artifact.id)) == null ? null : (ArtifactVersion)ContainerUtil.find(artifact.versions, v -> head.isOrGreater(v.version) && (filter2 == null || filter2.value(v)));
        }

        @Override
        public String getVersionDisplayName() {
            return this.name;
        }

        public String toString() {
            return "Channel: " + this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Channel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addHead";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledFor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLatest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ArtifactVersion
    implements Comparable<ArtifactVersion>,
    VersionRef {
        public final Artifact artifact;
        public final Version version;
        public final List<Item> items;
        public final String source;

        public ArtifactVersion(@NotNull Artifact artifact, @NotNull Version version, @NotNull List<Item> items2, @Nullable String source) {
            if (artifact == null) {
                ArtifactVersion.$$$reportNull$$$0(0);
            }
            if (version == null) {
                ArtifactVersion.$$$reportNull$$$0(1);
            }
            if (items2 == null) {
                ArtifactVersion.$$$reportNull$$$0(2);
            }
            this.artifact = artifact;
            this.version = version;
            this.items = items2;
            this.source = source;
        }

        @Override
        public int compareTo(@NotNull ArtifactVersion o) {
            if (o == null) {
                ArtifactVersion.$$$reportNull$$$0(3);
            }
            return o.version.compareTo(this.version);
        }

        public boolean matches(@Nullable Dbms dbms, @Nullable Version version) {
            return this.matches(dbms, version, version);
        }

        public boolean matches(@Nullable Dbms dbms, @Nullable Version dbFrom, @Nullable Version dbTo) {
            Constraint constraint = (Constraint)ContainerUtil.find(this.artifact.constraints, c2 -> c2.matches(null, null, null, null));
            if (constraint == null) {
                return true;
            }
            constraint = (Constraint)ContainerUtil.find(this.artifact.constraints, c2 -> c2.matches(this.version, null, null, null));
            if (constraint == null) {
                return true;
            }
            constraint = (Constraint)ContainerUtil.find(this.artifact.constraints, c2 -> c2.matches(this.version, dbms, null, null));
            if (constraint == null) {
                return true;
            }
            constraint = (Constraint)ContainerUtil.find(this.artifact.constraints, c2 -> c2.matches(this.version, dbms, dbFrom, dbTo));
            return constraint != null;
        }

        @Override
        @NlsSafe
        public String getVersionDisplayName() {
            String verS = this.version.toString();
            return this.source == null ? verS : verS + " (" + this.source + ")";
        }

        public String toString() {
            return this.artifact.name + ":" + this.version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$ArtifactVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface VersionRef {
        @Nls
        public String getVersionDisplayName();
    }

    public static final class Artifact {
        @NonNls
        public final String id;
        @NlsSafe
        public final String name;
        public final SortedSet<ArtifactVersion> versions;
        public final List<Constraint> constraints;
        final Set<String> names;

        public Artifact(@NotNull String id, @NotNull String name) {
            if (id == null) {
                Artifact.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Artifact.$$$reportNull$$$0(1);
            }
            this.names = new HashSet<String>();
            this.id = id;
            this.name = name;
            this.versions = new TreeSet<ArtifactVersion>();
            this.constraints = new ArrayList<Constraint>();
            this.names.add(id);
            this.names.add(name);
        }

        @Nullable
        public ArtifactVersion get(@NotNull Version version) {
            if (version == null) {
                Artifact.$$$reportNull$$$0(2);
            }
            return (ArtifactVersion)ContainerUtil.find(this.versions, v -> v.version.equals(version));
        }

        public String toString() {
            return this.name;
        }

        public boolean isId(String id) {
            return this.names.contains(id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Artifact";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Item {
        private final DatabaseArtifactList list;
        public final String name;
        public final String url;
        public final OS os;
        public final Type type;
        public volatile Pair<List<File>, Boolean> classpath;

        public Item(@NotNull DatabaseArtifactList list, @NotNull String name, @NotNull String url, @NotNull OS os, @NotNull Type type) {
            if (list == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Item.$$$reportNull$$$0(1);
            }
            if (url == null) {
                Item.$$$reportNull$$$0(2);
            }
            if (os == null) {
                Item.$$$reportNull$$$0(3);
            }
            if (type == null) {
                Item.$$$reportNull$$$0(4);
            }
            this.list = list;
            this.name = name;
            this.url = url;
            this.os = os;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }

        @Nullable
        public List<File> getClassPath(ArtifactVersion ver, File dir) {
            return (List)this.getClassPathState((ArtifactVersion)ver, (File)dir).first;
        }

        @NotNull
        private Pair<List<File>, Boolean> getClassPathState(ArtifactVersion ver, File dir) {
            Pair<List<File>, Boolean> cp = this.classpath;
            if (cp != null) {
                Pair<List<File>, Boolean> pair = cp;
                if (pair == null) {
                    Item.$$$reportNull$$$0(5);
                }
                return pair;
            }
            Pair<List<File>, Boolean> newClasspath = this.resolveClassPath(ver, dir);
            this.classpath = newClasspath;
            Pair<List<File>, Boolean> pair = newClasspath;
            if (pair == null) {
                Item.$$$reportNull$$$0(6);
            }
            return pair;
        }

        @NotNull
        private Pair<List<File>, Boolean> resolveClassPath(ArtifactVersion ver, File dir) {
            if (this.type == Type.JAR) {
                Pair pair = Pair.create(Collections.singletonList(new File(dir, this.name)), (Object)true);
                if (pair == null) {
                    Item.$$$reportNull$$$0(7);
                }
                return pair;
            }
            if (this.type == Type.PACK) {
                File root2 = DatabaseArtifactList.unpackZipIfNeeded(dir, ver, this);
                List files2 = JBIterable.of((Object[])(root2 == null ? null : root2.listFiles())).filter(f -> StringUtil.endsWithIgnoreCase((String)f.getName(), (String)".jar")).toList();
                Pair pair = Pair.create((Object)files2, (Object)true);
                if (pair == null) {
                    Item.$$$reportNull$$$0(8);
                }
                return pair;
            }
            if (this.type == Type.MAVEN) {
                Pair pair;
                try {
                    pair = Pair.create(new ArrayList<File>(this.list.resolveMavenItem(dir, this, false)), (Object)true);
                }
                catch (ArtifactResolutionException ignore) {
                    Pair pair2 = Pair.create(Collections.emptyList(), (Object)false);
                    if (pair2 == null) {
                        Item.$$$reportNull$$$0(10);
                    }
                    return pair2;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    Pair pair3 = Pair.create(Collections.emptyList(), (Object)false);
                    if (pair3 == null) {
                        Item.$$$reportNull$$$0(11);
                    }
                    return pair3;
                }
                if (pair == null) {
                    Item.$$$reportNull$$$0(9);
                }
                return pair;
            }
            Pair pair = Pair.create(Collections.emptyList(), (Object)true);
            if (pair == null) {
                Item.$$$reportNull$$$0(12);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseArtifactList$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseArtifactList$Item";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassPathState";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveClassPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Type {
            JAR,
            PACK,
            NATIVE,
            LICENSE,
            MAVEN,
            NONE;

        }

        public static enum OS {
            ANY(true),
            LINUX(SystemInfo.isLinux),
            MAC(SystemInfo.isMac),
            WIN(SystemInfo.isWindows);

            public final boolean applicable;

            private OS(boolean applicable) {
                this.applicable = applicable;
            }
        }
    }
}

