/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ComparePredicateOperation;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.JdbcPlaceholder;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.ObjectPredicateValue;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.PredicatesUtilKt;
import com.intellij.database.data.types.PredicatesUtilKt$WhenMappings;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import java.text.ParseException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001aN\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0010\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u0015\u001a\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\b\u001a \u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#\u001a2\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0015\u001a\u001a\u0010'\u001a\u00020!2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150)\u001a\u001c\u0010*\u001a\u00020\u0003*\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020\b\u001a\f\u0010+\u001a\u0004\u0018\u00010,*\u00020\b\u001a\n\u0010-\u001a\u00020.*\u00020\b\u001a\f\u0010/\u001a\u0004\u0018\u000100*\u00020\b\u001a,\u0010\t\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"formatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "composeWhereItem", "Lcom/intellij/database/util/DdlBuilder;", "builder", "dbms", "Lcom/intellij/database/Dbms;", "column", "Lcom/intellij/database/data/types/ColumnRef;", "value", "Lcom/intellij/database/data/types/PredicateValue;", "decorator", "Lcom/intellij/database/util/DbImplUtilCore$StringLiteralDecorator;", "likeWord", "", "alias", "op", "Lcom/intellij/database/data/types/ComparePredicateOperation;", "defaultEqualsPredicate", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "quote", "", "defaultLikePredicate", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "Lcom/intellij/database/data/types/LikePredicateOperation;", "version", "Lcom/intellij/database/util/Version;", "inUpdate", "getDescriptor", "Lcom/intellij/database/datagrid/mutating/ColumnDescriptor;", "columnRef", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "logicType", "Lcom/intellij/database/data/types/LogicalType;", "getLikeKeyword", "matchCase", "isNotLike", "simpleFormat", "test", "Lkotlin/Function1;", "identifier", "toBasicColumn", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "toConsumerColumn", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "toDasColumn", "Lcom/intellij/database/model/DasColumn;", "intellij.database.core.impl"})
public final class PredicatesUtilKt {
    private static final ObjectFormatter formatter = new ObjectFormatter();

    @NotNull
    public static final PredicatesHelper.PredicateProducer defaultEqualsPredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value2, boolean quote, @NotNull Dbms dbms, @Nullable String alias, @NotNull ComparePredicateOperation op) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value2, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(dbms, column2, value2, quote, alias, op){
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ ColumnRef $column;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ boolean $quote;
            final /* synthetic */ String $alias;
            final /* synthetic */ ComparePredicateOperation $op;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.access$composeWhereItem(builder, this.$dbms, this.$column, this.$value, this.$quote ? DbImplUtilCore.StringLiteralDecorator.PLAIN : null, null, this.$alias, this.$op);
            }
            {
                this.$dbms = dbms;
                this.$column = columnRef;
                this.$value = predicateValue;
                this.$quote = bl;
                this.$alias = string;
                this.$op = comparePredicateOperation;
                super(1);
            }
        }));
    }

    @NotNull
    public static final DdlBuilder identifier(@NotNull DdlBuilder $this$identifier, @Nullable String alias, @NotNull ColumnRef columnRef) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$identifier, (String)"$this$identifier");
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        if (columnRef instanceof DasColumnRef) {
            if (alias != null) {
                $this$identifier.alias(alias).symbol(".");
            }
            DdlBuilder ddlBuilder2 = $this$identifier.identifier(((DasColumnRef)columnRef).getCol());
            ddlBuilder = ddlBuilder2;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"this.identifier(columnRef.col)");
        } else if (columnRef instanceof ConsumerColumnRef && DbImplUtilCore.isRowId(((ConsumerColumnRef)columnRef).getCol())) {
            DdlBuilder ddlBuilder3 = $this$identifier.plain(columnRef.getName());
            ddlBuilder = ddlBuilder3;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder3, (String)"this.plain(columnRef.name)");
        } else {
            if (alias != null) {
                $this$identifier.alias(alias).symbol(".");
            }
            DdlBuilder ddlBuilder4 = $this$identifier.identifier(columnRef.getName());
            ddlBuilder = ddlBuilder4;
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder4, (String)"this.identifier(columnRef.name)");
        }
        return ddlBuilder;
    }

    private static final DdlBuilder composeWhereItem(DdlBuilder builder, Dbms dbms, ColumnRef column2, PredicateValue value2, DbImplUtilCore.StringLiteralDecorator decorator, String likeWord, String alias, ComparePredicateOperation op) {
        PredicatesUtilKt.identifier(builder, alias, column2).space();
        PredicateValue predicateValue = value2;
        if (Intrinsics.areEqual((Object)predicateValue, (Object)NullPredicateValue.INSTANCE)) {
            ComparePredicateOperation comparePredicateOperation = op;
            if (comparePredicateOperation instanceof EqualsPredicateOperation) {
                builder.keywords("IS", "NULL");
            } else if (comparePredicateOperation instanceof NotEqualsPredicateOperation) {
                builder.keywords("IS", "NOT", "NULL");
            }
        } else {
            if (likeWord != null) {
                builder.keyword(likeWord).space();
            } else {
                builder.symbol(op.getOperator()).space();
            }
            PredicatesUtilKt.value(builder, value2, column2, dbms, decorator);
        }
        return builder;
    }

    @NotNull
    public static final DdlBuilder value(@NotNull DdlBuilder $this$value, @NotNull PredicateValue value2, @NotNull ColumnRef columnRef, @NotNull Dbms dbms, @Nullable DbImplUtilCore.StringLiteralDecorator decorator) {
        block5: {
            PredicateValue predicateValue;
            block7: {
                block6: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)$this$value, (String)"$this$value");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
                        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
                        predicateValue = value2;
                        if (!Intrinsics.areEqual((Object)predicateValue, (Object)JdbcPlaceholder.INSTANCE)) break block4;
                        $this$value.placeholder();
                        if (decorator == null || decorator == DbImplUtilCore.StringLiteralDecorator.PLAIN) break block5;
                        boolean supportsEscape = DbImplUtilCore.getJdbcHelper(dbms).supportsEscape();
                        DbSqlUtilCore.SqlRegexDecorator sqlRegexDecorator = supportsEscape ? DbSqlUtilCore.SqlRegexDecorator.WITH_ESCAPE_CLAUSE : DbSqlUtilCore.SqlRegexDecorator.DEFAULT;
                        $this$value.plain(sqlRegexDecorator.getTail(dbms));
                        break block5;
                    }
                    if (!(predicateValue instanceof CustomPlaceholder)) break block6;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$value.plain(((CustomPlaceholder)value2).getPlaceholder()), (String)"this.plain(value.placeholder)");
                    break block5;
                }
                if (!(predicateValue instanceof StringPredicateValue)) break block7;
                Object object = decorator;
                if (object == null || (object = object.decorate(((StringPredicateValue)value2).getStr(), dbms)) == null) {
                    object = ((StringPredicateValue)value2).getStr();
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$value.literal((String)object), (String)"this.literal(decorator?.\u2026.str, dbms) ?: value.str)");
                break block5;
            }
            if (!(predicateValue instanceof ObjectPredicateValue)) break block5;
            String literal = formatter.getValueLiteral(((ObjectPredicateValue)value2).getO(), PredicatesUtilKt.toConsumerColumn(columnRef), dbms, PredicatesHelperKt.predicatesHelper(dbms).getMode());
            if (literal == null) {
                $this$value.literal("null");
            } else {
                Object object = decorator;
                if (object == null || (object = object.decorate(literal, dbms)) == null) {
                    object = literal;
                }
                $this$value.literal((String)object);
            }
        }
        return $this$value;
    }

    @Nullable
    public static final PredicatesHelper.PredicateProducer defaultLikePredicate(@NotNull ColumnRef column2, @NotNull PredicateValue value2, @Nullable Domain domain, @NotNull LikePredicateOperation op, @NotNull Dbms dbms, @Nullable Version version, @Nullable String alias, boolean inUpdate) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        if (domain != null && !domain.supports(OperationKt.LIKE_OPERATION)) {
            return null;
        }
        if (!(domain != null || column2 instanceof ConsumerColumnRef && JdbcUtil.isStringType(((ConsumerColumnRef)column2).getCol().type))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)value2, (Object)NullPredicateValue.INSTANCE) || value2 instanceof ObjectPredicateValue) {
            return null;
        }
        String string = PredicatesUtilKt.getLikeKeyword(op.getMatchCase(), op.isNotLike(), dbms, version, inUpdate);
        if (string == null) {
            return null;
        }
        String likeWord = string;
        return new PredicatesHelper.PredicateProducer(CollectionsKt.listOf((Object)column2), value2, (Function1<? super DdlBuilder, Unit>)((Function1)new Function1<DdlBuilder, Unit>(dbms, column2, value2, op, likeWord, alias){
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ ColumnRef $column;
            final /* synthetic */ PredicateValue $value;
            final /* synthetic */ LikePredicateOperation $op;
            final /* synthetic */ String $likeWord;
            final /* synthetic */ String $alias;

            public final void invoke(@NotNull DdlBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                PredicatesUtilKt.access$composeWhereItem(builder, this.$dbms, this.$column, this.$value, this.$op.getLikeType().getDecorator(), this.$likeWord, this.$alias, new EqualsPredicateOperation(null, 1, null));
            }
            {
                this.$dbms = dbms;
                this.$column = columnRef;
                this.$value = predicateValue;
                this.$op = likePredicateOperation;
                this.$likeWord = string;
                this.$alias = string2;
                super(1);
            }
        }));
    }

    @Nullable
    public static final String getLikeKeyword(boolean matchCase, boolean isNotLike, @NotNull Dbms dbms, @Nullable Version version, boolean inUpdate) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        boolean supportsLike = DbImplUtilCore.getDatabaseDialect(dbms).getLikeSupport(version).isSupported(inUpdate);
        if (!matchCase && supportsLike && DbImplUtilCore.getJdbcHelper(dbms).supportsIlike()) {
            string = "ILIKE";
        } else if (supportsLike) {
            string = "LIKE";
        } else {
            return null;
        }
        String like = string;
        return isNotLike ? "NOT " + like : like;
    }

    @NotNull
    public static final DataConsumer.Column toConsumerColumn(@NotNull ColumnRef $this$toConsumerColumn) {
        DataConsumer.Column column2;
        Intrinsics.checkNotNullParameter((Object)$this$toConsumerColumn, (String)"$this$toConsumerColumn");
        ColumnRef columnRef = $this$toConsumerColumn;
        if (columnRef instanceof ConsumerColumnRef) {
            column2 = ((ConsumerColumnRef)$this$toConsumerColumn).getCol();
        } else if (columnRef instanceof DasColumnRef) {
            DasColumn column3 = ((DasColumnRef)$this$toConsumerColumn).getCol();
            short s2 = column3.getPosition();
            String string = column3.getName();
            String string2 = column3.getDataType().typeName;
            DataType dataType = column3.getDataType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"column.dataType");
            column2 = new DataConsumer.Column(s2, string, 1111, string2, "", dataType.getPrecision(), column3.getDataType().scale, null, null, null);
        } else {
            column2 = new DataConsumer.Column(0, $this$toConsumerColumn.getName(), 1111, $this$toConsumerColumn.getTypeName(), "");
        }
        return column2;
    }

    @Nullable
    public static final DasColumn toDasColumn(@NotNull ColumnRef $this$toDasColumn) {
        Intrinsics.checkNotNullParameter((Object)$this$toDasColumn, (String)"$this$toDasColumn");
        ColumnRef columnRef = $this$toDasColumn;
        return columnRef instanceof ConsumerColumnRef ? DasUtil.findChild(((ConsumerColumnRef)$this$toDasColumn).getTable(), DasColumn.class, ObjectKind.COLUMN, $this$toDasColumn.getName()) : (columnRef instanceof DasColumnRef ? ((DasColumnRef)$this$toDasColumn).getCol() : null);
    }

    @Nullable
    public static final BasicTableOrViewColumn toBasicColumn(@NotNull ColumnRef $this$toBasicColumn) {
        Intrinsics.checkNotNullParameter((Object)$this$toBasicColumn, (String)"$this$toBasicColumn");
        DasColumn dasColumn = PredicatesUtilKt.toDasColumn($this$toBasicColumn);
        Object object = DbImplUtilCore.unwrap(dasColumn);
        if (!(object instanceof BasicTableOrViewColumn)) {
            object = null;
        }
        return (BasicTableOrViewColumn)object;
    }

    @Nullable
    public static final ColumnDescriptor getDescriptor(@NotNull ColumnRef columnRef) {
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        ColumnRef columnRef2 = columnRef;
        return columnRef2 instanceof DasColumnRef ? (ColumnDescriptor)new TypeNameColumnDescriptor(((DasColumnRef)columnRef).getCol().getDataType().typeName) : (columnRef2 instanceof ConsumerColumnRef ? (ColumnDescriptor)((ConsumerColumnRef)columnRef).getCol() : null);
    }

    @NotNull
    public static final FormatTester simpleFormat(@NotNull Function1<? super String, Boolean> test) {
        Intrinsics.checkNotNullParameter(test, (String)"test");
        return new FormatTester(true, false, (Function1)new Function1<String, FormatTestResult>(test){
            final /* synthetic */ Function1 $test;

            @NotNull
            public final FormatTestResult invoke(@NotNull String it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return (Boolean)this.$test.invoke((Object)it2) != false ? FormatTestResult.QUOTE : FormatTestResult.NOT_MATCHED;
            }
            {
                this.$test = function1;
                super(1);
            }
        }, 2, null);
    }

    @Nullable
    public static final FormatTester getFormatTester(@NotNull ColumnRef columnRef, @NotNull Dbms dbms, @NotNull LogicalType logicType) {
        Formatter formatter;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)((Object)logicType), (String)"logicType");
        DataConsumer.Column column2 = PredicatesUtilKt.toConsumerColumn(columnRef);
        if (column2 == null) {
            return null;
        }
        DataConsumer.Column col = column2;
        switch (PredicatesUtilKt$WhenMappings.$EnumSwitchMapping$0[logicType.ordinal()]) {
            case 1: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)getFormatTester.1.INSTANCE));
            }
            case 2: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)getFormatTester.2.INSTANCE));
            }
            case 3: {
                return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)getFormatTester.3.INSTANCE));
            }
        }
        switch (PredicatesUtilKt$WhenMappings.$EnumSwitchMapping$1[logicType.ordinal()]) {
            case 1: {
                formatter = PredicatesUtilKt.formatter.getZonedTimeFormat(col, dbms);
                break;
            }
            case 2: {
                formatter = PredicatesUtilKt.formatter.getZonedTimestampFormat(col, dbms);
                break;
            }
            case 3: {
                formatter = PredicatesUtilKt.formatter.getTimestampFormat(col, dbms);
                break;
            }
            case 4: {
                formatter = PredicatesUtilKt.formatter.getTimeFormat();
                break;
            }
            case 5: {
                formatter = PredicatesUtilKt.formatter.getDateFormat(col, dbms);
                break;
            }
            default: {
                formatter = null;
            }
        }
        if (formatter == null) {
            return null;
        }
        Formatter format = formatter;
        return PredicatesUtilKt.simpleFormat((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(format){
            final /* synthetic */ Formatter $format;

            public final boolean invoke(@NotNull String it2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                try {
                    bl = this.$format.parse(it2) != null;
                }
                catch (ParseException ignored) {
                    bl = false;
                }
                return bl;
            }
            {
                this.$format = formatter;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ DdlBuilder access$composeWhereItem(DdlBuilder builder, Dbms dbms, ColumnRef column2, PredicateValue value2, DbImplUtilCore.StringLiteralDecorator decorator, String likeWord, String alias, ComparePredicateOperation op) {
        return PredicatesUtilKt.composeWhereItem(builder, dbms, column2, value2, decorator, likeWord, alias, op);
    }
}

