/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.mysql;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.MysqlConfigurationBase;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CommonMysqlArguments;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.restore.mysql.MysqlArguments;
import com.intellij.database.cli.restore.mysql.MysqlArgumentsGroup;
import com.intellij.database.cli.restore.mysql.MysqlCliArguments;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlConfiguration
extends MysqlConfigurationBase {
    public static final MysqlConfiguration INSTANCE = new MysqlConfiguration();

    private MysqlConfiguration() {
        super(MysqlArgumentsGroup.values(), DbCliUtil.INPUT, "MYSQL_RESTORE_KEY", "mysql");
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        return "mysql";
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + File.separator + "mysql";
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        return new SimpleCliDialogValidator(DbCliUtil.INPUT, CommonMysqlArguments.PASSWORD);
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().onlyIfSingleElement((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().filter((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource || e.getKind() == ObjectKind.SCHEMA)).requireNotEmpty().onlyIfMoreThanOnce(DasUtil.byKind(ObjectKind.SCHEMA)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().finish();
        if (databaseObjectsPreparer == null) {
            MysqlConfiguration.$$$reportNull$$$0(0);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    protected StringCliArgument getDatabaseArgument() {
        StringCliArgument stringCliArgument = MysqlCliArguments.DATABASE;
        if (stringCliArgument == null) {
            MysqlConfiguration.$$$reportNull$$$0(1);
        }
        return stringCliArgument;
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map2 = super.getInfoMap();
        MysqlConfiguration.put(map2, "Only allow UPDATE and DELETE that uses keys", MysqlArguments.SAFE_UPDATES);
        MysqlConfiguration.put(map2, "Enable clear text auth plugin", MysqlArguments.ENABLE_CLEARTEXT_PLUGIN);
        MysqlConfiguration.put(map2, "Vertical output on narrow terminal", MysqlArguments.AUTO_VERTICAL_OUTPUT);
        MysqlConfiguration.put(map2, "Don't write errors line numbers", MysqlArguments.SKIP_LINE_NUMBERS);
        MysqlConfiguration.put(map2, "Don't write column names", MysqlArguments.SKIP_COLUMN_NAMES);
        MysqlConfiguration.put(map2, "Disable auto rehashing", MysqlArguments.DISABLE_AUTO_REHASH);
        MysqlConfiguration.put(map2, "Disable auto rehashing", MysqlArguments.NO_AUTO_REHASH);
        MysqlConfiguration.put(map2, "Enable named commands", MysqlArguments.NAMED_COMMANDS);
        MysqlConfiguration.put(map2, "Display column type info", MysqlArguments.COLUMN_TYPE_INFO);
        MysqlConfiguration.put(map2, "Ignore space after function name", MysqlArguments.IGNORE_SPACES);
        MysqlConfiguration.put(map2, "Ignore non-default database statements", MysqlArguments.ONE_DATABASE);
        MysqlConfiguration.put(map2, "Print program arguments", MysqlArguments.PRINT_DEFAULTS);
        MysqlConfiguration.put(map2, "Print debug info", MysqlArguments.DEBUG_INFO);
        MysqlConfiguration.put(map2, "Ignore SIGINT", MysqlArguments.SIGINT_IGNORE);
        MysqlConfiguration.put(map2, "Flush after each query", MysqlArguments.UNBUFFERED);
        MysqlConfiguration.put(map2, "Show warnings after each query", MysqlArguments.SHOW_WARNINGS);
        MysqlConfiguration.put(map2, "Line numbers for errors", MysqlArguments.LINE_NUMBERS);
        MysqlConfiguration.put(map2, "Print column names", MysqlArguments.COLUMN_NAMES);
        MysqlConfiguration.put(map2, "Enable LOAD DATA LOCAL INFILE", MysqlArguments.LOCAL_INFILE);
        MysqlConfiguration.put(map2, "Ignore option files", MysqlArguments.NO_DEFAULTS);
        MysqlConfiguration.put(map2, "Disallows old protocol usage", MysqlArguments.SECURE_AUTH);
        MysqlConfiguration.put(map2, "Turns on binary parsing mode", MysqlArguments.BINARY_MODE);
        MysqlConfiguration.put(map2, "Preserve comments", MysqlArguments.COMMENTS);
        MysqlConfiguration.put(map2, "Enable auto rehashing", MysqlArguments.AUTO_REHASH);
        MysqlConfiguration.put(map2, "Use compression", MysqlArguments.COMPRESS);
        MysqlConfiguration.put(map2, "Print debug info on exit", MysqlArguments.DEBUG_CHECK);
        MysqlConfiguration.put(map2, "Database name", MysqlArguments.DATABASE);
        MysqlConfiguration.put(map2, "Print query output vertically", MysqlArguments.VERTICAL);
        MysqlConfiguration.put(map2, "Show help", MysqlArguments.HELP);
        MysqlConfiguration.put(map2, "Turn off beep on error", MysqlArguments.NO_BEEP);
        MysqlConfiguration.put(map2, "Log filtered commands to syslog", MysqlArguments.SYSLOG);
        MysqlConfiguration.put(map2, "Reconnect on connection lost", MysqlArguments.RECONNECT);
        MysqlConfiguration.put(map2, "Silent mode", MysqlArguments.SILENT);
        MysqlConfiguration.put(map2, "Output in table format", MysqlArguments.TABLE);
        MysqlConfiguration.put(map2, "Don't use history file", MysqlArguments.BATCH);
        MysqlConfiguration.put(map2, "Debug mode", MysqlArguments.DEBUG);
        MysqlConfiguration.put(map2, "Continue on SQL error", MysqlArguments.FORCE);
        MysqlConfiguration.put(map2, "Don't cache result", MysqlArguments.QUICK);
        MysqlConfiguration.put(map2, "HTML output", MysqlArguments.HTML);
        MysqlConfiguration.put(map2, "Wait and retry if connection is down", MysqlArguments.WAIT);
        MysqlConfiguration.put(map2, "XML output", MysqlArguments.XML);
        MysqlConfiguration.put(map2, "Write fields without conversion", MysqlArguments.RAW);
        MysqlConfiguration.put(map2, "Ready to handle expired password", MysqlArguments.CONNECT_EXPIRED_PASSWORD);
        MysqlConfiguration.put(map2, "Read groups with concat group and suffix", MysqlArguments.DEFAULTS_GROUP_SUFFIX);
        MysqlConfiguration.put(map2, "Default charset name", MysqlArguments.DEFAULT_CHARACTER_SET);
        MysqlConfiguration.put(map2, "Read this file after global files", MysqlArguments.DEFAULTS_EXTRA_FILE);
        MysqlConfiguration.put(map2, "Public RSA key path", MysqlArguments.PUBLIC_KEY_PATH);
        MysqlConfiguration.put(map2, "Charset files directory", MysqlArguments.CHARACTER_SETS_DIR);
        MysqlConfiguration.put(map2, "Connection timeout in seconds", MysqlArguments.CONNECT_TIMEOUT);
        MysqlConfiguration.put(map2, "Default options file", MysqlArguments.DEFAULTS_FILE);
        MysqlConfiguration.put(map2, "JOIN row count limit", MysqlArguments.MAX_JOIN_SIZE);
        MysqlConfiguration.put(map2, "IP address to bind to", MysqlArguments.BIND_ADDRESS);
        MysqlConfiguration.put(map2, "SQL to execute when connecting", MysqlArguments.INIT_COMMAND);
        MysqlConfiguration.put(map2, "Client-side auth plugin", MysqlArguments.DEFAULT_AUTH);
        MysqlConfiguration.put(map2, "SELECT row count limit", MysqlArguments.SELECT_LIMIT);
        MysqlConfiguration.put(map2, "Parameter for server", MysqlArguments.SERVER_ARG);
        MysqlConfiguration.put(map2, "Path to read from the login file", MysqlArguments.LOGIN_PATH);
        MysqlConfiguration.put(map2, "Command to execute", MysqlArguments.EXECUTE);
        MysqlConfiguration.put(map2, "Delimiter to use", MysqlArguments.DELIMITER);
        MysqlConfiguration.put(map2, "Socket file", MysqlArguments.SOCKET);
        MysqlConfiguration.put(map2, "Connection protocol to use", MysqlArguments.PROTOCOL);
        MysqlConfiguration.put(map2, "Mysql prompt value", MysqlArguments.PROMPT);
        MysqlConfiguration.put(map2, "Pager to use", MysqlArguments.PAGER);
        MysqlConfiguration.put(map2, "Append everything into outfile", MysqlArguments.TEE);
        MysqlConfiguration.put(map2, "Disable named commands", "--disable-named-commands");
        MysqlConfiguration.put(map2, "Disable pager", "--disable-pager");
        MysqlConfiguration.put(map2, "Disable reconnect", "--disable-reconnect");
        MysqlConfiguration.put(map2, "Disable tee option", "--disable-tee");
        MysqlConfiguration.put(map2, "Disable auto rehash", "--skip-auto-rehash");
        MysqlConfiguration.put(map2, "Disable comments", "--skip-comments");
        MysqlConfiguration.put(map2, "Disable reconnect", "--skip-reconnect");
        MysqlConfiguration.put(map2, "Statements to ignore for logging", MysqlArguments.HISTIGNORE);
        Map<String, String> map3 = map2;
        if (map3 == null) {
            MysqlConfiguration.$$$reportNull$$$0(2);
        }
        return map3;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.concat(Arrays.asList("-e", "-S"), super.getParameterizableArguments());
        if (list == null) {
            MysqlConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            MysqlConfiguration.$$$reportNull$$$0(4);
        }
        return new MyBuilder(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName(), DbCliUtil.INPUT);
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.RESTORE;
        if (operation == null) {
            MysqlConfiguration.$$$reportNull$$$0(5);
        }
        return operation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNotificationManager
    extends CliConfigurationBase.CliNotificationManagerBase {
        private final String myFile;

        MyNotificationManager(@NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String file) {
            if (project == null) {
                MyNotificationManager.$$$reportNull$$$0(0);
            }
            if (operation == null) {
                MyNotificationManager.$$$reportNull$$$0(1);
            }
            if (name == null) {
                MyNotificationManager.$$$reportNull$$$0(2);
            }
            if (file == null) {
                MyNotificationManager.$$$reportNull$$$0(3);
            }
            super(project, operation, name);
            this.myFile = file;
        }

        @Override
        @NlsSafe
        @NotNull
        protected String getCommandText(@NotNull String text2) {
            if (text2 == null) {
                MyNotificationManager.$$$reportNull$$$0(4);
            }
            String string = StringUtil.trim((String)text2) + " < " + this.myFile;
            if (string == null) {
                MyNotificationManager.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyNotificationManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyNotificationManager";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommandText";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyBuilder
    extends CliConfigurationBase.CliBuilderBase {
        private final String[] myFileArgs;
        private String myFile;

        MyBuilder(@NotNull CliConfiguration.CliParameterProcessor processor2, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName, @NotNull String[] fileArgs) {
            if (processor2 == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            if (operation == null) {
                MyBuilder.$$$reportNull$$$0(2);
            }
            if (name == null) {
                MyBuilder.$$$reportNull$$$0(3);
            }
            if (envName == null) {
                MyBuilder.$$$reportNull$$$0(4);
            }
            if (fileArgs == null) {
                MyBuilder.$$$reportNull$$$0(5);
            }
            super(processor2, project, operation, name, envName, null);
            this.myFileArgs = fileArgs;
        }

        @Override
        @NotNull
        public Pair<GeneralCommandLine, String> build(@NotNull LocalDataSource dataSource2, @NotNull List<String> parameterizable, @NotNull String command, @Nullable String password) {
            if (dataSource2 == null) {
                MyBuilder.$$$reportNull$$$0(6);
            }
            if (parameterizable == null) {
                MyBuilder.$$$reportNull$$$0(7);
            }
            if (command == null) {
                MyBuilder.$$$reportNull$$$0(8);
            }
            String value2 = Objects.requireNonNull(DbCliUtil.getArgumentValue(command, parameterizable, this.myFileArgs));
            this.myFile = DbCliUtil.clearString(value2, StringUtil::unquoteString);
            LexemeIndicators fileIndicators = new LexemeIndicators(this.myFileArgs);
            String withoutFile = DbCliUtil.getCommandWithout(command, fileIndicators);
            Pair<GeneralCommandLine, String> line = super.build(dataSource2, parameterizable, withoutFile, password);
            Pair pair = Pair.create((Object)((GeneralCommandLine)line.first).withInput(new File(this.myFile)), (Object)((String)line.second));
            if (pair == null) {
                MyBuilder.$$$reportNull$$$0(9);
            }
            return pair;
        }

        @Override
        @NotNull
        public CliConfiguration.CliNotificationManager getNotificationManager() {
            return new MyNotificationManager(this.myProject, this.myOperation, this.myName, this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileArgs";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/restore/mysql/MysqlConfiguration$MyBuilder";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

