/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliProperties
implements Disposable {
    private static final String PATH = "_PATH";
    private static final String COMMAND = "_COMMAND";
    private static final String EXPANDED = "_EXPANDED";
    private static final String VARIANTS = "_VARIANTS_";
    private static final String LAST_USED_CONFIGURATION = "_LAST_USED_CONFIGURATION";
    private final ThreadPoolExecutor myExecutor;
    private final CliConfiguration myConfiguration;
    private final CliModel myModel;

    CliProperties(@NotNull CliConfiguration configuration, @NotNull CliModel model) {
        if (configuration == null) {
            CliProperties.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CliProperties.$$$reportNull$$$0(1);
        }
        this.myConfiguration = configuration;
        this.myModel = model;
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Cli database tool help parser");
    }

    public void store() {
        String key = this.myConfiguration.getPropertyKey();
        PropertiesComponent component = PropertiesComponent.getInstance();
        component.setValue(key + PATH, this.myModel.getPathToExecutable());
        component.setValue(key + COMMAND, this.myModel.getCommand());
        component.setValue(key + EXPANDED, String.valueOf(this.myModel.isExpanded()));
    }

    public void restore() {
        String key = this.myConfiguration.getPropertyKey();
        PropertiesComponent component = PropertiesComponent.getInstance();
        String path = component.getValue(key + PATH);
        String command = component.getValue(key + COMMAND);
        String expanded = component.getValue(key + EXPANDED);
        if (path != null) {
            this.myModel.setPathToExecutable(path);
        }
        if (command != null) {
            this.myModel.setCommand(command);
        }
        this.myModel.setExpanded(expanded != null ? Boolean.valueOf(expanded) : true);
    }

    public void storeVariants() {
        CliConfiguration configuration = this.myModel.getConfiguration();
        String key = configuration.getPropertyKey();
        String path = this.myModel.getPathToExecutable();
        File file = new File(path);
        if (!(file.exists() && file.isFile() && Files.isExecutable(Paths.get(path, new String[0])))) {
            this.myModel.setVariants(new ArrayList<String>());
            return;
        }
        int hash = FileUtil.fileHashCode((File)file);
        PropertiesComponent component = PropertiesComponent.getInstance();
        String value2 = component.getValue(key + VARIANTS + hash);
        if (value2 == null) {
            this.myExecutor.execute(new MyVariantsTask(this.myModel, path, configuration.getHelpCommand(), hash));
            return;
        }
        this.myModel.setVariants(StringUtil.split((String)value2, (String)" "));
    }

    public void dispose() {
        this.myExecutor.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutor.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void storeLastUsedConfiguration(@NotNull CliConfigurationPack pack, @NotNull CliConfiguration configuration) {
        if (pack == null) {
            CliProperties.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            CliProperties.$$$reportNull$$$0(3);
        }
        PropertiesComponent component = PropertiesComponent.getInstance();
        component.setValue(pack.getKey() + LAST_USED_CONFIGURATION, configuration.getPropertyKey());
    }

    @Nullable
    public static CliConfiguration getLastUsedConfigurationKey(@NotNull CliConfigurationPack pack) {
        if (pack == null) {
            CliProperties.$$$reportNull$$$0(4);
        }
        PropertiesComponent component = PropertiesComponent.getInstance();
        String configurationKey = component.getValue(pack.getKey() + LAST_USED_CONFIGURATION);
        return (CliConfiguration)ContainerUtil.find(pack.getConfigurations(), c2 -> StringUtil.equals((CharSequence)c2.getPropertyKey(), (CharSequence)configurationKey));
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<String> getVariants(@NotNull String path, @NotNull String helpCommand) {
        String string;
        Process process2;
        if (path == null) {
            CliProperties.$$$reportNull$$$0(5);
        }
        if (helpCommand == null) {
            CliProperties.$$$reportNull$$$0(6);
        }
        if ((process2 = CliProperties.createProcess(path, helpCommand)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CliProperties.$$$reportNull$$$0(7);
            }
            return list;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(process2.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder builder = new StringBuilder();
        while ((string = reader.readLine()) != null) {
            builder.append(string);
        }
        List<String> list = CliProperties.getFromString(builder.toString());
        reader.close();
        List<String> list2 = list;
        if (list2 == null) {
            CliProperties.$$$reportNull$$$0(8);
        }
        return list2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    process2.destroyForcibly();
                    List list3 = ContainerUtil.emptyList();
                    if (list3 == null) {
                        CliProperties.$$$reportNull$$$0(9);
                    }
                    return list3;
                }
            }
        }
    }

    @Nullable
    private static Process createProcess(@NotNull String path, @NotNull String helpCommand) {
        if (path == null) {
            CliProperties.$$$reportNull$$$0(10);
        }
        if (helpCommand == null) {
            CliProperties.$$$reportNull$$$0(11);
        }
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{path, helpCommand});
            return line.createProcess();
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @NotNull
    private static List<String> getFromString(@NotNull String current) {
        if (current == null) {
            CliProperties.$$$reportNull$$$0(12);
        }
        List<CliLexeme> result2 = DbCliUtil.extractArguments(current);
        List<String> list = result2.stream().map(CliLexeme::getText).distinct().collect(Collectors.toList());
        if (list == null) {
            CliProperties.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpCommand";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliProperties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliProperties";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "storeLastUsedConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLastUsedConfigurationKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyVariantsTask
    implements Runnable {
        private final CliModel mySettings;
        private final String myPath;
        private final String myCommand;
        private final int myHash;

        private MyVariantsTask(@NotNull CliModel settings, @NotNull String path, @NotNull String command, int hash) {
            if (settings == null) {
                MyVariantsTask.$$$reportNull$$$0(0);
            }
            if (path == null) {
                MyVariantsTask.$$$reportNull$$$0(1);
            }
            if (command == null) {
                MyVariantsTask.$$$reportNull$$$0(2);
            }
            this.mySettings = settings;
            this.myPath = path;
            this.myCommand = command;
            this.myHash = hash;
        }

        @Override
        public void run() {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            List<String> variants = CliProperties.getVariants(this.myPath, this.myCommand);
            DbUIUtil.invokeLater(() -> {
                properties.setValue(this.mySettings.getConfiguration().getPropertyKey() + CliProperties.VARIANTS + this.myHash, StringUtil.join((Collection)variants, (String)" "));
                this.mySettings.setVariants(variants);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/cli/CliProperties$MyVariantsTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

