/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.ddl;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.Dbms;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.DbObjectEditor;
import com.intellij.database.schemaEditor.DbObjectEditorDialogBase;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOption;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseModifyObjectAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        JBIterable<DbElement> selection;
        DbElement single;
        BasicElement element2;
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(0);
        }
        boolean visible = (element2 = BaseModifyObjectAction.getElement(single = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single())) != null && this.isAcceptable(element2) && BaseModifyObjectAction.canPerformOn(single.getDataSource()) && this.isSupported(element2);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && ImportUtil.canModify(single));
    }

    public static boolean canPerformOn(DbDataSource dataSource2) {
        return DbImplUtilCore.canConnectTo(dataSource2) || dataSource2.getDelegate() instanceof SqlDataSource;
    }

    public boolean isSupported(@NotNull BasicElement e) {
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(1);
        }
        Dbms dbms = DbImplUtilCore.getDbms(e);
        ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e);
        BasicModel model = e.getModel();
        Version version = model == null ? Version.INFINITY : model.getRoot().getServerVersion();
        return this.isSupported(capabilities, version);
    }

    protected abstract boolean isSupported(ScriptingCapabilities var1, Version var2);

    protected boolean isAcceptable(BasicElement e) {
        return true;
    }

    @Contract(value="null->null")
    static BasicElement getElement(DbElement single) {
        BasicElement element2;
        BasicElement basicElement = element2 = single == null ? null : (BasicElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicElement.class);
        if (element2 == null && single != null) {
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)single.getDataSource().getModel(), BasicModel.class);
            element2 = model == null ? null : model.getRoot();
        }
        return element2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JBIterable<DbElement> selection;
        DbElement single;
        BasicElement element2;
        BasicModel model;
        if (e == null) {
            BaseModifyObjectAction.$$$reportNull$$$0(2);
        }
        BasicModel basicModel = model = (element2 = BaseModifyObjectAction.getElement(single = (DbElement)(selection = DatabaseContextFun.getSelectedDbElements(e.getDataContext())).single())) == null ? null : element2.getModel();
        if (model == null) {
            return;
        }
        DbDataSource dataSource2 = single.getDataSource();
        BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(dataSource2, element2), BasicNamespace.class);
        SearchPath searchPath = ObjectPaths.searchPathOf(current);
        DatabaseScriptDialog dialog2 = this.createRefactoringDialog(dataSource2, model, element2, searchPath);
        dialog2.initAndShow();
    }

    @NotNull
    protected abstract DatabaseScriptDialog createRefactoringDialog(@NotNull DbDataSource var1, @NotNull BasicModel var2, @NotNull BasicElement var3, @Nullable SearchPath var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/ddl/BaseModifyObjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static abstract class Dialog
    extends DbObjectEditorDialogBase {
        protected final BasicElement myElement;
        private final BasicModel myModel;
        protected final DbObjectEditorFactory myFactory;
        private final DbObjectEditor myEditor;
        private final BasicModModel myTargetModel;
        private final BasicModElement myTargetElement;

        public Dialog(@NotNull DbDataSource dataSource2, @NotNull BasicModel model, @NotNull BasicElement element2, @Nullable SearchPath searchPath, @NlsContexts.DialogTitle String title) {
            if (dataSource2 == null) {
                Dialog.$$$reportNull$$$0(0);
            }
            if (model == null) {
                Dialog.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                Dialog.$$$reportNull$$$0(2);
            }
            super(dataSource2.getProject(), dataSource2, searchPath, title);
            this.myElement = element2;
            this.myModel = model;
            this.myFactory = DbObjectEditorFactory.forDbms(this.myModel.getDbms());
            this.myEditor = this.createEditor(dataSource2.getProject());
            this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(this.myModel.getDbms());
            this.myTargetElement = this.myFactory.pull(this.myTargetModel, this.myElement, this.myElement.getMetaObject());
            ScriptingCapabilities capabilities = ScriptGenerators.INSTANCE.byModel(model).capabilities(element2);
            Version version = model.getRoot().getServerVersion();
            this.myEditor.enable(p2 -> capabilities.canAlter((BasicMetaPropertyId<?>)p2).get(version));
            this.myEditor.initCompletion(dataSource2, searchPath, ObjectPaths.of(this.myElement));
        }

        @NotNull
        protected abstract DbObjectEditor createEditor(@NotNull Project var1);

        @Override
        protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
            if (handler == null) {
                Dialog.$$$reportNull$$$0(3);
            }
            LoaderContext context = handler.getContext();
            if (this.myTargetElement instanceof BasicMateNamespace && DatabaseSettings.getSettings().trackNamespaces) {
                ObjectPath src = BasicPaths.of(this.myElement);
                ObjectPath tgt = BasicPaths.of(this.myTargetElement);
                context.getScopeUpdater().toRemove(src);
                context.getScopeUpdater().toAdd(tgt);
                context.include(tgt);
            } else {
                context.include(this.myElement);
            }
            super.fillContext(handler);
        }

        @Override
        protected void reset() {
            this.myEditor.reset(this.myElement);
        }

        @Override
        protected void apply() {
            this.myEditor.apply(this.myElement, this.myTargetElement);
        }

        @Override
        protected DbObjectEditor getObjectEditor() {
            return this.myEditor;
        }

        @Override
        protected ScriptingTaskBuilder createBuilder() {
            ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(this.myModel, this.myTargetModel);
            BasicElement e1 = this.myElement;
            for (BasicElement e2 = this.myTargetElement; e1 != null && e2 != null; e1 = e1.getParent(), e2 = e2.getParent()) {
                if (e1.getKind() == ObjectKind.ROOT) continue;
                builder.getCorrespondence().add(ElementDelta.create(e1, e2));
            }
            builder.setOptions(new CustomScriptingOptions((Map<ScriptingOption<?>, ? extends Object>)ImmutableMap.of(ScriptingOptionStatic.USER_GRANTS, (Object)true)));
            return builder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/ddl/BaseModifyObjectAction$Dialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fillContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

