/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolActions {
    @NotNull
    public static JBIterable<PsiElement> getSelectedPsiElements(@NotNull DataContext dataContext) {
        PsiElement element2;
        if (dataContext == null) {
            ToolActions.$$$reportNull$$$0(0);
        }
        if ((element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) instanceof SqlElement) {
            JBIterable jBIterable = SqlPsiFacade.getInstance((Project)element2.getProject()).findRelatedDbElements(element2, true).filter(PsiElement.class);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        if (element2 != null) {
            JBIterable jBIterable = JBIterable.of((Object)element2);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        Object[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            JBIterable jBIterable = JBIterable.of((Object[])elements);
            if (jBIterable == null) {
                ToolActions.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        VirtualFile vfile = file == null ? null : file.getViewProvider().getVirtualFile();
        DbElement fileElement = vfile == null ? null : DbSrcUtilsCore.findDbElement(file.getProject(), vfile.getPath(), DbElement.class);
        JBIterable jBIterable = JBIterable.of(fileElement);
        if (jBIterable == null) {
            ToolActions.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToolActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToolActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPsiElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPsiElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RefreshMatViewAction
    extends ScriptingActionBase {
        public RefreshMatViewAction() {
            super(DatabaseBundle.message("action.DatabaseView.Tools.RefreshMatViewAction.title", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.RefreshMatViewAction.text", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.RefreshMatViewAction.description", new Object[0]), AllIcons.Actions.ForceRefresh);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.REFRESH;
            if (scriptCategory == null) {
                RefreshMatViewAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$RefreshMatViewAction", "getCategory"));
        }
    }

    public static class TruncateTablesAction
    extends ScriptingActionBase {
        public TruncateTablesAction() {
            super(DatabaseBundle.message("action.DatabaseView.Tools.TruncateTableAction.title", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.TruncateTableAction.text", new Object[0]), DatabaseBundle.message("action.DatabaseView.Tools.TruncateTableAction.description", new Object[0]), AllIcons.Actions.GC);
        }

        @Override
        @NotNull
        protected ScriptCategory getCategory() {
            ScriptCategory scriptCategory = ScriptCategory.TRUNCATE;
            if (scriptCategory == null) {
                TruncateTablesAction.$$$reportNull$$$0(0);
            }
            return scriptCategory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ToolActions$TruncateTablesAction", "getCategory"));
        }
    }

    public static abstract class ScriptingActionBase
    extends DumbAwareAction
    implements UpdateInBackground {
        @NlsContexts.DialogTitle
        private final String myTitle;

        public ScriptingActionBase(@NlsContexts.DialogTitle @NotNull String title, @NlsActions.ActionText @Nullable String text2, @NlsActions.ActionDescription @Nullable String description, @Nullable Icon icon) {
            if (title == null) {
                ScriptingActionBase.$$$reportNull$$$0(0);
            }
            super(text2, description, icon);
            this.myTitle = title;
        }

        public JBIterable<BasicElement> getSelectedElements(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(1);
            }
            DataContext dataContext = e.getDataContext();
            if (e.getPlace().equals("DatabaseViewPopup")) {
                return DatabaseContextFun.getSelectedElements(dataContext);
            }
            JBIterable<DbElement> selectedDbElements1 = this.getSelectedDbElements(e);
            DbElement first2 = (DbElement)selectedDbElements1.first();
            if (first2 == null) {
                return JBIterable.empty();
            }
            JBIterable<DbElement> selectedDbElements2 = this.filterOrExpandElements(selectedDbElements1);
            return selectedDbElements2.filterMap(o -> (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(o), BasicElement.class));
        }

        @NotNull
        private JBIterable<DbElement> getSelectedDbElements(@NotNull AnActionEvent e) {
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(2);
            }
            JBIterable res2 = ToolActions.getSelectedPsiElements(e.getDataContext()).flatten(ScriptingActionBase::expandIfNeeded).filter(DbElement.class);
            return this.filterOrExpandElements((JBIterable<DbElement>)res2);
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<BasicElement> elements;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(3);
            }
            Presentation p2 = e.getPresentation();
            try {
                elements = this.getSelectedElements(e);
            }
            catch (IndexNotReadyException inr) {
                p2.setEnabledAndVisible(false);
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                p2.setEnabledAndVisible(false);
                return;
            }
            ActionStatus s2 = this.checkApplicabilityStatus(elements, project);
            p2.setVisible(s2.visible);
            p2.setEnabled(s2.enabled);
        }

        @NotNull
        private ActionStatus checkApplicabilityStatus(@NotNull JBIterable<BasicElement> elements, @NotNull Project project) {
            BasicElement first2;
            if (elements == null) {
                ScriptingActionBase.$$$reportNull$$$0(4);
            }
            if (project == null) {
                ScriptingActionBase.$$$reportNull$$$0(5);
            }
            if ((first2 = (BasicElement)elements.first()) == null) {
                ActionStatus actionStatus = ActionStatus.HIDDEN;
                if (actionStatus == null) {
                    ScriptingActionBase.$$$reportNull$$$0(6);
                }
                return actionStatus;
            }
            DbDataSource dbDataSource = ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbDataSource(first2);
            LocalDataSource localDataSource = DataSourceFun.getLocalDataSource(dbDataSource);
            if (localDataSource == null) {
                ActionStatus actionStatus = ActionStatus.HIDDEN;
                if (actionStatus == null) {
                    ScriptingActionBase.$$$reportNull$$$0(7);
                }
                return actionStatus;
            }
            DbElement dbFirst = DbImplUtil.findElement(dbDataSource, first2);
            boolean en = DbImplUtilCore.canConnectTo(localDataSource) && ImportUtil.canModify(dbFirst);
            ActionStatus actionStatus = en ? ActionStatus.ENABLED : ActionStatus.DISABLED;
            if (actionStatus == null) {
                ScriptingActionBase.$$$reportNull$$$0(8);
            }
            return actionStatus;
        }

        protected boolean isSupported(@NotNull ScriptGenerator service, @Nullable BasicElement e) {
            if (service == null) {
                ScriptingActionBase.$$$reportNull$$$0(9);
            }
            if (e == null) {
                return false;
            }
            return service.capabilities(e).get(this.getCategory()).get(null);
        }

        @NotNull
        protected abstract ScriptCategory getCategory();

        @NotNull
        private static Iterable<? extends PsiElement> expandIfNeeded(PsiElement x) {
            DbModelRegistry modelRegistry = (DbModelRegistry)x.getProject().getService(DbModelRegistry.class);
            JBIterable jBIterable = x instanceof DatabaseStructure.FamilyGroup ? ((DatabaseStructure.FamilyGroup)x).iterateChildren().map(x1 -> DatabaseViewTreeFun.getDbWrapperFor(x1, modelRegistry)) : Collections.singleton(x);
            if (jBIterable == null) {
                ScriptingActionBase.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }

        @NotNull
        private JBIterable<DbElement> filterOrExpandElements(@NotNull JBIterable<DbElement> dbElements) {
            BasicModel model;
            DbElement first2;
            if (dbElements == null) {
                ScriptingActionBase.$$$reportNull$$$0(11);
            }
            if ((first2 = (DbElement)dbElements.first()) == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(12);
                }
                return jBIterable;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            BasicElement fe = (BasicElement)ObjectUtils.tryCast((Object)first2.getDelegate(), BasicElement.class);
            BasicModel basicModel = model = fe == null ? null : fe.getModel();
            if (model == null || !this.getCategory().getApplicableDbs().value((Object)model.getDbms())) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ScriptingActionBase.$$$reportNull$$$0(13);
                }
                return jBIterable;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            JBIterable dsElements = dbElements.filter(o -> o.getDataSource() == dataSource2).map(DbElement::getDelegate).filter(BasicElement.class);
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(BasicMixinElement::getChildren).withRoots((Iterable)dsElements)).expandAndSkip(o -> !this.isSupported(service, (BasicElement)o))).unique()).bfsTraversal().map(o -> DbImplUtilCore.findElement(dataSource2, o));
            if (jBIterable == null) {
                ScriptingActionBase.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable<BasicElement> selection;
            if (e == null) {
                ScriptingActionBase.$$$reportNull$$$0(15);
            }
            if ((selection = this.getSelectedElements(e)).isEmpty()) {
                return;
            }
            BasicElement firstElement = (BasicElement)selection.first();
            BasicModel model = firstElement.getModel();
            if (model == null) {
                return;
            }
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            DbDataSource firstDbDataSource = ((DbModelRegistry)project.getService(DbModelRegistry.class)).findDbDataSource(firstElement);
            if (firstDbDataSource == null) {
                return;
            }
            ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
            ScriptCategory category = this.getCategory();
            ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder(model, category);
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(firstDbDataSource, firstElement)), BasicNamespace.class);
            builder.setCurrentNamespace(namespace);
            builder.addElements((Iterable<? extends BasicElement>)selection);
            new MyDatabaseScriptDialog(firstDbDataSource, namespace, builder, service).initAndShow();
        }

        protected void fillContext(@NotNull DatabaseRefactoringHandler handler, Collection<BasicElement> elements) {
            if (handler == null) {
                ScriptingActionBase.$$$reportNull$$$0(16);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbElements";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ToolActions$ScriptingActionBase";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkApplicabilityStatus";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expandIfNeeded";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterOrExpandElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSelectedDbElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "checkApplicabilityStatus";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "filterOrExpandElements";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "fillContext";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyDatabaseScriptDialog
        extends DatabaseScriptDialog {
            private final ScriptingSingleModelTaskBuilder myBuilder;
            private final ScriptGenerator myService;

            public MyDatabaseScriptDialog(DbDataSource dataSource2, BasicNamespace namespace, ScriptingSingleModelTaskBuilder builder, ScriptGenerator service) {
                super(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), ScriptingActionBase.this.myTitle);
                this.myBuilder = builder;
                this.myService = service;
            }

            @Override
            protected void init() {
                super.init();
                this.generate();
            }

            @Override
            protected ScriptingTask getTask() {
                return this.myBuilder.build();
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                this.myBuilder.setOptions(options);
                this.generate();
            }

            @Override
            protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                if (handler == null) {
                    MyDatabaseScriptDialog.$$$reportNull$$$0(0);
                }
                Collection<BasicElement> elements = this.myBuilder.getElements();
                ScriptingActionBase.this.fillContext(handler, elements);
            }

            private void generate() {
                ScriptingResult script = this.myService.makeScript(this.myProject, this.getTask());
                this.updateText(script);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/ToolActions$ScriptingActionBase$MyDatabaseScriptDialog", "fillContext"));
            }
        }
    }
}

