/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectInDatabaseViewAction
extends DumbAwareAction {
    public SelectInDatabaseViewAction() {
        this.setInjectedContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SelectInDatabaseViewAction.$$$reportNull$$$0(0);
        }
        SelectInContext context = (project = e.getProject()) == null ? null : SelectInContextImpl.createContext((AnActionEvent)e);
        boolean enabled = context != null && new SelectInDatabaseView().canSelect(context, SelectInDatabaseViewAction.isStrict(e.getDataContext()));
        e.getPresentation().setEnabledAndVisible(enabled);
        boolean goTo = "EditorPopup".equals(e.getPlace());
        String text2 = DatabaseBundle.message(goTo ? "action.sql.SelectInDatabaseView.GoTo.text" : "action.sql.SelectInDatabaseView.text", new Object[0]);
        e.getPresentation().setText(text2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        SelectInContext context;
        if (e == null) {
            SelectInDatabaseViewAction.$$$reportNull$$$0(1);
        }
        SelectInContext selectInContext = context = (project = e.getProject()) == null ? null : SelectInContextImpl.createContext((AnActionEvent)e);
        if (context != null) {
            new SelectInDatabaseView().selectIn(context, true, SelectInDatabaseViewAction.isStrict(e.getDataContext()));
        }
    }

    private static boolean isStrict(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference ref = SelectInDatabaseViewAction.findDirectReferenceAt(file, offset);
        return ref != null;
    }

    @Nullable
    public static PsiReference findDirectReferenceAt(PsiFile file, int offset) {
        for (PsiElement element2 = file.findElementAt(offset); element2 != null; element2 = element2.getParent()) {
            PsiReference reference = element2.getReference();
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/actions/SelectInDatabaseViewAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

