/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.ModelStatisticsInternalAction;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.Function;
import com.intellij.util.PopupUtilsKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0004\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "formatPercent", "", "loaded", "", "total", "getRoot", "Lcom/intellij/database/model/basic/BasicElement;", "o", "Lcom/intellij/database/model/DasDataSource;", "getRoots", "Lcom/intellij/util/containers/JBIterable;", "showInfo", "info", "ForceLoadInternalAction", "ForceUnloadInternalAction", "intellij.database.impl"})
public class ModelStatisticsInternalAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int total = 0;
        int loaded = 0;
        for (BasicElement element2 : ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)this.getRoots(e))).filter(BasicElement.class)) {
            ++total;
            if (!BaseModel.isLoaded(element2)) continue;
            ++loaded;
        }
        this.showInfo("In memory: " + this.formatPercent(loaded, total), e);
    }

    @NotNull
    protected final String formatPercent(int loaded, int total) {
        StringBuilder stringBuilder = new StringBuilder().append(loaded).append('/').append(total).append(" (");
        String string = "%2f";
        Object[] objectArray = new Object[]{(double)loaded * 100.0 / (double)total};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return stringBuilder.append(string2).append("%)").toString();
    }

    protected final void showInfo(@NotNull String info, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(info, MessageType.INFO, null).createBalloon();
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        balloon.show(PopupUtilsKt.getBestBalloonPosition((DataContext)dataContext), Balloon.Position.above);
    }

    @NotNull
    protected final JBIterable<BasicElement> getRoots(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
        JBIterable jBIterable = DatabaseContextFun.getSelectedNodesExpandingGroups(dataContext).filterMap(new Function(this){
            final /* synthetic */ ModelStatisticsInternalAction this$0;

            @Nullable
            public final BasicElement fun(BasicNode o) {
                BasicNode basicNode = o;
                if (basicNode instanceof BasicElement) {
                    return (BasicElement)o;
                }
                if (basicNode instanceof DasDataSource) {
                    return ModelStatisticsInternalAction.access$getRoot(this.this$0, (DasDataSource)((Object)o));
                }
                return null;
            }
            {
                this.this$0 = modelStatisticsInternalAction;
            }
        }).intercept(new Function(this, e){
            final /* synthetic */ ModelStatisticsInternalAction this$0;
            final /* synthetic */ AnActionEvent $e;

            public final Iterator<BasicElement> fun(Iterator<? extends BasicElement> it2) {
                if (it2.hasNext()) {
                    return it2;
                }
                Project project = this.$e.getProject();
                DataSourceStorage dataSourceStorage = DbSrcUtils.getDataSourceStorage(project);
                Intrinsics.checkNotNullExpressionValue((Object)dataSourceStorage, (String)"DbSrcUtils.getDataSourceStorage(project)");
                return dataSourceStorage.getDataSourcesImpl().filterMap(new Function(this){
                    final /* synthetic */ getRoots.2 this$0;

                    @Nullable
                    public final BasicElement fun(LocalDataSource it2) {
                        ModelStatisticsInternalAction modelStatisticsInternalAction = this.this$0.this$0;
                        LocalDataSource localDataSource = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"it");
                        return ModelStatisticsInternalAction.access$getRoot(modelStatisticsInternalAction, localDataSource);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).iterator();
            }
            {
                this.this$0 = modelStatisticsInternalAction;
                this.$e = anActionEvent;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"e.dataContext.getSelecte\u2026        .iterator()\n    }");
        return jBIterable;
    }

    private final BasicElement getRoot(DasDataSource o) {
        DasModel $this$castSafelyTo$iv = o.getModel();
        boolean $i$f$castSafelyTo = false;
        DasModel dasModel = $this$castSafelyTo$iv;
        if (!(dasModel instanceof BasicModel)) {
            dasModel = null;
        }
        BasicModel basicModel = (BasicModel)dasModel;
        return basicModel != null ? basicModel.getRoot() : null;
    }

    public static final /* synthetic */ BasicElement access$getRoot(ModelStatisticsInternalAction $this, DasDataSource o) {
        return $this.getRoot(o);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction$ForceLoadInternalAction;", "Lcom/intellij/database/actions/ModelStatisticsInternalAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class ForceLoadInternalAction
    extends ModelStatisticsInternalAction {
        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int total = 0;
            int alreadyLoaded = 0;
            int loaded = 0;
            for (BasicElement element2 : ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)this.getRoots(e))).filter(BasicElement.class)) {
                ++total;
                if (BaseModel.isLoaded(element2)) {
                    ++alreadyLoaded;
                    continue;
                }
                if (!BaseModel.forceLoad(element2)) continue;
                ++loaded;
            }
            int totalLoaded = alreadyLoaded + loaded;
            int failed = total - totalLoaded;
            this.showInfo(StringsKt.trimMargin$default((String)("\n        |Was in memory: " + this.formatPercent(alreadyLoaded, total) + "\n        |Now in memory: " + this.formatPercent(totalLoaded, total) + "\n        |Failed to load: " + this.formatPercent(failed, total) + "\n      "), null, (int)1, null), e);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/actions/ModelStatisticsInternalAction$ForceUnloadInternalAction;", "Lcom/intellij/database/actions/ModelStatisticsInternalAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class ForceUnloadInternalAction
    extends ModelStatisticsInternalAction {
        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int total = 0;
            int loaded = 0;
            int unloaded = 0;
            for (BasicElement element2 : ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)this.getRoots(e))).filter(BasicElement.class)) {
                ++total;
                if (!BaseModel.isLoaded(element2)) continue;
                ++loaded;
                if (!BaseModel.forceUnload(element2)) continue;
                ++unloaded;
            }
            this.showInfo(StringsKt.trimMargin$default((String)("\n        |Was in memory: " + this.formatPercent(loaded, total) + "\n        |Now in memory: " + this.formatPercent(loaded - unloaded, total) + "\n        |Unloaded: " + this.formatPercent(unloaded, loaded) + "\n      "), null, (int)1, null), e);
        }
    }
}

