/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportEditorContext
extends DatabaseEditorContext {
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final ImportManager myManager;
    private final ImportInfo.Builder myBuilder;
    private final DbElement myElement;
    private final DeModel myDeModel;
    private final Disposable myDisposable;
    private final DeNamespace myNamespace;
    private final List<DbTable> myTables;
    private String myTableName;

    public ImportEditorContext(@NotNull DatabaseEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull ImportInfo.Builder builder, @NotNull DbElement element2, @NotNull DeModel deModel, @NotNull Disposable disposable2, @Nullable DeNamespace namespace) {
        if (context == null) {
            ImportEditorContext.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            ImportEditorContext.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            ImportEditorContext.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            ImportEditorContext.$$$reportNull$$$0(3);
        }
        if (deModel == null) {
            ImportEditorContext.$$$reportNull$$$0(4);
        }
        if (disposable2 == null) {
            ImportEditorContext.$$$reportNull$$$0(5);
        }
        super(context.getProject(), context.getDbms(), context.getModel(), context.getDataSource(), context.getSearchPath(), context.getVirtualFile(), null);
        this.myCaps = caps;
        this.myManager = ImportManager.of(context.getDbms(), DbImplUtilCore.getDatabaseVersion(this.getDataSource()));
        this.myBuilder = builder;
        this.myElement = element2;
        this.myDeModel = deModel;
        this.myDisposable = disposable2;
        this.myNamespace = namespace;
        this.myTables = this.getContextTables();
        builder.editorContext(this);
    }

    @NotNull
    public ImportInfo.Builder getBuilder() {
        ImportInfo.Builder builder = this.myBuilder;
        if (builder == null) {
            ImportEditorContext.$$$reportNull$$$0(6);
        }
        return builder;
    }

    @NotNull
    public DbElement getElement() {
        DbElement dbElement = this.myElement;
        if (dbElement == null) {
            ImportEditorContext.$$$reportNull$$$0(7);
        }
        return dbElement;
    }

    @NotNull
    public DeModel getDeModel() {
        DeModel deModel = this.myDeModel;
        if (deModel == null) {
            ImportEditorContext.$$$reportNull$$$0(8);
        }
        return deModel;
    }

    @Nullable
    public DeNamespace getNamespace() {
        return this.myNamespace;
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable2 = this.myDisposable;
        if (disposable2 == null) {
            ImportEditorContext.$$$reportNull$$$0(9);
        }
        return disposable2;
    }

    @NotNull
    public ImportManager getManager() {
        ImportManager importManager = this.myManager;
        if (importManager == null) {
            ImportEditorContext.$$$reportNull$$$0(10);
        }
        return importManager;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
        if (tableEditorCaps == null) {
            ImportEditorContext.$$$reportNull$$$0(11);
        }
        return tableEditorCaps;
    }

    @NotNull
    public String getTableName() {
        String string = this.myTableName == null ? (this.myTableName = this.getTableNameInternal()) : this.myTableName;
        if (string == null) {
            ImportEditorContext.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean isTableExists(@NotNull String name) {
        if (name == null) {
            ImportEditorContext.$$$reportNull$$$0(13);
        }
        return ContainerUtil.exists(this.myTables, DasUtil.byName(name));
    }

    @NotNull
    private String getTableNameInternal() {
        if (this.myBuilder.getImportType().isTableCreated()) {
            String string = this.myElement.getName();
            if (string == null) {
                ImportEditorContext.$$$reportNull$$$0(14);
            }
            return string;
        }
        String name = FileUtilRt.getNameWithoutExtension((String)this.myBuilder.getProducerName());
        Object result2 = name;
        int index2 = 1;
        while (this.isTableExists((String)result2)) {
            result2 = name + "_" + index2++;
        }
        String string = result2;
        if (string == null) {
            ImportEditorContext.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private List<DbTable> getContextTables() {
        DasNamespace namespace = DbImplUtilCore.getTopSingleNamespace(this.myElement);
        if (namespace == null || this.myElement instanceof DbTable) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ImportEditorContext.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects(this.myElement.getDataSource()).withRoot((Object)namespace)).filter(DbTable.class).toList();
        if (list == null) {
            ImportEditorContext.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ImportEditorContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ImportEditorContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableNameInternal";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isTableExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

