/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptedScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDeleteProvider {
    private static void deleteDataSources(@NotNull Project project, final @NotNull Set<DbDataSource> dataSources) {
        String message2;
        if (project == null) {
            DbDeleteProvider.$$$reportNull$$$0(0);
        }
        if (dataSources == null) {
            DbDeleteProvider.$$$reportNull$$$0(1);
        }
        if (dataSources.size() == 1) {
            DbDataSource element2 = dataSources.iterator().next();
            String name = StringUtil.shortenTextWithEllipsis((String)element2.getName(), (int)60, (int)26, (boolean)true);
            boolean nameContainsDataSource = StringUtil.containsIgnoreCase((String)name, (String)"DataSource") || StringUtil.containsIgnoreCase((String)name, (String)"Data") && StringUtil.containsIgnoreCase((String)name, (String)"Source");
            message2 = DatabaseBundle.message(nameContainsDataSource ? "confirmation.text.remove.data.source.1a" : "confirmation.text.remove.data.source.1b", name);
        } else {
            StringBuilder sb = new StringBuilder(DatabaseBundle.message("confirmation.text.remove.data.source.2", new Object[0])).append("\n");
            int i2 = 0;
            for (DbDataSource o : dataSources) {
                if (i2++ > 0) {
                    sb.append(",").append(i2 % 3 == 1 ? "\n" : " ");
                }
                sb.append(o.getName());
            }
            message2 = sb.toString();
        }
        int ret = Messages.showOkCancelDialog((Project)project, (String)message2, (String)CommonBundle.message((String)"title.confirmation", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (ret != 0) {
            return;
        }
        DbDeleteProvider.closeAllFilesBeforeDataSourceRemoval(project, dataSources);
        final DbPsiFacade facade = DbPsiFacade.getInstance(project);
        GlobalUndoableAction action2 = new GlobalUndoableAction(){

            public void undo() {
                for (DbDataSource dataSource2 : dataSources) {
                    facade.getDataSourceManager(dataSource2).addDataSource(dataSource2.getDelegate());
                }
            }

            public void redo() {
                for (DbDataSource dataSource2 : dataSources) {
                    facade.getDataSourceManager(dataSource2).removeDataSource(dataSource2.getDelegate());
                }
            }
        };
        try {
            WriteCommandAction.writeCommandAction((Project)project).withName(DatabaseBundle.message("command.name.remove.data.source", new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> DbDeleteProvider.lambda$deleteDataSources$0((UndoableAction)action2, project));
        }
        catch (UnexpectedUndoException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAllFilesBeforeDataSourceRemoval(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            DbDeleteProvider.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DbDeleteProvider.$$$reportNull$$$0(3);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            DbDataSource dataSource2 = DbImplUtilCore.findDataSource(project, virtualFile);
            if (!elements.contains(dataSource2)) continue;
            fileEditorManager.closeFile(virtualFile);
        }
    }

    @NotNull
    public static JBIterable<BasicElement> getElements(JBIterable<DbElement> selection) {
        JBIterable jBIterable = selection.filter(e -> !DataImporter.isBusy(e)).transform(DbElement::getDelegate).filter(BasicElement.class);
        if (jBIterable == null) {
            DbDeleteProvider.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public static void showDialogAndRun(final @NotNull Project project, final @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, final @NotNull JBIterable<DbElement> selection, final @NotNull DropQueryGenerator generator) {
        if (project == null) {
            DbDeleteProvider.$$$reportNull$$$0(5);
        }
        if (dataSource2 == null) {
            DbDeleteProvider.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            DbDeleteProvider.$$$reportNull$$$0(7);
        }
        if (generator == null) {
            DbDeleteProvider.$$$reportNull$$$0(8);
        }
        DatabaseScriptDialog dialog2 = new DatabaseScriptDialog(project, dataSource2, searchPath, DatabaseBundle.message("ddl.actions.confirm.drop", new Object[0])){

            @Override
            protected void init() {
                super.init();
                this.generate();
            }

            @Override
            protected ScriptingTask getTask() {
                return generator.createTask(null);
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                generator.setOptions(options);
                this.generate();
            }

            private void generate() {
                CompositeText text2 = generator.generate().getScript();
                try {
                    ObjectPath first2 = ObjectPaths.of((DasObject)ContainerUtil.getFirstItem(generator.getItems()));
                    String comment = first2.getDisplayName() + (String)(generator.getItems().size() > 1 ? " +" + (generator.getItems().size() - 1) : "");
                    text2 = DbSrcUtilsCore.formatCompositeText(project, DbSqlUtilCore.getSqlDialect(dataSource2), comment, text2, SqlCodeStyles.getSettings((Project)project, (String)ScriptingTaskBuilderKt.getCodeStyleName(dataSource2)));
                }
                catch (Error | RuntimeException e) {
                    Logger.getInstance(DdlActions.class).warn(e);
                }
                String query = text2.getText().toString();
                this.updateText(query);
            }

            @Override
            protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                if (handler == null) {
                    2.$$$reportNull$$$0(0);
                }
                LoaderContext context = handler.getContext();
                for (DbElement element2 : selection) {
                    if (element2 instanceof DbTableChild) {
                        DbTable table = ((DbTableChild)element2).getTable();
                        context.include(table);
                        for (DasForeignKey fk : DasUtil.getForeignKeys(table)) {
                            context.include(fk.getRefTable());
                        }
                    }
                    context.include(element2);
                }
                if (DatabaseSettings.getSettings().trackNamespaces) {
                    ArrayList<ObjectPath> toRemove = new ArrayList<ObjectPath>();
                    generator.fillNamespacesToRemove(toRemove);
                    for (ObjectPath pair : toRemove) {
                        context.getScopeUpdater().toRemove(pair);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/DbDeleteProvider$2", "fillContext"));
            }
        };
        dialog2.initAndShow();
    }

    @Nullable
    public static DeleteProvider getDeleteProvider(Iterable<? extends PsiElement> c2) {
        JBIterable e = JBIterable.from(c2);
        if (e.isEmpty()) {
            return null;
        }
        if (e.find(o -> !(o instanceof DbDataSource)) == null) {
            return new DataSourceDeleteProvider();
        }
        DatabaseSystem ds = (DatabaseSystem)e.filter(DbElement.class).map(o -> o.getDataSource().getDelegate()).first();
        return ds instanceof SqlDataSource ? new DdlElementDeleteProvider() : new DbElementDeleteProvider();
    }

    private static /* synthetic */ void lambda$deleteDataSources$0(UndoableAction action2, Project project) throws UnexpectedUndoException {
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed(action2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DbDeleteProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeAllFilesBeforeDataSourceRemoval";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DdlElementDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DdlElementDeleteProvider() {
        }

        public String getActionTitle() {
            return DatabaseBundle.message("action.DatabaseView.DropAction.text", new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DdlElementDeleteProvider.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dataSource2 = any == null ? null : any.getDataSource();
            return dataSource2 != null && dataSource2.getDelegate() instanceof SqlDataSource && any != dataSource2;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DdlElementDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            DbElement first2 = (DbElement)selection.first();
            if (first2 == null) {
                return;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            SqlDataSource sqlDs2 = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
            if (sqlDs2 == null) {
                return;
            }
            ScriptedScriptConsumer consumer2 = DumpToDdlDataSourceActionKt.createScriptConsumer(project, sqlDs2, (Function2<? super File, ? super ScriptingResult, Unit>)((Function2)(f, r) -> Unit.INSTANCE));
            if (consumer2 == null) {
                return;
            }
            ArrayList targets2 = new ArrayList();
            WriteAction.run(() -> ((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)selection.filter(o -> o.getDataSource() == dataSource2).filterMap(DbImplUtilCore::getMaybeBasicElement))).filter(BasicElement.class).map(o -> {
                String tag = consumer2.distribute((BasicElement)o);
                return tag == null ? null : consumer2.getFile(tag);
            }).unique().filterMap(f -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(f)).filterMap(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)project)).findFile(arg_0)).addAllTo(targets2));
            DeleteHandler.deletePsiElement((PsiElement[])targets2.toArray(PsiElement.EMPTY_ARRAY), (Project)project, (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DdlElementDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DbElementDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DbElementDeleteProvider() {
        }

        public String getActionTitle() {
            return DatabaseBundle.message("action.DatabaseView.DropAction.text", new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            BasicModel model;
            Project project;
            if (dataContext == null) {
                DbElementDeleteProvider.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dataSource2 = any == null ? null : any.getDataSource();
            BasicModel basicModel = model = dataSource2 == null ? null : (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null || !ImportUtil.canConnectToAndModify(dataSource2)) {
                return false;
            }
            for (DbElement e : selection) {
                if (!e.isWritable()) {
                    return false;
                }
                if (dataSource2.equals(e.getDataSource())) continue;
                return false;
            }
            return DropQueryGenerator.canDeleteAnything(model, DbDeleteProvider.getElements(selection));
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DbElementDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
            DbElement first2 = (DbElement)selection.first();
            if (first2 == null) {
                return;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(first2)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(project, model);
            generator.setItems((Iterable<BasicElement>)DbDeleteProvider.getElements(selection));
            while (namespace != null && generator.getItems().contains(namespace)) {
                namespace = (BasicNamespace)ObjectUtils.tryCast((Object)namespace.getParent(), BasicNamespace.class);
            }
            generator.setCurrentNamespace(namespace);
            DbDeleteProvider.showDialogAndRun(project, dataSource2, ObjectPaths.searchPathOf(namespace), selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DbElementDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DataSourceDeleteProvider
    implements DeleteProvider,
    TitledHandler {
        private DataSourceDeleteProvider() {
        }

        public String getActionTitle() {
            return DatabaseBundle.message("ddl.actions.remove", new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DataSourceDeleteProvider.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseContextFun.getSelectedDbElements(dataContext));
            if (selection.filter(DbDataSource.class).size() != selection.size()) {
                return false;
            }
            return !selection.isEmpty();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DataSourceDeleteProvider.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable selection = JBIterable.from(DatabaseContextFun.getSelectedDbDataSources(dataContext));
            DbDeleteProvider.deleteDataSources(project, selection.toSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/database/actions/DbDeleteProvider$DataSourceDeleteProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

