/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DbModelRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010 \u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/DbModelRegistry;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "models", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/database/model/basic/BasicModel;", "Lcom/intellij/database/psi/DbDataSource;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "roots", "Lcom/intellij/database/model/DasObject;", "clear", "", "dispose", "findDataSource", "Lcom/intellij/database/dataSource/AbstractDataSource;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "model", "findDbDataSource", "o", "findDbElement", "Lcom/intellij/database/psi/DbElement;", "invalidate", "dbDS", "obtainDbDataSourceForModel", "obtainDbDataSourceForRoot", "key", "onDataSourceChanged", "intellij.database.impl"})
public final class DbModelRegistry
implements Disposable {
    private final DbPsiFacade psiFacade;
    private final ConcurrentMap<BasicModel, DbDataSource> models;
    private final ConcurrentMap<DasObject, DbDataSource> roots;
    @NotNull
    private final Project project;

    private final DbDataSource obtainDbDataSourceForModel(BasicModel model) {
        Object v2;
        block1: {
            List<DbDataSource> list = this.psiFacade.getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"psiFacade.dataSources");
            Iterable iterable = list;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DbDataSource ds = (DbDataSource)t;
                boolean bl3 = false;
                DbDataSource dbDataSource = ds;
                Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"ds");
                if (!(dbDataSource.getModel() == model)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * Unable to fully structure code
     */
    private final DbDataSource obtainDbDataSourceForRoot(DasObject key) {
        block5: {
            v0 = this.psiFacade.getDataSources();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"psiFacade.dataSources");
            var2_2 = v0;
            var3_3 = false;
            var4_4 = var2_2;
            var5_5 = false;
            for (T var7_7 : var4_4) {
                block4: {
                    block7: {
                        block6: {
                            o = (DbDataSource)var7_7;
                            $i$a$-find-DbModelRegistry$obtainDbDataSourceForRoot$1 = false;
                            v1 = o;
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"o");
                            v2 = v1.getDelegate();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"o.delegate");
                            Intrinsics.checkNotNullExpressionValue((Object)v2.getModel(), (String)"o.delegate.model");
                            if (!(model instanceof BasicModel)) break block6;
                            v3 = ((BasicModel)model).getRoot() == key;
                            break block4;
                        }
                        v4 = model.getModelRoots();
                        Intrinsics.checkNotNullExpressionValue(v4, (String)"model.modelRoots");
                        $this$any$iv = (Iterable)v4;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block7;
                        v3 = false;
                        break block4;
                    }
                    for (T element$iv : $this$any$iv) {
                        root = (DasObject)element$iv;
                        $i$a$-any-DbModelRegistry$obtainDbDataSourceForRoot$1$1 = false;
                        if (root == key) ** GOTO lbl-1000
                        v5 = root;
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"root");
                        if (v5.getDasParent() == key) lbl-1000:
                        // 2 sources

                        {
                            v6 = true;
                        } else {
                            v6 = false;
                        }
                        if (!v6) continue;
                        v3 = true;
                        break block4;
                    }
                    v3 = false;
                }
                if (!v3) continue;
                v7 = var7_7;
                break block5;
            }
            v7 = null;
        }
        return v7;
    }

    @Nullable
    public final AbstractDataSource findDataSource(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DbDataSource dbDataSource = this.findDbDataSource(element2);
        return dbDataSource != null ? DataSourceFun.getRealDataSource(dbDataSource) : null;
    }

    @Nullable
    public final AbstractDataSource findDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        DbDataSource dbDataSource = this.findDbDataSource(model);
        return dbDataSource != null ? DataSourceFun.getRealDataSource(dbDataSource) : null;
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        BasicModel basicModel = element2.getModel();
        if (basicModel == null) {
            return null;
        }
        BasicModel model = basicModel;
        return this.findDbDataSource(model);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@NotNull BasicModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (DbDataSource)this.models.get(model);
    }

    @Nullable
    public final DbElement findDbElement(@NotNull BasicElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        DbDataSource dbDataSource = this.findDbDataSource(element2);
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource2 = dbDataSource;
        return dataSource2.findElement(element2);
    }

    @Nullable
    public final DbDataSource findDbDataSource(@Nullable DasObject o) {
        DbDataSource dbDataSource;
        DasObject theOldestAncestor;
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return ((DbElement)o).getDataSource();
        }
        DasObject dasObject = o;
        DasObject dasObject2 = theOldestAncestor = dasObject instanceof BasicRoot ? o : (dasObject instanceof BasicElement ? (DasObject)DasUtil.getParentOfClass(o, BasicRoot.class, false) : (DasObject)DasUtil.dasParents(o).last());
        if (dasObject2 != null) {
            dasObject = dasObject2;
            boolean bl = false;
            boolean bl2 = false;
            DasObject it2 = dasObject;
            boolean bl3 = false;
            dbDataSource = (DbDataSource)this.roots.get(it2);
        } else {
            dbDataSource = null;
        }
        return dbDataSource;
    }

    @Nullable
    public final DbElement findDbElement(@Nullable DasObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof DbElement) {
            return (DbElement)o;
        }
        DbDataSource dataSource2 = this.findDbDataSource(o);
        return dataSource2 == null ? null : DbImplUtilCore.findElement(dataSource2, o);
    }

    private final void clear() {
        this.models.clear();
        this.roots.clear();
    }

    private final void invalidate(DbDataSource dbDS) {
        if (this.models.isEmpty()) {
            return;
        }
        Set entries = this.models.entrySet();
        Iterator it2 = entries.iterator();
        while (it2.hasNext()) {
            Map.Entry e = it2.next();
            if ((DbDataSource)e.getValue() != dbDS || (BasicModel)e.getKey() == dbDS.getModel()) continue;
            it2.remove();
        }
    }

    private final void onDataSourceChanged(DbDataSource dbDS) {
        if (dbDS == null) {
            this.models.clear();
        } else {
            this.invalidate(dbDS);
        }
        this.roots.clear();
    }

    public void dispose() {
        this.clear();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public DbModelRegistry(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"DbPsiFacade.getInstance(project)");
        this.psiFacade = dbPsiFacade;
        Function1 function1 = (Function1)new Function1<BasicModel, DbDataSource>(this){

            @Nullable
            public final DbDataSource invoke(@NotNull BasicModel p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return DbModelRegistry.access$obtainDbDataSourceForModel((DbModelRegistry)this.receiver, p1);
            }
        };
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createWeakMap((Function)new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ Object fun(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ConcurrentFactoryMap.cre\u2026tainDbDataSourceForModel)");
        this.models = concurrentMap;
        function1 = (Function1)new Function1<DasObject, DbDataSource>(this){

            @Nullable
            public final DbDataSource invoke(@Nullable DasObject p1) {
                return DbModelRegistry.access$obtainDbDataSourceForRoot((DbModelRegistry)this.receiver, p1);
            }
        };
        Function function2 = new /* invalid duplicate definition of identical inner class */;
        Object object = roots.2.INSTANCE;
        if (object != null) {
            function1 = object;
            object = new Supplier((Function0)function1){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ Object get() {
                    return this.function.invoke();
                }
            };
        }
        ConcurrentMap concurrentMap2 = ConcurrentFactoryMap.create((Function)function2, (Supplier)((Supplier)object));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"ConcurrentFactoryMap.cre\u2026kKeyWeakValueIdentityMap)");
        this.roots = concurrentMap2;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        Function1 function12 = (Function1)new Function1<DbDataSource, Unit>(this){

            public final void invoke(@Nullable DbDataSource p1) {
                ((DbModelRegistry)this.receiver).onDataSourceChanged(p1);
            }
        };
        messageBusConnection2.subscribe(DbPsiFacade.TOPIC, (Object)new DbPsiFacade.Listener(function12){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void onChanged(@Nullable DbDataSource p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)p0), (String)"invoke(...)");
            }
        });
    }

    public static final /* synthetic */ DbDataSource access$obtainDbDataSourceForModel(DbModelRegistry $this, BasicModel model) {
        return $this.obtainDbDataSourceForModel(model);
    }

    public static final /* synthetic */ DbDataSource access$obtainDbDataSourceForRoot(DbModelRegistry $this, DasObject key) {
        return $this.obtainDbDataSourceForRoot(key);
    }
}

