/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.endpoints;

import com.intellij.grpc.GrpcBundle;
import com.intellij.grpc.GrpcIcons;
import com.intellij.grpc.ProtoFileUtilsKt;
import com.intellij.grpc.endpoints.ProtoEndpointsProvider$getEndpointData$1;
import com.intellij.grpc.endpoints.ProtoEndpointsProvider$getEndpointGroups$1;
import com.intellij.grpc.model.ProtoRpcModel;
import com.intellij.grpc.model.ProtoServiceModel;
import com.intellij.lang.Language;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.utils.EndpointsViewUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ValueKey;
import com.intellij.protobuf.lang.PbLanguage;
import com.intellij.protobuf.lang.psi.PbServiceMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lcom/intellij/grpc/endpoints/ProtoEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "Lcom/intellij/grpc/model/ProtoServiceModel;", "Lcom/intellij/grpc/model/ProtoRpcModel;", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getEndpointData", "", "group", "endpoint", "dataId", "", "getEndpointGroups", "", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "isValidEndpoint", "", "intellij.grpc"})
public final class ProtoEndpointsProvider
implements EndpointsProvider<ProtoServiceModel, ProtoRpcModel> {
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("gRPC", GrpcBundle.INSTANCE.message("protobuf.specification", new Object[0]), null);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.API_DEFINITION_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
        return ProtoFileUtilsKt.hasAnyProtoFiles(globalSearchScope) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<ProtoServiceModel> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof SearchScopeEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap(ProtoFileUtilsKt.getAllProtoFiles(((SearchScopeEndpointsFilter)filter).getSearchScope()), (Function1)((Function1)ProtoEndpointsProvider$getEndpointGroups$1.INSTANCE)));
    }

    @NotNull
    public Iterable<ProtoRpcModel> getEndpoints(@NotNull ProtoServiceModel group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return SequencesKt.asIterable(group.getRpcModels());
    }

    public boolean isValidEndpoint(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return new ItemPresentation(endpoint){
            final /* synthetic */ ProtoRpcModel $endpoint;

            @NotNull
            public String getPresentableText() {
                return this.$endpoint.getName();
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = GrpcIcons.Procedure;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"GrpcIcons.Procedure");
                return icon;
            }

            @Nullable
            public String getLocationString() {
                PbServiceMethod pbServiceMethod = this.$endpoint.getSourcePsi();
                return pbServiceMethod != null && (pbServiceMethod = pbServiceMethod.getContainingFile()) != null ? pbServiceMethod.getName() : null;
            }
            {
                this.$endpoint = $captured_local_variable$0;
            }
        };
    }

    @Nullable
    public Object getEndpointData(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint, @NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Function0 function0 = (Function0)new ProtoEndpointsProvider$getEndpointData$1(endpoint);
        ValueKey.BeforeIf beforeIf = ValueKey.match((String)dataId).ifEq((ValueKey)EndpointsProvider.DOCUMENTATION_ELEMENT).thenGet(new Supplier(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)beforeIf, (String)"ValueKey.match(dataId)\n \u2026nGet(endpoint::sourcePsi)");
        return EndpointsViewUtils.orCheckCommonEndpointKeys((ValueKey.BeforeIf)beforeIf, (PsiElement)((PsiElement)endpoint.getSourcePsi()));
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        ModificationTracker modificationTracker = psiManager.getModificationTracker().forLanguage((Language)PbLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"PsiManager.getInstance(p\u2026uage(PbLanguage.INSTANCE)");
        return modificationTracker;
    }
}

