/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.java;

import com.intellij.debugger.streams.trace.impl.handler.type.ClassTypeImpl;
import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.CallTypeExtractor;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.dsl.KotlinSequenceTypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/java/JavaStreamChainTypeExtractor;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/CallTypeExtractor$Base;", "()V", "extractItemsType", "Lcom/intellij/debugger/streams/trace/impl/handler/type/GenericType;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getResultType", "kotlin.jvm-debugger.sequence"})
public final class JavaStreamChainTypeExtractor
extends CallTypeExtractor.Base {
    @Override
    @NotNull
    protected GenericType extractItemsType(@Nullable KotlinType type) {
        GenericType genericType;
        if (type == null) {
            return KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
        }
        switch (KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type)) {
            case "java.util.stream.IntStream": {
                genericType = KotlinSequenceTypes.INSTANCE.getINT();
                break;
            }
            case "java.util.stream.DoubleStream": {
                genericType = KotlinSequenceTypes.INSTANCE.getDOUBLE();
                break;
            }
            case "java.util.stream.LongStream": {
                genericType = KotlinSequenceTypes.INSTANCE.getLONG();
                break;
            }
            case "java.util.stream.BaseStream": {
                genericType = KotlinSequenceTypes.INSTANCE.getNULLABLE_ANY();
                break;
            }
            default: {
                genericType = this.extractItemsType(TypeUtilsKt.getImmediateSuperclassNotAny((KotlinType)type));
            }
        }
        return genericType;
    }

    @Override
    @NotNull
    protected GenericType getResultType(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return (GenericType)new ClassTypeImpl(KotlinPsiUtil.INSTANCE.getTypeName(type), null, 2, null);
    }
}

