/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetType;
import com.intellij.jam.JamElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistenceFacetType;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistenceModelBrowserImpl
implements PersistenceModelBrowser {
    public static final PersistenceModelBrowserImpl INSTANCE = new PersistenceModelBrowserImpl();
    private Condition<? super PersistenceClassRole> myFilter;
    private static final Key<CachedValue<AttributeInfo>> MEMBER_PERSISTENT_ATTRIBUTES_KEY = Key.create((String)"MEMBER_PERSISTENT_ATTRIBUTES_KEY");
    private static final Key<CachedValue<Map<XmlFile, Collection<PersistencePackage>>>> PERSISTENCE_UNITS_KEY = Key.create((String)"PERSISTENCE_UNITS_KEY");

    @Override
    @NotNull
    public PersistenceModelBrowser setRoleFilter(Condition<? super PersistenceClassRole> filter) {
        assert (this != INSTANCE);
        this.myFilter = filter;
        PersistenceModelBrowserImpl persistenceModelBrowserImpl = this;
        if (persistenceModelBrowserImpl == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(0);
        }
        return persistenceModelBrowserImpl;
    }

    @Override
    public boolean acceptsRole(PersistenceClassRole role) {
        return this.myFilter == null || this.myFilter.value((Object)role);
    }

    @Override
    @NotNull
    public Query<PersistentObject> queryPersistentObjectHierarchy(PersistentObject obj) {
        return new ExecutorsQuery((Object)obj, Collections.singletonList((queryParameters, consumer) -> {
            PsiClass firstClass = (PsiClass)queryParameters.getClazz().getValue();
            if (firstClass == null) {
                return consumer.process(queryParameters);
            }
            if (!consumer.process(queryParameters)) {
                return false;
            }
            Ref first = Ref.create((Object)Boolean.FALSE);
            SmartList superClasses = new SmartList();
            Processor processor = aClass -> {
                if (firstClass.equals(aClass)) {
                    first.set((Object)Boolean.TRUE);
                    return false;
                }
                for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(aClass)) {
                    PersistentObject object = role.getPersistentObject();
                    if (object == null || consumer.process((Object)object)) continue;
                    return false;
                }
                return true;
            };
            if (!JamCommonUtil.processSuperClassList((PsiClass)firstClass.getSuperClass(), (Collection)superClasses, (Processor)processor)) {
                return (Boolean)first.get();
            }
            return true;
        }));
    }

    @Override
    @NotNull
    public Query<PersistentAttribute> queryAttributes(PersistentObject obj) {
        QueryExecutor queryExecutor = (queryParameters, consumer) -> {
            HashSet visitedNames = new HashSet();
            return this.queryPersistentObjectHierarchy((PersistentObject)queryParameters).forEach(persistentObject -> {
                for (PersistentAttribute persistentAttribute : persistentObject.getObjectModelHelper().getAttributes()) {
                    if (persistentAttribute instanceof JamElement && persistentAttribute.getPsiMember() instanceof PsiMethod && !visitedNames.add((String)persistentAttribute.getName().getValue()) || consumer.process((Object)persistentAttribute)) continue;
                    return false;
                }
                return true;
            });
        };
        return new ExecutorsQuery((Object)obj, Collections.singletonList(queryExecutor));
    }

    @Override
    @NotNull
    public Query<PersistentObject> queryTargetPersistentObjects(PersistentRelationshipAttribute attribute) {
        Query<PersistentObject> query = this.queryPersistentObjects(PersistenceCommonUtil.getTargetClass(attribute), PersistenceClassRoleEnum.ENTITY);
        if (query == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(1);
        }
        return query;
    }

    @Override
    @NotNull
    public Query<PersistentObject> queryTargetPersistentObjects(PersistentEmbeddedAttribute attribute) {
        if (attribute instanceof PersistentEmbeddable) {
            return new ArrayQuery((Object[])new PersistentObject[]{(PersistentObject)((Object)attribute)});
        }
        Query<PersistentObject> query = this.queryPersistentObjects(PersistenceCommonUtil.getTargetClass(attribute), PersistenceClassRoleEnum.EMBEDDABLE);
        if (query == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(2);
        }
        return query;
    }

    @Override
    @NotNull
    public Query<PersistenceListener> queryPersistenceListeners(PsiClass psiClass) {
        if (psiClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(3);
            }
            return query;
        }
        return new ExecutorsQuery((Object)psiClass, Collections.singletonList((queryParameters, consumer) -> {
            for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(queryParameters)) {
                PersistenceListener listener = role.getEntityListener();
                if (listener == null || this.myFilter != null && !this.myFilter.value((Object)role) || consumer.process((Object)listener)) continue;
                return false;
            }
            return true;
        }));
    }

    @Override
    @NotNull
    public Query<PersistentObject> queryPersistentObjects(PsiClass psiClass) {
        Query<PersistentObject> query = this.queryPersistentObjects(psiClass, null);
        if (query == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(4);
        }
        return query;
    }

    @Override
    @NotNull
    public Query<PersistentObject> queryPersistentObjects(PsiClass psiClass, PersistenceClassRoleEnum type) {
        if (psiClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(5);
            }
            return query;
        }
        return new ExecutorsQuery((Object)psiClass, Collections.singletonList((queryParameters, consumer) -> {
            for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles(queryParameters)) {
                PersistentObject object = role.getPersistentObject();
                if (object == null || this.myFilter != null && !this.myFilter.value((Object)role) || type != null && type != role.getType() || consumer.process((Object)object)) continue;
                return false;
            }
            return true;
        }));
    }

    @Override
    @NotNull
    public Query<PersistentRelationshipAttribute> queryTheOtherSideAttributes(PersistentRelationshipAttribute relationAttribute, boolean inverseOnly) {
        PsiMember thisMember = relationAttribute.getPsiMember();
        if (thisMember == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(6);
            }
            return query;
        }
        PsiClass thisClass = thisMember.getContainingClass();
        if (thisClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(7);
            }
            return query;
        }
        SmartList queryExecutors = new SmartList();
        for (PersistentObject object : this.queryTargetPersistentObjects(relationAttribute)) {
            queryExecutors.add((queryParameters, consumer) -> this.queryTheOtherSideAttributes((PersistentRelationshipAttribute)queryParameters, inverseOnly, object).forEach(consumer));
        }
        return new ExecutorsQuery((Object)relationAttribute, (List)queryExecutors);
    }

    @Override
    @NotNull
    public Query<PersistentRelationshipAttribute> queryTheOtherSideAttributes(PersistentRelationshipAttribute relationAttribute, boolean inverseOnly, PersistentObject targetEntity) {
        boolean thisInverse = relationAttribute.getAttributeModelHelper().isInverseSide();
        if (inverseOnly && thisInverse) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(8);
            }
            return query;
        }
        PsiMember thisMember = relationAttribute.getPsiMember();
        if (thisMember == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(9);
            }
            return query;
        }
        PsiClass thisClass = thisMember.getContainingClass();
        if (thisClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(10);
            }
            return query;
        }
        String thisName = (String)relationAttribute.getName().getValue();
        String thisMappedBy = relationAttribute.getAttributeModelHelper().getMappedByAttributeName();
        return new ExecutorsQuery((Object)relationAttribute, Collections.singletonList((queryParameters, consumer) -> {
            if (targetEntity != null) {
                this.queryAttributes(targetEntity).forEach(attributeBase -> {
                    if (attributeBase instanceof PersistentRelationshipAttribute) {
                        PersistentRelationshipAttribute targetAttribute = (PersistentRelationshipAttribute)attributeBase;
                        PsiClass targetTargetClass = (PsiClass)targetAttribute.getTargetEntityClass().getValue();
                        if (!thisClass.getManager().areElementsEquivalent((PsiElement)thisClass, (PsiElement)targetTargetClass)) {
                            return true;
                        }
                        boolean thatInverse = targetAttribute.getAttributeModelHelper().isInverseSide();
                        if (inverseOnly && !thatInverse) {
                            return true;
                        }
                        String thatMappedBy = targetAttribute.getAttributeModelHelper().getMappedByAttributeName();
                        if ((thisMappedBy != null && thisMappedBy.equals(attributeBase.getName().getValue()) || thatMappedBy != null && thatMappedBy.equals(thisName)) && !consumer.process((Object)targetAttribute)) {
                            return false;
                        }
                    }
                    return true;
                });
            }
            return true;
        }));
    }

    @Override
    @NotNull
    public List<PersistentAttribute> getPersistenceAttributes(PsiMember psiMember) {
        if (psiMember == null || !psiMember.isValid()) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        AttributeInfo attributeInfo = PersistenceModelBrowserImpl.getAttributeInfo(psiMember.getContainingClass());
        if (attributeInfo == null) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        Collection<PersistentAttribute> attributes = attributeInfo.memberAttributes.get(psiMember);
        return attributes == null ? Collections.emptyList() : new SmartList(attributes);
    }

    @Override
    @NotNull
    public List<PersistentAttribute> getPersistenceAttributes(PersistentObject object, PsiMember psiMember) {
        Collection<? extends PersistentAttribute> attributes2;
        if (!(object != null && object.isValid() || psiMember != null && psiMember.isValid())) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        PsiClass psiClass = psiMember != null ? psiMember.getContainingClass() : (PsiClass)object.getClazz().getValue();
        AttributeInfo attributeInfo = PersistenceModelBrowserImpl.getAttributeInfo(psiClass);
        if (attributeInfo == null) {
            List<PersistentAttribute> list = Collections.emptyList();
            if (list == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        Collection<PersistentAttribute> attributes1 = psiMember == null ? null : attributeInfo.memberAttributes.get(psiMember);
        Collection<? extends PersistentAttribute> collection = attributes2 = object == null ? null : attributeInfo.objectAttributes.get(object);
        if (attributes1 == null) {
            return attributes2 == null || psiMember != null ? Collections.emptyList() : new ArrayList<PersistentAttribute>(attributes2);
        }
        if (attributes2 == null) {
            return object != null ? Collections.emptyList() : new ArrayList<PersistentAttribute>(attributes1);
        }
        ArrayList<PersistentAttribute> result = new ArrayList<PersistentAttribute>(attributes2);
        result.retainAll(attributes1);
        ArrayList<PersistentAttribute> arrayList = result;
        if (arrayList == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static AttributeInfo getAttributeInfo(PsiClass aClass) {
        if (aClass == null || !aClass.isValid()) {
            return null;
        }
        PsiClass originalClass = (PsiClass)aClass.getOriginalElement();
        PsiClass containingClass = originalClass != null ? originalClass : aClass;
        CachedValue data = (CachedValue)containingClass.getUserData(MEMBER_PERSISTENT_ATTRIBUTES_KEY);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)containingClass.getProject()).createCachedValue(() -> {
                PersistenceClassRole[] classRoles = PersistenceCommonUtil.getPersistenceRoles(containingClass);
                if (classRoles.length == 0) {
                    return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                HashSet<Object> dependencyItemsList = new HashSet<Object>();
                dependencyItemsList.add(containingClass);
                AttributeInfo info = null;
                for (PersistenceClassRole classRole : classRoles) {
                    PersistentObject persistentObject = classRole.getPersistentObject();
                    if (persistentObject == null) continue;
                    if (info == null) {
                        info = new AttributeInfo();
                        info.memberAttributes = new HashMap<PsiMember, Collection<PersistentAttribute>>();
                        info.objectAttributes = new HashMap<PersistentObject, Collection<? extends PersistentAttribute>>();
                    }
                    PersistenceFacet facet = classRole.getFacet();
                    dependencyItemsList.add(facet.getModificationTracker());
                    List<? extends PersistentAttribute> attributes = persistentObject.getObjectModelHelper().getAttributes();
                    info.objectAttributes.put(persistentObject, attributes);
                    for (PersistentAttribute persistentAttribute : attributes) {
                        PsiMember member;
                        if (persistentAttribute instanceof PersistentTransientAttribute || (member = persistentAttribute.getPsiMember()) == null) continue;
                        Collection<PersistentAttribute> attrs = info.memberAttributes.get(member);
                        if (attrs == null) {
                            attrs = new HashSet<PersistentAttribute>();
                            info.memberAttributes.put(member, attrs);
                        }
                        attrs.add(persistentAttribute);
                    }
                }
                Object[] dependencyItems = dependencyItemsList.toArray();
                return new CachedValueProvider.Result(info, dependencyItems);
            }, false);
            containingClass.putUserData(MEMBER_PERSISTENT_ATTRIBUTES_KEY, (Object)data);
        }
        return (AttributeInfo)data.getValue();
    }

    private static PersistencePackage findOriginalUnitDuringCompletion(PersistenceFacet facet, PersistencePackage proxyUnitInstance) {
        PsiElement proxyPsiElement = PersistenceModelBrowserImpl.getOriginalIdentifyingElement(proxyUnitInstance);
        if (proxyPsiElement == null) {
            return null;
        }
        for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
            PsiElement xmlPsiElement = PersistenceModelBrowserImpl.getOriginalIdentifyingElement(persistencePackage);
            if (xmlPsiElement == null || xmlPsiElement != proxyPsiElement) continue;
            return persistencePackage;
        }
        return null;
    }

    private static PsiElement getOriginalIdentifyingElement(PersistencePackage unit) {
        PsiElement identifyingPsiElement = unit.getIdentifyingPsiElement();
        if (identifyingPsiElement == null) {
            return null;
        }
        PsiElement navigationElement = identifyingPsiElement.getNavigationElement();
        if (navigationElement == null) {
            return null;
        }
        return CompletionUtil.getOriginalElement((PsiElement)navigationElement);
    }

    @Override
    @NotNull
    public List<PersistenceFacet> getPersistenceFacets(@NotNull PersistencePackage unit) {
        if (unit == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(16);
        }
        ArrayList<PersistenceFacet> result = new ArrayList<PersistenceFacet>();
        Module module = unit.getModule();
        List<PersistenceFacet> facets = module == null ? PersistenceCommonUtil.getAllPersistenceFacets(unit.getPsiManager().getProject()) : PersistenceCommonUtil.getAllPersistenceFacets(module);
        for (PersistenceFacet facet : facets) {
            for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
                if (persistencePackage != unit && persistencePackage != PersistenceModelBrowserImpl.findOriginalUnitDuringCompletion(facet, unit)) continue;
                result.add(facet);
            }
        }
        ArrayList<PersistenceFacet> arrayList = result;
        if (arrayList == null) {
            PersistenceModelBrowserImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<PersistencePackage> getPersistenceUnits(PersistenceMappings mappings) {
        if (mappings instanceof JamElement) {
            Module module = mappings.getModule();
            ArrayList<PersistencePackage> result = new ArrayList<PersistencePackage>();
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets(module)) {
                if (facet.getAnnotationEntityMappings() == null) continue;
                result.addAll(facet.getPersistenceUnits());
            }
            ArrayList<PersistencePackage> arrayList = result;
            if (arrayList == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        if (mappings instanceof DomElement) {
            Map map;
            XmlFile xmlFile = DomUtil.getFile((DomElement)((DomElement)mappings));
            if (!xmlFile.isValid()) {
                List<PersistencePackage> list = Collections.emptyList();
                if (list == null) {
                    PersistenceModelBrowserImpl.$$$reportNull$$$0(19);
                }
                return list;
            }
            Project project = (xmlFile = (XmlFile)xmlFile.getOriginalFile()).getProject();
            CachedValue value = (CachedValue)project.getUserData(PERSISTENCE_UNITS_KEY);
            if (value == null) {
                value = CachedValuesManager.getManager((Project)xmlFile.getProject()).createCachedValue(() -> {
                    HashSet<ModificationTracker> depSet = new HashSet<ModificationTracker>();
                    FacetFinder facetFinder = FacetFinder.getInstance((Project)project);
                    for (FacetType facetType : (FacetType[])FacetType.EP_NAME.getExtensions()) {
                        if (!(facetType instanceof PersistenceFacetType)) continue;
                        depSet.add(facetFinder.getAllFacetsOfTypeModificationTracker(facetType.getId()));
                    }
                    HashMap<XmlFile, HashSet<PersistencePackage>> result = new HashMap<XmlFile, HashSet<PersistencePackage>>();
                    for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets(project)) {
                        for (PersistencePackage persistencePackage : facet.getPersistenceUnits()) {
                            ContainerUtil.addIfNotNull(depSet, (Object)persistencePackage.getContainingFile());
                            for (PersistenceMappings mappings1 : PersistenceCommonUtil.getDomEntityMappings(PersistenceMappings.class, persistencePackage, facet)) {
                                XmlFile xmlFile1 = DomUtil.getFile((DomElement)((DomElement)mappings1));
                                HashSet<PersistencePackage> persistenceUnits = (HashSet<PersistencePackage>)result.get(xmlFile1);
                                if (persistenceUnits == null) {
                                    persistenceUnits = new HashSet<PersistencePackage>();
                                    result.put(xmlFile1, persistenceUnits);
                                }
                                persistenceUnits.add(persistencePackage);
                            }
                        }
                    }
                    Object[] dependencyObjects = depSet.toArray();
                    return new CachedValueProvider.Result(result, dependencyObjects);
                }, false);
                project.putUserData(PERSISTENCE_UNITS_KEY, (Object)value);
            }
            if ((map = (Map)value.getValue()) == null) {
                List<PersistencePackage> list = Collections.emptyList();
                if (list == null) {
                    PersistenceModelBrowserImpl.$$$reportNull$$$0(20);
                }
                return list;
            }
            Collection units = (Collection)map.get(xmlFile);
            if (units == null) {
                List<PersistencePackage> list = Collections.emptyList();
                if (list == null) {
                    PersistenceModelBrowserImpl.$$$reportNull$$$0(21);
                }
                return list;
            }
            return new ArrayList<PersistencePackage>(units);
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public Query<PersistenceFacet> queryPersistenceFacets(PsiElement element) {
        if (element == null) {
            Query query = EmptyQuery.getEmptyQuery();
            if (query == null) {
                PersistenceModelBrowserImpl.$$$reportNull$$$0(22);
            }
            return query;
        }
        return new ExecutorsQuery((Object)element, Collections.singletonList((queryParameters, consumer) -> {
            Module module;
            PsiClass psiClass;
            PsiFile containingFile = element.getContainingFile();
            if (containingFile instanceof XmlFile) {
                DomElement rootElement;
                for (PersistenceFacet curFacet : PersistenceCommonUtil.getAllPersistenceFacets(element.getProject())) {
                    for (ConfigFile configFile : curFacet.getDescriptors()) {
                        if (!element.getManager().areElementsEquivalent((PsiElement)configFile.getPsiFile(), (PsiElement)containingFile) || consumer.process((Object)curFacet)) continue;
                        return false;
                    }
                    for (PersistencePackage persistencePackage : curFacet.getPersistenceUnits()) {
                        if (!element.getManager().areElementsEquivalent((PsiElement)persistencePackage.getContainingFile(), (PsiElement)containingFile) || consumer.process((Object)curFacet)) continue;
                        return false;
                    }
                }
                DomFileElement fileElement = DomManager.getDomManager((Project)element.getProject()).getFileElement((XmlFile)containingFile, DomElement.class);
                if (fileElement != null && (rootElement = fileElement.getRootElement()) instanceof PersistenceMappings) {
                    List<PersistencePackage> units = this.getPersistenceUnits((PersistenceMappings)rootElement);
                    for (PersistencePackage unit : units) {
                        if (ContainerUtil.process(this.getPersistenceFacets(unit), (Processor)consumer)) continue;
                        return false;
                    }
                }
            } else if (element.getLanguage() == StdFileTypes.JAVA.getLanguage() && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null) {
                PersistenceClassRole[] roles;
                for (PersistenceClassRole role : roles = PersistenceCommonUtil.getPersistenceRoles(psiClass)) {
                    if (consumer.process((Object)role.getFacet())) continue;
                    return false;
                }
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null) {
                List<PersistenceFacet> facets = PersistenceCommonUtil.getAllPersistenceFacets(module);
                return ContainerUtil.process(facets, (Processor)consumer);
            }
            return true;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/util/PersistenceModelBrowserImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "setRoleFilter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "queryTargetPersistentObjects";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "queryPersistenceListeners";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "queryPersistentObjects";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "queryTheOtherSideAttributes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/util/PersistenceModelBrowserImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceFacets";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "queryPersistenceFacets";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceFacets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttributeInfo {
        Map<PsiMember, Collection<PersistentAttribute>> memberAttributes;
        Map<PersistentObject, Collection<? extends PersistentAttribute>> objectAttributes;

        private AttributeInfo() {
        }
    }
}

