/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public enum JavaContainerType {
    MAP,
    SET,
    LIST,
    COLLECTION,
    ARRAY;


    public String getJavaBaseClassName() {
        switch (this) {
            case ARRAY: {
                return "java.lang.reflect.Array";
            }
            case COLLECTION: {
                return "java.util.Collection";
            }
            case LIST: {
                return "java.util.List";
            }
            case MAP: {
                return "java.util.Map";
            }
            case SET: {
                return "java.util.Set";
            }
        }
        throw new AssertionError();
    }

    public static boolean isCollection(@Nullable JavaContainerType containerType) {
        return containerType == LIST || containerType == SET || containerType == COLLECTION;
    }

    public static boolean isCollectionOrMap(@Nullable JavaContainerType containerType) {
        return containerType == LIST || containerType == SET || containerType == COLLECTION || containerType == MAP;
    }

    public PsiType createCollectionType(PsiElement context, PsiType elementType, @Nullable PsiType mapKeyType) throws IncorrectOperationException {
        return JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeFromText(this.getCollectionTypeText(PsiUtil.isLanguageLevel5OrHigher((PsiElement)context), elementType == null ? null : elementType.getCanonicalText(), mapKeyType == null ? null : mapKeyType.getCanonicalText()), context);
    }

    public String getCollectionTypeText(boolean generics, String elementTypeName, String mapKeyType) {
        String text;
        boolean useGenerics = generics && StringUtil.isNotEmpty((String)elementTypeName);
        switch (this) {
            case ARRAY: {
                text = elementTypeName + "[]";
                break;
            }
            case COLLECTION: {
                text = "java.util.Collection" + (String)(!useGenerics ? "" : "<" + elementTypeName + ">");
                break;
            }
            case LIST: {
                text = "java.util.List" + (String)(!useGenerics ? "" : "<" + elementTypeName + ">");
                break;
            }
            case MAP: {
                text = "java.util.Map" + (String)(!useGenerics ? "" : "<" + (mapKeyType == null ? "java.lang.Object" : mapKeyType) + ", " + elementTypeName + ">");
                break;
            }
            case SET: {
                text = "java.util.Set" + (String)(!useGenerics ? "" : "<" + elementTypeName + ">");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return text;
    }
}

