/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.diagram;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DefaultUserResponse;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.diagram.PersistenceDiagram;
import com.intellij.persistence.diagram.PersistenceDiagramSupport;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.PersistentSuperclass;
import com.intellij.persistence.model.PersistentTransientAttribute;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDiagramSupport
implements PersistenceDiagramSupport<PersistencePackage, PersistentObject, PersistentAttribute> {
    private Map<PsiClass, PersistentObject> myClassMap;
    private Collection<PersistentObject> myPersistentObjects;
    private final PersistenceFacet myFacet;
    private PersistenceModelBrowser myModelBrowser;

    public DefaultDiagramSupport(PersistenceFacet facet) {
        this.myFacet = facet;
    }

    public PersistenceFacet getFacet() {
        return this.myFacet;
    }

    @Override
    public ModificationTracker getModificationTracker(PersistencePackage unit) {
        return this.myFacet.getModificationTracker();
    }

    @Override
    public void startDataModelUpdate(PersistencePackage persistencePackage) {
        this.myModelBrowser = PersistenceCommonUtil.createFacetAndUnitModelBrowser(this.myFacet, persistencePackage, null);
        if (persistencePackage == null || !persistencePackage.isValid()) {
            this.myPersistentObjects = Collections.emptyList();
            this.myClassMap = Collections.emptyMap();
        } else {
            PersistenceMappings entityMappings = this.myFacet.getEntityMappings(persistencePackage);
            this.startDataModelUpdate(entityMappings);
        }
    }

    @Override
    public void startDataModelUpdate(PersistenceMappings entityMappings) {
        this.myPersistentObjects = PersistenceCommonUtil.queryPersistentObjects(entityMappings).findAll();
        this.myClassMap = new HashMap<PsiClass, PersistentObject>();
        for (PersistentObject persistentObject : this.myPersistentObjects) {
            PsiClass psiClass = (PsiClass)persistentObject.getClazz().getValue();
            if (psiClass == null) continue;
            this.myClassMap.put(psiClass, persistentObject);
        }
    }

    @Override
    public void finishDataModelUpdate() {
        this.myPersistentObjects = null;
        this.myClassMap = null;
    }

    public PersistenceModelBrowser getModelBrowser() {
        return this.myModelBrowser;
    }

    @Override
    public void processEntities(PairProcessor<? super PersistentObject, String> pairProcessor, boolean superclasses, boolean embeddables) {
        for (PersistentObject object : this.myPersistentObjects) {
            PsiClass psiClass;
            if (!superclasses && object instanceof PersistentSuperclass || !embeddables && object instanceof PersistentEmbeddable || pairProcessor.process((Object)object, (Object)((psiClass = (PsiClass)object.getClazz().getValue()) == null ? object.getClazz().getStringValue() : psiClass.getQualifiedName()))) continue;
            return;
        }
    }

    @Override
    public void processSuper(PersistentObject sourceEntity, PairProcessor<? super PersistentObject, String> pairProcessor) {
        PsiClass psiClass = (PsiClass)sourceEntity.getClazz().getValue();
        if (psiClass == null) {
            return;
        }
        for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass.getSuperClass())) {
            PersistentObject superObject = this.myClassMap.get(curClass);
            if (superObject == null || pairProcessor.process((Object)superObject, (Object)curClass.getQualifiedName())) continue;
            return;
        }
    }

    @Override
    public void processRelated(PersistentObject sourceEntity, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : sourceEntity.getObjectModelHelper().getAttributes()) {
            PersistentRelationshipAttribute attribute;
            PsiClass psiClass;
            if (!(persistentAttribute instanceof PersistentRelationshipAttribute) || pairProcessor.process((Object)persistentAttribute, (Object)((psiClass = PersistenceCommonUtil.getTargetClass(attribute = (PersistentRelationshipAttribute)persistentAttribute)) == null ? attribute.getTargetEntityClass().getStringValue() : psiClass.getQualifiedName()))) continue;
            return;
        }
    }

    @Override
    public void processEmbedded(PersistentObject sourceEntity, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : sourceEntity.getObjectModelHelper().getAttributes()) {
            PersistentEmbeddedAttribute attribute;
            PsiClass psiClass;
            if (!(persistentAttribute instanceof PersistentEmbeddedAttribute) || pairProcessor.process((Object)persistentAttribute, (Object)((psiClass = PersistenceCommonUtil.getTargetClass(attribute = (PersistentEmbeddedAttribute)persistentAttribute)) == null ? attribute.getTargetEmbeddableClass().getStringValue() : psiClass.getQualifiedName()))) continue;
            return;
        }
    }

    @Override
    public void processAttributes(PersistentObject persistentObject, PairProcessor<? super PersistentAttribute, String> pairProcessor) {
        for (PersistentAttribute persistentAttribute : persistentObject.getObjectModelHelper().getAttributes()) {
            if (persistentAttribute instanceof PersistentTransientAttribute || persistentAttribute instanceof PersistentRelationshipAttribute || persistentAttribute instanceof PersistentEmbeddedAttribute || pairProcessor.process((Object)persistentAttribute, (Object)((String)persistentAttribute.getName().getValue()))) continue;
            return;
        }
    }

    @Override
    @Nullable
    public PersistentObject getAttributeTarget(PersistentAttribute persistentAttribute) {
        if (persistentAttribute instanceof PersistentRelationshipAttribute) {
            return (PersistentObject)this.myModelBrowser.queryTargetPersistentObjects((PersistentRelationshipAttribute)persistentAttribute).findFirst();
        }
        if (persistentAttribute instanceof PersistentEmbeddedAttribute) {
            return (PersistentObject)this.myModelBrowser.queryTargetPersistentObjects((PersistentEmbeddedAttribute)persistentAttribute).findFirst();
        }
        return null;
    }

    @Override
    public String getUniqueId(PersistentObject persistentObject) {
        return PersistenceCommonUtil.getUniqueId(persistentObject == null ? null : persistentObject.getIdentifyingPsiElement());
    }

    @Override
    @Nullable
    public PersistentAttribute getInverseSideAttribute(PersistentAttribute persistentAttribute) {
        assert (persistentAttribute instanceof PersistentRelationshipAttribute);
        return (PersistentAttribute)this.myModelBrowser.queryTheOtherSideAttributes((PersistentRelationshipAttribute)persistentAttribute, false).findFirst();
    }

    @Override
    @Nullable
    public String getAttributeName(PersistentAttribute persistentAttribute) {
        return (String)persistentAttribute.getName().getValue();
    }

    @Override
    @Nullable
    public PsiType getAttributePsiType(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getPsiType();
    }

    @Override
    @NonNls
    @NotNull
    public String getEntityTypeName(PersistentObject persistentObject) {
        String string = ElementPresentationManager.getTypeNameForObject((Object)persistentObject);
        if (string == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getAttributeTypeName(PersistentAttribute persistentAttribute) {
        String string = ElementPresentationManager.getTypeNameForObject((Object)persistentAttribute);
        if (string == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isIdAttribute(PersistentAttribute persistentAttribute) {
        return persistentAttribute.getAttributeModelHelper().isIdAttribute();
    }

    @Override
    @NotNull
    public String getAttributeMultiplicityLabel(PersistentAttribute first, PersistentAttribute second, boolean isSource) {
        assert (first instanceof PersistentRelationshipAttribute && (second == null || second instanceof PersistentRelationshipAttribute));
        PersistentRelationshipAttribute attribute = (PersistentRelationshipAttribute)first;
        boolean many = attribute.getAttributeModelHelper().getRelationshipType().isMany(isSource);
        boolean optional = attribute.getAttributeModelHelper().isRelationshipSideOptional(isSource) && !this.isNotNull((PersistentRelationshipAttribute)second);
        String string = PersistenceCommonUtil.getMultiplicityString(optional, many);
        if (string == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(2);
        }
        return string;
    }

    private boolean isNotNull(PersistentRelationshipAttribute attribute) {
        PsiMember owner = attribute == null ? null : attribute.getPsiMember();
        return owner != null && NullableNotNullManager.isNotNull((PsiModifierListOwner)owner);
    }

    @Override
    @Nullable
    public Icon getEntityIcon(PersistentObject persistentObject) {
        return ElementPresentationManager.getIcon((Object)persistentObject);
    }

    @Override
    @Nullable
    public Icon getAttributeIcon(PersistentAttribute persistentAttribute, boolean forceId) {
        return ElementPresentationManager.getIcon((Object)persistentAttribute);
    }

    @Override
    @NotNull
    public DataProvider createDataProvider(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        DataProvider dataProvider = dataId -> this.getData(diagram, dataId);
        if (dataProvider == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(3);
        }
        return dataProvider;
    }

    @Nullable
    protected Object getData(@NotNull PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, @NotNull String dataId) {
        Collection<CommonModelElement> elements;
        if (diagram == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(4);
        }
        if (dataId == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(5);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return diagram.getProject();
        }
        if (PersistenceDataKeys.PERSISTENCE_FACET.is(dataId)) {
            return this.myFacet;
        }
        if (PersistenceDataKeys.PERSISTENCE_UNIT.is(dataId)) {
            return diagram.getUnit();
        }
        if (!diagram.getUnit().isValid()) {
            return null;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            return diagram.getUnit().getModule();
        }
        if (PersistenceDataKeys.MODEL_ELEMENT_CONTEXT.is(dataId)) {
            return diagram.getSelectedEntity() != null ? diagram.getSelectedEntity() : diagram.getUnit();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<CommonModelElement> elements2 = this.getSelectedElements(diagram);
            if (!elements2.isEmpty()) {
                HashSet result = new HashSet();
                for (CommonModelElement element : elements2) {
                    PsiElement psiElement = element.getIdentifyingPsiElement();
                    ContainerUtil.addIfNotNull(result, (Object)psiElement);
                }
                return PsiUtilCore.toPsiElementArray(result);
            }
            return null;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Collection<CommonModelElement> elements3 = this.getSelectedElements(diagram);
            if (!elements3.isEmpty()) {
                return new JamDeleteProvider((JamUserResponse)new DefaultUserResponse(diagram.getProject()), elements3);
            }
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId) && !(elements = this.getSelectedElements(diagram)).isEmpty()) {
            HashSet<Navigatable> result = new HashSet<Navigatable>();
            for (CommonModelElement element : elements) {
                PsiFile containingFile;
                VirtualFile file;
                PsiElement psiElement = element.getIdentifyingPsiElement();
                if (psiElement instanceof Navigatable) {
                    result.add((Navigatable)psiElement);
                    continue;
                }
                if (psiElement == null || (file = (containingFile = psiElement.getContainingFile()) == null ? null : containingFile.getVirtualFile()) == null) continue;
                result.add(PsiNavigationSupport.getInstance().createNavigatable(psiElement.getProject(), file, psiElement.getTextOffset()));
            }
            return result.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        return null;
    }

    private Collection<CommonModelElement> getSelectedElements(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        HashSet<CommonModelElement> elements = new HashSet<CommonModelElement>();
        diagram.processSelectedNodes((PairProcessor<PersistentObject, String>)((PairProcessor)(persistentObject, persistentAttribute) -> {
            ContainerUtil.addIfNotNull((Collection)elements, (Object)persistentObject);
            return true;
        }));
        diagram.processSelectedEdges((PairProcessor<PersistentObject, PersistentAttribute>)((PairProcessor)(persistentObject, persistentAttribute) -> {
            ContainerUtil.addIfNotNull((Collection)elements, (Object)persistentAttribute);
            if (persistentAttribute instanceof PersistentRelationshipAttribute) {
                elements.addAll(this.myModelBrowser.queryTheOtherSideAttributes((PersistentRelationshipAttribute)persistentAttribute, false).findAll());
            }
            return true;
        }));
        return elements;
    }

    @Override
    public boolean processEditNode(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram, PersistentObject entity) {
        return false;
    }

    @Override
    public boolean processEditEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram) {
        return false;
    }

    @Override
    public void processCreateEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram, PersistentObject sourceEntity, PersistentObject targetEntity) {
    }

    @Override
    public void customizeGraphView(Graph2DView view, EditMode editMode) {
    }

    public static void initUpdateListenerOnFacet(final @NotNull GraphBuilder builder, @NotNull Facet facet) {
        if (builder == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(6);
        }
        if (facet == null) {
            DefaultDiagramSupport.$$$reportNull$$$0(7);
        }
        FacetModificationTrackingService.getInstance((Facet)facet).addModificationTrackerListener(facet, (ModificationTrackerListener)new ModificationTrackerListener<Facet>(){

            public void modificationCountChanged(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (builder.getView().getJComponent().isShowing()) {
                    builder.queueUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/persistence/diagram/DefaultDiagramSupport$1", "modificationCountChanged"));
            }
        }, (Disposable)builder);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (builder.getView().getJComponent().isShowing()) {
                    builder.queueUpdate();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/persistence/diagram/DefaultDiagramSupport$2", "documentChanged"));
            }
        }, (Disposable)builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/persistence/diagram/DefaultDiagramSupport";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagram";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityTypeName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeTypeName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeMultiplicityLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/persistence/diagram/DefaultDiagramSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initUpdateListenerOnFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

