/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence;

import com.intellij.persistence.model.manipulators.ManipulatorsRegistry;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import com.intellij.persistence.model.manipulators.PersistenceManipulator;
import com.intellij.persistence.model.manipulators.PersistenceManipulatorsProvider;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ManipulatorsRegistryImpl
implements ManipulatorsRegistry {
    private final ModelMerger myModelMerger = DomService.getInstance().createModelMerger();

    public ManipulatorsRegistryImpl() {
        this.myModelMerger.addInvocationStrategy(PersistenceAction.class, (ModelMerger.InvocationStrategy)new ModelMerger.InvocationStrategy<PersistenceAction>(){

            public boolean accepts(Method method) {
                return PersistenceAction.class.equals(method.getDeclaringClass()) && Void.TYPE.equals(method.getReturnType());
            }

            public Object invokeMethod(JavaMethod method, PersistenceAction proxy, Object[] args, List<? extends PersistenceAction> implementations) {
                for (PersistenceAction persistenceAction : implementations) {
                    if (!persistenceAction.getPresentation().isEnabled()) continue;
                    method.invoke((Object)persistenceAction, args);
                }
                return null;
            }
        });
        this.myModelMerger.addInvocationStrategy(PersistenceAction.class, (ModelMerger.InvocationStrategy)new ModelMerger.InvocationStrategy<PersistenceAction>(){

            public boolean accepts(Method method) {
                return PersistenceAction.class.equals(method.getDeclaringClass()) && Boolean.TYPE.equals(method.getReturnType());
            }

            public Object invokeMethod(JavaMethod method, PersistenceAction proxy, Object[] args, List<? extends PersistenceAction> implementations) {
                boolean result = true;
                for (PersistenceAction persistenceAction : implementations) {
                    if (!persistenceAction.getPresentation().isEnabled()) continue;
                    Object o = method.invoke((Object)persistenceAction, args);
                    result = result && Boolean.TRUE.equals(o);
                }
                return result;
            }
        });
        this.myModelMerger.addMergingStrategy(PersistenceAction.class, (ModelMerger.MergingStrategy)new ModelMerger.MergingStrategy<PersistenceAction>(){

            public PersistenceAction mergeChildren(Class<PersistenceAction> type, List<? extends PersistenceAction> implementations) {
                return (PersistenceAction)ManipulatorsRegistryImpl.this.myModelMerger.mergeModels(type, implementations);
            }
        });
    }

    @Override
    public <N extends PersistenceManipulator> N getManipulator(Object element, Class<N> manipulatorClass) {
        HashSet manipulators = new HashSet();
        List implementations = ModelMergerUtil.getFilteredImplementations((Object)element);
        for (Object v : implementations) {
            ManipulatorsRegistryImpl.getManipulatorsInternal(v, manipulatorClass, manipulators);
        }
        return (N)(manipulators.isEmpty() ? null : (PersistenceManipulator)this.myModelMerger.mergeModels(manipulatorClass, manipulators));
    }

    private static <T, V extends T> void getManipulatorsInternal(Object element, Class<V> manipulatorClass, Collection<T> manipulators) {
        Class<?> thisClass = element.getClass();
        for (PersistenceManipulatorsProvider manipulatorsProvider : PersistenceManipulatorsProvider.EP_NAME.getExtensionList()) {
            for (Map.Entry<Class<?>, Class<PersistenceManipulator<?>>> entry : manipulatorsProvider.getManipulators().entrySet()) {
                PersistenceManipulator<?> manipulator;
                if (!ReflectionUtil.isAssignable(entry.getKey(), thisClass) || (manipulator = ManipulatorsRegistryImpl.getManipulator(entry.getValue(), element)) == null || !ReflectionUtil.isAssignable(manipulatorClass, manipulator.getClass())) continue;
                manipulators.add(manipulator);
            }
        }
    }

    @Nullable
    private static PersistenceManipulator<?> getManipulator(@NotNull Class<? extends PersistenceManipulator<?>> aClass, Object element) {
        if (aClass == null) {
            ManipulatorsRegistryImpl.$$$reportNull$$$0(0);
        }
        try {
            Constructor<?> constructor = aClass.getConstructors()[0];
            return (PersistenceManipulator)constructor.newInstance(element);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            ExceptionUtil.rethrowUnchecked((Throwable)cause);
            assert (false) : cause;
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            assert (false) : e;
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/persistence/ManipulatorsRegistryImpl", "getManipulator"));
    }
}

