/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder.psd;

import com.android.tools.chunkio.ChunkIO;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.decoder.psd.PsdFile;
import com.android.tools.pixelprobe.decoder.psd.PsdImage;
import java.io.IOException;
import java.io.InputStream;

public final class PsdDecoder
extends Decoder {
    public PsdDecoder() {
        super("psd", "photoshop");
    }

    @Override
    public boolean accept(InputStream in) {
        try {
            return ChunkIO.read((InputStream)in, PsdFile.Header.class) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public Image decode(InputStream in, Decoder.Options options) throws IOException {
        try {
            PsdFile psd = (PsdFile)ChunkIO.read((InputStream)in, PsdFile.class);
            return PsdImage.from(psd, options);
        }
        catch (Throwable t) {
            throw new IOException("Error while decoding PSD stream", t);
        }
    }
}

