/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.javaee.oss.jboss.server.JBossExtensions;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.supportProvider.AppServerSupportContributor;
import com.intellij.javaee.ui.packaging.ExplodedEarArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedEjbArtifactType;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossServerSupportContributor
extends AppServerSupportContributor<JBossLocalModel> {
    @NonNls
    public static final String DEFAULT_SERVER = "default";
    private JBossContributionsProvider<ServerSupportContribution> myContributionsProvider;

    public JBossServerSupportContributor() {
        super(JBossLocalModel.class);
        this.init();
    }

    private void init() {
        this.myContributionsProvider = new JBossContributionsProvider<ServerSupportContribution>(ServerSupportContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new ServerSupportContribution(){

            @Override
            public void setupRunConfiguration(JBossLocalModel serverModel) {
                JBossServerSupportContributor.selectDefaultServer(serverModel);
            }
        });
    }

    protected void performSetup(@NotNull JBossLocalModel serverModel, @NotNull AppServerSupportContributor.SetupSubject setupSubject) {
        if (serverModel == null) {
            JBossServerSupportContributor.$$$reportNull$$$0(0);
        }
        if (setupSubject == null) {
            JBossServerSupportContributor.$$$reportNull$$$0(1);
        }
        super.performSetup((ServerModel)serverModel, setupSubject);
        serverModel.getContribution(this.myContributionsProvider).setupRunConfiguration(serverModel);
        for (ArtifactType nextType : JBossServerSupportContributor.explodedTypes()) {
            JBossServerSupportContributor.setCorrectExtension(setupSubject.findModifiableArtifactOfType(nextType));
        }
    }

    private static void setCorrectExtension(@Nullable ModifiableArtifact artifact) {
        if (artifact == null) {
            return;
        }
        String outputPath = artifact.getOutputPath();
        if (outputPath == null) {
            return;
        }
        JBossExtensions extensions = JBossExtensions.getInstance();
        String extension = FileUtilRt.getExtension((String)PathUtil.getFileName((String)outputPath));
        if (!extensions.isValidExtension(artifact.getArtifactType(), extension)) {
            artifact.setOutputPath(outputPath + "." + extensions.getDefaultExtension(artifact.getArtifactType()));
        }
    }

    private static void selectDefaultServer(JBossLocalModel jBossModel) {
        if (new File(jBossModel.getServersDirectory(), DEFAULT_SERVER).isDirectory()) {
            jBossModel.SERVER = DEFAULT_SERVER;
        } else {
            File[] children;
            for (File child : children = jBossModel.getServersDirectory().listFiles()) {
                if (!child.isDirectory()) continue;
                jBossModel.SERVER = child.getName();
                break;
            }
        }
    }

    private static ArtifactType[] explodedTypes() {
        return new ArtifactType[]{ExplodedEarArtifactType.getInstance(), ExplodedEjbArtifactType.getInstance(), ExplodedWarArtifactType.getInstance()};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "serverModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "setupSubject";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/oss/jboss/server/JBossServerSupportContributor";
        objectArray[2] = "performSetup";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface ServerSupportContribution
    extends JBossVersionContribution {
        public void setupRunConfiguration(JBossLocalModel var1);
    }
}

