/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.oss.descriptor.JavaeeResources;
import com.intellij.javaee.oss.util.FileWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xml.index.XsdNamespaceBuilder;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JBossResources
extends JavaeeResources {
    private static final Pattern JBOSS7_DEPLOYMENT_STRUCTURE_FILENAME = Pattern.compile("jboss-deployment-structure-(\\d)_(\\d)\\.xsd");

    @NotNull
    protected String getResourceUri(FileWrapper file) throws Exception {
        String fileName = file.getName();
        Matcher matcher = JBOSS7_DEPLOYMENT_STRUCTURE_FILENAME.matcher(fileName);
        if (matcher.matches()) {
            String string = "urn:jboss:deployment-structure:" + matcher.group(1) + "." + matcher.group(2);
            if (string == null) {
                JBossResources.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (StringUtil.endsWith((CharSequence)fileName, (CharSequence)".dtd")) {
            String string = "http://www.jboss.org/j2ee/dtd/" + fileName;
            if (string == null) {
                JBossResources.$$$reportNull$$$0(1);
            }
            return string;
        }
        String namespace = XsdNamespaceBuilder.computeNamespace((InputStream)file.getStream());
        return namespace != null ? namespace + "/" + fileName : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/server/JBossResources", "getResourceUri"));
    }
}

