/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import runtime.text.BOM;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"detectBOM", "Lruntime/text/BOM;", "bytes", "", "fileContentToString", "", "isBinaryFileContent", "", "isControlChar", "ch", "", "platform-runtime"})
public final class FileContentKt {
    public static final boolean isBinaryFileContent(@NotNull byte[] bytes) {
        int n;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (FileContentKt.detectBOM(bytes) != null) {
            return false;
        }
        int controlChars = 0;
        for (byte by : bytes) {
            if (!FileContentKt.isControlChar(by)) continue;
            ++controlChars;
        }
        int n2 = bytes.length;
        if (n2 == 0) {
            return false;
        }
        boolean bl = 1 <= n2 ? n2 <= 255 : false;
        if (bl) {
            n = 1;
        } else {
            int n3 = bytes.length / 100;
            int n4 = 100;
            boolean bl2 = false;
            n = Math.min(n3, n4);
        }
        int threshold = n;
        return controlChars >= threshold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isControlChar(byte ch) {
        boolean bl;
        byte by = ch;
        if (0 <= by) {
            if (by <= 7) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        by = ch;
        if (14 > by) return false;
        if (by > 25) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static final BOM detectBOM(byte[] bytes) {
        block7: {
            $this$firstOrNull$iv = BOM.values();
            $i$f$firstOrNull = false;
            var3_3 = $this$firstOrNull$iv;
            var4_4 = var3_3.length;
            for (var5_5 = 0; var5_5 < var4_4; ++var5_5) {
                block6: {
                    bom = element$iv = var3_3[var5_5];
                    $i$a$-firstOrNull-FileContentKt$detectBOM$1 = false;
                    if (bytes.length < bom.getBom().length) ** GOTO lbl-1000
                    $this$all$iv = (Iterable)ArraysKt.getIndices((byte[])bom.getBom());
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v0 = true;
                    } else {
                        var11_11 = $this$all$iv.iterator();
                        while (var11_11.hasNext()) {
                            it = element$iv = ((IntIterator)var11_11).nextInt();
                            $i$a$-all-FileContentKt$detectBOM$1$1 = false;
                            if (bom.getBom()[it] == bytes[it]) continue;
                            v0 = false;
                            break block6;
                        }
                        v0 = true;
                    }
                }
                if (v0) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        return v2;
    }

    @NotNull
    public static final String fileContentToString(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        BOM bom = FileContentKt.detectBOM(bytes);
        if (bom != null) {
            int n = bom.getBom().length;
            int n2 = bytes.length - bom.getBom().length;
            Charset charset = bom.getCharset();
            boolean bl = false;
            return new String(bytes, n, n2, charset);
        }
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        return new String(bytes, charset);
    }
}

