/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import libraries.coroutines.extra.Lifetimed;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.ComputedKt;
import runtime.reactive.FailuresHandler;
import runtime.reactive.LoadingContext;
import runtime.reactive.LoadingResultThrowable;
import runtime.reactive.LoadingValue;
import runtime.reactive.LoadingValueKt;
import runtime.reactive.Property;
import runtime.reactive.XTrackable;
import runtime.reactive.XTrackableLifetimed;
import runtime.reactive.XTrackableLifetimedLoading;
import runtime.reactive.XTrackableLoading;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a3\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00040\b\u00a2\u0006\u0002\b\n\u001aF\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0004\"\b\b\u0001\u0010\f*\u00020\t*\u0002H\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u00040\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\r\u001a6\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00040\u000f\"\u0004\b\u0000\u0010\u0004*\u00020\u00102\u001c\u0010\u0011\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u000fj\b\u0012\u0004\u0012\u0002H\u0004`\u0012\u001a7\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0004*\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u00040\b\u00a2\u0006\u0002\b\n\u001a7\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0003\"\u0004\b\u0000\u0010\u0004*\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u00040\b\u00a2\u0006\u0002\b\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*(\u0010\u0017\u001a\u0004\b\u0000\u0010\u0004\"\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u00182\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u0018\u00a8\u0006\u0019"}, d2={"log", "Llibraries/klogging/KLogger;", "loading", "Lruntime/reactive/LoadingValue;", "T", "failuresHandler", "Lruntime/reactive/FailuresHandler;", "handler", "Lkotlin/Function1;", "Lruntime/reactive/LoadingContext;", "Lkotlin/ExtensionFunctionType;", "getResult", "TC", "(Lruntime/reactive/LoadingContext;Lruntime/reactive/FailuresHandler;Lkotlin/jvm/functions/Function1;)Lruntime/reactive/LoadingValue;", "lastLoadedValueOrNull", "Lruntime/reactive/Property;", "Llibraries/coroutines/extra/Lifetimed;", "prop", "Lruntime/reactive/LoadingProperty;", "Lruntime/reactive/XTrackable;", "Lruntime/reactive/XTrackableLoading;", "Lruntime/reactive/XTrackableLifetimed;", "Lruntime/reactive/XTrackableLifetimedLoading;", "LoadingComputed", "Lruntime/reactive/Computed;", "platform-runtime"})
public final class LoadingUtilsKt {
    @NotNull
    private static final KLogger log;

    @NotNull
    public static final <T, TC extends LoadingContext> LoadingValue<T> getResult(@NotNull TC $this$getResult, @NotNull FailuresHandler failuresHandler, @NotNull Function1<? super TC, ? extends T> handler) {
        LoadingValue loadingValue;
        Intrinsics.checkNotNullParameter($this$getResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)failuresHandler, (String)"failuresHandler");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        try {
            loadingValue = new LoadingValue.Loaded<Object>(handler.invoke($this$getResult));
        }
        catch (LoadingResultThrowable e) {
            LoadingValue result2 = e.getResult();
            if (result2 instanceof LoadingValue.Failure) {
                failuresHandler.handleFailure(((LoadingValue.Failure)result2).getError());
            }
            loadingValue = result2;
        }
        catch (Throwable e) {
            failuresHandler.handleFailure(e);
            loadingValue = new LoadingValue.Failure(e);
        }
        return loadingValue;
    }

    @NotNull
    public static final <T> LoadingValue<T> loading(@NotNull FailuresHandler failuresHandler, @NotNull Function1<? super LoadingContext, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)failuresHandler, (String)"failuresHandler");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return LoadingUtilsKt.getResult(new LoadingContext(), failuresHandler, handler);
    }

    @NotNull
    public static final <T> LoadingValue<T> loading(@NotNull XTrackable $this$loading, @NotNull FailuresHandler failuresHandler, @NotNull Function1<? super XTrackableLoading, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)$this$loading, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)failuresHandler, (String)"failuresHandler");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return LoadingUtilsKt.getResult((LoadingContext)new XTrackableLoading($this$loading), failuresHandler, handler);
    }

    @NotNull
    public static final <T> LoadingValue<T> loading(@NotNull XTrackableLifetimed $this$loading, @NotNull FailuresHandler failuresHandler, @NotNull Function1<? super XTrackableLifetimedLoading, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)$this$loading, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)failuresHandler, (String)"failuresHandler");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return LoadingUtilsKt.getResult((LoadingContext)new XTrackableLifetimedLoading($this$loading), failuresHandler, handler);
    }

    @NotNull
    public static final <T> Property<T> lastLoadedValueOrNull(@NotNull Lifetimed $this$lastLoadedValueOrNull, @NotNull Property<? extends LoadingValue<? extends T>> prop2) {
        Intrinsics.checkNotNullParameter((Object)$this$lastLoadedValueOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(prop2, (String)"prop");
        Ref.ObjectRef lastLoadedValue2 = new Ref.ObjectRef();
        lastLoadedValue2.element = LoadingValueKt.unsafeGetOrNull(prop2.getValue());
        return ComputedKt.computed($this$lastLoadedValueOrNull, (Function1)new Function1<XTrackableLifetimed, T>(prop2, lastLoadedValue2){
            final /* synthetic */ Property<LoadingValue<T>> $prop;
            final /* synthetic */ Ref.ObjectRef<T> $lastLoadedValue;
            {
                this.$prop = $prop;
                this.$lastLoadedValue = $lastLoadedValue;
                super(1);
            }

            @Nullable
            public final T invoke(@NotNull XTrackableLifetimed $this$computed) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)$this$computed, (String)"$this$computed");
                LoadingValue<T> value2 = $this$computed.getLive(this.$prop);
                if (value2 instanceof LoadingValue.Loading) {
                    object = this.$lastLoadedValue.element;
                } else if (value2 instanceof LoadingValue.Failure) {
                    object = this.$lastLoadedValue.element;
                } else if (value2 instanceof LoadingValue.Loaded) {
                    this.$lastLoadedValue.element = ((LoadingValue.Loaded)value2).getValue();
                    object = ((LoadingValue.Loaded)value2).getValue();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return (T)object;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$logger$iv;
        KLoggers kLoggers = KLoggers.INSTANCE;
        String fallbackName$iv = "LoadingUtils.kt";
        boolean $i$f$logger = false;
        log = $this$logger$iv.logger((Function0<String>)((Function0)new Function0<String>(fallbackName$iv){
            final /* synthetic */ String $fallbackName;
            {
                this.$fallbackName = $fallbackName;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$fallbackName;
            }
        }));
    }
}

