/*
 * Decompiled with CFR 0.152.
 */
package runtime.net;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import libraries.klogging.KLogger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchKt;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.net.WebSocket;
import runtime.net.WebSocketBinaryMessage;
import runtime.net.WebSocketFactoryKt;
import runtime.net.WebSocketJsonMessage;
import runtime.net.WebSocketListener;
import runtime.net.WebSocketMessage;
import runtime.net.WebSocketState;
import runtime.net.WebSocketTextMessage;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J \u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010 \u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001eH\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lruntime/net/JvmWebSocket;", "Lokhttp3/WebSocketListener;", "Lruntime/net/WebSocket;", "client", "Lokhttp3/OkHttpClient;", "request", "Lokhttp3/Request;", "listener", "Lruntime/net/WebSocketListener;", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lruntime/net/WebSocketListener;)V", "connectState", "Lruntime/net/WebSocketState;", "getConnectState", "()Lruntime/net/WebSocketState;", "stt", "getStt", "setStt", "(Lruntime/net/WebSocketState;)V", "ws", "Lokhttp3/WebSocket;", "getWs", "()Lokhttp3/WebSocket;", "cancel", "", "close", "onClosed", "webSocket", "code", "", "reason", "", "onClosing", "onFailure", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "bytes", "Lokio/ByteString;", "onOpen", "send", "message", "Lruntime/net/WebSocketMessage;", "Companion", "platform-runtime"})
public final class JvmWebSocket
extends okhttp3.WebSocketListener
implements WebSocket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebSocketListener listener;
    @NotNull
    private WebSocketState stt;
    @NotNull
    private final okhttp3.WebSocket ws;
    private static final int NORMAL_CLOSURE = 1000;

    public JvmWebSocket(@NotNull OkHttpClient client, @NotNull Request request, @NotNull WebSocketListener listener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
        this.stt = WebSocketState.CLOSED;
        okhttp3.WebSocket webSocket = client.newWebSocket(request, (okhttp3.WebSocketListener)this);
        Intrinsics.checkNotNullExpressionValue((Object)webSocket, (String)"client.newWebSocket(request, this)");
        this.ws = webSocket;
    }

    @NotNull
    public final WebSocketState getStt() {
        return this.stt;
    }

    public final void setStt(@NotNull WebSocketState webSocketState) {
        Intrinsics.checkNotNullParameter((Object)((Object)webSocketState), (String)"<set-?>");
        this.stt = webSocketState;
    }

    @NotNull
    public final okhttp3.WebSocket getWs() {
        return this.ws;
    }

    @Override
    @NotNull
    public WebSocketState getConnectState() {
        return this.stt;
    }

    @Override
    public void send(@NotNull WebSocketMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        WebSocketMessage webSocketMessage = message2;
        if (webSocketMessage instanceof WebSocketTextMessage) {
            this.ws.send(((WebSocketTextMessage)message2).getMessage());
        } else if (webSocketMessage instanceof WebSocketBinaryMessage) {
            byte[] byArray = ((WebSocketBinaryMessage)message2).getMessage();
            this.ws.send(ByteString.of((byte[])Arrays.copyOf(byArray, byArray.length)));
        } else if (webSocketMessage instanceof WebSocketJsonMessage) {
            this.ws.send(JsonDslKt.text(((WebSocketJsonMessage)message2).getJson()));
        }
    }

    public void onMessage(@NotNull okhttp3.WebSocket webSocket, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        JsonElement json = JsonDslKt.jsonElement(text2);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)DispatchKt.getUi(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, json, null){
            int label;
            final /* synthetic */ JvmWebSocket this$0;
            final /* synthetic */ JsonElement $json;
            {
                this.this$0 = $receiver;
                this.$json = $json;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JvmWebSocket.access$getListener$p(this.this$0).onMessage(this.this$0, new WebSocketJsonMessage(this.$json));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onMessage(@NotNull okhttp3.WebSocket webSocket, @NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)DispatchKt.getUi(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, bytes, null){
            int label;
            final /* synthetic */ JvmWebSocket this$0;
            final /* synthetic */ ByteString $bytes;
            {
                this.this$0 = $receiver;
                this.$bytes = $bytes;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        WebSocketListener webSocketListener = JvmWebSocket.access$getListener$p(this.this$0);
                        WebSocket webSocket = this.this$0;
                        byte[] byArray = this.$bytes.toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes.toByteArray()");
                        webSocketListener.onMessage(webSocket, new WebSocketBinaryMessage(byArray));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onFailure(@NotNull okhttp3.WebSocket webSocket, @NotNull Throwable t, @Nullable Response response2) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        KLogger this_$iv = WebSocketFactoryKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            Throwable throwable = t;
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "native web socket received onFailure";
            kLogger.trace(throwable, string);
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)DispatchKt.getUi(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, response2, null){
            int label;
            final /* synthetic */ JvmWebSocket this$0;
            final /* synthetic */ Response $response;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.setStt(WebSocketState.CLOSED);
                        if (this.$response != null) {
                            JvmWebSocket.access$getListener$p(this.this$0).onFailure(this.this$0, this.$response.code());
                        } else {
                            this.this$0.close();
                            JvmWebSocket.access$getListener$p(this.this$0).onConnectionClosed(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onClosed(@NotNull okhttp3.WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        KLogger this_$iv = WebSocketFactoryKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "native web socket received onClosed, " + code + ' ' + reason;
            kLogger.trace(string);
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)DispatchKt.getUi(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JvmWebSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.setStt(WebSocketState.CLOSED);
                        JvmWebSocket.access$getListener$p(this.this$0).onConnectionClosed(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void onClosing(@NotNull okhttp3.WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        KLogger this_$iv = WebSocketFactoryKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "native web socket received onClosing, " + code + ' ' + reason;
            kLogger.trace(string);
        }
        this.ws.close(1000, Intrinsics.stringPlus((String)"Connection closed by peer: ", (Object)code));
    }

    public void onOpen(@NotNull okhttp3.WebSocket webSocket, @NotNull Response response2) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        KLogger this_$iv = WebSocketFactoryKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "native web socket received onOpen";
            kLogger.trace(string);
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)DispatchKt.getUi(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JvmWebSocket this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.setStt(WebSocketState.OPEN);
                        JvmWebSocket.access$getListener$p(this.this$0).onConnectionOpen(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void close() {
        KLogger this_$iv = WebSocketFactoryKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "closing native web socket";
            kLogger.trace(string);
        }
        this.ws.close(1000, null);
    }

    @Override
    public void cancel() {
        KLogger this_$iv = WebSocketFactoryKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "cancelling native web socket";
            kLogger.trace(string);
        }
        this.ws.cancel();
    }

    public static final /* synthetic */ WebSocketListener access$getListener$p(JvmWebSocket $this) {
        return $this.listener;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lruntime/net/JvmWebSocket$Companion;", "", "()V", "NORMAL_CLOSURE", "", "platform-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

