/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.ComponentContainer;
import runtime.container.ComponentResolveContext;
import runtime.container.Container;
import runtime.container.DynamicComponentDescriptor;
import runtime.container.JvmTypeBasedComponentDescriptor;
import runtime.container.JvmTypeBasedComponentStorage;
import runtime.container.LifetimeSourceDescriptor;
import runtime.container.ListDescriptor;
import runtime.container.MaybeDescriptor;
import runtime.container.OptionalDescriptor;
import runtime.container.ReadOnlyJvmTypeBasedComponentStorage;
import runtime.container.ValueDescriptor;
import runtime.container.ValueResolveContext;
import runtime.reactive.Maybe;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0 H\u0002\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u00020\u00002\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u001a\u0010&\u001a\u0004\u0018\u00010\u001c2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0$2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0$2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0010\u0010+\u001a\u00020,*\u0006\u0012\u0002\b\u00030-H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006."}, d2={"Lruntime/container/StorageComponentContainer;", "Lruntime/container/ComponentContainer;", "Lruntime/container/Container;", "Ljava/io/Closeable;", "id", "", "parent", "(Ljava/lang/String;Lruntime/container/Container;)V", "componentStorage", "Lruntime/container/JvmTypeBasedComponentStorage;", "getId", "()Ljava/lang/String;", "getParent", "()Lruntime/container/Container;", "unknownContext", "Lruntime/container/ComponentResolveContext;", "getUnknownContext", "()Lruntime/container/ComponentResolveContext;", "unknownContext$delegate", "Lkotlin/Lazy;", "close", "", "compose", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "createResolveContext", "Lruntime/container/ValueResolveContext;", "requestingDescriptor", "Lruntime/container/ValueDescriptor;", "getSingleUpperBoundOrNull", "Ljava/lang/reflect/Type;", "typeArguments", "", "([Ljava/lang/reflect/Type;)Ljava/lang/reflect/Type;", "registerDescriptors", "descriptors", "", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "resolve", "request", "context", "resolveMultiple", "typesList", "isNotEmpty", "", "", "platform-runtime"})
public final class StorageComponentContainer
implements ComponentContainer,
Container,
Closeable {
    @NotNull
    private final String id;
    @Nullable
    private final Container parent;
    @NotNull
    private final Lazy unknownContext$delegate;
    @NotNull
    private final JvmTypeBasedComponentStorage componentStorage;

    public StorageComponentContainer(@NotNull String id, @Nullable Container parent) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.parent = parent;
        this.unknownContext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ComponentResolveContext>(this){
            final /* synthetic */ StorageComponentContainer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ComponentResolveContext invoke() {
                return new ComponentResolveContext(this.this$0, DynamicComponentDescriptor.INSTANCE);
            }
        }));
        this.componentStorage = new JvmTypeBasedComponentStorage(this.getId());
    }

    public /* synthetic */ StorageComponentContainer(String string, Container container, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            container = null;
        }
        this(string, container);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public final Container getParent() {
        return this.parent;
    }

    private final ComponentResolveContext getUnknownContext() {
        Lazy lazy = this.unknownContext$delegate;
        boolean bl = false;
        return (ComponentResolveContext)lazy.getValue();
    }

    @Override
    @NotNull
    public ValueResolveContext createResolveContext(@NotNull ValueDescriptor requestingDescriptor) {
        Intrinsics.checkNotNullParameter((Object)requestingDescriptor, (String)"requestingDescriptor");
        if (Intrinsics.areEqual((Object)requestingDescriptor, (Object)DynamicComponentDescriptor.INSTANCE)) {
            return this.getUnknownContext();
        }
        return new ComponentResolveContext(this, requestingDescriptor);
    }

    @NotNull
    public final Container compose(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        AtomicReference<Closeable> closeable = new AtomicReference<Closeable>(this);
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(closeable){
            final /* synthetic */ AtomicReference<Closeable> $closeable;
            {
                this.$closeable = $closeable;
                super(0);
            }

            public final void invoke() {
                this.$closeable.get().close();
            }
        }));
        this.componentStorage.compose(this.getUnknownContext());
        ReadOnlyJvmTypeBasedComponentStorage result2 = new ReadOnlyJvmTypeBasedComponentStorage(this.componentStorage, this.parent, null, 4, null);
        closeable.set(() -> StorageComponentContainer.compose$lambda-0(result2));
        return result2;
    }

    @Override
    public void close() {
        this.componentStorage.dispose();
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Container container;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ValueResolveContext resolveContext = Intrinsics.areEqual((Object)context2, (Object)ValueResolveContext.Companion.getDefault()) ? (ValueResolveContext)this.getUnknownContext() : context2;
        ValueDescriptor storageResolve = this.componentStorage.resolve(request, resolveContext);
        if (storageResolve != null) {
            return storageResolve;
        }
        if (Intrinsics.areEqual((Object)request.getTypeName(), (Object)Lifetime.class.getTypeName())) {
            return new LifetimeSourceDescriptor(new LifetimeSource());
        }
        if (request instanceof ParameterizedType) {
            Type type;
            Type[] typeArguments = ((ParameterizedType)request).getActualTypeArguments();
            Type rawType = ((ParameterizedType)request).getRawType();
            if (Intrinsics.areEqual((Object)rawType, Iterable.class) || Intrinsics.areEqual((Object)rawType, Collection.class) || Intrinsics.areEqual((Object)rawType, List.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)typeArguments, (String)"typeArguments");
                type = this.getSingleUpperBoundOrNull(typeArguments);
                if (type != null) {
                    Type type2 = type;
                    boolean bl = false;
                    boolean bl2 = false;
                    Type it = type2;
                    boolean bl3 = false;
                    return new ListDescriptor(this.typesList(it, resolveContext));
                }
            }
            if (Intrinsics.areEqual((Object)rawType, Optional.class) && typeArguments.length == 1) {
                type = typeArguments[0];
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"typeArguments[0]");
                return new OptionalDescriptor(this.componentStorage.resolve(type, resolveContext));
            }
            if (Intrinsics.areEqual((Object)rawType, Maybe.class)) {
                Intrinsics.checkNotNullExpressionValue((Object)typeArguments, (String)"typeArguments");
                type = this.getSingleUpperBoundOrNull(typeArguments);
                if (type != null) {
                    Type type3 = type;
                    boolean bl = false;
                    boolean bl4 = false;
                    Type it = type3;
                    boolean bl5 = false;
                    return new MaybeDescriptor(this.componentStorage.resolve(it, resolveContext));
                }
            }
        }
        return (container = this.parent) == null ? null : container.resolve(request, resolveContext);
    }

    private final Type getSingleUpperBoundOrNull(Type[] typeArguments) {
        if (typeArguments.length == 1) {
            Type iterableTypeArgument = typeArguments[0];
            if (iterableTypeArgument instanceof WildcardType) {
                Type[] upperBounds = ((WildcardType)iterableTypeArgument).getUpperBounds();
                if (upperBounds.length == 1) {
                    return upperBounds[0];
                }
            } else if (iterableTypeArgument instanceof Class) {
                return iterableTypeArgument;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.typesList(request, context2);
    }

    @Override
    @NotNull
    public List<ValueDescriptor> typesList(@NotNull Type request, @NotNull ValueResolveContext context2) {
        List<ValueDescriptor> list;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List<ValueDescriptor> types2 = this.componentStorage.resolveMultiple(request, context2);
        if (this.isNotEmpty((Iterable)types2)) {
            list = types2;
        } else {
            Container container = this.parent;
            List<ValueDescriptor> list2 = container == null ? null : container.typesList(request, context2);
            list = list2 == null ? CollectionsKt.emptyList() : list2;
        }
        return list;
    }

    private final boolean isNotEmpty(Iterable<?> $this$isNotEmpty) {
        return $this$isNotEmpty.iterator().hasNext();
    }

    @NotNull
    public final StorageComponentContainer registerDescriptors(@NotNull List<? extends JvmTypeBasedComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        this.componentStorage.registerDescriptors(descriptors);
        return this;
    }

    private static final void compose$lambda-0(ReadOnlyJvmTypeBasedComponentStorage $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.dispose();
    }
}

