/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.ComponentState;
import runtime.container.ContainerConsistencyException;
import runtime.container.Disposable;
import runtime.container.SingletonDescriptor;
import runtime.container.ValueDescriptor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\fH\u0002J\b\u0010\u001c\u001a\u00020\fH$J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0002H\u0004R+\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0005j\b\u0012\u0004\u0012\u00020\u0002`\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lruntime/container/SingletonDescriptor;", "Lruntime/container/ValueDescriptor;", "Lruntime/container/Disposable;", "()V", "disposableObjects", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getDisposableObjects", "()Ljava/util/ArrayList;", "disposableObjects$delegate", "Lkotlin/Lazy;", "instance", "", "lifetimeSource", "Llibraries/coroutines/extra/LifetimeSource;", "getLifetimeSource", "()Llibraries/coroutines/extra/LifetimeSource;", "setLifetimeSource", "(Llibraries/coroutines/extra/LifetimeSource;)V", "state", "Lruntime/container/ComponentState;", "getState", "()Lruntime/container/ComponentState;", "setState", "(Lruntime/container/ComponentState;)V", "createInstance", "", "createInstanceOf", "createInstanceOfImpl", "dispose", "disposeImpl", "getValue", "registerDisposableObject", "ownedObject", "platform-runtime"})
public abstract class SingletonDescriptor
implements ValueDescriptor,
Disposable {
    @Nullable
    private Object instance;
    @NotNull
    private ComponentState state = ComponentState.Null;
    @Nullable
    private LifetimeSource lifetimeSource;
    @NotNull
    private final Lazy disposableObjects$delegate = LazyKt.lazy((Function0)disposableObjects.2.INSTANCE);

    @NotNull
    protected final ComponentState getState() {
        return this.state;
    }

    protected final void setState(@NotNull ComponentState componentState) {
        Intrinsics.checkNotNullParameter((Object)((Object)componentState), (String)"<set-?>");
        this.state = componentState;
    }

    @Nullable
    protected final LifetimeSource getLifetimeSource() {
        return this.lifetimeSource;
    }

    protected final void setLifetimeSource(@Nullable LifetimeSource lifetimeSource) {
        this.lifetimeSource = lifetimeSource;
    }

    private final ArrayList<Disposable> getDisposableObjects() {
        Lazy lazy = this.disposableObjects$delegate;
        boolean bl = false;
        return (ArrayList)lazy.getValue();
    }

    protected final void registerDisposableObject(@NotNull Disposable ownedObject) {
        Intrinsics.checkNotNullParameter((Object)ownedObject, (String)"ownedObject");
        this.getDisposableObjects().add(ownedObject);
    }

    @Override
    @NotNull
    public Object getValue() {
        if (this.state == ComponentState.Corrupted) {
            throw new ContainerConsistencyException("Component descriptor " + this + " is corrupted and cannot be accessed");
        }
        if (this.state == ComponentState.Disposing) {
            throw new CancellationException("Could not get the component " + this + " because it is being disposed");
        }
        if (this.state == ComponentState.Disposed) {
            throw new CancellationException("Component descriptor " + this + " is disposed and cannot be accessed");
        }
        if (this.instance == null) {
            this.createInstance();
        }
        Object object = this.instance;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    private final void createInstance() {
        ComponentState componentState = this.state;
        int n = WhenMappings.$EnumSwitchMapping$0[componentState.ordinal()];
        switch (n) {
            case 1: {
                try {
                    this.instance = this.createInstanceOf();
                    return;
                }
                catch (Throwable ex) {
                    this.state = ComponentState.Corrupted;
                    for (Disposable disposable : this.getDisposableObjects()) {
                        disposable.dispose();
                    }
                    throw ex;
                }
            }
            case 2: {
                throw new ContainerConsistencyException("Could not create the component " + this + " because it is being initialized. Do we have undetected circular dependency?");
            }
            case 3: {
                throw new ContainerConsistencyException("Could not get the component " + this + ". Instance is null in Initialized state");
            }
            case 4: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is corrupted");
            }
            case 5: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is being disposed");
            }
            case 6: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is already disposed");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void disposeImpl() {
        Object wereInstance = this.instance;
        this.state = ComponentState.Disposing;
        this.instance = null;
        try {
            Object object;
            if (wereInstance instanceof Disposable) {
                ((Disposable)wereInstance).dispose();
            }
            if ((object = this.lifetimeSource) != null) {
                ((LifetimeSource)object).terminate();
            }
            for (Disposable disposable : this.getDisposableObjects()) {
                disposable.dispose();
            }
        }
        catch (Throwable ex) {
            this.state = ComponentState.Corrupted;
            throw ex;
        }
        this.state = ComponentState.Disposed;
    }

    @Override
    public void dispose() {
        ComponentState componentState = this.state;
        int n = WhenMappings.$EnumSwitchMapping$0[componentState.ordinal()];
        switch (n) {
            case 3: {
                this.disposeImpl();
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new ContainerConsistencyException("The component " + this + " is being initialized and cannot be disposed.");
            }
            case 5: {
                throw new ContainerConsistencyException("The component " + this + " is already in disposing state.");
            }
            case 6: {
                throw new ContainerConsistencyException("The component " + this + " has already been destroyed.");
            }
        }
    }

    private final Object createInstanceOf() {
        this.state = ComponentState.Initializing;
        Object instance = this.createInstanceOfImpl();
        this.state = ComponentState.Initialized;
        return instance;
    }

    @NotNull
    protected abstract Object createInstanceOfImpl();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentState.values().length];
            nArray[ComponentState.Null.ordinal()] = 1;
            nArray[ComponentState.Initializing.ordinal()] = 2;
            nArray[ComponentState.Initialized.ordinal()] = 3;
            nArray[ComponentState.Corrupted.ordinal()] = 4;
            nArray[ComponentState.Disposing.ordinal()] = 5;
            nArray[ComponentState.Disposed.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

