/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.klogging.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.ComponentRegisterEntry;
import runtime.container.Container;
import runtime.container.ContainerConsistencyException;
import runtime.container.Disposable;
import runtime.container.JvmTypeBasedComponentDescriptor;
import runtime.container.JvmTypeBasedComponentStorage;
import runtime.container.ValueDescriptor;
import runtime.container.ValueResolveContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lruntime/container/ReadOnlyJvmTypeBasedComponentStorage;", "Lruntime/container/Container;", "source", "Lruntime/container/JvmTypeBasedComponentStorage;", "parent", "id", "", "(Lruntime/container/JvmTypeBasedComponentStorage;Lruntime/container/Container;Ljava/lang/String;)V", "descriptorsInDisposeOrder", "", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "disposed", "", "getId", "()Ljava/lang/String;", "registry", "", "", "Lruntime/container/ComponentRegisterEntry;", "dispose", "", "entriesByRequest", "request", "Ljava/lang/reflect/Type;", "resolve", "Lruntime/container/ValueDescriptor;", "context", "Lruntime/container/ValueResolveContext;", "resolveMultiple", "typesList", "Companion", "platform-runtime"})
public final class ReadOnlyJvmTypeBasedComponentStorage
implements Container {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Container parent;
    @NotNull
    private final String id;
    @NotNull
    private final Map<Object, ComponentRegisterEntry> registry;
    @NotNull
    private final List<JvmTypeBasedComponentDescriptor> descriptorsInDisposeOrder;
    private volatile boolean disposed;

    public ReadOnlyJvmTypeBasedComponentStorage(@NotNull JvmTypeBasedComponentStorage source, @Nullable Container parent, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.parent = parent;
        this.id = id;
        this.registry = source.getRegistry$platform_runtime().copy();
        this.descriptorsInDisposeOrder = source.getDescriptorsInDisposeOrder$platform_runtime();
    }

    public /* synthetic */ ReadOnlyJvmTypeBasedComponentStorage(JvmTypeBasedComponentStorage jvmTypeBasedComponentStorage, Container container, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            container = null;
        }
        if ((n & 4) != 0) {
            string = jvmTypeBasedComponentStorage.getId();
        }
        this(jvmTypeBasedComponentStorage, container, string);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentRegisterEntry componentRegisterEntry = this.entriesByRequest(request);
        return componentRegisterEntry == null ? null : componentRegisterEntry.singleOrNull(request);
    }

    @Override
    @NotNull
    public List<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ComponentRegisterEntry componentRegisterEntry = this.entriesByRequest(request);
        List<ValueDescriptor> list = componentRegisterEntry == null ? null : componentRegisterEntry.toList();
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Override
    @NotNull
    public List<ValueDescriptor> typesList(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List types2 = this.resolveMultiple(request, context2);
        Collection collection2 = types2;
        boolean bl = false;
        if (!collection2.isEmpty()) {
            collection = types2;
        } else {
            Container container = this.parent;
            collection2 = container == null ? null : container.typesList(request, context2);
            collection = collection2 == null ? CollectionsKt.emptyList() : collection2;
        }
        return collection;
    }

    private final ComponentRegisterEntry entriesByRequest(Type request) {
        ComponentRegisterEntry componentRegisterEntry;
        ComponentRegisterEntry componentRegisterEntry2 = this.registry.get(request);
        if (componentRegisterEntry2 == null) {
            ParameterizedType parameterizedType;
            ParameterizedType parameterizedType2 = parameterizedType = request instanceof ParameterizedType ? (ParameterizedType)request : null;
            if (parameterizedType == null) {
                componentRegisterEntry = null;
            } else {
                boolean bl;
                ParameterizedType parameterizedType3;
                block5: {
                    ParameterizedType parameterizedType4 = parameterizedType;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    parameterizedType3 = parameterizedType4;
                    boolean bl4 = false;
                    Type[] typeArray = parameterizedType3.getActualTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"parameterizedType.actualTypeArguments");
                    Object[] $this$all$iv = typeArray;
                    boolean $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        Type it = (Type)element$iv;
                        boolean bl5 = false;
                        if (it instanceof WildcardType) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                componentRegisterEntry = bl ? this.registry.get(parameterizedType3.getRawType()) : null;
            }
        } else {
            componentRegisterEntry = componentRegisterEntry2;
        }
        return componentRegisterEntry;
    }

    public final void dispose() {
        if (this.disposed) {
            throw new ContainerConsistencyException("Component circlet.container was already disposed");
        }
        for (JvmTypeBasedComponentDescriptor descriptor2 : this.descriptorsInDisposeOrder) {
            if (!(descriptor2 instanceof Disposable)) continue;
            ((Disposable)((Object)descriptor2)).dispose();
        }
        this.disposed = true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lruntime/container/ReadOnlyJvmTypeBasedComponentStorage$Companion;", "Llibraries/klogging/KLogging;", "()V", "platform-runtime"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

