/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import libraries.basics.ClassLoaderUtilsKt;
import org.jetbrains.annotations.NotNull;
import runtime.container.ComponentContainer;
import runtime.container.ConstructorBinding;
import runtime.container.DescriptorsKt;
import runtime.container.Disposable;
import runtime.container.JvmTypeBasedComponentDescriptor;
import runtime.container.JvmTypeBasedSingletonDescriptorKt;
import runtime.container.LifetimeSourceDescriptor;
import runtime.container.ResolveKt;
import runtime.container.SingletonDescriptor;
import runtime.container.ValueDescriptor;
import runtime.container.ValueResolveContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lruntime/container/JvmTypeBasedSingletonDescriptor;", "Lruntime/container/SingletonDescriptor;", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "container", "Lruntime/container/ComponentContainer;", "klass", "Ljava/lang/Class;", "(Lruntime/container/ComponentContainer;Ljava/lang/Class;)V", "getContainer", "()Lruntime/container/ComponentContainer;", "getKlass", "()Ljava/lang/Class;", "createInstanceOfImpl", "", "getRegistrations", "", "Ljava/lang/reflect/Type;", "toString", "", "platform-runtime"})
public final class JvmTypeBasedSingletonDescriptor
extends SingletonDescriptor
implements JvmTypeBasedComponentDescriptor {
    @NotNull
    private final ComponentContainer container;
    @NotNull
    private final Class<?> klass;

    public JvmTypeBasedSingletonDescriptor(@NotNull ComponentContainer container, @NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.container = container;
        this.klass = klass;
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    @NotNull
    public final Class<?> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    protected Object createInstanceOfImpl() {
        Object objectInstance = JvmClassMappingKt.getKotlinClass(this.klass).getObjectInstance();
        if (objectInstance != null) {
            return objectInstance;
        }
        ValueResolveContext context2 = this.container.createResolveContext(this);
        ConstructorBinding binding = ResolveKt.bindToConstructor(this.klass, context2);
        for (ValueDescriptor argumentDescriptor : binding.getArgumentDescriptors()) {
            if (argumentDescriptor instanceof Disposable && !(argumentDescriptor instanceof SingletonDescriptor)) {
                this.registerDisposableObject((Disposable)((Object)argumentDescriptor));
            }
            if (!(argumentDescriptor instanceof LifetimeSourceDescriptor)) continue;
            if (this.getLifetimeSource() != null) {
                String string = "Duplicated lifetimeSource constructor argument.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.setLifetimeSource(((LifetimeSourceDescriptor)argumentDescriptor).getLifetimeSource());
        }
        Constructor<?> constructor = binding.getConstructor();
        List<Object> arguments = ResolveKt.bindArguments(binding.getArgumentDescriptors());
        ClassLoader classLoader = this.klass.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"klass.classLoader");
        Object t = ClassLoaderUtilsKt.withContextClassLoader(classLoader, (Function0)new Function0<Object>(this, constructor, arguments){
            final /* synthetic */ JvmTypeBasedSingletonDescriptor this$0;
            final /* synthetic */ Constructor<?> $constructor;
            final /* synthetic */ List<Object> $arguments;
            {
                this.this$0 = $receiver;
                this.$constructor = $constructor;
                this.$arguments = $arguments;
                super(0);
            }

            public final Object invoke() {
                Object object;
                try {
                    JvmTypeBasedSingletonDescriptorKt.access$getLog$p().trace(Intrinsics.stringPlus((String)"Create ", (Object)this.this$0.getKlass().getSimpleName()));
                    Collection $this$toTypedArray$iv = this.$arguments;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                    if (objectArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    object = objectArray;
                    object = this.$constructor.newInstance(Arrays.copyOf(object, ((Object[])object).length));
                }
                catch (Throwable ex) {
                    JvmTypeBasedSingletonDescriptorKt.access$getLog$p().error(ex, Intrinsics.stringPlus((String)"Error creating instance of ", (Object)this.this$0.getKlass().getName()));
                    throw ex;
                }
                return object;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"override fun createInstanceOfImpl(): Any {\n        val objectInstance = klass.kotlin.objectInstance\n        if (objectInstance != null)\n            return objectInstance\n        val context = container.createResolveContext(this)\n        val binding = klass.bindToConstructor(context)\n\n        for (argumentDescriptor in binding.argumentDescriptors) {\n            if (argumentDescriptor is Disposable && argumentDescriptor !is SingletonDescriptor) {\n                registerDisposableObject(argumentDescriptor)\n            }\n            if (argumentDescriptor is LifetimeSourceDescriptor) {\n                if (lifetimeSource != null) {\n                    error(\"Duplicated lifetimeSource constructor argument.\")\n                }\n                lifetimeSource = argumentDescriptor.lifetimeSource\n            }\n        }\n\n        val constructor = binding.constructor\n        val arguments = bindArguments(binding.argumentDescriptors)\n\n        return klass.classLoader.withContextClassLoader {\n            try {\n                log.trace(\"Create ${klass.simpleName}\")\n                constructor.newInstance(*arguments.toTypedArray())\n            }\n            catch (ex: Throwable) {\n                log.error(ex, \"Error creating instance of ${klass.name}\")\n                throw ex\n            }\n        }\n    }");
        return t;
    }

    @Override
    @NotNull
    public Iterable<Type> getRegistrations() {
        return DescriptorsKt.supertypes(this.klass);
    }

    @NotNull
    public String toString() {
        return "JvmTypeBasedSingletonDescriptor(" + this.klass.getSimpleName() + " in " + this.klass.getClassLoader() + ')';
    }
}

