/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.collections.MultiMap;
import libraries.collections.MultiMapKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.ComponentRegisterEntry;
import runtime.container.ComponentRegistry;
import runtime.container.ComponentResolveContext;
import runtime.container.ComponentStorageState;
import runtime.container.Container;
import runtime.container.ContainerConsistencyException;
import runtime.container.DataStructuresKt;
import runtime.container.DescriptorsKt;
import runtime.container.Disposable;
import runtime.container.JvmTypeBasedComponentDescriptor;
import runtime.container.JvmTypeBasedSingletonDescriptor;
import runtime.container.MethodBinding;
import runtime.container.ResolveKt;
import runtime.container.ValueDescriptor;
import runtime.container.ValueResolveContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\bH\u0002J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"H\u0000\u00a2\u0006\u0002\b#J\u0018\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020'H\u0002J\u0014\u0010)\u001a\u00020\u00162\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\"J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020'H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020'H\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020,0\"2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020'H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lruntime/container/JvmTypeBasedComponentStorage;", "Lruntime/container/Container;", "id", "", "(Ljava/lang/String;)V", "dependencies", "Llibraries/collections/MultiMap;", "Lruntime/container/JvmTypeBasedComponentDescriptor;", "Ljava/lang/reflect/Type;", "descriptors", "", "getId", "()Ljava/lang/String;", "log", "Llibraries/klogging/KLogger;", "registry", "Lruntime/container/ComponentRegistry;", "getRegistry$platform_runtime", "()Lruntime/container/ComponentRegistry;", "state", "Lruntime/container/ComponentStorageState;", "compose", "", "context", "Lruntime/container/ComponentResolveContext;", "composeDescriptors", "", "dispose", "disposeDescriptor", "descriptor", "entriesByRequest", "Lruntime/container/ComponentRegisterEntry;", "request", "getDescriptorsInDisposeOrder", "", "getDescriptorsInDisposeOrder$platform_runtime", "injectMethods", "instance", "", "Lruntime/container/ValueResolveContext;", "registerDependency", "registerDescriptors", "items", "resolve", "Lruntime/container/ValueDescriptor;", "resolveMultiple", "typesList", "platform-runtime"})
public final class JvmTypeBasedComponentStorage
implements Container {
    @NotNull
    private final String id;
    @NotNull
    private final KLogger log;
    @NotNull
    private ComponentStorageState state;
    @NotNull
    private final ComponentRegistry registry;
    @NotNull
    private Set<JvmTypeBasedComponentDescriptor> descriptors;
    @NotNull
    private final MultiMap<JvmTypeBasedComponentDescriptor, Type> dependencies;

    public JvmTypeBasedComponentStorage(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.log = KLoggersKt.logger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.state = ComponentStorageState.Initial;
        this.registry = new ComponentRegistry();
        boolean bl = false;
        this.descriptors = new LinkedHashSet();
        this.dependencies = MultiMapKt.linkedMultiMap$default(null, 1, null);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final ComponentRegistry getRegistry$platform_runtime() {
        return this.registry;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.state == ComponentStorageState.Initial) {
            throw new ContainerConsistencyException("Container was not composed before resolving");
        }
        ComponentRegisterEntry entry = this.entriesByRequest(request);
        if (entry != null) {
            this.registerDependency(request, context2);
            return entry.singleOrNull(request);
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context2) {
        ValueDescriptor descriptor2;
        if (context2 instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context2).getRequestingDescriptor()) instanceof JvmTypeBasedComponentDescriptor) {
            this.dependencies.put((JvmTypeBasedComponentDescriptor)descriptor2, request);
        }
    }

    @Override
    @NotNull
    public List<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.registerDependency(request, context2);
        ComponentRegisterEntry componentRegisterEntry = this.entriesByRequest(request);
        List<ValueDescriptor> list = componentRegisterEntry == null ? null : componentRegisterEntry.toList();
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Override
    @NotNull
    public List<ValueDescriptor> typesList(@NotNull Type request, @NotNull ValueResolveContext context2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return this.resolveMultiple(request, context2);
    }

    public final void registerDescriptors(@NotNull List<? extends JvmTypeBasedComponentDescriptor> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        if (this.state != ComponentStorageState.Initial) {
            throw new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        this.descriptors.addAll((Collection<JvmTypeBasedComponentDescriptor>)items2);
    }

    /*
     * WARNING - void declaration
     */
    public final void compose(@NotNull ComponentResolveContext context2) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List list;
        JvmTypeBasedComponentDescriptor it;
        Object object;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        JvmTypeBasedComponentDescriptor jvmTypeBasedComponentDescriptor;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.state != ComponentStorageState.Initial) {
            throw new ContainerConsistencyException("Container " + this.getId() + " is already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        Iterable $this$flatMap$iv = this.descriptors;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            JvmTypeBasedComponentDescriptor de = (JvmTypeBasedComponentDescriptor)element$iv$iv;
            boolean bl = false;
            jvmTypeBasedComponentDescriptor = de;
            if (jvmTypeBasedComponentDescriptor instanceof JvmTypeBasedSingletonDescriptor) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = DescriptorsKt.supertypes(((JvmTypeBasedSingletonDescriptor)de).getKlass());
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                    Type it2 = (Type)element$iv$iv2;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it2, ((JvmTypeBasedSingletonDescriptor)de).getKlass()))) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Type)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            list = it;
            object.add(list);
        }
        Set overriddenTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = this.descriptors;
        object = this;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            it = (JvmTypeBasedComponentDescriptor)element$iv$iv;
            boolean bl3 = false;
            jvmTypeBasedComponentDescriptor = it;
            if (jvmTypeBasedComponentDescriptor instanceof JvmTypeBasedSingletonDescriptor) {
                boolean ret = !overriddenTypes.contains(((JvmTypeBasedSingletonDescriptor)it).getKlass());
                KLogger this_$iv = this.log;
                boolean $i$f$trace = false;
                if (this_$iv.isTraceEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl4 = false;
                    String string = "Component: enabled=" + ret + ' ' + ((JvmTypeBasedSingletonDescriptor)it).getKlass() + ';';
                    kLogger.trace(string);
                }
                bl = ret;
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list = (List)destination$iv$iv;
        ((JvmTypeBasedComponentStorage)object).descriptors = CollectionsKt.toMutableSet((Iterable)list);
        this.composeDescriptors(context2, (Collection<? extends JvmTypeBasedComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context2, Collection<? extends JvmTypeBasedComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)descriptors);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JvmTypeBasedComponentDescriptor it = (JvmTypeBasedComponentDescriptor)element$iv;
            boolean bl = false;
            this.injectMethods(it.getValue(), context2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void injectMethods(Object instance, ValueResolveContext context2) {
        void $this$filterTo$iv$iv;
        Class<?> type = instance.getClass();
        Method[] methodArray = type.getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"type.methods");
        Object[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block3: {
                Method member = (Method)element$iv$iv;
                boolean bl2 = false;
                Annotation[] annotationArray = member.getDeclaredAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)annotationArray, (String)"member.declaredAnnotations");
                Object[] $this$any$iv = annotationArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Annotation it = (Annotation)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getAnnotationClass((Annotation)it).getSimpleName(), (Object)"Inject")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List injectors = (List)destination$iv$iv;
        Iterable $this$forEach$iv = injectors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method injector = (Method)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)injector, (String)"injector");
            MethodBinding methodBinding = ResolveKt.bindToMethod(injector, context2);
            methodBinding.invoke(instance);
        }
    }

    public final void dispose() {
        if (this.state != ComponentStorageState.Initialized) {
            if (this.state == ComponentStorageState.Initial) {
                return;
            }
            throw new ContainerConsistencyException("Component circlet.container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<JvmTypeBasedComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder$platform_runtime();
        for (JvmTypeBasedComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    @NotNull
    public final List<JvmTypeBasedComponentDescriptor> getDescriptorsInDisposeOrder$platform_runtime() {
        return DataStructuresKt.topologicalSort((Iterable)this.descriptors, (Function1)new Function1<JvmTypeBasedComponentDescriptor, Iterable<? extends JvmTypeBasedComponentDescriptor>>(this){
            final /* synthetic */ JvmTypeBasedComponentStorage this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Iterable<JvmTypeBasedComponentDescriptor> invoke(@NotNull JvmTypeBasedComponentDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ArrayList<JvmTypeBasedComponentDescriptor> dependent = new ArrayList<JvmTypeBasedComponentDescriptor>();
                for (Type interfaceType : JvmTypeBasedComponentStorage.access$getDependencies$p(this.this$0).get(it)) {
                    ComponentRegisterEntry componentRegisterEntry = JvmTypeBasedComponentStorage.access$entriesByRequest(this.this$0, interfaceType);
                    if (componentRegisterEntry == null) continue;
                    ComponentRegisterEntry entry = componentRegisterEntry;
                    for (JvmTypeBasedComponentDescriptor dependency : entry.toList()) {
                        dependent.add(dependency);
                    }
                }
                return dependent;
            }
        });
    }

    private final ComponentRegisterEntry entriesByRequest(Type request) {
        ComponentRegisterEntry componentRegisterEntry;
        ComponentRegisterEntry componentRegisterEntry2 = this.registry.tryGetEntry(request);
        if (componentRegisterEntry2 == null) {
            ParameterizedType parameterizedType;
            ParameterizedType parameterizedType2 = parameterizedType = request instanceof ParameterizedType ? (ParameterizedType)request : null;
            if (parameterizedType == null) {
                componentRegisterEntry = null;
            } else {
                boolean bl;
                Object object;
                ParameterizedType parameterizedType3;
                block7: {
                    ParameterizedType parameterizedType4 = parameterizedType;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    parameterizedType3 = parameterizedType4;
                    boolean bl4 = false;
                    object = parameterizedType3.getActualTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameterizedType.actualTypeArguments");
                    Object[] $this$all$iv = object;
                    boolean $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        Type it = (Type)element$iv;
                        boolean bl5 = false;
                        if (it instanceof WildcardType) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
                if (bl) {
                    ComponentRegistry componentRegistry = this.getRegistry$platform_runtime();
                    object = parameterizedType3.getRawType();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameterizedType.rawType");
                    componentRegisterEntry = componentRegistry.tryGetEntry((Type)object);
                } else {
                    componentRegisterEntry = null;
                }
            }
        } else {
            componentRegisterEntry = componentRegisterEntry2;
        }
        return componentRegisterEntry;
    }

    private final void disposeDescriptor(JvmTypeBasedComponentDescriptor descriptor2) {
        if (descriptor2 instanceof Disposable) {
            ((Disposable)((Object)descriptor2)).dispose();
        }
    }

    public static final /* synthetic */ MultiMap access$getDependencies$p(JvmTypeBasedComponentStorage $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ ComponentRegisterEntry access$entriesByRequest(JvmTypeBasedComponentStorage $this, Type request) {
        return $this.entriesByRequest(request);
    }
}

