/*
 * Decompiled with CFR 0.152.
 */
package platform.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.Typography;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.DefaultCategoriesSummary;
import platform.common.EmojiCommonKt;
import platform.common.EmojiFormat;
import platform.common.EmojiScale;
import platform.common.EmojiSize;
import platform.common.SkinTone;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ7\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u001e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006!"}, d2={"Lplatform/common/EmojiCommon;", "", "()V", "MD_PATTERN", "Lkotlin/text/Regex;", "getMD_PATTERN", "()Lkotlin/text/Regex;", "NAME_PATTERN", "getNAME_PATTERN", "USER_INPUT_PATTERN", "getUSER_INPUT_PATTERN", "emojiFromMarkdown", "", "text", "dropVariation", "", "emojiHref", "emoji", "format", "Lplatform/common/EmojiFormat;", "size", "Lplatform/common/EmojiSize;", "scale", "Lplatform/common/EmojiScale;", "version", "", "(Ljava/lang/String;Lplatform/common/EmojiFormat;Lplatform/common/EmojiSize;Lplatform/common/EmojiScale;Ljava/lang/Long;)Ljava/lang/String;", "emojiInMarkdown", "withSkinTone", "tone", "Lplatform/common/SkinTone;", "data", "Lplatform/common/DefaultCategoriesSummary;", "platform-common"})
public final class EmojiCommon {
    @NotNull
    public static final EmojiCommon INSTANCE = new EmojiCommon();
    @NotNull
    private static final Regex NAME_PATTERN;
    @NotNull
    private static final Regex USER_INPUT_PATTERN;
    @NotNull
    private static final Regex MD_PATTERN;

    private EmojiCommon() {
    }

    @NotNull
    public final String emojiHref(@NotNull String emoji, @NotNull EmojiFormat format, @NotNull EmojiSize size2, @NotNull EmojiScale scale, @Nullable Long version) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)((Object)size2), (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)scale), (String)"scale");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$emojiHref_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        $this$emojiHref_u24lambda_u2d0.append("/emojis/");
        $this$emojiHref_u24lambda_u2d0.append(format.getStringValue());
        $this$emojiHref_u24lambda_u2d0.append('/');
        $this$emojiHref_u24lambda_u2d0.append(size2.getStringValue());
        $this$emojiHref_u24lambda_u2d0.append('/');
        $this$emojiHref_u24lambda_u2d0.append(emoji);
        $this$emojiHref_u24lambda_u2d0.append(scale.suffix());
        if (version != null) {
            $this$emojiHref_u24lambda_u2d0.append("?version=");
            $this$emojiHref_u24lambda_u2d0.append(version);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String emojiHref$default(EmojiCommon emojiCommon, String string, EmojiFormat emojiFormat, EmojiSize emojiSize, EmojiScale emojiScale, Long l, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = null;
        }
        return emojiCommon.emojiHref(string, emojiFormat, emojiSize, emojiScale, l);
    }

    @NotNull
    public final String emojiInMarkdown(@NotNull String emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        return "" + ':' + EmojiCommonKt.getZwsp(Typography.INSTANCE) + emoji + EmojiCommonKt.getZwsp(Typography.INSTANCE) + ':';
    }

    @NotNull
    public final String emojiFromMarkdown(@NotNull String text2, boolean dropVariation) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        char[] cArray = new char[]{':', EmojiCommonKt.getZwsp(Typography.INSTANCE)};
        String result2 = StringsKt.trim((String)text2, (char[])cArray);
        return !dropVariation ? result2 : StringsKt.substringBefore$default((String)result2, (String)"::", null, (int)2, null);
    }

    public static /* synthetic */ String emojiFromMarkdown$default(EmojiCommon emojiCommon, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return emojiCommon.emojiFromMarkdown(string, bl);
    }

    @NotNull
    public final String withSkinTone(@NotNull String emoji, @NotNull SkinTone tone, @NotNull DefaultCategoriesSummary data2) {
        List<Integer> list;
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)tone, (String)"tone");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String raw = this.emojiFromMarkdown(emoji, true);
        int toneIndex = ArraysKt.indexOf((Object[])data2.getVariations(), (Object)tone.shortName());
        return toneIndex >= 0 && Intrinsics.areEqual((list = data2.getEmojisWithVariations().get(emoji)) == null ? null : Boolean.valueOf(list.contains(toneIndex)), (Object)true) ? raw + "::" + data2.getVariations()[toneIndex] : raw;
    }

    @NotNull
    public final Regex getNAME_PATTERN() {
        return NAME_PATTERN;
    }

    @NotNull
    public final Regex getUSER_INPUT_PATTERN() {
        return USER_INPUT_PATTERN;
    }

    @NotNull
    public final Regex getMD_PATTERN() {
        return MD_PATTERN;
    }

    static {
        String string = "[a-z0-9+\\-_]+";
        boolean bl = false;
        NAME_PATTERN = new Regex(string);
        string = ":([a-z0-9+\\-_]+):";
        bl = false;
        USER_INPUT_PATTERN = new Regex(string);
        string = "" + ':' + EmojiCommonKt.getZwsp(Typography.INSTANCE) + "([a-z0-9+\\-_:]+)" + EmojiCommonKt.getZwsp(Typography.INSTANCE) + ':';
        bl = false;
        MD_PATTERN = new Regex(string);
    }
}

