/*
 * Decompiled with CFR 0.152.
 */
package libraries.process;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import libraries.io.DaemonThreadFactory;
import libraries.io.FileUtil;
import libraries.io.StreamsKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLogging;
import libraries.klogging.MDC;
import libraries.process.Cancellation;
import libraries.process.DeferredProcessResult;
import libraries.process.OSProcesses;
import libraries.process.ProcessHandle;
import libraries.process.ProcessResult;
import libraries.process.ProcessRunner;
import libraries.process.Processes;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use truly non-blocking ProcessGroup instead")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0002CDB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010)\u001a\u00020\u0004H\u0002J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020-H\u0002J_\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004042\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u0001062\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004092\u0006\u0010:\u001a\u00020\b2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020+0<H\u0016\u00a2\u0006\u0002\u0010>JS\u0010?\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004042\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u0001062\u0006\u0010@\u001a\u00020\b2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004092\u0006\u0010:\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010AJ\f\u0010B\u001a\u00020\u0004*\u00020\u0004H\u0002R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u000f\u001a\u0004\b!\u0010\"R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u000f\u001a\u0004\b&\u0010'\u00a8\u0006E"}, d2={"Llibraries/process/OSProcesses;", "Llibraries/process/Processes;", "Lkotlinx/coroutines/CoroutineScope;", "name", "", "maxProcesses", "", "logEnv", "", "(Ljava/lang/String;IZ)V", "cancellationScheduler", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "getCancellationScheduler", "()Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "cancellationScheduler$delegate", "Lkotlin/Lazy;", "coroutineContext", "Lkotlinx/coroutines/CompletableJob;", "getCoroutineContext", "()Lkotlinx/coroutines/CompletableJob;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "executor$delegate", "getMaxProcesses", "()I", "getName", "()Ljava/lang/String;", "processRunDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "getProcessRunDispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "processRunDispatcher$delegate", "processRunner", "Llibraries/process/ProcessRunner;", "getProcessRunner", "()Llibraries/process/ProcessRunner;", "processRunner$delegate", "buildProcessId", "close", "", "createTempFolder", "Ljava/io/File;", "prefix", "deleteFolder", "folder", "readStdoutBlocking", "Llibraries/process/DeferredProcessResult;", "args", "", "cancelTimeout", "", "idleTimeout", "environmentPatch", "", "redirectErrorStream", "stdoutReader", "Lkotlin/Function1;", "Ljava/io/InputStream;", "(Ljava/util/List;Ljava/lang/Long;Ljava/lang/Long;Ljava/util/Map;ZLkotlin/jvm/functions/Function1;)Llibraries/process/DeferredProcessResult;", "startAsync", "readStdout", "(Ljava/util/List;Ljava/lang/Long;Ljava/lang/Long;ZLjava/util/Map;Z)Llibraries/process/DeferredProcessResult;", "sanitize", "Companion", "SwitchableStream", "libraries-process"})
public final class OSProcesses
implements Processes,
CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int maxProcesses;
    @NotNull
    private final CompletableJob coroutineContext;
    @NotNull
    private final Lazy executor$delegate;
    @NotNull
    private final Lazy cancellationScheduler$delegate;
    @NotNull
    private final Lazy processRunner$delegate;
    @NotNull
    private final Lazy processRunDispatcher$delegate;
    @NotNull
    private final AtomicInteger counter;
    private static final long defaultTimeout = Long.MAX_VALUE;

    public OSProcesses(@NotNull String name2, int maxProcesses, boolean logEnv) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.maxProcesses = maxProcesses;
        this.coroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.executor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ThreadPoolExecutor>(this){
            final /* synthetic */ OSProcesses this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ThreadPoolExecutor invoke() {
                return new ThreadPoolExecutor(this.this$0.getMaxProcesses(), this.this$0.getMaxProcesses(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<E>(), new DaemonThreadFactory(Intrinsics.stringPlus((String)this.this$0.getName(), (Object)"-wait-threads")));
            }
        }));
        this.cancellationScheduler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScheduledThreadPoolExecutor>(this){
            final /* synthetic */ OSProcesses this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScheduledThreadPoolExecutor invoke() {
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory(Intrinsics.stringPlus((String)this.this$0.getName(), (Object)"-cancellation-tasks")));
                boolean bl = false;
                boolean bl2 = false;
                ScheduledThreadPoolExecutor $this$invoke_u24lambda_u2d0 = scheduledThreadPoolExecutor;
                boolean bl3 = false;
                $this$invoke_u24lambda_u2d0.setRemoveOnCancelPolicy(true);
                return scheduledThreadPoolExecutor;
            }
        }));
        this.processRunner$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProcessRunner>(this, logEnv){
            final /* synthetic */ OSProcesses this$0;
            final /* synthetic */ boolean $logEnv;
            {
                this.this$0 = $receiver;
                this.$logEnv = $logEnv;
                super(0);
            }

            @NotNull
            public final ProcessRunner invoke() {
                return new ProcessRunner(this.this$0.getMaxProcesses() * 2 + 1, new DaemonThreadFactory(Intrinsics.stringPlus((String)this.this$0.getName(), (Object)"-io-threads")), this.$logEnv);
            }
        }));
        this.processRunDispatcher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExecutorCoroutineDispatcher>(this){
            final /* synthetic */ OSProcesses this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ExecutorCoroutineDispatcher invoke() {
                return ExecutorsKt.from((ExecutorService)OSProcesses.access$getExecutor(this.this$0));
            }
        }));
        this.counter = new AtomicInteger(0);
    }

    public /* synthetic */ OSProcesses(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(string, n, bl);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public int getMaxProcesses() {
        return this.maxProcesses;
    }

    @NotNull
    public CompletableJob getCoroutineContext() {
        return this.coroutineContext;
    }

    private final ThreadPoolExecutor getExecutor() {
        Lazy lazy = this.executor$delegate;
        boolean bl = false;
        return (ThreadPoolExecutor)lazy.getValue();
    }

    private final ScheduledThreadPoolExecutor getCancellationScheduler() {
        Lazy lazy = this.cancellationScheduler$delegate;
        boolean bl = false;
        return (ScheduledThreadPoolExecutor)lazy.getValue();
    }

    private final ProcessRunner getProcessRunner() {
        Lazy lazy = this.processRunner$delegate;
        boolean bl = false;
        return (ProcessRunner)lazy.getValue();
    }

    private final ExecutorCoroutineDispatcher getProcessRunDispatcher() {
        Lazy lazy = this.processRunDispatcher$delegate;
        boolean bl = false;
        return (ExecutorCoroutineDispatcher)lazy.getValue();
    }

    @Override
    @NotNull
    public DeferredProcessResult startAsync(@NotNull List<String> args, @Nullable Long cancelTimeout, @Nullable Long idleTimeout, boolean readStdout, @NotNull Map<String, String> environmentPatch, boolean redirectErrorStream) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(environmentPatch, (String)"environmentPatch");
        Ref.ObjectRef cancelReason = new Ref.ObjectRef();
        MDC.StickyMDC mdc = MDC.INSTANCE.copy();
        Deferred resultAsync2 = BuildersKt.async$default((CoroutineScope)this, (CoroutineContext)this.getProcessRunDispatcher().plus((CoroutineContext)new CoroutineName("process-wait")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProcessResult>, Object>(this, readStdout, args, environmentPatch, idleTimeout, redirectErrorStream, cancelTimeout, mdc, (Ref.ObjectRef<String>)cancelReason, null){
            int label;
            final /* synthetic */ OSProcesses this$0;
            final /* synthetic */ boolean $readStdout;
            final /* synthetic */ List<String> $args;
            final /* synthetic */ Map<String, String> $environmentPatch;
            final /* synthetic */ Long $idleTimeout;
            final /* synthetic */ boolean $redirectErrorStream;
            final /* synthetic */ Long $cancelTimeout;
            final /* synthetic */ MDC.StickyMDC $mdc;
            final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
            {
                this.this$0 = $receiver;
                this.$readStdout = $readStdout;
                this.$args = $args;
                this.$environmentPatch = $environmentPatch;
                this.$idleTimeout = $idleTimeout;
                this.$redirectErrorStream = $redirectErrorStream;
                this.$cancelTimeout = $cancelTimeout;
                this.$mdc = $mdc;
                this.$cancelReason = $cancelReason;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ScheduledFuture<?> scheduledFuture;
                        ResultKt.throwOnFailure((Object)object);
                        String processId = OSProcesses.access$buildProcessId(this.this$0);
                        OutputStream stdout = this.$readStdout ? (OutputStream)new ByteArrayOutputStream() : FileUtil.INSTANCE.nullOutputStream();
                        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                        File tempdir = OSProcesses.access$createTempFolder(this.this$0, processId + '-' + UUID.randomUUID());
                        Long l = this.$idleTimeout;
                        ProcessHandle handler = OSProcesses.access$getProcessRunner(this.this$0).executeProcess(processId, tempdir, this.$args, this.$environmentPatch, l == null ? Long.MAX_VALUE : l, FileUtil.INSTANCE.nullInputStream(), StreamsKt.checkedStream$default(stdout, null, 1, null), StreamsKt.checkedStream$default(stderr, null, 1, null), this.$redirectErrorStream);
                        Long l2 = this.$cancelTimeout;
                        if (l2 == null) {
                            scheduledFuture = null;
                        } else {
                            Long l3 = l2;
                            OSProcesses oSProcesses = this.this$0;
                            Long l4 = this.$cancelTimeout;
                            Ref.ObjectRef<String> objectRef = this.$cancelReason;
                            boolean bl = false;
                            boolean bl2 = false;
                            long it = ((Number)l3).longValue();
                            boolean bl3 = false;
                            scheduledFuture = OSProcesses.access$getCancellationScheduler(oSProcesses).schedule(() -> startAsync.resultAsync.1.invokeSuspend$lambda-1$lambda-0(objectRef, l4), (long)l4, TimeUnit.MILLISECONDS);
                        }
                        ScheduledFuture<?> cancelTask = scheduledFuture;
                        return this.$mdc.syncWrapped((Function0)new Function0<ProcessResult>(handler, cancelTask, this.this$0, tempdir, stderr, this.$readStdout, stdout, processId, this.$cancelReason){
                            final /* synthetic */ ProcessHandle $handler;
                            final /* synthetic */ ScheduledFuture<?> $cancelTask;
                            final /* synthetic */ OSProcesses this$0;
                            final /* synthetic */ File $tempdir;
                            final /* synthetic */ ByteArrayOutputStream $stderr;
                            final /* synthetic */ boolean $readStdout;
                            final /* synthetic */ OutputStream $stdout;
                            final /* synthetic */ String $processId;
                            final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
                            {
                                this.$handler = $handler;
                                this.$cancelTask = $cancelTask;
                                this.this$0 = $receiver;
                                this.$tempdir = $tempdir;
                                this.$stderr = $stderr;
                                this.$readStdout = $readStdout;
                                this.$stdout = $stdout;
                                this.$processId = $processId;
                                this.$cancelReason = $cancelReason;
                                super(0);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final ProcessResult invoke() {
                                void this_$iv;
                                Object object = OSProcesses.Companion.getLogger();
                                String string = this.$processId;
                                OSProcesses oSProcesses = this.this$0;
                                boolean $i$f$debug = false;
                                if (this_$iv.isDebugEnabled()) {
                                    void var6_5 = this_$iv;
                                    boolean bl = false;
                                    String string2 = "Waiting for " + string + ". Queue size: " + OSProcesses.access$getExecutor(oSProcesses).getQueue().size();
                                    var6_5.debug(string2);
                                }
                                this.$handler.waitFor((Function0<Cancellation>)((Function0)new Function0<Cancellation>(this.$cancelReason){
                                    final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
                                    {
                                        this.$cancelReason = $cancelReason;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Cancellation invoke() {
                                        Cancellation cancellation;
                                        String string = (String)this.$cancelReason.element;
                                        if (string == null) {
                                            cancellation = null;
                                        } else {
                                            String string2 = string;
                                            boolean bl = false;
                                            boolean bl2 = false;
                                            String it = string2;
                                            boolean bl3 = false;
                                            cancellation = Cancellation.Companion.cancel(it);
                                        }
                                        Cancellation cancellation2 = cancellation;
                                        return cancellation2 == null ? Cancellation.Companion.getDoNotCancel() : cancellation2;
                                    }
                                }));
                                object = this.$cancelTask;
                                if (object != null) {
                                    object.cancel(false);
                                }
                                OSProcesses.access$deleteFolder(this.this$0, this.$tempdir);
                                int n = this.$handler.getExitCode();
                                object = this.$stderr.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stderr.toString()");
                                return ProcessResult.Companion.create(n, (String)object, this.$readStdout ? this.$stdout.toString() : "");
                            }
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ProcessResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-1$lambda-0(Ref.ObjectRef $cancelReason, Long $cancelTimeout) {
                $cancelReason.element = "Cancelled after " + $cancelTimeout + " ms timeout";
            }
        }), (int)2, null);
        return new DeferredProcessResult((Deferred<? extends ProcessResult>)resultAsync2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Ref.ObjectRef<String>)cancelReason){
            final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
            {
                this.$cancelReason = $cancelReason;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$cancelReason.element = it;
            }
        }));
    }

    @Override
    @NotNull
    public DeferredProcessResult readStdoutBlocking(@NotNull List<String> args, @Nullable Long cancelTimeout, @Nullable Long idleTimeout, @NotNull Map<String, String> environmentPatch, boolean redirectErrorStream, @NotNull Function1<? super InputStream, Unit> stdoutReader) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(environmentPatch, (String)"environmentPatch");
        Intrinsics.checkNotNullParameter(stdoutReader, (String)"stdoutReader");
        Ref.ObjectRef cancelReason = new Ref.ObjectRef();
        MDC.StickyMDC mdc = MDC.INSTANCE.copy();
        Ref.ObjectRef pis = new Ref.ObjectRef();
        Ref.ObjectRef sws = new Ref.ObjectRef();
        CountDownLatch latch = new CountDownLatch(1);
        Deferred resultAsync2 = BuildersKt.async$default((CoroutineScope)this, (CoroutineContext)this.getProcessRunDispatcher().plus((CoroutineContext)new CoroutineName("process-wait-b")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProcessResult>, Object>((Ref.ObjectRef<PipedInputStream>)pis, (Ref.ObjectRef<SwitchableStream>)sws, this, args, environmentPatch, idleTimeout, redirectErrorStream, latch, cancelTimeout, mdc, (Ref.ObjectRef<String>)cancelReason, null){
            int label;
            final /* synthetic */ Ref.ObjectRef<PipedInputStream> $pis;
            final /* synthetic */ Ref.ObjectRef<SwitchableStream> $sws;
            final /* synthetic */ OSProcesses this$0;
            final /* synthetic */ List<String> $args;
            final /* synthetic */ Map<String, String> $environmentPatch;
            final /* synthetic */ Long $idleTimeout;
            final /* synthetic */ boolean $redirectErrorStream;
            final /* synthetic */ CountDownLatch $latch;
            final /* synthetic */ Long $cancelTimeout;
            final /* synthetic */ MDC.StickyMDC $mdc;
            final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
            {
                this.$pis = $pis;
                this.$sws = $sws;
                this.this$0 = $receiver;
                this.$args = $args;
                this.$environmentPatch = $environmentPatch;
                this.$idleTimeout = $idleTimeout;
                this.$redirectErrorStream = $redirectErrorStream;
                this.$latch = $latch;
                this.$cancelTimeout = $cancelTimeout;
                this.$mdc = $mdc;
                this.$cancelReason = $cancelReason;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ScheduledFuture<?> scheduledFuture;
                        ResultKt.throwOnFailure((Object)object);
                        this.$pis.element = new PipedInputStream();
                        if (this.$pis.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"pis");
                            throw null;
                        }
                        PipedOutputStream pos = new PipedOutputStream((PipedInputStream)this.$pis.element);
                        this.$sws.element = new SwitchableStream(pos);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        String processId = OSProcesses.access$buildProcessId(this.this$0);
                        File tempdir = OSProcesses.access$createTempFolder(this.this$0, processId + '-' + UUID.randomUUID());
                        Long l = this.$idleTimeout;
                        long l2 = l == null ? Long.MAX_VALUE : l;
                        if (this.$sws.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"sws");
                            throw null;
                        }
                        ProcessHandle handler = OSProcesses.access$getProcessRunner(this.this$0).executeProcess(processId, tempdir, this.$args, this.$environmentPatch, l2, FileUtil.INSTANCE.nullInputStream(), StreamsKt.checkedStream$default((SwitchableStream)this.$sws.element, null, 1, null), StreamsKt.checkedStream$default(baos, null, 1, null), this.$redirectErrorStream);
                        this.$latch.countDown();
                        Long l3 = this.$cancelTimeout;
                        if (l3 == null) {
                            scheduledFuture = null;
                        } else {
                            Long l4 = l3;
                            OSProcesses oSProcesses = this.this$0;
                            Long l5 = this.$cancelTimeout;
                            Ref.ObjectRef<String> objectRef = this.$cancelReason;
                            boolean bl = false;
                            boolean bl2 = false;
                            long it = ((Number)l4).longValue();
                            boolean bl3 = false;
                            scheduledFuture = OSProcesses.access$getCancellationScheduler(oSProcesses).schedule(() -> readStdoutBlocking.resultAsync.1.invokeSuspend$lambda-1$lambda-0(objectRef, l5), (long)l5, TimeUnit.MILLISECONDS);
                        }
                        ScheduledFuture<?> cancelTask = scheduledFuture;
                        return this.$mdc.syncWrapped((Function0)new Function0<ProcessResult>(handler, this.$sws, cancelTask, this.this$0, tempdir, pos, baos, this.$cancelReason){
                            final /* synthetic */ ProcessHandle $handler;
                            final /* synthetic */ Ref.ObjectRef<SwitchableStream> $sws;
                            final /* synthetic */ ScheduledFuture<?> $cancelTask;
                            final /* synthetic */ OSProcesses this$0;
                            final /* synthetic */ File $tempdir;
                            final /* synthetic */ PipedOutputStream $pos;
                            final /* synthetic */ ByteArrayOutputStream $baos;
                            final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
                            {
                                this.$handler = $handler;
                                this.$sws = $sws;
                                this.$cancelTask = $cancelTask;
                                this.this$0 = $receiver;
                                this.$tempdir = $tempdir;
                                this.$pos = $pos;
                                this.$baos = $baos;
                                this.$cancelReason = $cancelReason;
                                super(0);
                            }

                            @NotNull
                            public final ProcessResult invoke() {
                                this.$handler.waitFor((Function0<Cancellation>)((Function0)new Function0<Cancellation>(this.$cancelReason){
                                    final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
                                    {
                                        this.$cancelReason = $cancelReason;
                                        super(0);
                                    }

                                    @NotNull
                                    public final Cancellation invoke() {
                                        Cancellation cancellation;
                                        String string = (String)this.$cancelReason.element;
                                        if (string == null) {
                                            cancellation = null;
                                        } else {
                                            String string2 = string;
                                            boolean bl = false;
                                            boolean bl2 = false;
                                            String it = string2;
                                            boolean bl3 = false;
                                            cancellation = Cancellation.Companion.cancel(it);
                                        }
                                        Cancellation cancellation2 = cancellation;
                                        return cancellation2 == null ? Cancellation.Companion.getDoNotCancel() : cancellation2;
                                    }
                                }));
                                if (this.$sws.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"sws");
                                    throw null;
                                }
                                ((SwitchableStream)this.$sws.element).switch();
                                Object object = this.$cancelTask;
                                if (object != null) {
                                    object.cancel(false);
                                }
                                OSProcesses.access$deleteFolder(this.this$0, this.$tempdir);
                                this.$pos.close();
                                int n = this.$handler.getExitCode();
                                object = this.$baos.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"baos.toString()");
                                return ProcessResult.Companion.create(n, (String)object, null);
                            }
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ProcessResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda-1$lambda-0(Ref.ObjectRef $cancelReason, Long $cancelTimeout) {
                $cancelReason.element = "Cancelled after " + $cancelTimeout + " ms timeout";
            }
        }), (int)2, null);
        latch.await();
        if (pis.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pis");
            throw null;
        }
        stdoutReader.invoke((Object)((PipedInputStream)pis.element));
        if (sws.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sws");
            throw null;
        }
        ((SwitchableStream)sws.element).switch();
        cancelReason.element = "Canceled after the end of stdout read";
        return new DeferredProcessResult((Deferred<? extends ProcessResult>)resultAsync2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Ref.ObjectRef<String>)cancelReason){
            final /* synthetic */ Ref.ObjectRef<String> $cancelReason;
            {
                this.$cancelReason = $cancelReason;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$cancelReason.element = it;
            }
        }));
    }

    @Override
    public void close() {
        this.getProcessRunner().destroy();
        Job.DefaultImpls.cancel$default((Job)((Job)this.getCoroutineContext()), null, (int)1, null);
        this.getProcessRunDispatcher().close();
        KLogger this_$iv = Companion.getLogger();
        boolean $i$f$info = false;
        if (this_$iv.isInfoEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "Closed Processes[" + this.getName() + ']';
            kLogger.info(string);
        }
    }

    private final File createTempFolder(String prefix) {
        File file2 = Files.createTempDirectory(this.sanitize(prefix), new FileAttribute[0]).toFile();
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        FileUtils.forceDeleteOnExit((File)it);
        File file3 = file2;
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"createTempDirectory(prefix.sanitize()).toFile().also {\n            FileUtils.forceDeleteOnExit(it)\n        }");
        return file3;
    }

    /*
     * WARNING - void declaration
     */
    private final String sanitize(String $this$sanitize) {
        void $this$fold$iv;
        CharSequence charSequence = $this$sanitize;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        void var6_6 = $this$fold$iv;
        for (int i = 0; i < var6_6.length(); ++i) {
            void char_;
            char element$iv;
            char c = element$iv = var6_6.charAt(i);
            String result2 = accumulator$iv;
            boolean bl = false;
            void var12_12 = char_;
            boolean bl2 = false;
            accumulator$iv = Character.isLetterOrDigit((char)var12_12) || char_ == 45 ? Intrinsics.stringPlus((String)result2, (Object)Character.valueOf((char)char_)) : (char_ == 32 ? (StringsKt.endsWith$default((String)result2, (String)"_", (boolean)false, (int)2, null) ? result2 : Intrinsics.stringPlus((String)result2, (Object)"_")) : (StringsKt.endsWith$default((String)result2, (String)"-", (boolean)false, (int)2, null) ? result2 : Intrinsics.stringPlus((String)result2, (Object)"-")));
        }
        return accumulator$iv;
    }

    private final void deleteFolder(File folder) {
        try {
            FileUtils.deleteDirectory((File)folder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String buildProcessId() {
        return this.name + '-' + this.counter.getAndIncrement();
    }

    @Override
    @NotNull
    public DeferredProcessResult startAsync(@NotNull String args, @Nullable Long cancelTimeout, @Nullable Long idleTimeout, boolean readStdout, boolean redirectErrorStream) {
        return Processes.DefaultImpls.startAsync(this, args, cancelTimeout, idleTimeout, readStdout, redirectErrorStream);
    }

    public static final /* synthetic */ String access$buildProcessId(OSProcesses $this) {
        return $this.buildProcessId();
    }

    public static final /* synthetic */ File access$createTempFolder(OSProcesses $this, String prefix) {
        return $this.createTempFolder(prefix);
    }

    public static final /* synthetic */ ProcessRunner access$getProcessRunner(OSProcesses $this) {
        return $this.getProcessRunner();
    }

    public static final /* synthetic */ void access$deleteFolder(OSProcesses $this, File folder) {
        $this.deleteFolder(folder);
    }

    public static final /* synthetic */ ThreadPoolExecutor access$getExecutor(OSProcesses $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ ScheduledThreadPoolExecutor access$getCancellationScheduler(OSProcesses $this) {
        return $this.getCancellationScheduler();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llibraries/process/OSProcesses$Companion;", "Llibraries/klogging/KLogging;", "()V", "defaultTimeout", "", "libraries-process"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Llibraries/process/OSProcesses$SwitchableStream;", "Ljava/io/OutputStream;", "target", "(Ljava/io/OutputStream;)V", "enabled", "", "switch", "", "write", "b", "", "libraries-process"})
    private static final class SwitchableStream
    extends OutputStream {
        @NotNull
        private final OutputStream target;
        private boolean enabled;

        public SwitchableStream(@NotNull OutputStream target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.enabled = true;
        }

        @Override
        public void write(int b) {
            if (this.enabled) {
                this.target.write(b);
            }
        }

        public final void switch() {
            this.enabled = false;
        }
    }
}

