/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.storage;

import java.io.Closeable;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import libraries.io.blobs.RequestContent;
import libraries.io.channels.ChannelUtilsKt;
import libraries.io.channels.FileChannelsKt;
import libraries.io.storage.Blob;
import libraries.io.storage.BlobInfo;
import libraries.io.storage.BlobRequestSigner;
import libraries.io.storage.BlobStorage;
import libraries.io.storage.FileBlob;
import libraries.io.storage.FileBlobInfo;
import libraries.io.storage.FileBlobStorage;
import libraries.io.storage.FileDirectory;
import libraries.io.storage.ObjectInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0014\b\u0002\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J&\u0010 \u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00062\u0014\b\u0002\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001eH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0019\u0010&\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0019\u0010*\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0006H\u0002J\u001f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00192\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J!\u0010/\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u00100\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u00101\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2={"Llibraries/io/storage/FileBlobStorage;", "Llibraries/io/storage/BlobStorage;", "directory", "", "(Ljava/lang/String;)V", "basePath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "requestSigner", "Llibraries/io/storage/BlobRequestSigner;", "getRequestSigner", "()Llibraries/io/storage/BlobRequestSigner;", "appendBlob", "Llibraries/io/storage/BlobInfo;", "path", "content", "Llibraries/io/blobs/RequestContent;", "(Ljava/lang/String;Llibraries/io/blobs/RequestContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "completeBlob", "Llibraries/io/storage/Blob;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyBlob", "blob", "(Llibraries/io/storage/BlobInfo;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteBlob", "Lkotlinx/coroutines/flow/Flow;", "deleteFiles", "", "directoryPath", "accept", "Lkotlin/Function1;", "", "deletePathAndEmptyParents", "block", "deletePrefixedPath", "", "pathPrefix", "deleteSpecificPath", "getBlob", "getFileBlobInfo", "Llibraries/io/storage/FileBlobInfo;", "getPath", "headBlob", "isEmptyDirectory", "listChildren", "listFiles", "Llibraries/io/storage/ObjectInfo;", "moveBlob", "putBlob", "tryHeadBlob", "Companion", "libraries-io"})
public final class FileBlobStorage
implements BlobStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Path basePath;
    @Nullable
    private final BlobRequestSigner requestSigner;
    private static final Logger LOG = LoggerFactory.getLogger(FileBlobStorage.class);

    public FileBlobStorage(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.basePath = Paths.get(directory, new String[0]);
    }

    @Override
    @Nullable
    public BlobRequestSigner getRequestSigner() {
        return this.requestSigner;
    }

    @Override
    @Nullable
    public Object getBlob(@NotNull String path2, @NotNull Continuation<? super Blob> $completion) {
        Path filePath = this.getPath(path2);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new NoSuchElementException("Blob " + path2 + " not found");
        }
        return new FileBlob(filePath, path2, null, null, false, 28, null);
    }

    @Nullable
    public Object headBlob(@NotNull String path2, @NotNull Continuation<? super Blob> $completion) {
        return this.getBlob(path2, $completion);
    }

    @Override
    @Nullable
    public Object tryHeadBlob(@NotNull String path2, @NotNull Continuation<? super BlobInfo> $completion) {
        Path filePath = this.getPath(path2);
        if (!Files.exists(filePath, new LinkOption[0])) {
            return null;
        }
        return new FileBlob(filePath, path2, null, null, false, 28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object putBlob(@NotNull String var1_1, @NotNull RequestContent var2_2, @NotNull Continuation<? super BlobInfo> var3_3) {
        if (!(var3_3 instanceof putBlob.1)) ** GOTO lbl-1000
        var18_4 = var3_3;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ FileBlobStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.putBlob(null, null, (Continuation<? super BlobInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                filePath = this.getPath(path);
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                var7_8 = FileChannelsKt.writableChannel$default(filePath, 0L, 1, null);
                var8_9 = false;
                var9_10 = false;
                var9_11 = null;
                fileChannel = (WritableByteChannel)var7_8;
                $i$a$-use-FileBlobStorage$putBlob$length$1 = false;
                $continuation.L$0 = path;
                $continuation.L$1 = filePath;
                $continuation.L$2 = var7_8;
                $continuation.L$3 = var9_11;
                $continuation.L$4 = fileChannel;
                $continuation.label = 1;
                v0 = content.getContent((Continuation<? super ReadableByteChannel>)$continuation);
                ** if (v0 != var19_6) goto lbl32
lbl31:
                // 1 sources

                return var19_6;
lbl32:
                // 1 sources

                ** GOTO lbl44
            }
            case 1: {
                $i$a$-use-FileBlobStorage$putBlob$length$1 = false;
                fileChannel = (WritableByteChannel)$continuation.L$4;
                var9_11 = (Throwable)$continuation.L$3;
                var7_8 = (Closeable)$continuation.L$2;
                filePath = (Path)$continuation.L$1;
                path = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl44:
                    // 2 sources

                    var12_17 = (Closeable)v0;
                    var13_18 = false;
                    var14_19 = false;
                    var14_20 = null;
                    try {
                        it = (ReadableByteChannel)var12_17;
                        $i$a$-use-FileBlobStorage$putBlob$length$1$1 = false;
                        var15_21 = Boxing.boxLong((long)ChannelUtilsKt.copyTo$default(it, fileChannel, 0L, null, 6, null));
                    }
                    catch (Throwable var15_22) {
                        var14_20 = var15_22;
                        throw var15_22;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var12_17, (Throwable)var14_20);
                    }
                    var10_12 = Boxing.boxLong((long)((Number)var15_21).longValue());
                    ** GOTO lbl70
                }
                catch (Throwable var10_13) {
                    var9_11 = var10_13;
                    throw var10_13;
                }
            }
            catch (Throwable var10_14) {
                throw var10_14;
            }
            {
                finally {
                    CloseableKt.closeFinally((Closeable)var7_8, (Throwable)var9_11);
                }
lbl70:
                // 1 sources

                length = ((Number)var10_12).longValue();
                FileBlobStorage.LOG.trace("Created file " + path + ", length " + length + " bytes");
                return new FileBlob(filePath, path, null, null, false, 28, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object appendBlob(@NotNull String var1_1, @NotNull RequestContent var2_2, @NotNull Continuation<? super BlobInfo> var3_3) {
        if (!(var3_3 instanceof appendBlob.1)) ** GOTO lbl-1000
        var20_4 = var3_3;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ FileBlobStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.appendBlob(null, null, (Continuation<? super BlobInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                filePath = this.getPath(path);
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                position = Files.size(filePath);
                var9_9 = FileChannelsKt.writableChannel(filePath, position);
                var10_10 = false;
                var11_11 = false;
                var11_12 = null;
                fileChannel = (WritableByteChannel)var9_9;
                $i$a$-use-FileBlobStorage$appendBlob$length$1 = false;
                $continuation.L$0 = path;
                $continuation.L$1 = filePath;
                $continuation.L$2 = var9_9;
                $continuation.L$3 = var11_12;
                $continuation.L$4 = fileChannel;
                $continuation.label = 1;
                v0 = content.getContent((Continuation<? super ReadableByteChannel>)$continuation);
                ** if (v0 != var21_6) goto lbl33
lbl32:
                // 1 sources

                return var21_6;
lbl33:
                // 1 sources

                ** GOTO lbl45
            }
            case 1: {
                $i$a$-use-FileBlobStorage$appendBlob$length$1 = false;
                fileChannel = (WritableByteChannel)$continuation.L$4;
                var11_12 = (Throwable)$continuation.L$3;
                var9_9 = (Closeable)$continuation.L$2;
                filePath = (Path)$continuation.L$1;
                path = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl45:
                    // 2 sources

                    var14_18 = (Closeable)v0;
                    var15_19 = false;
                    var16_20 = false;
                    var16_21 = null;
                    try {
                        it = (ReadableByteChannel)var14_18;
                        $i$a$-use-FileBlobStorage$appendBlob$length$1$1 = false;
                        var17_22 = Boxing.boxLong((long)ChannelUtilsKt.copyTo$default(it, fileChannel, 0L, null, 6, null));
                    }
                    catch (Throwable var17_23) {
                        var16_21 = var17_23;
                        throw var17_23;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var14_18, (Throwable)var16_21);
                    }
                    var12_13 = Boxing.boxLong((long)((Number)var17_22).longValue());
                    ** GOTO lbl71
                }
                catch (Throwable var12_14) {
                    var11_12 = var12_14;
                    throw var12_14;
                }
            }
            catch (Throwable var12_15) {
                throw var12_15;
            }
            {
                finally {
                    CloseableKt.closeFinally((Closeable)var9_9, (Throwable)var11_12);
                }
lbl71:
                // 1 sources

                length = ((Number)var12_13).longValue();
                FileBlobStorage.LOG.trace("Appended file " + path + ", added " + length + " bytes");
                return new FileBlob(filePath, path, null, null, false, 28, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object completeBlob(@NotNull String path2, @NotNull Continuation<? super Blob> $completion) {
        return this.getBlob(path2, $completion);
    }

    @Override
    @Nullable
    public Object copyBlob(@NotNull BlobInfo blob, @NotNull String path2, @NotNull Continuation<? super BlobInfo> $completion) {
        FileBlob fileBlob = (FileBlob)blob;
        Path newFilePath = this.getPath(path2);
        LOG.trace("Copying file " + fileBlob.getFilePath() + " to " + path2);
        Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(fileBlob.getFilePath(), newFilePath, copyOptionArray);
        return new FileBlob(newFilePath, path2, null, null, false, 28, null);
    }

    @Override
    @Nullable
    public Object moveBlob(@NotNull BlobInfo blob, @NotNull String path2, @NotNull Continuation<? super BlobInfo> $completion) {
        FileBlob fileBlob = (FileBlob)blob;
        Path newFilePath = this.getPath(path2);
        LOG.trace("Moving file " + fileBlob.getFilePath() + " to " + path2);
        Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.move(fileBlob.getFilePath(), newFilePath, copyOptionArray);
        return new FileBlob(newFilePath, path2, null, null, false, 28, null);
    }

    @Override
    @Nullable
    public Object deleteBlob(@NotNull String path2, @NotNull Continuation<? super Flow<? extends BlobInfo>> $completion) {
        return StringsKt.endsWith$default((String)path2, (String)"*", (boolean)false, (int)2, null) ? FlowKt.asFlow((Iterable)this.deletePrefixedPath(StringsKt.removeSuffix((String)path2, (CharSequence)"*"))) : FlowKt.asFlow((Iterable)this.deleteSpecificPath(path2));
    }

    @Override
    @Nullable
    public Object listChildren(@NotNull String path2, @NotNull Continuation<? super Flow<? extends BlobInfo>> $completion) {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super FileBlob>, Continuation<? super Unit>, Object>(this, path2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileBlobStorage this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super FileBlob>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super FileBlob> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @Nullable
    public Object listFiles(@NotNull String path2, @NotNull Continuation<? super Flow<? extends ObjectInfo>> $completion) {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ObjectInfo>, Continuation<? super Unit>, Object>(this, path2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileBlobStorage this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3;
                FlowCollector flowCollector;
                Iterator<T> iterator2;
                Throwable throwable;
                FileBlobStorage fileBlobStorage;
                Closeable closeable;
                FlowCollector $this$flow;
                Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        $this$flow = (FlowCollector)this.L$0;
                        Path directoryPath = FileBlobStorage.access$getPath(this.this$0, this.$path);
                        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                            return Unit.INSTANCE;
                        }
                        closeable = Files.newDirectoryStream(directoryPath);
                        fileBlobStorage = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        throwable = null;
                        DirectoryStream stream = (DirectoryStream)closeable;
                        boolean bl3 = false;
                        iterator2 = stream.iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean bl3 = false;
                        iterator2 = (Iterator<T>)this.L$4;
                        throwable = (Throwable)this.L$3;
                        fileBlobStorage = (FileBlobStorage)this.L$2;
                        closeable = (Closeable)this.L$1;
                        flowCollector = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object3 = $result;
                        break;
                    }
                    case 2: {
                        void $result;
                        boolean bl3 = false;
                        iterator2 = (Iterator)this.L$4;
                        throwable = (Throwable)this.L$3;
                        fileBlobStorage = (FileBlobStorage)this.L$2;
                        closeable = (Closeable)this.L$1;
                        flowCollector = (FlowCollector)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                throw throwable3;
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    Path filePath = (Path)iterator2.next();
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                        this.L$0 = $this$flow;
                        this.L$1 = closeable;
                        this.L$2 = fileBlobStorage;
                        this.L$3 = throwable;
                        this.L$4 = iterator2;
                        this.label = 1;
                        object3 = $this$flow.emit((Object)new FileDirectory(filePath, ((Object)FileBlobStorage.access$getBasePath$p(fileBlobStorage).relativize(filePath)).toString()), (Continuation)this);
                        if (object3 != object4) continue;
                        return object4;
                    }
                    if (!Files.isRegularFile(filePath, new LinkOption[0])) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                    this.L$0 = flowCollector;
                    this.L$1 = closeable;
                    this.L$2 = fileBlobStorage;
                    this.L$3 = throwable;
                    this.L$4 = iterator2;
                    this.label = 2;
                    object2 = flowCollector.emit((Object)new FileBlob(filePath, ((Object)FileBlobStorage.access$getBasePath$p(fileBlobStorage).relativize(filePath)).toString(), null, null, false, 28, null), (Continuation)this);
                    if (object2 != object4) continue;
                    return object4;
                }
                Unit unit = Unit.INSTANCE;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<FlowCollector<? super ObjectInfo>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super ObjectInfo> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final List<BlobInfo> deleteSpecificPath(String path2) {
        Path filePath = this.getPath(path2);
        boolean bl = false;
        List deletedFiles = new ArrayList();
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            this.deleteFiles(filePath, (Function1<? super Path, Boolean>)((Function1)new Function1<Path, Boolean>((List<BlobInfo>)deletedFiles, this){
                final /* synthetic */ List<BlobInfo> $deletedFiles;
                final /* synthetic */ FileBlobStorage this$0;
                {
                    this.$deletedFiles = $deletedFiles;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final boolean invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$deletedFiles.add(FileBlobStorage.access$getFileBlobInfo(this.this$0, it));
                    return true;
                }
            }));
        }
        this.deletePathAndEmptyParents(filePath, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>((List<BlobInfo>)deletedFiles, this){
            final /* synthetic */ List<BlobInfo> $deletedFiles;
            final /* synthetic */ FileBlobStorage this$0;
            {
                this.$deletedFiles = $deletedFiles;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$deletedFiles.add(FileBlobStorage.access$getFileBlobInfo(this.this$0, it));
            }
        }));
        return deletedFiles;
    }

    private final List<BlobInfo> deletePrefixedPath(String pathPrefix) {
        Path directoryPath = this.getPath(StringsKt.substringBeforeLast$default((String)pathPrefix, (char)'/', null, (int)2, null));
        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
            return CollectionsKt.emptyList();
        }
        String namePrefix = StringsKt.substringAfterLast$default((String)pathPrefix, (char)'/', null, (int)2, null);
        boolean bl = false;
        List deletedFiles = new ArrayList();
        this.deleteFiles(directoryPath, (Function1<? super Path, Boolean>)((Function1)new Function1<Path, Boolean>(namePrefix, (List<BlobInfo>)deletedFiles, this){
            final /* synthetic */ String $namePrefix;
            final /* synthetic */ List<BlobInfo> $deletedFiles;
            final /* synthetic */ FileBlobStorage this$0;
            {
                this.$namePrefix = $namePrefix;
                this.$deletedFiles = $deletedFiles;
                this.this$0 = $receiver;
                super(1);
            }

            public final boolean invoke(@NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                boolean bl = StringsKt.startsWith$default((String)((Object)path2.getFileName()).toString(), (String)this.$namePrefix, (boolean)false, (int)2, null);
                List<BlobInfo> list = this.$deletedFiles;
                FileBlobStorage fileBlobStorage = this.this$0;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean removed = bl;
                boolean bl4 = false;
                if (removed) {
                    list.add(FileBlobStorage.access$getFileBlobInfo(fileBlobStorage, path2));
                }
                return bl;
            }
        }));
        if (this.isEmptyDirectory(directoryPath)) {
            this.deletePathAndEmptyParents(directoryPath, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>((List<BlobInfo>)deletedFiles, this){
                final /* synthetic */ List<BlobInfo> $deletedFiles;
                final /* synthetic */ FileBlobStorage this$0;
                {
                    this.$deletedFiles = $deletedFiles;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$deletedFiles.add(FileBlobStorage.access$getFileBlobInfo(this.this$0, it));
                }
            }));
        }
        return deletedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteFiles(Path directoryPath, Function1<? super Path, Boolean> accept) {
        try {
            AutoCloseable autoCloseable = Files.walk(directoryPath, new FileVisitOption[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl3 = false;
                stream.sorted(Collections.reverseOrder()).forEach(arg_0 -> FileBlobStorage.deleteFiles$lambda-5$lambda-4(directoryPath, accept, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.error(Intrinsics.stringPlus((String)"Failed to list files in directory ", (Object)directoryPath));
        }
    }

    static /* synthetic */ void deleteFiles$default(FileBlobStorage fileBlobStorage, Path path2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = deleteFiles.1.INSTANCE;
        }
        fileBlobStorage.deleteFiles(path2, (Function1<? super Path, Boolean>)function1);
    }

    private final void deletePathAndEmptyParents(Path path2, Function1<? super Path, Unit> block) {
        Path filePath = path2;
        if (Files.isRegularFile(path2, new LinkOption[0])) {
            block.invoke((Object)path2);
        }
        if (Files.deleteIfExists(filePath)) {
            try {
                Path path3;
                do {
                    path3 = filePath.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"filePath.parent");
                } while (this.isEmptyDirectory(filePath = path3) && Files.deleteIfExists(filePath));
            }
            catch (Throwable e) {
                LOG.error(Intrinsics.stringPlus((String)"Failed to delete directory ", (Object)filePath), e);
            }
        }
    }

    static /* synthetic */ void deletePathAndEmptyParents$default(FileBlobStorage fileBlobStorage, Path path2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = deletePathAndEmptyParents.1.INSTANCE;
        }
        fileBlobStorage.deletePathAndEmptyParents(path2, (Function1<? super Path, Unit>)function1);
    }

    private final Path getPath(String path2) {
        Path path3 = this.basePath.resolve(path2);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"basePath.resolve(path)");
        return path3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isEmptyDirectory(Path directory) {
        Closeable closeable = Files.newDirectoryStream(directory);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            DirectoryStream dirStream = (DirectoryStream)closeable;
            boolean bl3 = false;
            boolean bl4 = !dirStream.iterator().hasNext();
            return bl4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final FileBlobInfo getFileBlobInfo(Path path2) {
        return new FileBlobInfo(((Object)this.basePath.relativize(path2)).toString(), Files.size(path2));
    }

    private static final void deleteFiles$lambda-5$lambda-4(Path $directoryPath, Function1 $accept, Path path2) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$directoryPath, (String)"$directoryPath");
                Intrinsics.checkNotNullParameter((Object)$accept, (String)"$accept");
                if (Intrinsics.areEqual((Object)path2, (Object)$directoryPath)) break block4;
                if (!Files.isRegularFile(path2, new LinkOption[0])) break block5;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                if (((Boolean)$accept.invoke((Object)path2)).booleanValue()) break block5;
            }
            return;
        }
        try {
            Files.deleteIfExists(path2);
        }
        catch (Throwable e) {
            LOG.error(Intrinsics.stringPlus((String)"Failed to delete file ", (Object)path2), e);
        }
    }

    public static final /* synthetic */ Path access$getPath(FileBlobStorage $this, String path2) {
        return $this.getPath(path2);
    }

    public static final /* synthetic */ Path access$getBasePath$p(FileBlobStorage $this) {
        return $this.basePath;
    }

    public static final /* synthetic */ FileBlobInfo access$getFileBlobInfo(FileBlobStorage $this, Path path2) {
        return $this.getFileBlobInfo(path2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llibraries/io/storage/FileBlobStorage$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "libraries-io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

