/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.blobs;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.io.blobs.BlobUtils;
import libraries.io.blobs.ContentDigest;
import libraries.io.blobs.MessageDigestPool;
import libraries.io.channels.ByteBufferPoolKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0014R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Llibraries/io/blobs/BlobUtils;", "", "()V", "sha256Pool", "Llibraries/io/blobs/MessageDigestPool;", "getSha256Pool", "()Llibraries/io/blobs/MessageDigestPool;", "sha256Pool$delegate", "Lkotlin/Lazy;", "computeSha256Digest", "Llibraries/io/blobs/ContentDigest;", "action", "Lkotlin/Function1;", "Ljava/security/MessageDigest;", "", "getDigest", "messageDigest", "getSha256Digest", "content", "Ljava/nio/channels/ReadableByteChannel;", "", "libraries-io"})
public final class BlobUtils {
    @NotNull
    public static final BlobUtils INSTANCE = new BlobUtils();
    @NotNull
    private static final Lazy sha256Pool$delegate = LazyKt.lazy((Function0)sha256Pool.2.INSTANCE);

    private BlobUtils() {
    }

    private final MessageDigestPool getSha256Pool() {
        Lazy lazy = sha256Pool$delegate;
        boolean bl = false;
        return (MessageDigestPool)((Object)lazy.getValue());
    }

    @NotNull
    public final ContentDigest getSha256Digest(@NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return this.computeSha256Digest((Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(content2){
            final /* synthetic */ byte[] $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(@NotNull MessageDigest messageDigest) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                messageDigest.update(this.$content);
            }
        }));
    }

    @NotNull
    public final ContentDigest getSha256Digest(@NotNull ReadableByteChannel content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return this.computeSha256Digest((Function1<? super MessageDigest, Unit>)((Function1)new Function1<MessageDigest, Unit>(content2){
            final /* synthetic */ ReadableByteChannel $content;
            {
                this.$content = $content;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull MessageDigest messageDigest) {
                Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
                ByteBuffer buffer = (ByteBuffer)ByteBufferPoolKt.getIoByteBufferPool().borrow();
                try {
                    while (true) {
                        buffer.clear();
                        int readCount = this.$content.read(buffer);
                        if (readCount < 0) {
                            break;
                        }
                        if (readCount == 0) continue;
                        buffer.flip();
                        messageDigest.update(buffer);
                    }
                }
                finally {
                    this.$content.close();
                    ByteBufferPoolKt.getIoByteBufferPool().recycle((Object)buffer);
                }
            }
        }));
    }

    @NotNull
    public final ContentDigest getDigest(@NotNull MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        byte[] value2 = messageDigest.digest();
        messageDigest.reset();
        String string = messageDigest.getAlgorithm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageDigest.algorithm");
        Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
        return new ContentDigest(string, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ContentDigest computeSha256Digest(Function1<? super MessageDigest, Unit> action2) {
        MessageDigest messageDigest = (MessageDigest)this.getSha256Pool().borrow();
        try {
            action2.invoke((Object)messageDigest);
            ContentDigest contentDigest = this.getDigest(messageDigest);
            return contentDigest;
        }
        finally {
            this.getSha256Pool().recycle(messageDigest);
        }
    }
}

