/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.workspaces;

import circlet.platform.api.ClientSupportFlag;
import circlet.platform.api.oauth.CodeChallenge;
import circlet.platform.api.oauth.OAuthFlowKt;
import circlet.platform.api.oauth.OAuthTokenResponse;
import circlet.platform.api.oauth.OpenSet;
import circlet.platform.workspaces.WorkspaceConfigurationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import libraries.collections.MultiMap;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.Uri;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J!\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u0019\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lcirclet/platform/workspaces/WorkspaceConfiguration;", "", "server", "", "clientId", "clientSecret", "features", "Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/platform/api/ClientSupportFlag;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcirclet/platform/api/oauth/OpenSet;)V", "STRING_LENGTH", "", "charPool", "", "", "getClientId", "()Ljava/lang/String;", "getClientSecret", "codeChallenge", "Lcirclet/platform/api/oauth/CodeChallenge$S256;", "getCodeChallenge", "()Lcirclet/platform/api/oauth/CodeChallenge$S256;", "codeChallenge$delegate", "Lkotlin/Lazy;", "codeVerifier", "getCodeVerifier", "codeVerifier$delegate", "getFeatures", "()Lcirclet/platform/api/oauth/OpenSet;", "getServer", "codeFlowURL", "redirectUri", "handleCodeFlowRedirect", "Lcirclet/platform/api/oauth/OAuthTokenResponse;", "uri", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshTokenFlow", "refreshToken", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "platform-app-state"})
public final class WorkspaceConfiguration {
    @NotNull
    private final String server;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final OpenSet<ClientSupportFlag> features;
    private final int STRING_LENGTH;
    @NotNull
    private final List<Character> charPool;
    @NotNull
    private final Lazy codeVerifier$delegate;
    @NotNull
    private final Lazy codeChallenge$delegate;

    public WorkspaceConfiguration(@NotNull String server2, @NotNull String clientId, @NotNull String clientSecret, @NotNull OpenSet<ClientSupportFlag> features2) {
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter(features2, (String)"features");
        this.server = server2;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.features = features2;
        this.STRING_LENGTH = 64;
        this.charPool = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        this.codeVerifier$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ WorkspaceConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                Integer n;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = (Iterable)new IntRange(1, WorkspaceConfiguration.access$getSTRING_LENGTH$p(this.this$0));
                Object object = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    n = Random.Default.nextInt(0, WorkspaceConfiguration.access$getCharPool$p((WorkspaceConfiguration)object).size());
                    collection.add(n);
                }
                $this$map$iv = (List)destination$iv$iv;
                object = WorkspaceConfiguration.access$getCharPool$p(this.this$0);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    int it = ((Number)item$iv$iv).intValue();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    n = object.get((int)p0);
                    collection.add(n);
                }
                return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }
        }));
        KLogger this_$iv = WorkspaceConfigurationKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "WorkspaceConfiguration.init()";
            kLogger.debug(string);
        }
        this.codeChallenge$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CodeChallenge.S256>(this){
            final /* synthetic */ WorkspaceConfiguration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CodeChallenge.S256 invoke() {
                return CodeChallenge.Companion.s256(WorkspaceConfiguration.access$getCodeVerifier(this.this$0));
            }
        }));
    }

    public /* synthetic */ WorkspaceConfiguration(String string, String string2, String string3, OpenSet openSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            openSet = OpenSet.None.INSTANCE;
        }
        this(string, string2, string3, openSet);
    }

    @NotNull
    public final String getServer() {
        return this.server;
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final String getClientSecret() {
        return this.clientSecret;
    }

    @NotNull
    public final OpenSet<ClientSupportFlag> getFeatures() {
        return this.features;
    }

    private final String getCodeVerifier() {
        Lazy lazy = this.codeVerifier$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final CodeChallenge.S256 getCodeChallenge() {
        Lazy lazy = this.codeChallenge$delegate;
        boolean bl = false;
        return (CodeChallenge.S256)lazy.getValue();
    }

    @NotNull
    public final String codeFlowURL(@NotNull String redirectUri) {
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        return OAuthFlowKt.codeFlowURL$default(this.server, this.clientId, redirectUri, null, null, true, this.getCodeChallenge(), 24, null);
    }

    @Nullable
    public final Object refreshTokenFlow(@NotNull String refreshToken2, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        return OAuthFlowKt.refreshTokenFlow$default(this.getServer(), this.getClientId(), this.getClientSecret(), refreshToken2, null, null, $completion, 48, null);
    }

    @Nullable
    public final Object handleCodeFlowRedirect(@NotNull String uri, @NotNull String redirectUri, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        String string = Uri.INSTANCE.extractQuery(uri);
        if (string == null) {
            return new OAuthTokenResponse.Error(uri, "500", Intrinsics.stringPlus((String)"Error parsing redirect uri: ", (Object)uri), null, 8, null);
        }
        String query2 = string;
        MultiMap<String, String> queryParameters = Uri.INSTANCE.parseQuery(query2);
        String string2 = (String)CollectionsKt.firstOrNull((Iterable)queryParameters.get("code"));
        if (string2 == null) {
            return new OAuthTokenResponse.Error(uri, "500", Intrinsics.stringPlus((String)"Error parsing redirect uri, code is missing: ", (Object)uri), null, 8, null);
        }
        String code = string2;
        boolean qr = StringsKt.contains$default((CharSequence)uri, (CharSequence)"qr-token", (boolean)false, (int)2, null);
        if (qr) {
            return OAuthFlowKt.qrCodeFlowToken$default(this.getServer(), this.getClientId(), this.getClientSecret(), code, true, null, null, $completion, 96, null);
        }
        return OAuthFlowKt.codeFlowToken$default(this.getServer(), this.getClientId(), redirectUri, this.getClientSecret(), code, this.getCodeVerifier(), null, $completion, 64, null);
    }

    public static final /* synthetic */ int access$getSTRING_LENGTH$p(WorkspaceConfiguration $this) {
        return $this.STRING_LENGTH;
    }

    public static final /* synthetic */ List access$getCharPool$p(WorkspaceConfiguration $this) {
        return $this.charPool;
    }

    public static final /* synthetic */ String access$getCodeVerifier(WorkspaceConfiguration $this) {
        return $this.getCodeVerifier();
    }
}

