/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client.arenas;

import circlet.platform.api.ARecord;
import circlet.platform.api.ArenasKt;
import circlet.platform.api.Ref;
import circlet.platform.client.ArenaManager;
import circlet.platform.client.ArenaPersistence;
import circlet.platform.client.arenas.Etag;
import circlet.platform.client.arenas.EtagUnknown;
import circlet.platform.client.arenas.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002H504\"\b\b\u0000\u00105*\u000206J\u0016\u00107\u001a\b\u0012\u0004\u0012\u0002H508\"\b\b\u0000\u00105*\u000206J\u0006\u00109\u001a\u00020\u001cJ-\u0010:\u001a\u0004\u0018\u0001H5\"\b\b\u0000\u00105*\u0002062\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H50<2\u0006\u0010=\u001a\u00020\u001c\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020\u001c2\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u000206J\b\u0010D\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001b\u0010%\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`'0&8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R!\u0010*\u001a\u0012\u0012\b\u0012\u00060\u0003j\u0002`'\u0012\u0004\u0012\u00020,0+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006E"}, d2={"Lcirclet/platform/client/arenas/ClientArenaRecordsCache;", "", "arenaId", "", "manager", "Lcirclet/platform/client/ArenaManager;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "persistence", "Lcirclet/platform/client/ArenaPersistence;", "(Ljava/lang/String;Lcirclet/platform/client/ArenaManager;Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/client/ArenaPersistence;)V", "getArenaId", "()Ljava/lang/String;", "etag", "Lcirclet/platform/client/arenas/Etag;", "getEtag", "()Lcirclet/platform/client/arenas/Etag;", "setEtag", "(Lcirclet/platform/client/arenas/Etag;)V", "etagFullyLoaded", "getEtagFullyLoaded", "setEtagFullyLoaded", "hasAllUpdatesFromEtag", "getHasAllUpdatesFromEtag", "setHasAllUpdatesFromEtag", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "loadedFully", "", "getLoadedFully", "()Z", "setLoadedFully", "(Z)V", "getManager", "()Lcirclet/platform/client/ArenaManager;", "getPersistence", "()Lcirclet/platform/client/ArenaPersistence;", "recordIds", "", "Lcirclet/platform/api/TID;", "getRecordIds", "()Ljava/util/Set;", "records", "", "Lcirclet/platform/client/arenas/Record;", "getRecords", "()Ljava/util/Map;", "size", "", "getSize", "()I", "allRecords", "Lkotlin/sequences/Sequence;", "T", "Lcirclet/platform/api/ARecord;", "allRecordsList", "", "hasOptimisticUpdates", "lookupRef", "ref", "Lcirclet/platform/api/Ref;", "acceptUnresolved", "(Lcirclet/platform/api/Ref;Z)Lcirclet/platform/api/ARecord;", "needResolve", "id", "putOptimisticRecord", "", "record", "toString", "platform-client"})
public final class ClientArenaRecordsCache {
    @NotNull
    private final String arenaId;
    @NotNull
    private final ArenaManager manager;
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final ArenaPersistence persistence;
    @NotNull
    private final Map<String, Record> records;
    @NotNull
    private Etag etag;
    @NotNull
    private Etag etagFullyLoaded;
    @Nullable
    private Etag hasAllUpdatesFromEtag;
    private boolean loadedFully;

    public ClientArenaRecordsCache(@NotNull String arenaId, @NotNull ArenaManager manager, @NotNull Lifetime lifetime, @Nullable ArenaPersistence persistence2) {
        Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.arenaId = arenaId;
        this.manager = manager;
        this.lifetime = lifetime;
        this.persistence = persistence2;
        boolean bl = false;
        this.records = new LinkedHashMap();
        this.etag = EtagUnknown.INSTANCE;
        this.etagFullyLoaded = EtagUnknown.INSTANCE;
    }

    @NotNull
    public final String getArenaId() {
        return this.arenaId;
    }

    @NotNull
    public final ArenaManager getManager() {
        return this.manager;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public final ArenaPersistence getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final Map<String, Record> getRecords() {
        return this.records;
    }

    @NotNull
    public final Etag getEtag() {
        return this.etag;
    }

    public final void setEtag(@NotNull Etag etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"<set-?>");
        this.etag = etag;
    }

    @NotNull
    public final Etag getEtagFullyLoaded() {
        return this.etagFullyLoaded;
    }

    public final void setEtagFullyLoaded(@NotNull Etag etag) {
        Intrinsics.checkNotNullParameter((Object)etag, (String)"<set-?>");
        this.etagFullyLoaded = etag;
    }

    @Nullable
    public final Etag getHasAllUpdatesFromEtag() {
        return this.hasAllUpdatesFromEtag;
    }

    public final void setHasAllUpdatesFromEtag(@Nullable Etag etag) {
        this.hasAllUpdatesFromEtag = etag;
    }

    public final boolean getLoadedFully() {
        return this.loadedFully;
    }

    public final void setLoadedFully(boolean bl) {
        this.loadedFully = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSize() {
        int n;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord aRecord;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ARecord it$iv$iv = aRecord;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ARecord it = (ARecord)element$iv;
                boolean bl = false;
                if (!(!it.getArchived())) continue;
                int n2 = ++count$iv;
                boolean bl6 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_4;
        }
        return n;
    }

    @NotNull
    public final Set<String> getRecordIds() {
        return this.records.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> Sequence<T> allRecords() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord aRecord;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ARecord it$iv$iv = aRecord;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends ARecord> List<T> allRecordsList() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.records.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ARecord aRecord;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Record it = (Record)element$iv$iv;
            boolean bl2 = false;
            if (Record.value$default(it, false, 1, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ARecord it$iv$iv = aRecord;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final <T extends ARecord> T lookupRef(@NotNull Ref<? extends T> ref2, boolean acceptUnresolved) {
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        Record record = this.records.get(ref2.getId());
        ARecord aRecord = record == null ? null : record.value(acceptUnresolved);
        return (T)(aRecord instanceof ARecord ? aRecord : null);
    }

    public final void putOptimisticRecord(@NotNull ARecord record) {
        String string;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (!ArenasKt.isTemporary(record) && (string = record.getTemporaryId()) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.getRecords().remove(it);
        }
        String key2 = record.getId();
        Record oldRecord = this.records.get(key2);
        Map<String, Record> map2 = this.records;
        Record record2 = oldRecord;
        record2 = new Record(record, record2 == null ? null : record2.getServer());
        boolean bl = false;
        map2.put(key2, record2);
    }

    public final boolean hasOptimisticUpdates() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.records.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Record it = (Record)element$iv;
                    boolean bl2 = false;
                    if (!(it.getOptimistic() != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean needResolve(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Record record = this.records.get(id);
        return (record == null ? null : record.getServer()) == null;
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            etag = " + this.etag + ", size = " + this.getSize() + ",\n            etagFL = " + this.etagFullyLoaded + ",\n            hasAllUpdatesFromEtag = " + this.hasAllUpdatesFromEtag + ",\n        "));
    }
}

