/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client;

import circlet.platform.api.Packet;
import circlet.platform.api.PacketMeta;
import circlet.platform.api.serialization.ExtendableSerializationRegistry;
import circlet.platform.api.services.impl.ParserFunctionsKt;
import circlet.platform.client.ConnectionStatus;
import circlet.platform.client.PushHandler;
import circlet.platform.client.RpcDeserializerException;
import circlet.platform.client.RpcRequest;
import circlet.platform.client.RpcResponse;
import circlet.platform.client.StableConnection;
import circlet.platform.client.Transport;
import circlet.platform.client.WebSocketTransport;
import circlet.platform.client.WebSocketTransportKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.ReceiveChannel;
import libraries.basics.Sync;
import libraries.coroutines.extra.ChannelKt;
import libraries.coroutines.extra.CoroutineBuildersCommonKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeContext;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchKt;
import runtime.FailureInfo;
import runtime.RpcException;
import runtime.RpcExceptionKt;
import runtime.RpcServerCancellationException;
import runtime.RpcServerRateLimitedException;
import runtime.RpcTimeoutException;
import runtime.TimeService;
import runtime.async.AtomicInteger;
import runtime.async.AtomicKt;
import runtime.json.JsonBuilderContext;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.json.JsonObject;
import runtime.reactive.Property;
import runtime.reactive.Result;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001VB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\rH\u0016Jh\u00105\u001a\u00020-\"\b\b\u0000\u00106*\u0002012\u0006\u00107\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002H6092(\u0010;\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H60=\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0>\u0012\u0006\u0012\u0004\u0018\u0001010<H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J&\u0010@\u001a\u00020-2\u0006\u00107\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016J$\u0010A\u001a\u0002H6\"\u0004\b\u0000\u001062\u000e\b\u0004\u0010B\u001a\b\u0012\u0004\u0012\u0002H60,H\u0082\b\u00a2\u0006\u0002\u0010CJ\b\u0010D\u001a\u00020-H\u0002J\b\u0010E\u001a\u00020-H\u0002J\u0019\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020:H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u00020-2\u0006\u0010G\u001a\u00020:H\u0002JU\u0010J\u001a\b\u0012\u0004\u0012\u0002H60K\"\u0004\b\u0000\u001062\u0006\u00107\u001a\u00020\r2\u0006\u0010L\u001a\u00020M2\b\u0010N\u001a\u0004\u0018\u00010O2\b\u0010P\u001a\u0004\u0018\u00010\u00132\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u0002H609H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010QJ\u001c\u0010R\u001a\u00020-2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0TH\u0002J\f\u0010U\u001a\u00020\r*\u00020:H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010'\u001a&\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0(j\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030)`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006W"}, d2={"Lcirclet/platform/client/WebSocketTransport;", "Lcirclet/platform/client/Transport;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "connection", "Lcirclet/platform/client/StableConnection;", "timeService", "Lruntime/TimeService;", "registry", "Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/client/StableConnection;Lruntime/TimeService;Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;)V", "apiVersions", "", "", "backOffProcess", "Lcirclet/platform/client/WebSocketTransport$BackOffProcess;", "getConnection", "()Lcirclet/platform/client/StableConnection;", "connectionGeneration", "", "getConnectionGeneration", "()I", "connectionStatus", "Lruntime/reactive/Property;", "Lcirclet/platform/client/ConnectionStatus;", "getConnectionStatus", "()Lruntime/reactive/Property;", "deadHandlers", "", "generation", "Lruntime/async/AtomicInteger;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "logReceivedMessagesAs", "getLogReceivedMessagesAs", "()Ljava/lang/String;", "setLogReceivedMessagesAs", "(Ljava/lang/String;)V", "nextId", "outgoingRpc", "Ljava/util/LinkedHashMap;", "Lcirclet/platform/client/RpcRequest;", "Lkotlin/collections/LinkedHashMap;", "pushEndedHandlers", "Lkotlin/Function0;", "", "pushHandlers", "Lcirclet/platform/client/PushHandler;", "sync", "", "apiVersion", "service", "version", "handlePushes", "T", "path", "parser", "Lkotlin/Function1;", "Lcirclet/platform/api/Packet;", "handler", "Lkotlin/Function2;", "Lruntime/reactive/Result;", "Lkotlin/coroutines/Continuation;", "(Ljava/lang/String;Llibraries/coroutines/extra/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "handlePushesEnded", "lock", "inner", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "onConnectionAuthFail", "onConnectionCreated", "onMessage", "packet", "(Lcirclet/platform/api/Packet;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "post", "rpc", "Lcirclet/platform/client/RpcResponse;", "payload", "Lruntime/json/JsonElement;", "meta", "Lcirclet/platform/api/PacketMeta;", "timeout", "(Ljava/lang/String;Lruntime/json/JsonElement;Lcirclet/platform/api/PacketMeta;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendApiVersions", "versions", "", "debugPrint", "BackOffProcess", "platform-client"})
public final class WebSocketTransport
implements Transport {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final StableConnection connection;
    @NotNull
    private final TimeService timeService;
    @NotNull
    private final ExtendableSerializationRegistry registry;
    @NotNull
    private final AtomicInteger nextId;
    @Nullable
    private BackOffProcess backOffProcess;
    @NotNull
    private final LinkedHashMap<Integer, RpcRequest<?>> outgoingRpc;
    @NotNull
    private final Map<String, PushHandler<?>> pushHandlers;
    @NotNull
    private final Set<String> deadHandlers;
    @NotNull
    private final Set<Function0<Unit>> pushEndedHandlers;
    @NotNull
    private final Map<String, String> apiVersions;
    @NotNull
    private final Object sync;
    @NotNull
    private final AtomicInteger generation;
    @Nullable
    private String logReceivedMessagesAs;

    public WebSocketTransport(@NotNull Lifetime lifetime, @NotNull StableConnection connection, @NotNull TimeService timeService, @NotNull ExtendableSerializationRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)timeService, (String)"timeService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.lifetime = lifetime;
        this.connection = connection;
        this.timeService = timeService;
        this.registry = registry;
        this.nextId = AtomicKt.atomicInt(1);
        this.outgoingRpc = new LinkedHashMap();
        boolean bl = false;
        this.pushHandlers = new LinkedHashMap();
        bl = false;
        this.deadHandlers = new LinkedHashSet();
        bl = false;
        this.pushEndedHandlers = new LinkedHashSet();
        bl = false;
        this.apiVersions = new LinkedHashMap();
        this.sync = new Object();
        this.generation = AtomicKt.atomicInt(0);
        SourceKt.view((Source)this.connection.getStatus(), this.lifetime, (Function2)new Function2<Lifetime, ConnectionStatus, Unit>(){

            public final void invoke(@NotNull Lifetime $noName_0, @NotNull ConnectionStatus value2) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                if (value2 instanceof ConnectionStatus.AuthFailed) {
                    this.onConnectionAuthFail();
                }
                if (value2 instanceof ConnectionStatus.Connected) {
                    generation.incrementAndGet();
                    this.onConnectionCreated();
                }
            }
        });
        this.connection.getReceived().invokeOnClose((Function1)2.INSTANCE);
        ChannelKt.launchForEach$default((ReceiveChannel)this.connection.getReceived(), this.lifetime, DispatchKt.getUi(), null, (Function2)new Function2<Packet, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ WebSocketTransport this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var31_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        it = (Packet)this.L$0;
                        var3_4 = WebSocketTransportKt.access$getLog$p();
                        var4_5 = this.this$0;
                        $i$f$catch = false;
                        $this$internalCatch_u24default$iv$iv = $this$catch$iv;
                        except$iv$iv = CollectionsKt.emptyList();
                        $i$f$internalCatch = false;
                        $i$a$-catch-WebSocketTransport$3$2 = false;
                        if (var4_5.getLogReceivedMessagesAs() != null) {
                            this_$iv = WebSocketTransportKt.access$getLog$p();
                            $i$f$info = false;
                            if (this_$iv.isInfoEnabled()) {
                                var12_14 = this_$iv;
                                $i$a$-info-WebSocketTransport$3$2$1 = false;
                                var14_16 = var4_5.getLogReceivedMessagesAs() + " received " + WebSocketTransport.access$debugPrint(var4_5, it);
                                var12_14.info(var14_16);
                            }
                        }
                        this.L$0 = $this$internalCatch_u24default$iv$iv;
                        this.L$1 = except$iv$iv;
                        this.label = 1;
                        v0 = WebSocketTransport.access$onMessage(var4_5, it, (Continuation)this);
                        ** if (v0 != var31_2) goto lbl30
lbl29:
                        // 1 sources

                        return var31_2;
lbl30:
                        // 1 sources

                        ** GOTO lbl41
                    }
                    case 1: {
                        $i$f$catch = false;
                        $i$f$internalCatch = false;
                        $i$a$-catch-WebSocketTransport$3$2 = false;
                        except$iv$iv = (List)this.L$1;
                        $this$internalCatch_u24default$iv$iv = (KLogger)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl41:
                            // 2 sources

                            var15_17 = Unit.INSTANCE;
                        }
                        catch (Throwable th$iv$iv) {
                            $i$f$isCancellationException = false;
                            if (th$iv$iv instanceof InterruptedException != false || th$iv$iv instanceof CancellationException != false) {
                                throw th$iv$iv;
                            }
                            $this$any$iv$iv$iv = except$iv$iv;
                            $i$f$any = false;
                            if (!($this$any$iv$iv$iv instanceof Collection) || !((Collection)$this$any$iv$iv$iv).isEmpty()) ** GOTO lbl52
                            v1 = false;
                            ** GOTO lbl59
lbl52:
                            // 2 sources

                            for (T element$iv$iv$iv : $this$any$iv$iv$iv) {
                                it$iv$iv = (KClass)element$iv$iv$iv;
                                $i$a$-any-KLoggerExKt$internalCatch$1$iv$iv = false;
                                if (!it$iv$iv.isInstance((Object)th$iv$iv)) continue;
                                v1 = true;
                                ** GOTO lbl59
                            }
                            v1 = false;
lbl59:
                            // 3 sources

                            if (v1) {
                                throw th$iv$iv;
                            }
                            var23_27 = th$iv$iv;
                            $this$catch_u24lambda_u2d1$iv = $this$internalCatch_u24default$iv$iv;
                            $i$a$-internalCatch$default-KLoggerExKt$catch$2$iv = false;
                            this_$iv$iv = $this$catch_u24lambda_u2d1$iv;
                            $i$f$error = false;
                            if (this_$iv$iv.isErrorEnabled()) {
                                var29_32 = th$iv;
                                var28_33 = this_$iv$iv;
                                $i$a$-catch-WebSocketTransport$3$1 = false;
                                var30_34 = "error in web socket message handing";
                                var28_33.error((Throwable)var29_32, var30_34);
                            }
                            var15_18 = null;
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<Packet, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull Packet p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 4, null);
    }

    public /* synthetic */ WebSocketTransport(Lifetime lifetime, StableConnection stableConnection, TimeService timeService, ExtendableSerializationRegistry extendableSerializationRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            extendableSerializationRegistry = ExtendableSerializationRegistry.Companion.getGlobal();
        }
        this(lifetime, stableConnection, timeService, extendableSerializationRegistry);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final StableConnection getConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public Property<ConnectionStatus> getConnectionStatus() {
        return this.connection.getStatus();
    }

    @Override
    public int getConnectionGeneration() {
        return this.generation.getValue();
    }

    @Nullable
    public final String getLogReceivedMessagesAs() {
        return this.logReceivedMessagesAs;
    }

    public final void setLogReceivedMessagesAs(@Nullable String string) {
        this.logReceivedMessagesAs = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apiVersion(@NotNull String service, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            bl2 = this.apiVersions.put(service, version) == null;
        }
        boolean newApi = bl2;
        if (newApi) {
            this.sendApiVersions(MapsKt.mapOf((Pair)TuplesKt.to((Object)service, (Object)version)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void handlePushes(@NotNull String path2, @NotNull Lifetime lifetime, @NotNull Function1<? super Packet, ? extends T> parser, @NotNull Function2<? super runtime.reactive.Result<? extends T>, ? super Continuation<? super Unit>, ? extends Object> handler) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(parser, (String)"parser");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            Map map2 = this.pushHandlers;
            PushHandler<? extends T> pushHandler = new PushHandler<T>(parser, handler);
            boolean bl5 = false;
            map2.put(path2, pushHandler);
            Unit unit = Unit.INSTANCE;
        }
        lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(this, path2){
            final /* synthetic */ WebSocketTransport this$0;
            final /* synthetic */ String $path;
            {
                this.this$0 = $receiver;
                this.$path = $path;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void this_$iv;
                WebSocketTransport webSocketTransport = this.this$0;
                WebSocketTransport webSocketTransport2 = this.this$0;
                String string = this.$path;
                boolean $i$f$lock = false;
                Sync sync = Sync.INSTANCE;
                Object lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                boolean $i$f$exec = false;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (lock$iv$iv) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    WebSocketTransport.access$getPushHandlers$p(webSocketTransport2).remove(string);
                    WebSocketTransport.access$getDeadHandlers$p(webSocketTransport2).add(string);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePushesEnded(@NotNull String path2, @NotNull Lifetime lifetime, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Lifetime $this$inContext$iv = lifetime;
        boolean $i$f$inContext = false;
        if (!$this$inContext$iv.isTerminated()) {
            LifetimeContext $this$handlePushesEnded_u24lambda_u2d3 = new LifetimeContext($this$inContext$iv);
            boolean bl = false;
            WebSocketTransport this_$iv = this;
            boolean $i$f$lock = false;
            Sync sync = Sync.INSTANCE;
            Object lock$iv$iv = this_$iv.sync;
            boolean $i$f$exec = false;
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (lock$iv$iv) {
                boolean bl4 = false;
                boolean bl5 = false;
                bl3 = this.pushEndedHandlers.add(handler);
            }
            $this$handlePushesEnded_u24lambda_u2d3.afterTermination((Function0<Unit>)((Function0)new Function0<Unit>(this, handler){
                final /* synthetic */ WebSocketTransport this$0;
                final /* synthetic */ Function0<Unit> $handler;
                {
                    this.this$0 = $receiver;
                    this.$handler = $handler;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void this_$iv;
                    WebSocketTransport webSocketTransport = this.this$0;
                    WebSocketTransport webSocketTransport2 = this.this$0;
                    Function0<Unit> function0 = this.$handler;
                    boolean $i$f$lock = false;
                    Sync sync = Sync.INSTANCE;
                    Object lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                    boolean $i$f$exec = false;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (lock$iv$iv) {
                        boolean bl3 = false;
                        boolean bl4 = false;
                        WebSocketTransport.access$getPushEndedHandlers$p(webSocketTransport2).remove(function0);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public <T> Object rpc(@NotNull String var1_1, @NotNull JsonElement var2_2, @Nullable PacketMeta var3_3, @Nullable Integer var4_4, @NotNull Function1<? super Packet, ? extends T> var5_5, @NotNull Continuation<? super RpcResponse<T>> var6_6) {
        if (!(var6_6 instanceof rpc.1)) ** GOTO lbl-1000
        var35_7 = var6_6;
        if ((var35_7.label & -2147483648) != 0) {
            var35_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WebSocketTransport this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.rpc(null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var36_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                id = this.nextId.getAndIncrement();
                $i$f$suspendCancellableCoroutine = false;
                $continuation.L$0 = this;
                $continuation.L$1 = path;
                $continuation.L$2 = payload;
                $continuation.L$3 = meta;
                $continuation.L$4 = timeout;
                $continuation.L$5 = parser;
                $continuation.I$0 = id;
                $continuation.label = 1;
                uCont$iv = $continuation;
                $i$a$-suspendCoroutineUninterceptedOrReturn-CancellableContinuationKt$suspendCancellableCoroutine$2$iv = false;
                cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
                cancellable$iv.initCancellability();
                callback = (CancellableContinuation)cancellable$iv;
                $i$a$-suspendCancellableCoroutine-WebSocketTransport$rpc$2 = false;
                if (this.getConnection().getStatus().getValue() instanceof ConnectionStatus.AuthFailed) {
                    var14_23 = (Continuation)callback;
                    var15_27 = new RpcException(new FailureInfo("Authentication failed", null, null, null, null, null, 62, null), (String)path);
                    var16_32 = false;
                    var17_36 = Result.Companion;
                    var18_40 = false;
                    var14_23.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var15_27)));
                } else {
                    var15_27 = timeout;
                    realTimeout = var15_27 == null ? 60000 : var15_27.intValue();
                    now = WebSocketTransport.access$getTimeService$p(this).now();
                    timer = WebSocketTransport.access$getTimeService$p(this).launchAfterDelay(this.getLifetime(), DispatchKt.getUi(), realTimeout, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, callback, realTimeout, id, null){
                        int label;
                        final /* synthetic */ WebSocketTransport this$0;
                        final /* synthetic */ CancellableContinuation<RpcResponse<T>> $callback;
                        final /* synthetic */ int $realTimeout;
                        final /* synthetic */ int $id;
                        {
                            this.this$0 = $receiver;
                            this.$callback = $callback;
                            this.$realTimeout = $realTimeout;
                            this.$id = $id;
                            super(1, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    RpcRequest rpcRequest;
                                    void this_$iv;
                                    ResultKt.throwOnFailure((Object)object);
                                    WebSocketTransport webSocketTransport = this.this$0;
                                    Object object3 = this.this$0;
                                    int n = this.$id;
                                    boolean $i$f$lock = false;
                                    Sync sync = Sync.INSTANCE;
                                    Object lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                                    boolean $i$f$exec = false;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    synchronized (lock$iv$iv) {
                                        boolean bl3 = false;
                                        boolean bl4 = false;
                                        rpcRequest = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p((WebSocketTransport)object3).remove(Boxing.boxInt((int)n));
                                    }
                                    RpcRequest removed = rpcRequest;
                                    if (removed != null && !this.this$0.getLifetime().isTerminated()) {
                                        webSocketTransport = (Continuation)this.$callback;
                                        object3 = new RpcTimeoutException("Request to " + removed.getPacket().getPath() + " has timed out after " + this.$realTimeout + "ms");
                                        n = 0;
                                        Result.Companion companion = Result.Companion;
                                        boolean this_$iv$iv = false;
                                        webSocketTransport.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)object3)));
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                    packet = new Packet(id, (String)path, (JsonElement)payload, null, null, null, (PacketMeta)meta, null, 184, null);
                    request = new RpcRequest<T>(packet, (Continuation)callback, timer, realTimeout, now + (long)realTimeout, parser);
                    this_$iv = this;
                    $i$f$lock = false;
                    var24_47 = Sync.INSTANCE;
                    lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
                    $i$f$exec = false;
                    var27_50 = false;
                    var28_51 = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$rpc$2$1 = false;
                        var31_56 = WebSocketTransport.access$getOutgoingRpc$p(this);
                        var32_57 = Boxing.boxInt((int)id);
                        var33_58 = false;
                        var31_56.put(var32_57, request);
                        var28_52 = Unit.INSTANCE;
                    }
                    WebSocketTransport.access$post(this, packet);
                }
                v0 = cancellable$iv.getResult();
                if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended($continuation);
                }
                v1 = v0;
                if (v0 == var36_9) {
                    return var36_9;
                }
                ** GOTO lbl88
            }
            case 1: {
                $i$f$suspendCancellableCoroutine = false;
                id = $continuation.I$0;
                var5_5 = (Function1)$continuation.L$5;
                var4_4 = (Integer)$continuation.L$4;
                var3_3 = (PacketMeta)$continuation.L$3;
                var2_2 = (JsonElement)$continuation.L$2;
                var1_1 = (String)$continuation.L$1;
                this = (WebSocketTransport)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl88:
                    // 2 sources

                    var8_12 = (RpcResponse)v1;
                    ** GOTO lbl108
                }
            }
            {
                finally {
                    this_$iv = this;
                    $i$f$lock = false;
                    var12_20 = Sync.INSTANCE;
                    lock$iv$iv = WebSocketTransport.access$getSync$p(this_$iv);
                    $i$f$exec = false;
                    var15_31 = false;
                    var16_33 = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$rpc$3 = false;
                        var16_34 = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(this).remove(Boxing.boxInt((int)id));
                    }
                }
            }
lbl108:
            // 1 sources

            return var8_12;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object onMessage(Packet var1_1, Continuation<? super Unit> var2_2) {
        block71: {
            block69: {
                block70: {
                    block68: {
                        if (!(var2_2 instanceof onMessage.1)) ** GOTO lbl-1000
                        var22_3 = var2_2;
                        if ((var22_3.label & -2147483648) != 0) {
                            var22_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                Object L$0;
                                Object L$1;
                                Object L$2;
                                int I$0;
                                int I$1;
                                /* synthetic */ Object result;
                                final /* synthetic */ WebSocketTransport this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return WebSocketTransport.access$onMessage(this.this$0, null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var23_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var3_6 = packet.getMeta();
                                if (var3_6 != null) ** GOTO lbl16
                                v0 = null;
                                break block68;
lbl16:
                                // 1 sources

                                var4_7 = var3_6.getExtensionClasses();
                                if (var4_7 != null) ** GOTO lbl20
                                v0 = null;
                                break block68;
lbl20:
                                // 1 sources

                                $this$forEach$iv = var4_7;
                                $i$f$forEach = false;
                                var7_25 = $this$forEach$iv;
                                var8_30 = var7_25.length;
                                var9_40 = 0;
lbl25:
                                // 2 sources

                                while (var9_40 < var8_30) {
                                    it = element$iv = var7_25[var9_40];
                                    $i$a$-forEach-WebSocketTransport$onMessage$2 = false;
                                    $continuation.L$0 = this;
                                    $continuation.L$1 = packet;
                                    $continuation.L$2 = var7_25;
                                    $continuation.I$0 = var8_30;
                                    $continuation.I$1 = var9_40;
                                    $continuation.label = 1;
                                    v1 = this.registry.loadDeserializer(it, (Continuation<? super Unit>)$continuation);
                                    if (v1 == var23_5) {
                                        return var23_5;
                                    }
                                    ** GOTO lbl49
                                }
                                break;
                            }
                            case 1: {
                                $i$f$forEach = false;
                                $i$a$-forEach-WebSocketTransport$onMessage$2 = false;
                                var9_40 = $continuation.I$1;
                                var8_30 = $continuation.I$0;
                                var7_25 = (String[])$continuation.L$2;
                                packet = (Packet)$continuation.L$1;
                                this = (WebSocketTransport)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl49:
                                // 2 sources

                                ++var9_40;
                                ** GOTO lbl25
                            }
                        }
                        v0 = Unit.INSTANCE;
                    }
                    failure = packet.getFailure();
                    if (failure == null) break block69;
                    if (failure.getTransportError() != null) {
                        WebSocketTransportKt.access$getLog$p().debug("Push " + packet.getPath() + " failed and will be resent with backoff: " + RpcExceptionKt.message(failure));
                        this_$iv = this;
                        $i$f$lock = false;
                        $i$f$forEach = Sync.INSTANCE;
                        lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                        $i$f$exec = false;
                        var9_40 = 0;
                        var10_49 = false;
                        synchronized (lock$iv$iv) {
                            $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                            $i$a$-lock-WebSocketTransport$onMessage$3 = false;
                            var13_78 = WebSocketTransport.access$getBackOffProcess$p(this);
                            if (var13_78 == null) {
                                var14_82 = new BackOffProcess();
                                var15_84 = false;
                                var16_86 = false;
                                created = var14_82;
                                $i$a$-also-WebSocketTransport$onMessage$3$1 = false;
                                WebSocketTransport.access$setBackOffProcess$p(this, created);
                                v2 = var14_82;
                            } else {
                                v2 = var13_78;
                            }
                            var10_50 = v2;
                        }
                    }
                    if (packet.getId() == 0) {
                        if (failure.getAuthenticationError() != null) {
                            this_$iv = "Should be handled earlier and synchronously when message is just received";
                            $i$f$lock = false;
                            throw (Throwable)new IllegalStateException(this_$iv.toString());
                        }
                        WebSocketTransportKt.access$getLog$p().error("Push " + packet.getPath() + " failed: " + RpcExceptionKt.message(failure));
                        this_$iv = this;
                        $i$f$lock = false;
                        $i$f$forEach = Sync.INSTANCE;
                        lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                        $i$f$exec = false;
                        var9_40 = 0;
                        var10_52 = false;
                        synchronized (lock$iv$iv) {
                            $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                            $i$a$-lock-WebSocketTransport$onMessage$4 = false;
                            WebSocketTransport.access$getPushHandlers$p(this).remove(packet.getPath());
                            var10_53 = Boxing.boxBoolean((boolean)WebSocketTransport.access$getDeadHandlers$p(this).add(packet.getPath()));
                        }
                    }
                    this_$iv = this;
                    $i$f$lock = false;
                    lock$iv$iv = Sync.INSTANCE;
                    lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                    $i$f$exec = false;
                    var10_55 = false;
                    $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$onMessage$rpc$1 = false;
                        $i$a$-exec-WebSocketTransport$lock$1$iv = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(this).remove(Boxing.boxInt((int)packet.getId()));
                    }
                    rpc = $i$a$-exec-WebSocketTransport$lock$1$iv;
                    if (rpc != null) break block70;
                    this_$iv = WebSocketTransportKt.access$getLog$p();
                    $i$f$warn = false;
                    if (this_$iv.isWarnEnabled()) {
                        var19_89 = this_$iv;
                        $i$a$-warn-WebSocketTransport$onMessage$5 = false;
                        var20_91 = "no handler with id = " + packet.getId() + " found";
                        var19_89.warn(var20_91);
                    }
                    break block71;
                }
                this_$iv = rpc.getTimer();
                if (this_$iv == null) {
                    v3 = null;
                } else {
                    Job.DefaultImpls.cancel$default((Job)this_$iv, null, (int)1, null);
                    v3 = Unit.INSTANCE;
                }
                this_$iv = failure.getRequestError();
                if (this_$iv == null) ** GOTO lbl-1000
                tmp = -1;
                switch (this_$iv.hashCode()) {
                    case -771078535: {
                        if (this_$iv.equals("Too many requests")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 1914718620: {
                        if (this_$iv.equals("Request execution cancelled on server")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1782696108: {
                        if (this_$iv.equals("Request execution timed out")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 3: {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcTimeoutException("Request to " + rpc.getPacket().getPath() + " has timed out from server side");
                        lock$iv$iv = false;
                        $i$f$exec = Result.Companion;
                        var10_55 = false;
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                    case 2: {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcServerCancellationException("Request to " + rpc.getPacket().getPath() + " was cancelled on server side");
                        lock$iv$iv = false;
                        $i$f$exec = Result.Companion;
                        var10_55 = false;
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                    case 1: {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcServerRateLimitedException("Request to " + rpc.getPacket().getPath() + " was rate limited on server side");
                        lock$iv$iv = false;
                        $i$f$exec = Result.Companion;
                        var10_55 = false;
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        $i$f$warn = rpc.getCallback();
                        $i$a$-warn-WebSocketTransport$onMessage$5 = new RpcException(failure, rpc.getPacket().getPath());
                        lock$iv$iv = false;
                        $i$f$exec = Result.Companion;
                        var10_55 = false;
                        $i$f$warn.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$5)));
                        break;
                    }
                }
                break block71;
            }
            if (packet.getId() != 0 || Intrinsics.areEqual((Object)packet.getPath(), (Object)"")) ** GOTO lbl250
            this_$iv = this;
            $i$f$lock = false;
            $i$a$-warn-WebSocketTransport$onMessage$5 = Sync.INSTANCE;
            lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
            $i$f$exec = false;
            var10_56 = false;
            $i$a$-exec-WebSocketTransport$lock$1$iv = false;
            synchronized (lock$iv$iv) {
                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                $i$a$-lock-WebSocketTransport$onMessage$pushHandler$1 = false;
                $i$a$-exec-WebSocketTransport$lock$1$iv = (PushHandler)WebSocketTransport.access$getPushHandlers$p(this).get(packet.getPath());
            }
            pushHandler = $i$a$-exec-WebSocketTransport$lock$1$iv;
            if (pushHandler != null) {
                try {
                    $i$f$lock = new Result.Success<Object>(pushHandler.getParser().invoke((Object)packet));
                }
                catch (Throwable e) {
                    $i$f$lock = new Result.Failure(new RpcDeserializerException(e, packet.getPath()));
                }
                result = $i$f$lock;
                CoroutineBuildersCommonKt.launch$default(this.getLifetime(), DispatchKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((PushHandler<Object>)pushHandler, (runtime.reactive.Result<? extends Object>)result, null){
                    int label;
                    final /* synthetic */ PushHandler<Object> $pushHandler;
                    final /* synthetic */ runtime.reactive.Result<Object> $result;
                    {
                        this.$pushHandler = $pushHandler;
                        this.$result = $result;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$pushHandler.getHandler().invoke(this.$result, (Object)((Object)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 12, null);
            } else {
                this_$iv = this;
                $i$f$lock = false;
                e = Sync.INSTANCE;
                lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                $i$f$exec = false;
                var10_56 = false;
                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                synchronized (lock$iv$iv) {
                    $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                    $i$a$-lock-WebSocketTransport$onMessage$7 = false;
                    if (!WebSocketTransport.access$getDeadHandlers$p(this).contains(packet.getPath())) {
                        var14_83 = "Payload " + packet.getPath() + ':' + packet.getPayload() + " for unknown handler";
                        var15_85 = false;
                        throw (Throwable)new IllegalStateException(var14_83.toString());
                    }
                    WebSocketTransportKt.access$getLog$p().warn("Payload " + packet.getPayload() + " for dead handler");
                    $i$a$-exec-WebSocketTransport$lock$1$iv = Unit.INSTANCE;
                }
lbl250:
                // 1 sources

                if (packet.getId() != 0 && Intrinsics.areEqual((Object)packet.getPath(), (Object)"")) {
                    this_$iv = this;
                    $i$f$lock = false;
                    e = Sync.INSTANCE;
                    lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                    $i$f$exec = false;
                    var10_57 = false;
                    $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                    synchronized (lock$iv$iv) {
                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                        $i$a$-lock-WebSocketTransport$onMessage$rpc$2 = false;
                        $i$a$-exec-WebSocketTransport$lock$1$iv = (RpcRequest)WebSocketTransport.access$getOutgoingRpc$p(this).remove(Boxing.boxInt((int)packet.getId()));
                    }
                    rpc = $i$a$-exec-WebSocketTransport$lock$1$iv;
                    if (rpc == null) {
                        this_$iv = WebSocketTransportKt.access$getLog$p();
                        $i$f$warn = false;
                        if (this_$iv.isWarnEnabled()) {
                            var19_90 = this_$iv;
                            $i$a$-warn-WebSocketTransport$onMessage$8 = false;
                            var20_92 = "no handler with id = " + packet.getId() + " found";
                            var19_90.warn(var20_92);
                        }
                    } else {
                        this_$iv = rpc.getTimer();
                        if (this_$iv == null) {
                            v4 = null;
                        } else {
                            Job.DefaultImpls.cancel$default((Job)this_$iv, null, (int)1, null);
                            v4 = Unit.INSTANCE;
                        }
                        try {
                            value = rpc.getParser().invoke((Object)packet);
                            var6_22 = rpc.getCallback();
                            $i$a$-warn-WebSocketTransport$onMessage$8 = new RpcResponse<Object>(value, packet.getStats(), packet.getUpdates(), packet.getPayload());
                            lock$iv$iv = false;
                            var9_45 = Result.Companion;
                            var10_57 = false;
                            var6_22.resumeWith(Result.constructor-impl((Object)$i$a$-warn-WebSocketTransport$onMessage$8));
                        }
                        catch (Throwable e) {
                            var6_23 = rpc.getCallback();
                            $i$a$-warn-WebSocketTransport$onMessage$8 = new RpcDeserializerException(e, Intrinsics.stringPlus((String)"rpc: ", (Object)rpc.getPacket().getPath()));
                            lock$iv$iv = false;
                            var9_46 = Result.Companion;
                            var10_57 = false;
                            var6_23.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-warn-WebSocketTransport$onMessage$8)));
                        }
                    }
                }
            }
        }
        if (failure == null) {
            this_$iv = this;
            $i$f$lock = false;
            var6_24 = Sync.INSTANCE;
            lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
            $i$f$exec = false;
            var9_47 = false;
            var10_58 = false;
            synchronized (lock$iv$iv) {
                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                $i$a$-lock-WebSocketTransport$onMessage$9 = false;
                var13_78 = WebSocketTransport.access$getBackOffProcess$p(this);
                if (var13_78 == null) {
                    v5 = null;
                } else {
                    var14_82 = var13_78;
                    var15_84 = false;
                    var16_86 = false;
                    it = var14_82;
                    $i$a$-let-WebSocketTransport$onMessage$9$1 = false;
                    if (WebSocketTransport.access$getOutgoingRpc$p(this).isEmpty()) {
                        it.terminate();
                        WebSocketTransport.access$setBackOffProcess$p(this, null);
                    } else {
                        it.reset();
                    }
                    v5 = Unit.INSTANCE;
                }
                var10_59 = v5;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectionCreated() {
        Collection collection;
        boolean bl;
        Pair pair;
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec22 = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (lock$iv$iv) {
            boolean bl4 = false;
            boolean bl5 = false;
            HashMap hashMap = new HashMap(this.apiVersions);
            Collection collection2 = this.outgoingRpc.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"outgoingRpc.values");
            pair = TuplesKt.to(hashMap, (Object)CollectionsKt.toList((Iterable)collection2));
        }
        Pair pair2 = pair;
        HashMap versions = (HashMap)pair2.component1();
        List requests = (List)pair2.component2();
        this.sendApiVersions(versions);
        Iterable $this$forEach$iv = requests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RpcRequest rpc2 = (RpcRequest)element$iv;
            bl = false;
            this.post(rpc2.getPacket());
        }
        Object this_$iv2 = this;
        boolean $i$f$lock2 = false;
        Sync $i$f$exec22 = Sync.INSTANCE;
        Object lock$iv$iv2 = ((WebSocketTransport)this_$iv2).sync;
        boolean $i$f$exec = false;
        bl = false;
        boolean bl6 = false;
        synchronized (lock$iv$iv2) {
            boolean bl7 = false;
            boolean bl8 = false;
            collection = runtime.utils.CollectionsKt.getAndClear(this.pushEndedHandlers);
        }
        this_$iv2 = collection;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl9 = false;
            it.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onConnectionAuthFail() {
        Map map2;
        WebSocketTransport this_$iv = this;
        boolean $i$f$lock = false;
        Object object = Sync.INSTANCE;
        Object lock$iv$iv = this_$iv.sync;
        boolean $i$f$exec = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv$iv) {
            boolean bl3 = false;
            boolean bl4 = false;
            map2 = runtime.utils.CollectionsKt.getAndClear(this.outgoingRpc);
        }
        Map $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl5 = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl6 = false;
            Continuation continuation = ((RpcRequest)it.getValue()).getTimer();
            if (continuation != null) {
                Job.DefaultImpls.cancel$default((Job)continuation, null, (int)1, null);
            }
            continuation = ((RpcRequest)it.getValue()).getCallback();
            Throwable throwable = new RpcException(new FailureInfo("Authentication failed", null, null, null, null, null, 62, null), ((RpcRequest)it.getValue()).getPacket().getPath());
            boolean bl7 = false;
            Result.Companion companion = Result.Companion;
            boolean bl8 = false;
            continuation.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
        }
    }

    private final void sendApiVersions(Map<String, String> versions) {
        this.post(new Packet(0, "apiVersion", JsonDslKt.jsonObjectNode((Function1<? super JsonBuilderContext, Unit>)((Function1)new Function1<JsonBuilderContext, Unit>(versions){
            final /* synthetic */ Map<String, String> $versions;
            {
                this.$versions = $versions;
                super(1);
            }

            public final void invoke(@NotNull JsonBuilderContext $this$jsonObjectNode) {
                Intrinsics.checkNotNullParameter((Object)$this$jsonObjectNode, (String)"$this$jsonObjectNode");
                Map<String, String> $this$forEach$iv = this.$versions;
                boolean $i$f$forEach = false;
                Map<String, String> map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<String, String>> iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> $dstr$key$value = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Map.Entry<String, String> entry = $dstr$key$value;
                    boolean bl3 = false;
                    String key2 = entry.getKey();
                    Map.Entry<String, String> entry2 = $dstr$key$value;
                    boolean bl4 = false;
                    String value2 = entry2.getValue();
                    $this$jsonObjectNode.put(key2, value2);
                }
            }
        })), null, null, null, null, null, 248, null));
    }

    private final void post(Packet packet) {
        JsonObject packetJson2 = JsonDslKt.jsonObjectNode((Function1<? super JsonBuilderContext, Unit>)((Function1)new Function1<JsonBuilderContext, Unit>(packet, this){
            final /* synthetic */ Packet $packet;
            final /* synthetic */ WebSocketTransport this$0;
            {
                this.$packet = $packet;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonBuilderContext $this$jsonObjectNode) {
                Intrinsics.checkNotNullParameter((Object)$this$jsonObjectNode, (String)"$this$jsonObjectNode");
                ParserFunctionsKt.jsonify_Packet(this.$packet, $this$jsonObjectNode, WebSocketTransport.access$getRegistry$p(this.this$0));
            }
        }));
        this.connection.postJson(packetJson2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T lock(Function0<? extends T> inner) {
        boolean $i$f$lock = false;
        Sync sync = Sync.INSTANCE;
        Object lock$iv = this.sync;
        boolean $i$f$exec = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            Object object;
            try {
                boolean bl3 = false;
                object = inner.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl15 : MonitorExitStatement: MONITOREXIT : lock$iv
                InlineMarker.finallyEnd((int)1);
            }
            return (T)object;
        }
    }

    private final String debugPrint(Packet $this$debugPrint) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("Packet(id=").append($this$debugPrint.getId()).append(", path='").append($this$debugPrint.getPath()).append("', payload=").append(JsonDslKt.text($this$debugPrint.getPayload())).append(", failure=").append($this$debugPrint.getFailure()).append(", stats=").append($this$debugPrint.getStats()).append(", limitsTokensRemaining=").append($this$debugPrint.getLimitsTokensRemaining()).append(", meta=").append($this$debugPrint.getMeta()).append(", updates=");
        Object[] objectArray = $this$debugPrint.getUpdates();
        if (objectArray == null) {
            string = null;
        } else {
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            String string2 = Arrays.toString(objectArray2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.util.Arrays.toString(this)");
        }
        return stringBuilder.append((Object)string).append(')').toString();
    }

    public static final /* synthetic */ Set access$getDeadHandlers$p(WebSocketTransport $this) {
        return $this.deadHandlers;
    }

    public static final /* synthetic */ Object access$onMessage(WebSocketTransport $this, Packet packet, Continuation $completion) {
        return $this.onMessage(packet, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ExtendableSerializationRegistry access$getRegistry$p(WebSocketTransport $this) {
        return $this.registry;
    }

    public static final /* synthetic */ TimeService access$getTimeService$p(WebSocketTransport $this) {
        return $this.timeService;
    }

    public static final /* synthetic */ void access$setBackOffProcess$p(WebSocketTransport $this, BackOffProcess backOffProcess) {
        $this.backOffProcess = backOffProcess;
    }

    public static final /* synthetic */ void access$post(WebSocketTransport $this, Packet packet) {
        $this.post(packet);
    }

    public static final /* synthetic */ BackOffProcess access$getBackOffProcess$p(WebSocketTransport $this) {
        return $this.backOffProcess;
    }

    public static final /* synthetic */ String access$debugPrint(WebSocketTransport $this, Packet $receiver) {
        return $this.debugPrint($receiver);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\u0006\u0010\u000e\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcirclet/platform/client/WebSocketTransport$BackOffProcess;", "", "(Lcirclet/platform/client/WebSocketTransport;)V", "delay", "", "getDelay", "()I", "setDelay", "(I)V", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "reset", "", "start", "terminate", "platform-client"})
    private final class BackOffProcess {
        @NotNull
        private LifetimeSource lifetime;
        private int delay;

        public BackOffProcess() {
            Intrinsics.checkNotNullParameter((Object)WebSocketTransport.this, (String)"this$0");
            this.lifetime = LifetimeUtilsKt.nested(WebSocketTransport.this.getLifetime());
            this.delay = 5000;
            this.start();
        }

        public final int getDelay() {
            return this.delay;
        }

        public final void setDelay(int n) {
            this.delay = n;
        }

        /*
         * WARNING - void declaration
         */
        public final void reset() {
            if (WebSocketTransport.this.getLogReceivedMessagesAs() != null) {
                void this_$iv;
                KLogger kLogger = WebSocketTransportKt.access$getLog$p();
                WebSocketTransport webSocketTransport = WebSocketTransport.this;
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    void var5_4 = this_$iv;
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)webSocketTransport.getLogReceivedMessagesAs(), (Object)" back off: restart");
                    var5_4.info(string);
                }
            }
            this.lifetime.terminate();
            this.lifetime = LifetimeUtilsKt.nested(WebSocketTransport.this.getLifetime());
            this.start();
        }

        /*
         * WARNING - void declaration
         */
        public final void terminate() {
            if (WebSocketTransport.this.getLogReceivedMessagesAs() != null) {
                void this_$iv;
                KLogger kLogger = WebSocketTransportKt.access$getLog$p();
                WebSocketTransport webSocketTransport = WebSocketTransport.this;
                boolean $i$f$info = false;
                if (this_$iv.isInfoEnabled()) {
                    void var5_4 = this_$iv;
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)webSocketTransport.getLogReceivedMessagesAs(), (Object)" back off: terminate");
                    var5_4.info(string);
                }
            }
            this.lifetime.terminate();
        }

        private final void start() {
            CoroutineBuildersCommonKt.launch$default(this.lifetime, DispatchKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, WebSocketTransport.this, null){
                Object L$0;
                int label;
                final /* synthetic */ BackOffProcess this$0;
                final /* synthetic */ WebSocketTransport this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var26_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block6 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                            // 2 sources

                            while (!BackOffProcess.access$getLifetime$p(this.this$0).isTerminated()) {
                                now = WebSocketTransport.access$getTimeService$p(this.this$1).now();
                                var5_5 = this.this$1;
                                var6_6 = this.this$1;
                                $i$f$lock = false;
                                var8_10 = Sync.INSTANCE;
                                lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                                $i$f$exec = false;
                                var11_18 = false;
                                var12_20 = false;
                                synchronized (lock$iv$iv) {
                                    $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                                    $i$a$-lock-WebSocketTransport$BackOffProcess$start$1$requests$1 = false;
                                    var15_30 = WebSocketTransport.access$getOutgoingRpc$p(var6_6).values();
                                    Intrinsics.checkNotNullExpressionValue(var15_30, (String)"outgoingRpc.values");
                                    $this$filter$iv = var15_30;
                                    $i$f$filter = false;
                                    var17_32 = $this$filter$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (RpcRequest)element$iv$iv;
                                        $i$a$-filter-WebSocketTransport$BackOffProcess$start$1$requests$1$1 = false;
                                        if (!Boxing.boxBoolean((boolean)(it.getDue() > now)).booleanValue()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    var12_21 = (List)destination$iv$iv;
                                }
                                requests = var12_21;
                                if (requests.isEmpty()) {
                                    this_$iv = this.this$1;
                                    var6_6 = this.this$1;
                                    $i$f$lock = false;
                                    var8_10 = Sync.INSTANCE;
                                    lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                                    $i$f$exec = false;
                                    var11_18 = false;
                                    var12_23 = false;
                                    synchronized (lock$iv$iv) {
                                        $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                                        $i$a$-lock-WebSocketTransport$BackOffProcess$start$1$1 = false;
                                        WebSocketTransport.access$setBackOffProcess$p(var6_6, null);
                                        var12_24 = Unit.INSTANCE;
                                        break block6;
                                    }
                                }
                                if (this.this$1.getLogReceivedMessagesAs() != null) {
                                    this_$iv = WebSocketTransportKt.access$getLog$p();
                                    var6_6 = this.this$1;
                                    $i$f$lock = this.this$0;
                                    $i$f$info = false;
                                    if (this_$iv.isInfoEnabled()) {
                                        var24_39 = this_$iv;
                                        $i$a$-info-WebSocketTransport$BackOffProcess$start$1$2 = false;
                                        var25_40 = var6_6.getLogReceivedMessagesAs() + " back off: will repeat " + requests.size() + " requests after " + $i$f$lock.getDelay() + " milliseconds";
                                        var24_39.info(var25_40);
                                    }
                                }
                                this.L$0 = requests;
                                this.label = 1;
                                v0 = WebSocketTransport.access$getTimeService$p(this.this$1).delay(this.this$0.getDelay(), (Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var26_2) {
                                    return var26_2;
                                }
                                ** GOTO lbl80
                            }
                            break;
                        }
                        case 1: {
                            var4_4 = (List)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl80:
                            // 2 sources

                            this_$iv = this.this$1;
                            var6_6 = this.this$1;
                            $i$f$lock = false;
                            var8_10 = Sync.INSTANCE;
                            lock$iv$iv = WebSocketTransport.access$getSync$p((WebSocketTransport)this_$iv);
                            $i$f$exec = false;
                            var11_18 = false;
                            var12_26 = false;
                            synchronized (lock$iv$iv) {
                                $i$a$-exec-WebSocketTransport$lock$1$iv = false;
                                $i$a$-lock-WebSocketTransport$BackOffProcess$start$1$3 = false;
                                $this$filter$iv = var4_4;
                                $i$f$filter = false;
                                $this$filterTo$iv$iv = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (RpcRequest)element$iv$iv;
                                    $i$a$-filter-WebSocketTransport$BackOffProcess$start$1$3$1 = false;
                                    if (!Boxing.boxBoolean((boolean)WebSocketTransport.access$getOutgoingRpc$p(var6_6).containsKey(Boxing.boxInt((int)it.getPacket().getId()))).booleanValue()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                var12_19 = (List)destination$iv$iv;
                            }
                            $this$forEach$iv = var12_19;
                            var6_6 = this.this$1;
                            $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                rpc = (RpcRequest)element$iv;
                                $i$a$-forEach-WebSocketTransport$BackOffProcess$start$1$4 = false;
                                WebSocketTransport.access$post(var6_6, rpc.getPacket());
                            }
                            ** GOTO lbl5
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 12, null);
        }

        public static final /* synthetic */ LifetimeSource access$getLifetime$p(BackOffProcess $this) {
            return $this.lifetime;
        }
    }
}

