/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client;

import circlet.platform.client.arenas.ClientArenaImpl;
import circlet.platform.client.arenas.PreloadedArena;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u0012J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J$\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00180\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcirclet/platform/client/ReferencedArenas;", "", "arena", "Lcirclet/platform/client/arenas/PreloadedArena;", "cache", "", "", "Lcirclet/platform/client/arenas/ClientArenaImpl;", "(Lcirclet/platform/client/arenas/PreloadedArena;Ljava/util/Map;)V", "getArena", "()Lcirclet/platform/client/arenas/PreloadedArena;", "getCache", "()Ljava/util/Map;", "referencedArenas", "", "getReferencedArenas", "()Ljava/util/Set;", "reversedGraph", "", "", "visited", "checkRefConsistency", "", "globalResults", "", "fillReferencedArenas", "fillReversedGraph", "propagateBrokenState", "results", "platform-client"})
final class ReferencedArenas {
    @NotNull
    private final PreloadedArena arena;
    @NotNull
    private final Map<String, ClientArenaImpl> cache;
    @NotNull
    private final Set<PreloadedArena> referencedArenas;
    @NotNull
    private final Map<PreloadedArena, List<PreloadedArena>> reversedGraph;
    @NotNull
    private final Set<PreloadedArena> visited;

    public ReferencedArenas(@NotNull PreloadedArena arena2, @NotNull Map<String, ClientArenaImpl> cache) {
        Intrinsics.checkNotNullParameter((Object)arena2, (String)"arena");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        this.arena = arena2;
        this.cache = cache;
        boolean bl = false;
        this.referencedArenas = new LinkedHashSet();
        bl = false;
        this.reversedGraph = new LinkedHashMap();
        bl = false;
        this.visited = new LinkedHashSet();
        this.fillReferencedArenas(this.arena);
        this.fillReversedGraph();
    }

    @NotNull
    public final PreloadedArena getArena() {
        return this.arena;
    }

    @NotNull
    public final Map<String, ClientArenaImpl> getCache() {
        return this.cache;
    }

    @NotNull
    public final Set<PreloadedArena> getReferencedArenas() {
        return this.referencedArenas;
    }

    private final void fillReversedGraph() {
        Iterable $this$forEach$iv = this.referencedArenas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PreloadedArena arena2 = (PreloadedArena)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = arena2.referenced();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List list;
                PreloadedArena referenced = (PreloadedArena)element$iv2;
                boolean bl2 = false;
                Map<PreloadedArena, List<PreloadedArena>> $this$getOrPut$iv = this.reversedGraph;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(referenced);
                if (value$iv == null) {
                    boolean bl3 = false;
                    boolean bl4 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(referenced, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                list.add((PreloadedArena)arena2);
            }
        }
    }

    private final void fillReferencedArenas(PreloadedArena arena2) {
        if (this.referencedArenas.add(arena2) && !this.cache.containsKey(arena2.getArenaId())) {
            Iterable $this$forEach$iv = arena2.referenced();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreloadedArena it = (PreloadedArena)element$iv;
                boolean bl = false;
                this.fillReferencedArenas(it);
            }
        }
    }

    public final void checkRefConsistency(@NotNull Map<String, Boolean> globalResults) {
        PreloadedArena it;
        Intrinsics.checkNotNullParameter(globalResults, (String)"globalResults");
        Iterable $this$forEach$iv = this.referencedArenas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PreloadedArena)element$iv;
            boolean bl = false;
            if (it.selfChecked() && !Intrinsics.areEqual((Object)globalResults.get(it.getArenaId()), (Object)false)) continue;
            this.propagateBrokenState(it, globalResults);
        }
        $this$forEach$iv = this.referencedArenas;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PreloadedArena)element$iv;
            boolean bl = false;
            if (globalResults.containsKey(it.getArenaId())) continue;
            Map<String, Boolean> map2 = globalResults;
            String string = it.getArenaId();
            Boolean bl2 = true;
            boolean bl3 = false;
            map2.put(string, bl2);
        }
    }

    private final void propagateBrokenState(PreloadedArena arena2, Map<String, Boolean> results2) {
        if (this.visited.contains(arena2)) {
            return;
        }
        this.visited.add(arena2);
        if (Intrinsics.areEqual((Object)results2.get(arena2.getArenaId()), (Object)true)) {
            Function0<String> function0 = new Function0<String>(arena2){
                final /* synthetic */ PreloadedArena $arena;
                {
                    this.$arena = $arena;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "arena " + this.$arena.getArenaId() + " has bad refs, but previously it was considered consistent";
                }
            };
            boolean bl = false;
            throw (Throwable)new IllegalStateException(function0.toString());
        }
        Object object = results2;
        String string = arena2.getArenaId();
        Boolean bl = false;
        boolean bl2 = false;
        object.put((String)string, (Boolean)bl);
        object = this.reversedGraph.get(arena2);
        if (object != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreloadedArena it = (PreloadedArena)element$iv;
                boolean bl3 = false;
                this.propagateBrokenState(it, results2);
            }
        }
    }
}

