/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client;

import circlet.platform.api.CallContextImpl;
import circlet.platform.api.Packet;
import circlet.platform.api.serialization.ExtendableSerializationRegistry;
import circlet.platform.api.services.impl.ParserFunctionsKt;
import circlet.platform.client.ConnectionHolderKt;
import circlet.platform.client.ConnectionHolderState;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.channels.Channel;
import libraries.coroutines.extra.Lifetime;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.FailureInfo;
import runtime.json.JsonDslKt;
import runtime.json.JsonElement;
import runtime.net.WebSocket;
import runtime.net.WebSocketFactory;
import runtime.net.WebSocketJsonMessage;
import runtime.net.WebSocketListener;
import runtime.net.WebSocketMessage;
import runtime.net.WebSocketState;
import runtime.net.WebSocketTextMessage;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\u001f\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001f0%H\u0082\bJ\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0012H\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcirclet/platform/client/ConnectionHolder;", "Lruntime/net/WebSocketListener;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "registry", "Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "received", "Lkotlinx/coroutines/channels/Channel;", "Lcirclet/platform/api/Packet;", "socketsFactory", "Lruntime/net/WebSocketFactory;", "url", "", "headers", "", "Lkotlin/Pair;", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;Lkotlinx/coroutines/channels/Channel;Lruntime/net/WebSocketFactory;Ljava/lang/String;Ljava/util/List;)V", "connection", "Lruntime/net/WebSocket;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getReceived", "()Lkotlinx/coroutines/channels/Channel;", "getRegistry", "()Lcirclet/platform/api/serialization/ExtendableSerializationRegistry;", "state", "Lruntime/reactive/MutableProperty;", "Lcirclet/platform/client/ConnectionHolderState;", "getState", "()Lruntime/reactive/MutableProperty;", "close", "", "_state", "closeConnection", "closeIfTerminated", "ws", "action", "Lkotlin/Function0;", "onConnectionClosed", "onConnectionOpen", "onFailure", "reason", "", "onMessage", "message", "Lruntime/net/WebSocketMessage;", "onMessageReceived", "packetJson", "Lruntime/json/JsonElement;", "platform-client"})
public final class ConnectionHolder
implements WebSocketListener {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ExtendableSerializationRegistry registry;
    @NotNull
    private final Channel<Packet> received;
    @NotNull
    private final String url;
    @NotNull
    private final MutableProperty<ConnectionHolderState> state;
    @NotNull
    private final WebSocket connection;

    public ConnectionHolder(@NotNull Lifetime lifetime, @NotNull ExtendableSerializationRegistry registry, @NotNull Channel<Packet> received, @NotNull WebSocketFactory socketsFactory, @NotNull String url2, @NotNull List<Pair<String, String>> headers) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter(received, (String)"received");
        Intrinsics.checkNotNullParameter((Object)socketsFactory, (String)"socketsFactory");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        this.lifetime = lifetime;
        this.registry = registry;
        this.received = received;
        this.url = url2;
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "new ConnectionHolder";
            kLogger.debug(string);
        }
        this.state = CellableKt.mutableProperty(ConnectionHolderState.Initial.INSTANCE);
        this.connection = socketsFactory.createWebSocket(this.url, this, headers);
        this.lifetime.addOrCallImmediately((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.closeConnection();
            }
        }));
    }

    public /* synthetic */ ConnectionHolder(Lifetime lifetime, ExtendableSerializationRegistry extendableSerializationRegistry, Channel channel2, WebSocketFactory webSocketFactory, String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(lifetime, extendableSerializationRegistry, (Channel<Packet>)channel2, webSocketFactory, string, list);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final ExtendableSerializationRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final Channel<Packet> getReceived() {
        return this.received;
    }

    @NotNull
    public final MutableProperty<ConnectionHolderState> getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onMessage(@NotNull WebSocket ws, @NotNull WebSocketMessage message2) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        ConnectionHolder this_$iv = this;
        boolean $i$f$closeIfTerminated = false;
        if (this_$iv.getLifetime().isTerminated()) {
            ws.close();
            return;
        }
        boolean bl = false;
        WebSocketMessage webSocketMessage = message2;
        if (webSocketMessage instanceof WebSocketTextMessage) {
            this.onMessageReceived(JsonDslKt.jsonElement(((WebSocketTextMessage)message2).getMessage()));
            return;
        }
        if (webSocketMessage instanceof WebSocketJsonMessage) {
            this.onMessageReceived(((WebSocketJsonMessage)message2).getJson());
            return;
        }
        String string = "Message of type \"" + Reflection.getOrCreateKotlinClass(message2.getClass()) + "\" is not expected";
        boolean bl2 = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onMessageReceived(JsonElement packetJson2) {
        Packet packet = ParserFunctionsKt.parse_Packet(packetJson2, new CallContextImpl(this.registry, null, null, null, 12, null));
        if (packet.getFailure() != null && packet.getId() == 0) {
            Object object = packet.getFailure();
            Intrinsics.checkNotNull((Object)object);
            if (((FailureInfo)object).getAuthenticationError() != null) {
                KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
                boolean $i$f$debug = false;
                if (this_$iv.isDebugEnabled()) {
                    KLogger kLogger = this_$iv;
                    boolean bl = false;
                    FailureInfo failureInfo = packet.getFailure();
                    String string = Intrinsics.stringPlus((String)"onMessageReceived that contains auth failed ", (Object)(failureInfo == null ? null : failureInfo.getAuthenticationError()));
                    kLogger.debug(string);
                }
                FailureInfo failureInfo = packet.getFailure();
                Intrinsics.checkNotNull((Object)failureInfo);
                object = failureInfo.getAuthenticationError();
                Intrinsics.checkNotNull((Object)object);
                this.close(new ConnectionHolderState.AuthFailed("", (String)object));
                return;
            }
        }
        this.received.offer((Object)packet);
    }

    @Override
    public void onFailure(@NotNull WebSocket ws, int reason) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        ConnectionHolder this_$iv = this;
        boolean $i$f$closeIfTerminated = false;
        if (!this_$iv.getLifetime().isTerminated()) {
            boolean bl = false;
            KLogger this_$iv2 = ConnectionHolderKt.access$getLog$p();
            boolean $i$f$debug = false;
            if (this_$iv2.isDebugEnabled()) {
                KLogger kLogger = this_$iv2;
                boolean bl2 = false;
                String string = Intrinsics.stringPlus((String)"onFailure ", (Object)reason);
                kLogger.debug(string);
            }
            int n = reason;
            switch (n) {
                case 401: {
                    this.close(new ConnectionHolderState.AuthFailed("401", "Web socket is closed due to authentication failure."));
                    break;
                }
                case 404: {
                    this.close(new ConnectionHolderState.AuthFailed("404", Intrinsics.stringPlus((String)this.url, (Object)" is not found")));
                    break;
                }
                default: {
                    this.close(ConnectionHolderState.Closed.INSTANCE);
                }
            }
        } else {
            ws.close();
        }
    }

    @Override
    public void onConnectionOpen(@NotNull WebSocket ws) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        Object this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (((KLogger)this_$iv).isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "on open";
            kLogger.debug(string);
        }
        this_$iv = this;
        boolean $i$f$closeIfTerminated = false;
        if (!((ConnectionHolder)this_$iv).getLifetime().isTerminated()) {
            boolean bl = false;
            this.getState().setValue(new ConnectionHolderState.Open(ws));
        } else {
            ws.close();
        }
    }

    @Override
    public void onConnectionClosed(@NotNull WebSocket ws) {
        Intrinsics.checkNotNullParameter((Object)ws, (String)"ws");
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "on closed";
            kLogger.debug(string);
        }
        this.state.setValue(ConnectionHolderState.Closed.INSTANCE);
    }

    private final void closeIfTerminated(WebSocket ws, Function0<Unit> action2) {
        boolean $i$f$closeIfTerminated = false;
        if (!this.getLifetime().isTerminated()) {
            action2.invoke();
        } else {
            ws.close();
        }
    }

    private final void close(ConnectionHolderState _state) {
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"close reason ", (Object)Reflection.getOrCreateKotlinClass(_state.getClass()).getSimpleName());
            kLogger.debug(string);
        }
        this.state.setValue(_state);
        this.closeConnection();
    }

    private final void closeConnection() {
        KLogger this_$iv = ConnectionHolderKt.access$getLog$p();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            String string = "do close";
            kLogger.trace(string);
        }
        if (!Intrinsics.areEqual((Object)this.connection.getConnectState().name(), (Object)WebSocketState.CLOSED.name())) {
            this.connection.close();
        }
    }
}

