/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api.oauth;

import circlet.platform.api.oauth.OAuthFlow;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import platform.common.OrderedEnum;

@Deprecated(message="Applications are composable now, all applications return type ServiceAccount")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B-\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001b\u00a8\u0006\u001c"}, d2={"Lcirclet/platform/api/oauth/OAuthServiceType;", "", "Lplatform/common/OrderedEnum;", "orderNumber", "", "displayName", "", "description", "supportedFlows", "", "Lcirclet/platform/api/oauth/OAuthFlow;", "(Ljava/lang/String;IILjava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getDescription", "()Ljava/lang/String;", "getDisplayName", "hasServicePermissions", "", "getHasServicePermissions", "()Z", "isRedirectUriRequired", "getOrderNumber", "()I", "getSupportedFlows", "()Ljava/util/List;", "Server", "WebClient", "Mobile", "ServiceAccount", "platform-api"})
public final class OAuthServiceType
extends Enum<OAuthServiceType>
implements OrderedEnum {
    private final int orderNumber;
    @NotNull
    private final String displayName;
    @NotNull
    private final String description;
    @NotNull
    private final List<OAuthFlow> supportedFlows;
    private final boolean isRedirectUriRequired;
    private final boolean hasServicePermissions;
    public static final /* enum */ OAuthServiceType Server;
    public static final /* enum */ OAuthServiceType WebClient;
    public static final /* enum */ OAuthServiceType Mobile;
    public static final /* enum */ OAuthServiceType ServiceAccount;
    private static final /* synthetic */ OAuthServiceType[] $VALUES;

    private OAuthServiceType(int orderNumber, String displayName, String description, List<? extends OAuthFlow> supportedFlows) {
        this.orderNumber = orderNumber;
        this.displayName = displayName;
        this.description = description;
        this.supportedFlows = supportedFlows;
        this.isRedirectUriRequired = this.supportedFlows.contains((Object)OAuthFlow.Code) || this.supportedFlows.contains((Object)OAuthFlow.Implicit);
        this.hasServicePermissions = this.supportedFlows.contains((Object)OAuthFlow.Client);
    }

    @Override
    public int getOrderNumber() {
        return this.orderNumber;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final List<OAuthFlow> getSupportedFlows() {
        return this.supportedFlows;
    }

    public final boolean isRedirectUriRequired() {
        return this.isRedirectUriRequired;
    }

    public final boolean getHasServicePermissions() {
        return this.hasServicePermissions;
    }

    public static OAuthServiceType[] values() {
        OAuthServiceType[] oAuthServiceTypeArray = $VALUES;
        return Arrays.copyOf(oAuthServiceTypeArray, oAuthServiceTypeArray.length);
    }

    public static OAuthServiceType valueOf(String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return Enum.valueOf(OAuthServiceType.class, value2);
    }

    static {
        OAuthFlow[] oAuthFlowArray = new OAuthFlow[]{OAuthFlow.Code, OAuthFlow.RefreshToken, OAuthFlow.Client};
        Server = new OAuthServiceType(0, "Server-side Web App", "A web application with authorization logic on the server side. It can store a secret securely on server without exposing it to users.", CollectionsKt.listOf((Object[])oAuthFlowArray));
        WebClient = new OAuthServiceType(1, "JavaScript Web App", "A rich client web application with all authorization logic in browser. It cannot use a secret for authentication but can access fragment part of a URL that is not sent to server.", CollectionsKt.listOf((Object)((Object)OAuthFlow.Implicit)));
        oAuthFlowArray = new OAuthFlow[]{OAuthFlow.Code, OAuthFlow.RefreshToken, OAuthFlow.ResourceOwner, OAuthFlow.QrFlow};
        Mobile = new OAuthServiceType(2, "Mobile or Desktop App", "A desktop or a mobile application able to request authorization token non-interactively", CollectionsKt.listOf((Object[])oAuthFlowArray));
        oAuthFlowArray = new OAuthFlow[]{OAuthFlow.Client, OAuthFlow.RefreshToken, OAuthFlow.ResourceOwner};
        ServiceAccount = new OAuthServiceType(3, "Service Account", "An OAuth 2.0 client that needs to access resources on behalf of itself", CollectionsKt.listOf((Object[])oAuthFlowArray));
        $VALUES = oAuthServiceTypeArray = new OAuthServiceType[]{OAuthServiceType.Server, OAuthServiceType.WebClient, OAuthServiceType.Mobile, OAuthServiceType.ServiceAccount};
    }
}

